/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui.util;

import com.ibm.collaboration.realtime.ui.DisplayLoop;
import com.ibm.collaboration.realtime.ui.strings.Messages;
import com.ibm.collaboration.realtime.util.OSUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;

public class EclipseRestartUtil {
    public static void displayRestartUIPrompt() {
        EclipseRestartUtil.displayRestartUIPrompt(Messages.sametime, Messages.restart_prompt_content);
    }

    public static void displayRestartUIPrompt(String restartPromptContent) {
        EclipseRestartUtil.displayRestartUIPrompt(Messages.sametime, restartPromptContent);
    }

    public static void displayRestartUIPrompt(final String dialogTitle, final String dialogTextContent) {
        DisplayLoop.getDisplay().asyncExec(new Runnable(){

            public void run() {
                boolean answer = MessageDialog.openQuestion((Shell)DisplayLoop.getDisplay().getActiveShell(), (String)dialogTitle, (String)dialogTextContent);
                if (answer) {
                    EclipseRestartUtil.restartClient();
                }
            }
        });
    }

    public static void restartClient() {
        if (OSUtils.isMac()) {
            DisplayLoop.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    PlatformUI.getWorkbench().restart();
                }
            });
        } else {
            UIJob restartJob = new UIJob("Restart Job"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    PlatformUI.getWorkbench().restart();
                    return Status.OK_STATUS;
                }
            };
            restartJob.setPriority(10);
            restartJob.setSystem(true);
            restartJob.schedule(250L);
        }
    }
}

