/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Region;

public class DrawingUtils {
    private static final Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.collaboration.realtime.ui.util.DrawingUtils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getPackage().getName());
    }

    public static Region getRoundRectangleRegion(int x, int y, int width, int height, int radius) {
        Region region = new Region();
        region.add(DrawingUtils.getCircle(x + radius, y + radius, radius));
        region.add(DrawingUtils.getCircle(x + width - radius, y + radius, radius));
        region.add(x, y + radius, width, height - radius * 2);
        region.add(x + radius, y, width - radius * 2, height);
        region.add(DrawingUtils.getCircle(x + radius, y + height - radius, radius));
        region.add(DrawingUtils.getCircle(x + width - radius, y + height - radius, radius));
        return region;
    }

    public static int[] getCircle(int x, int y, int radius) {
        int[] circle = new int[radius * 2 * 2 * 2];
        int index = 0;
        int i = 0;
        while (i < radius * 2 + 1) {
            int xpos = i - radius;
            int ypos = (int)Math.sqrt(radius * radius - xpos * xpos);
            circle[index] = xpos + x;
            circle[index + 1] = y - ypos;
            circle[circle.length - 1 - (index + 1)] = xpos + x;
            circle[circle.length - 1 - index] = y + ypos;
            index += 2;
            ++i;
        }
        return circle;
    }

    public static int[] getCircle2(int offsetX, int offsetY, int r) {
        int[] polygon = new int[8 * r + 4];
        int i = 0;
        while (i < 2 * r + 1) {
            int x = i - r;
            int y = (int)Math.sqrt(r * r - x * x);
            polygon[2 * i] = offsetX + x;
            polygon[2 * i + 1] = offsetY + y;
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, String.valueOf(offsetX + x) + ", " + offsetY + y);
            }
            polygon[8 * r - 2 * i - 2] = offsetX + x;
            polygon[8 * r - 2 * i - 1] = offsetY - y;
            ++i;
        }
        i = 0;
        while (i < polygon.length) {
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, String.valueOf(polygon[i]) + ", " + polygon[i + 1]);
            }
            i += 2;
        }
        return polygon;
    }
}

