/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Display;

public class ColorUtils {
    private static final int COLOR_COUNT = 40;
    private static Color[] s_SystemColors = null;
    private static final Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.collaboration.realtime.ui.util.ColorUtils");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
        Display display = Display.getDefault();
        if (display != null) {
            s_SystemColors = new Color[40];
            int index = 0;
            while (index < 40) {
                try {
                    ColorUtils.s_SystemColors[index] = display.getSystemColor(index + 1);
                }
                catch (Throwable t) {
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, t.getMessage(), t);
                    }
                    ColorUtils.s_SystemColors[index] = null;
                }
                ++index;
            }
        }
    }

    public static Color cloneColor(Display display, Color color) {
        return new Color((Device)display, color.getRed(), color.getGreen(), color.getBlue());
    }

    public static boolean isSystemColor(Color color) {
        boolean found = false;
        if (s_SystemColors != null) {
            int index = 0;
            while (!found && index < 40) {
                if (s_SystemColors[index] != null && s_SystemColors[index] == color) {
                    found = true;
                }
                ++index;
            }
        } else if (logger.isLoggable(Level.WARNING)) {
            logger.log(Level.WARNING, "WARNING: Unable ColorUtils.isSystemColor unable to check System Color");
        }
        return found;
    }

    public static boolean disposeIfNotSystem(Color color) {
        boolean result = false;
        if (color != null && !ColorUtils.isSystemColor(color) && !color.isDisposed()) {
            color.dispose();
            result = true;
        }
        return result;
    }

    public static boolean dispose(Color color) {
        boolean result = false;
        if (color == null) {
            try {
                throw new Exception("ERROR: Attempt to dispose a null Color!");
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
        } else if (ColorUtils.isSystemColor(color)) {
            try {
                throw new Exception("ERROR: Attempt to dispose a System Color: " + color);
            }
            catch (Exception e) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
        } else {
            color.dispose();
            result = true;
        }
        return result;
    }

    public static String rgbToHex(String rgbString) {
        String[] rgb = rgbString.split(",");
        String red = Integer.toHexString(Integer.parseInt(rgb[0]));
        String green = Integer.toHexString(Integer.parseInt(rgb[1]));
        String blue = Integer.toHexString(Integer.parseInt(rgb[2]));
        if (red.length() == 1) {
            red = "0" + red;
        }
        if (green.length() == 1) {
            green = "0" + green;
        }
        if (blue.length() == 1) {
            blue = "0" + blue;
        }
        return "#" + red + green + blue;
    }
}

