/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui.util;

import com.ibm.collaboration.realtime.ui.util.BitmapDecoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Display;

public class BitmapTransfer
extends ByteArrayTransfer {
    public static BitmapTransfer getInstance() {
        return new BitmapTransfer();
    }

    protected String[] getTypeNames() {
        return new String[]{"CF_DIB"};
    }

    protected int[] getTypeIds() {
        return new int[]{8};
    }

    protected void javaToNative(Object obj, TransferData transferData) {
        if (this.isSupportedType(transferData)) {
            ImageLoader loader = new ImageLoader();
            if (obj instanceof Image) {
                Image im = (Image)obj;
                loader.data = new ImageData[]{im.getImageData()};
            } else if (obj instanceof ImageData[]) {
                loader.data = (ImageData[])obj;
            }
            if (loader.data != null) {
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                loader.save((OutputStream)stream, 0);
                byte[] input = stream.toByteArray();
                byte[] bytes = new byte[input.length - 14];
                int i = 14;
                while (i < bytes.length) {
                    bytes[i - 14] = input[i];
                    ++i;
                }
                super.javaToNative((Object)bytes, transferData);
            }
        }
    }

    protected Object nativeToJava(TransferData transferData) {
        if (this.isSupportedType(transferData)) {
            byte[] buffer = (byte[])super.nativeToJava(transferData);
            if (buffer == null) {
                return null;
            }
            ByteArrayInputStream is = new ByteArrayInputStream(buffer);
            return BitmapDecoder.loadbitmap(Display.getDefault(), is);
        }
        return null;
    }
}

