/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui.util;

import com.ibm.collaboration.realtime.ui.util.BitmapTransfer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class BitmapDecoder {
    private static final Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.collaboration.realtime.ui.util.BitmapDecoder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getPackage().getName());
    }

    public static void main(String[] args) {
        block3: {
            try {
                Display d = new Display();
                Clipboard c = new Clipboard(d);
                Object o = c.getContents((Transfer)BitmapTransfer.getInstance());
                Image image = (Image)o;
                c.dispose();
                Shell s = new Shell(d);
                s.setSize(300, 400);
                s.setLayout((Layout)new FillLayout());
                Label l = new Label((Composite)s, 0);
                l.setImage(image);
                s.open();
                while (!s.isDisposed()) {
                    if (s.getDisplay().readAndDispatch()) continue;
                    s.getDisplay().sleep();
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.WARNING)) break block3;
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    public static Image loadbitmap(Display d, ByteArrayInputStream is) {
        return BitmapDecoder.loadBitmapFromInputStream(d, is);
    }

    public static Image loadBitmapFromInputStream(Display d, InputStream fs) {
        Image image = null;
        try {
            int bilen = 40;
            byte[] bi = new byte[bilen];
            fs.read(bi, 0, bilen);
            int nwidth = (bi[7] & 0xFF) << 24 | (bi[6] & 0xFF) << 16 | (bi[5] & 0xFF) << 8 | bi[4] & 0xFF;
            int nheight = (bi[11] & 0xFF) << 24 | (bi[10] & 0xFF) << 16 | (bi[9] & 0xFF) << 8 | bi[8] & 0xFF;
            int nbitcount = (bi[15] & 0xFF) << 8 | bi[14] & 0xFF;
            int ncompression = (bi[19] & 0xFF) << 24 | (bi[18] & 0xFF) << 16 | (bi[17] & 0xFF) << 8 | bi[16] & 0xFF;
            int nsizeimage = (bi[23] & 0xFF) << 24 | (bi[22] & 0xFF) << 16 | (bi[21] & 0xFF) << 8 | bi[20] & 0xFF;
            int nclrused = (bi[35] & 0xFF) << 24 | (bi[34] & 0xFF) << 16 | (bi[33] & 0xFF) << 8 | bi[32] & 0xFF;
            if (nbitcount == 24) {
                int npad;
                if (nsizeimage == 0) {
                    nsizeimage = (nwidth * nbitcount + 31 & 0xFFFFFFE0) >> 3;
                    nsizeimage *= nheight;
                }
                if ((npad = nsizeimage / nheight - nwidth * 3) == 4) {
                    npad = 0;
                }
                byte[] brgb = new byte[(nwidth * 3 + npad) * nheight];
                fs.read(brgb, 0, (nwidth * 3 + npad) * nheight);
                int nindex = 0;
                Vector<RGB> set = new Vector<RGB>();
                byte[] rgbs = new byte[brgb.length];
                int j = 0;
                while (j < nheight) {
                    int i = 0;
                    while (i < nwidth) {
                        RGB rgb = new RGB(brgb[nindex + 2] & 0xFF, brgb[nindex + 1] & 0xFF, brgb[nindex] & 0xFF);
                        set.add(rgb);
                        rgbs[nwidth * 3 * (nheight - j - 1) + i * 3] = brgb[nindex];
                        rgbs[nwidth * 3 * (nheight - j - 1) + i * 3 + 1] = brgb[nindex + 1];
                        rgbs[nwidth * 3 * (nheight - j - 1) + i * 3 + 2] = brgb[nindex + 2];
                        nindex += 3;
                        ++i;
                    }
                    nindex += npad;
                    ++j;
                }
                ImageData id = null;
                if (npad == 0) {
                    id = new ImageData(nwidth, nheight, nbitcount, new PaletteData(set.toArray(new RGB[set.size()])));
                    id.data = rgbs;
                } else {
                    id = new ImageData(nwidth, nheight, nbitcount, new PaletteData(set.toArray(new RGB[set.size()])), npad, rgbs);
                }
                image = new Image((Device)d, id);
            } else if (nbitcount == 8) {
                int nNumColors = 0;
                nNumColors = nclrused > 0 ? nclrused : 1 << nbitcount;
                if (nsizeimage == 0) {
                    nsizeimage = (nwidth * nbitcount + 31 & 0xFFFFFFE0) >> 3;
                    nsizeimage *= nheight;
                }
                int[] npalette = new int[nNumColors];
                byte[] bpalette = new byte[nNumColors * 4];
                fs.read(bpalette, 0, nNumColors * 4);
                int nindex8 = 0;
                Vector<RGB> set = new Vector<RGB>();
                int n = 0;
                while (n < nNumColors) {
                    npalette[n] = 0xFF000000 | (bpalette[nindex8 + 2] & 0xFF) << 16 | (bpalette[nindex8 + 1] & 0xFF) << 8 | bpalette[nindex8] & 0xFF;
                    RGB rgb = new RGB(bpalette[nindex8 + 2] & 0xFF, bpalette[nindex8 + 1] & 0xFF, bpalette[nindex8] & 0xFF);
                    set.add(rgb);
                    nindex8 += 4;
                    ++n;
                }
                int npad8 = nsizeimage / nheight - nwidth;
                try {
                    byte[] bdata = new byte[(nwidth + npad8) * nheight];
                    byte[] bdata8 = new byte[bdata.length];
                    fs.read(bdata, 0, (nwidth + npad8) * nheight);
                    nindex8 = 0;
                    int j8 = 0;
                    while (j8 < nheight) {
                        int i8 = 0;
                        while (i8 < nwidth) {
                            bdata8[nwidth * (nheight - j8 - 1) + i8] = bdata[nindex8];
                            ++nindex8;
                            ++i8;
                        }
                        nindex8 += npad8;
                        ++j8;
                    }
                    ImageData id = null;
                    if (npad8 == 0) {
                        id = new ImageData(nwidth, nheight, nbitcount, new PaletteData(set.toArray(new RGB[set.size()])));
                        id.data = bdata8;
                    } else {
                        id = new ImageData(nwidth, nheight, nbitcount, new PaletteData(set.toArray(new RGB[set.size()])), npad8, bdata8);
                    }
                    image = new Image((Device)d, id);
                }
                catch (Exception e) {
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, e.getMessage(), e);
                    }
                }
            } else if (nbitcount == 16) {
                int npad = nsizeimage / nheight - nwidth * 2;
                if (npad == 4) {
                    npad = 0;
                }
                byte[] brgb = new byte[(nwidth * 2 + npad) * nheight];
                int avail = fs.available();
                int extra = avail - brgb.length;
                int red_mask = 63488;
                int green_mask = 2016;
                int blue_mask = 31;
                if (extra > 0) {
                    byte[] b = new byte[extra];
                    fs.read(b, 0, b.length);
                    if (extra == 12 && ncompression == 3) {
                        int r = 0;
                        red_mask = (b[r + 3] & 0xFF) << 24 | (b[r + 2] & 0xFF) << 16 | (b[r + 1] & 0xFF) << 8 | b[r] & 0xFF;
                        green_mask = (b[(r += 4) + 3] & 0xFF) << 24 | (b[r + 2] & 0xFF) << 16 | (b[r + 1] & 0xFF) << 8 | b[r] & 0xFF;
                        blue_mask = (b[(r += 4) + 3] & 0xFF) << 24 | (b[r + 2] & 0xFF) << 16 | (b[r + 1] & 0xFF) << 8 | b[r] & 0xFF;
                    }
                }
                fs.read(brgb, 0, (nwidth * 2 + npad) * nheight);
                int nindex = 0;
                byte[] rgbs = new byte[brgb.length];
                int j = 0;
                while (j < nheight) {
                    int i = 0;
                    while (i < nwidth) {
                        rgbs[nwidth * 2 * (nheight - j - 1) + i * 2] = brgb[nindex];
                        rgbs[nwidth * 2 * (nheight - j - 1) + i * 2 + 1] = brgb[nindex + 1];
                        nindex += 2;
                        ++i;
                    }
                    nindex += npad;
                    ++j;
                }
                ImageData id = null;
                PaletteData data = new PaletteData(red_mask, green_mask, blue_mask);
                data.isDirect = true;
                if (npad == 0) {
                    id = new ImageData(nwidth, nheight, nbitcount, data);
                    id.data = rgbs;
                } else {
                    id = new ImageData(nwidth, nheight, nbitcount, data, npad, rgbs);
                }
                image = new Image((Device)d, id);
            } else if (nbitcount == 4) {
                int nNumColors = 0;
                nNumColors = nclrused > 0 ? nclrused : 1 << nbitcount;
                if (nsizeimage == 0) {
                    nsizeimage = (nwidth * nbitcount + 31 & 0xFFFFFFE0) >> 3;
                    nsizeimage *= nheight;
                }
                byte[] bpalette = new byte[nNumColors * 4];
                fs.read(bpalette, 0, nNumColors * 4);
                int nindex8 = 0;
                Vector<RGB> set = new Vector<RGB>();
                int n = 0;
                while (n < nNumColors) {
                    RGB rgb = new RGB(bpalette[nindex8 + 2] & 0xFF, bpalette[nindex8 + 1] & 0xFF, bpalette[nindex8] & 0xFF);
                    set.add(rgb);
                    nindex8 += 4;
                    ++n;
                }
                int npad8 = nsizeimage / nheight - nwidth / 2;
                if (npad8 < 0) {
                    npad8 = 0;
                }
                try {
                    byte[] bdata = new byte[nsizeimage];
                    byte[] bdata8 = new byte[nsizeimage];
                    fs.read(bdata, 0, nsizeimage);
                    nindex8 = 0;
                    int j = 0;
                    while (j < nheight) {
                        int i = 0;
                        while (i < nwidth / 2) {
                            bdata8[nwidth / 2 * (nheight - j - 1) + i] = bdata[nindex8];
                            ++nindex8;
                            ++i;
                        }
                        nindex8 += npad8;
                        ++j;
                    }
                    ImageData id = null;
                    if (npad8 == 0) {
                        id = new ImageData(nwidth, nheight, nbitcount, new PaletteData(set.toArray(new RGB[set.size()])));
                        id.data = bdata8;
                    } else {
                        id = new ImageData(nwidth, nheight, nbitcount, new PaletteData(set.toArray(new RGB[set.size()])), npad8, bdata8);
                    }
                    image = new Image((Device)d, id);
                }
                catch (Throwable e) {
                    if (logger.isLoggable(Level.WARNING)) {
                        logger.log(Level.WARNING, e.getMessage(), e);
                    }
                }
            } else if (nbitcount == 32) {
                int npad = nsizeimage / nheight - nwidth * 4;
                byte[] brgb = new byte[(nwidth * 4 + npad) * nheight];
                int avail = fs.available();
                int extra = avail - brgb.length;
                if (extra > 0) {
                    byte[] b = new byte[extra];
                    fs.read(b, 0, b.length);
                    if (extra == 12 && ncompression == 3) {
                        int r = 0;
                        int cfr_ignored_0 = (b[r + 3] & 0xFF) << 24 | (b[r + 2] & 0xFF) << 16 | (b[r + 1] & 0xFF) << 8 | b[r] & 0xFF;
                        int cfr_ignored_1 = (b[(r += 4) + 3] & 0xFF) << 24 | (b[r + 2] & 0xFF) << 16 | (b[r + 1] & 0xFF) << 8 | b[r] & 0xFF;
                        int cfr_ignored_2 = (b[(r += 4) + 3] & 0xFF) << 24 | (b[r + 2] & 0xFF) << 16 | (b[r + 1] & 0xFF) << 8 | b[r] & 0xFF;
                    }
                }
                fs.read(brgb, 0, (nwidth * 4 + npad) * nheight);
                byte[] topdown = new byte[brgb.length];
                int nindex = 0;
                Vector<RGB> set = new Vector<RGB>();
                int j = 0;
                while (j < nheight) {
                    int i = 0;
                    while (i < nwidth) {
                        RGB rgb = new RGB(brgb[nindex + 2] & 0xFF, brgb[nindex + 1] & 0xFF, brgb[nindex] & 0xFF);
                        set.add(rgb);
                        topdown[nwidth * 4 * (nheight - j - 1) + i * 4] = brgb[nindex];
                        topdown[nwidth * 4 * (nheight - j - 1) + i * 4 + 1] = brgb[nindex + 1];
                        topdown[nwidth * 4 * (nheight - j - 1) + i * 4 + 2] = brgb[nindex + 2];
                        topdown[nwidth * 4 * (nheight - j - 1) + i * 4 + 3] = brgb[nindex + 3];
                        nindex += 4;
                        ++i;
                    }
                    nindex += npad;
                    ++j;
                }
                PaletteData data = new PaletteData(set.toArray(new RGB[set.size()]));
                if (npad == 0) {
                    npad = 4;
                }
                ImageData id = new ImageData(nwidth, nheight, nbitcount, data, npad, topdown);
                image = new Image((Device)d, id);
            } else {
                image = null;
            }
            fs.close();
            return image;
        }
        catch (Throwable e) {
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "Caught exception in loadbitmap!");
            }
            if (logger.isLoggable(Level.WARNING)) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
            return null;
        }
    }
}

