/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui.tableextension;

import com.ibm.collaboration.realtime.ui.tableextension.DynamicTable;
import com.ibm.collaboration.realtime.ui.tableextension.DynamicTableExtension;
import com.ibm.collaboration.realtime.ui.tableextension.TableLabelProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class DynamicTableProvider
extends LabelProvider
implements ITableLabelProvider,
ITableFontProvider,
ITableColorProvider {
    private final DynamicTable stable;

    public DynamicTableProvider(DynamicTable stable) {
        this.stable = stable;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        DynamicTableExtension[] exts = this.stable.getExtensions();
        if (exts != null) {
            int currIndex = 0;
            int i = 0;
            while (i < exts.length) {
                DynamicTableExtension ext = exts[i];
                int cols = ext.getColumnCount();
                int j = 0;
                while (j < cols) {
                    TableLabelProvider provider = ext.getLabelProvider();
                    if (j + currIndex >= columnIndex && provider != null) {
                        return provider.getColumnImage(element, columnIndex - currIndex);
                    }
                    ++j;
                }
                if (cols > 0) {
                    currIndex += cols;
                }
                ++i;
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        DynamicTableExtension[] exts = this.stable.getExtensions();
        if (exts != null) {
            int currIndex = 0;
            int i = 0;
            while (i < exts.length) {
                DynamicTableExtension ext = exts[i];
                int cols = ext.getColumnCount();
                int j = 0;
                while (j < cols) {
                    TableLabelProvider provider = ext.getLabelProvider();
                    if (j + currIndex >= columnIndex && provider != null) {
                        return provider.getColumnText(element, columnIndex - currIndex);
                    }
                    ++j;
                }
                if (cols > 0) {
                    currIndex += cols;
                }
                ++i;
            }
        }
        return "";
    }

    public Color getBackground(Object element, int columnIndex) {
        DynamicTableExtension[] exts = this.stable.getExtensions();
        if (exts != null) {
            int currIndex = 0;
            int i = 0;
            while (i < exts.length) {
                DynamicTableExtension ext = exts[i];
                int cols = ext.getColumnCount();
                int j = 0;
                while (j < cols) {
                    TableLabelProvider provider = ext.getLabelProvider();
                    if (provider instanceof ITableColorProvider && j + currIndex >= columnIndex && provider != null) {
                        return ((ITableColorProvider)provider).getBackground(element, columnIndex - currIndex);
                    }
                    ++j;
                }
                if (cols > 0) {
                    currIndex += cols;
                }
                ++i;
            }
        }
        return null;
    }

    public Font getFont(Object element, int columnIndex) {
        DynamicTableExtension[] exts = this.stable.getExtensions();
        if (exts != null) {
            int currIndex = 0;
            int i = 0;
            while (i < exts.length) {
                DynamicTableExtension ext = exts[i];
                int cols = ext.getColumnCount();
                int j = 0;
                while (j < cols) {
                    TableLabelProvider provider = ext.getLabelProvider();
                    if (provider instanceof ITableFontProvider && j + currIndex >= columnIndex && provider != null) {
                        return ((ITableFontProvider)provider).getFont(element, columnIndex - currIndex);
                    }
                    ++j;
                }
                if (cols > 0) {
                    currIndex += cols;
                }
                ++i;
            }
        }
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        DynamicTableExtension[] exts = this.stable.getExtensions();
        if (exts != null) {
            int currIndex = 0;
            int i = 0;
            while (i < exts.length) {
                DynamicTableExtension ext = exts[i];
                int cols = ext.getColumnCount();
                int j = 0;
                while (j < cols) {
                    TableLabelProvider provider = ext.getLabelProvider();
                    if (provider instanceof ITableColorProvider && j + currIndex >= columnIndex && provider != null) {
                        return ((ITableColorProvider)provider).getForeground(element, columnIndex - currIndex);
                    }
                    ++j;
                }
                if (cols > 0) {
                    currIndex += cols;
                }
                ++i;
            }
        }
        return null;
    }

    public String getColumnToolTipText(Object element, int columnIndex) {
        DynamicTableExtension[] exts = this.stable.getExtensions();
        if (exts != null) {
            int i = 0;
            while (i < exts.length) {
                DynamicTableExtension ext = exts[i];
                int cols = ext.getColumnCount();
                int j = 0;
                if (j < cols) {
                    TableLabelProvider provider = ext.getLabelProvider();
                    return provider.getColumnToolTipText(element, columnIndex);
                }
                ++i;
            }
        }
        return null;
    }
}

