/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui.prefs;

import com.ibm.collaboration.realtime.ui.prefs.PreferenceListChild;
import com.ibm.collaboration.realtime.ui.prefs.PreferenceListDescriptor;
import com.ibm.collaboration.realtime.ui.prefs.PreferenceListExtension;
import com.ibm.collaboration.realtime.ui.prefs.PreferenceListNode;
import com.ibm.collaboration.realtime.ui.prefs.PreferenceListPage;
import com.ibm.collaboration.realtime.ui.strings.Messages;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class PreferenceListTableTreePage
extends PreferenceListPage {
    private Tree prefTable;
    private TreeViewer treeViewer;
    private final ArrayList prefList = new ArrayList();
    private ITableLabelProvider labelProvider;
    private static final Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.collaboration.realtime.ui.prefs.PreferenceListTableTreePage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getPackage().getName());
    }

    public PreferenceListTableTreePage(String plugin, String directionText) {
        super(plugin, directionText, false);
    }

    public void setLabelProvider(ITableLabelProvider provider) {
        this.labelProvider = provider;
    }

    protected void createTable(Composite parent) {
        int style = 67584;
        this.prefTable = new Tree(parent, style);
        this.prefTable.setHeaderVisible(true);
        this.treeViewer = new TreeViewer(this.prefTable);
        if (this.labelProvider != null) {
            this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        } else {
            this.treeViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

                public Image getColumnImage(Object arg0, int arg1) {
                    return null;
                }

                public String getColumnText(Object obj, int col) {
                    if (obj instanceof PreferenceListExtension) {
                        PreferenceListExtension ext = (PreferenceListExtension)obj;
                        switch (col) {
                            case 0: {
                                return ext.getLabel();
                            }
                            case 1: {
                                return "";
                            }
                        }
                    }
                    return "";
                }

                public void addListener(ILabelProviderListener arg0) {
                }

                public void dispose() {
                }

                public boolean isLabelProperty(Object arg0, String arg1) {
                    return false;
                }

                public void removeListener(ILabelProviderListener arg0) {
                }
            });
        }
        this.treeViewer.setContentProvider((IContentProvider)new ITreeContentProvider(){

            public Object[] getChildren(Object objs) {
                if (objs instanceof PreferenceListNode) {
                    PreferenceListNode ext = (PreferenceListNode)objs;
                    return ext.getChildren();
                }
                return null;
            }

            public Object getParent(Object arg0) {
                return null;
            }

            public boolean hasChildren(Object objs) {
                if (objs instanceof PreferenceListNode) {
                    PreferenceListNode ext = (PreferenceListNode)objs;
                    return ext.getChildren() != null;
                }
                return false;
            }

            public Object[] getElements(Object objs) {
                if (objs instanceof PreferenceListNode) {
                    PreferenceListNode ext = (PreferenceListNode)objs;
                    return ext.getChildren();
                }
                if (objs instanceof ArrayList) {
                    return ((ArrayList)objs).toArray(new PreferenceListExtension[0]);
                }
                return new Object[]{objs};
            }

            public void dispose() {
            }

            public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
            }
        });
        this.treeViewer.setInput((Object)this.prefList);
        TreeColumn col = new TreeColumn(this.prefTable, 0);
        col.setText(Messages.event);
        col.setWidth(300);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                StructuredSelection ss = (StructuredSelection)event.getSelection();
                PreferenceListExtension pref = (PreferenceListExtension)ss.getFirstElement();
                boolean showControls = !PreferenceListTableTreePage.this.showEnabledCheckbox;
                boolean resetControls = false;
                showControls = true;
                resetControls = true;
                if (PreferenceListTableTreePage.this.prefTable.getSelectionCount() > 0 && ss.equals((Object)PreferenceListTableTreePage.this.treeViewer.getSelection())) {
                    showControls = true;
                    resetControls = true;
                    pref = (PreferenceListExtension)PreferenceListTableTreePage.this.prefTable.getSelection()[0].getData();
                }
                if (resetControls) {
                    PreferenceListTableTreePage.this.currentPref = pref;
                    if (PreferenceListTableTreePage.this.currentPref != null) {
                        if (PreferenceListTableTreePage.this.currentPref instanceof PreferenceListChild) {
                            ((PreferenceListChild)((Object)PreferenceListTableTreePage.this.currentPref)).setParentPreferencePage(PreferenceListTableTreePage.this);
                        }
                        String label = PreferenceListTableTreePage.this.getLabel(PreferenceListTableTreePage.this.currentPref, null);
                        if (PreferenceListTableTreePage.this.currentPref instanceof PreferenceListNode) {
                            label = PreferenceListTableTreePage.this.getBreadcrumbTrail((PreferenceListNode)((Object)PreferenceListTableTreePage.this.currentPref));
                        }
                        PreferenceListTableTreePage.this.groupLabel.setText(label);
                        if (!PreferenceListTableTreePage.this.setSelectedPreference(PreferenceListTableTreePage.this.currentPref)) {
                            PreferenceListTableTreePage.this.createPreferenceControls(PreferenceListTableTreePage.this.currentPref, PreferenceListTableTreePage.this.prefGroup, showControls);
                        } else {
                            PreferenceListTableTreePage.this.currentPref.setEnabled(showControls);
                        }
                        PreferenceListTableTreePage.this.prefGroup.layout();
                        PreferenceListTableTreePage.this.prefGroup.getParent().layout();
                    }
                }
            }
        });
        if (this.showEnabledCheckbox) {
            TreeColumn enabled = new TreeColumn(this.prefTable, 0);
            enabled.setText(Messages.enabled);
            enabled.setWidth(80);
            enabled.setAlignment(0x1000000);
        }
    }

    private String getBreadcrumbTrail(PreferenceListNode node) {
        StringBuffer b = new StringBuffer();
        b.append(((PreferenceListExtension)((Object)node)).getLabel());
        PreferenceListExtension parent = node.getParent();
        if (parent != null) {
            b.insert(0, " > ");
            if (parent instanceof PreferenceListNode) {
                b.insert(0, this.getBreadcrumbTrail((PreferenceListNode)((Object)parent)));
            }
        }
        return b.toString();
    }

    protected boolean setSelectedPreference(PreferenceListExtension ext) {
        Control[] kids = this.prefGroup.getChildren();
        int i = 0;
        while (i < kids.length) {
            Composite comp;
            if (kids[i] instanceof Composite && ext.equals((PreferenceListExtension)(comp = (Composite)kids[i]).getData())) {
                this.prefGroupStack.topControl = comp;
                return true;
            }
            ++i;
        }
        return false;
    }

    protected TreeItem getTreeItem(PreferenceListExtension ext) {
        TreeItem[] items = this.prefTable.getItems();
        return this.getTreeItem(items, ext);
    }

    private boolean isTreeItem(TreeItem item, PreferenceListExtension ext) {
        PreferenceListExtension data = (PreferenceListExtension)item.getData();
        return data != null && ext != null && data.equals(ext);
    }

    private TreeItem getTreeItem(TreeItem[] items, PreferenceListExtension ext) {
        TreeItem item = null;
        int i = 0;
        while (i < items.length) {
            item = items[i];
            if (this.isTreeItem(item, ext)) {
                return item;
            }
            if ((item = this.getTreeItem(item.getItems(), ext)) != null) {
                return item;
            }
            ++i;
        }
        return null;
    }

    protected void populateTable() {
        if (this.descs != null) {
            int i = 0;
            while (i < this.descs.length) {
                PreferenceListDescriptor desc = this.descs[i];
                PreferenceListExtension pref = this.createPreferenceExtension(desc);
                if (pref != null && pref.isVisible()) {
                    if (pref instanceof PreferenceListChild) {
                        ((PreferenceListChild)((Object)pref)).setParentPreferencePage(this);
                    }
                    this.prefList.add(pref);
                    this.treeViewer.refresh();
                }
                ++i;
            }
        }
        if (this.prefTable.getItemCount() > 0) {
            this.prefTable.setSelection(this.prefTable.getItem(0));
            PreferenceListDescriptor desc = this.getFirstVisibleDesc();
            if (desc != null) {
                this.currentPref = desc.getObject();
                if (this.currentPref instanceof PreferenceListChild) {
                    ((PreferenceListChild)((Object)this.currentPref)).setParentPreferencePage(this);
                }
                TreeItem first = this.prefTable.getItem(0);
                this.groupLabel.setText(this.getLabel(this.currentPref, desc));
                if (!this.setSelectedPreference(this.currentPref)) {
                    this.createPreferenceControls(this.currentPref, this.prefGroup, this.showEnabledCheckbox ? first.getChecked() : true);
                } else {
                    this.currentPref.setEnabled(this.showEnabledCheckbox ? first.getChecked() : true);
                }
                this.prefGroup.layout();
                this.prefGroup.getParent().layout();
            }
        }
    }

    private TreeItem createTreeItem(PreferenceListDescriptor desc, PreferenceListExtension pref) {
        if (pref == null || !pref.isVisible()) {
            return null;
        }
        if (pref instanceof PreferenceListChild) {
            ((PreferenceListChild)((Object)pref)).setParentPreferencePage(this);
        }
        TreeItem item = new TreeItem(this.prefTable, 0);
        boolean prefEnabled = pref.isEnabled();
        item.setData((Object)pref);
        if (this.showEnabledCheckbox) {
            item.setText(new String[]{this.getLabel(pref, desc), prefEnabled ? Messages.enabled : Messages.disabled});
            item.setChecked(prefEnabled);
        } else {
            item.setText(this.getLabel(pref, desc));
        }
        return item;
    }

    private TreeItem createTreeItem(TreeItem parent, PreferenceListExtension pref) {
        PreferenceListNode nest;
        PreferenceListExtension[] children;
        if (pref == null || !pref.isVisible()) {
            return null;
        }
        if (pref instanceof PreferenceListChild) {
            ((PreferenceListChild)((Object)pref)).setParentPreferencePage(this);
        }
        TreeItem item = new TreeItem(parent, 0);
        boolean prefEnabled = pref.isEnabled();
        item.setData((Object)pref);
        if (this.showEnabledCheckbox) {
            item.setText(new String[]{this.getLabel(pref, null), prefEnabled ? Messages.enabled : Messages.disabled});
            item.setChecked(prefEnabled);
        } else {
            item.setText(this.getLabel(pref, null));
        }
        if (pref instanceof PreferenceListNode && (children = (nest = (PreferenceListNode)((Object)pref)).getChildren()) != null) {
            int e = 0;
            while (e < children.length) {
                this.createTreeItem(item, children[e]);
                ++e;
            }
        }
        return item;
    }

    protected Control getTableControl() {
        return this.prefTable;
    }

    protected void createPreferenceControls(PreferenceListExtension pref, Composite parent, boolean enabled) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new FillLayout());
        comp.setData((Object)pref);
        pref.createControls(comp);
        this.prefGroupStack.topControl = comp;
        pref.initializeValues();
        pref.setEnabled(enabled);
        comp.layout();
    }

    protected void refreshTableItems() {
        super.refreshTableItems();
        this.treeViewer.refresh();
    }

    protected void refreshTableItem(PreferenceListExtension ext) {
        super.refreshTableItem(ext);
        this.treeViewer.refresh();
    }

    protected void savePreferenceValues() {
        if (this.prefList != null) {
            int i = 0;
            while (i < this.prefList.size()) {
                block4: {
                    PreferenceListExtension ext = (PreferenceListExtension)this.prefList.get(i);
                    try {
                        ext.saveValues();
                    }
                    catch (Exception e) {
                        if (!logger.isLoggable(Level.INFO)) break block4;
                        logger.log(Level.INFO, e.getMessage(), e);
                    }
                }
                ++i;
            }
        }
    }

    protected void restoreDefaultPrefs() {
        if (this.prefList != null) {
            int i = 0;
            while (i < this.prefList.size()) {
                block4: {
                    PreferenceListExtension ext = (PreferenceListExtension)this.prefList.get(i);
                    try {
                        ext.resetDefaults();
                    }
                    catch (Exception e) {
                        if (!logger.isLoggable(Level.INFO)) break block4;
                        logger.log(Level.INFO, e.getMessage(), e);
                    }
                }
                ++i;
            }
        }
    }

    public TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected void performDefaults() {
        this.restoreDefaultPrefs();
    }

    public PreferenceListExtension[] getPreferenceExtensions() {
        if (this.prefList != null) {
            return this.prefList.toArray(new PreferenceListExtension[this.prefList.size()]);
        }
        return null;
    }
}

