/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui.prefs;

import com.ibm.collaboration.realtime.ui.prefs.PreferenceListChild;
import com.ibm.collaboration.realtime.ui.prefs.PreferenceListDescriptor;
import com.ibm.collaboration.realtime.ui.prefs.PreferenceListExtension;
import com.ibm.collaboration.realtime.ui.prefs.PreferenceListManager;
import com.ibm.collaboration.realtime.ui.strings.Messages;
import com.ibm.collaboration.realtime.ui.util.SwtUtils;
import com.ibm.collaboration.realtime.ui.widgets.ScrolledPage;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class PreferenceListPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected String pluginid;
    protected String directionText;
    protected PreferenceListDescriptor[] descs;
    private static final Logger logger;
    protected Label directions;
    protected Table prefTable;
    protected Composite prefGroup;
    protected Label groupLabel;
    protected StackLayout prefGroupStack;
    protected PreferenceListExtension currentPref;
    protected boolean showEnabledCheckbox;
    private static final int MARGIN = 4;
    private boolean useScrollPage = true;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.collaboration.realtime.ui.prefs.PreferenceListPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getPackage().getName());
    }

    public PreferenceListPage(String plugin, String directionText, boolean showEnabledCheckbox) {
        this.pluginid = plugin;
        this.directionText = directionText;
        this.showEnabledCheckbox = showEnabledCheckbox;
    }

    protected void setUseScrollPage(boolean useScrollPage) {
        this.useScrollPage = useScrollPage;
    }

    protected Control createContents(Composite comp) {
        Composite parent = null;
        ScrolledPage scrolledPage = null;
        if (this.useScrollPage) {
            scrolledPage = new ScrolledPage(comp);
            Composite scrolledPagComp = scrolledPage.getBody();
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            scrolledPagComp.setLayout((Layout)layout);
            parent = new Composite(scrolledPagComp, 0);
            parent.setBackground(comp.getBackground());
        } else {
            parent = new Composite(comp, 0);
        }
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.verticalSpacing = 15;
        parent.setLayout((Layout)new FormLayout());
        parent.setLayoutData((Object)new GridData(1808));
        this.directions = new Label(parent, 64);
        this.directions.setText(this.directionText);
        this.createTable(parent);
        Composite group = new Composite(parent, 0);
        group.setLayout((Layout)new FormLayout());
        this.groupLabel = new Label(group, 0);
        Label sep = new Label(group, 258);
        this.prefGroup = new Composite(group, 0);
        this.prefGroupStack = new StackLayout();
        this.prefGroupStack.marginHeight = 1;
        this.prefGroupStack.marginWidth = 1;
        this.prefGroup.setLayout((Layout)this.prefGroupStack);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 4);
        fd.left = new FormAttachment(0, 4);
        fd.right = new FormAttachment(100, -4);
        this.directions.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.directions, 10);
        fd.left = new FormAttachment(0, 4);
        fd.right = new FormAttachment(100, -4);
        fd.height = 150;
        this.getTableControl().setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 0);
        this.groupLabel.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.groupLabel, 3);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        sep.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)sep, 4);
        fd.left = new FormAttachment(0, 4);
        fd.right = new FormAttachment(100, -4);
        fd.height = SwtUtils.usingHighContrast() ? 400 : 250;
        this.prefGroup.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(this.getTableControl(), 8);
        fd.left = new FormAttachment(0, 4);
        fd.right = new FormAttachment(100, -4);
        fd.bottom = new FormAttachment(100, -4);
        group.setLayoutData((Object)fd);
        this.populateTable();
        return this.useScrollPage ? scrolledPage : parent;
    }

    protected void createTable(Composite parent) {
        int style = 67584;
        if (this.showEnabledCheckbox) {
            style |= 0x20;
        }
        this.prefTable = new Table(parent, style);
        this.prefTable.setHeaderVisible(true);
        TableColumn col = new TableColumn(this.prefTable, 0);
        col.setText(Messages.event);
        col.setWidth(300);
        this.prefTable.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                TableItem item = (TableItem)event.item;
                String id = (String)item.getData();
                boolean showControls = !PreferenceListPage.this.showEnabledCheckbox;
                boolean resetControls = false;
                if (event.detail == 32) {
                    if (item.getChecked()) {
                        showControls = true;
                        item.setText(1, Messages.enabled);
                    } else {
                        item.setText(1, Messages.disabled);
                    }
                    PreferenceListPage.this.prefTable.setSelection(item);
                    resetControls = true;
                } else {
                    showControls = PreferenceListPage.this.showEnabledCheckbox ? item.getChecked() : true;
                    resetControls = true;
                }
                if (PreferenceListPage.this.prefTable.getSelectionCount() > 0 && item.equals(PreferenceListPage.this.prefTable.getSelection()[0])) {
                    showControls = PreferenceListPage.this.showEnabledCheckbox ? item.getChecked() : true;
                    resetControls = true;
                    id = (String)PreferenceListPage.this.prefTable.getSelection()[0].getData();
                }
                if (resetControls) {
                    int i = 0;
                    while (i < PreferenceListPage.this.descs.length) {
                        PreferenceListDescriptor desc = PreferenceListPage.this.descs[i];
                        if (desc.getId().compareTo(id) == 0) {
                            PreferenceListPage.this.currentPref = desc.getObject();
                            PreferenceListPage.this.groupLabel.setText(PreferenceListPage.this.getLabel(PreferenceListPage.this.currentPref, desc));
                            if (!PreferenceListPage.this.setSelectedPreference(desc)) {
                                PreferenceListPage.this.createPreferenceControls(desc, PreferenceListPage.this.prefGroup, showControls);
                            } else {
                                PreferenceListPage.this.currentPref.setEnabled(showControls);
                            }
                            PreferenceListPage.this.prefGroup.layout();
                            PreferenceListPage.this.prefGroup.getParent().layout();
                        }
                        ++i;
                    }
                }
            }
        });
        if (this.showEnabledCheckbox) {
            TableColumn enabled = new TableColumn(this.prefTable, 0);
            enabled.setText(Messages.enabled);
            enabled.setWidth(80);
            enabled.setAlignment(0x1000000);
        }
    }

    protected void populateTable() {
        if (this.descs != null) {
            int i = 0;
            while (i < this.descs.length) {
                PreferenceListDescriptor desc = this.descs[i];
                PreferenceListExtension pref = this.createPreferenceExtension(desc);
                if (pref != null && pref.isVisible()) {
                    if (pref instanceof PreferenceListChild) {
                        ((PreferenceListChild)((Object)pref)).setParentPreferencePage(this);
                    }
                    TableItem item = new TableItem(this.prefTable, 0);
                    boolean prefEnabled = pref.isEnabled();
                    item.setData((Object)desc.getId());
                    if (this.showEnabledCheckbox) {
                        item.setText(new String[]{this.getLabel(pref, desc), prefEnabled ? Messages.enabled : Messages.disabled});
                        item.setChecked(prefEnabled);
                    } else {
                        item.setText(this.getLabel(pref, desc));
                    }
                }
                ++i;
            }
        }
        if (this.prefTable.getItemCount() > 0) {
            this.prefTable.select(0);
            PreferenceListDescriptor desc = this.getFirstVisibleDesc();
            if (desc != null) {
                this.currentPref = desc.getObject();
                TableItem first = this.prefTable.getItem(0);
                this.groupLabel.setText(this.getLabel(this.currentPref, desc));
                if (!this.setSelectedPreference(desc)) {
                    this.createPreferenceControls(desc, this.prefGroup, this.showEnabledCheckbox ? first.getChecked() : true);
                } else {
                    this.currentPref.setEnabled(this.showEnabledCheckbox ? first.getChecked() : true);
                }
                this.prefGroup.layout();
                this.prefGroup.getParent().layout();
            }
        }
    }

    protected PreferenceListDescriptor getFirstVisibleDesc() {
        int i = 0;
        while (i < this.descs.length) {
            PreferenceListDescriptor desc = this.descs[i];
            PreferenceListExtension pref = desc.getObject();
            if (pref == null) {
                pref = desc.createObject();
            }
            if (pref != null && pref.isVisible()) {
                return desc;
            }
            ++i;
        }
        return null;
    }

    protected String getLabel(PreferenceListExtension ext, PreferenceListDescriptor desc) {
        String label = ext.getLabel();
        if (label != null && label.length() > 0) {
            return label;
        }
        return desc.getLabel();
    }

    protected PreferenceListExtension createPreferenceExtension(PreferenceListDescriptor desc) {
        return desc.createObject();
    }

    protected void createPreferenceControls(PreferenceListDescriptor desc, Composite parent, boolean enabled) {
        PreferenceListExtension pref = desc.createObject();
        if (pref != null) {
            Composite comp = new Composite(parent, 0);
            comp.setData((Object)desc.getId());
            GridLayout gl = new GridLayout();
            gl.marginHeight = 0;
            gl.marginWidth = 0;
            comp.setLayout((Layout)gl);
            comp.pack();
            this.createPreferenceControls(pref, comp, enabled);
            desc.createdUI = true;
        }
    }

    protected void createPreferenceControls(PreferenceListExtension pref, Composite parent, boolean enabled) {
        pref.setPrefPage(this);
        pref.createControls(parent);
        this.prefGroupStack.topControl = parent;
        pref.initializeValues();
        pref.setEnabled(enabled);
        parent.layout();
    }

    protected boolean setSelectedPreference(PreferenceListDescriptor desc) {
        Control[] kids = this.prefGroup.getChildren();
        int i = 0;
        while (i < kids.length) {
            if (kids[i] instanceof Composite) {
                Composite comp = (Composite)kids[i];
                if (desc.getId().compareTo((String)comp.getData()) == 0) {
                    this.prefGroupStack.topControl = comp;
                    return true;
                }
            }
            ++i;
        }
        return false;
    }

    public boolean performOk() {
        this.savePreferenceValues();
        return super.performOk();
    }

    public void init(IWorkbench workbench) {
        this.descs = PreferenceListManager.getExtensionsForPlugin(this.pluginid);
    }

    public PreferenceListDescriptor[] getPreferenceDescriptors() {
        return this.descs;
    }

    protected void savePreferenceValues() {
        if (this.descs != null) {
            int i = 0;
            while (i < this.descs.length) {
                block5: {
                    PreferenceListDescriptor desc = this.descs[i];
                    if (desc.getObject() != null) {
                        try {
                            desc.getObject().saveValues();
                        }
                        catch (Exception ex) {
                            if (!logger.isLoggable(Level.WARNING)) break block5;
                            logger.log(Level.WARNING, ex.getMessage(), ex);
                        }
                    }
                }
                ++i;
            }
        }
    }

    protected void performDefaults() {
        super.performDefaults();
        if (this.descs != null) {
            int i = 0;
            while (i < this.descs.length) {
                PreferenceListDescriptor desc = this.descs[i];
                TableItem item = this.getTableItem(desc.getId());
                if (item != null) {
                    PreferenceListExtension obj = desc.getObject();
                    if (obj == null) {
                        obj = desc.createObject();
                    }
                    boolean defaultEnabled = obj.resetDefaults();
                    if (this.showEnabledCheckbox) {
                        item.setChecked(defaultEnabled);
                        item.setText(1, defaultEnabled ? Messages.enabled : Messages.disabled);
                    }
                    if (this.currentPref != null && this.currentPref.equals(obj)) {
                        this.currentPref.setEnabled(defaultEnabled);
                        this.prefGroup.layout();
                        this.prefGroup.getParent().layout();
                    }
                }
                ++i;
            }
        }
    }

    protected TableItem getTableItem(String id) {
        TableItem[] items = this.prefTable.getItems();
        int i = 0;
        while (i < items.length) {
            String data = (String)items[i].getData();
            if (data != null && id != null && data.compareTo(id) == 0) {
                return items[i];
            }
            ++i;
        }
        return null;
    }

    protected Table getTable() {
        return this.prefTable;
    }

    protected TableItem getTableItem(PreferenceListExtension ext) {
        if (this.descs != null) {
            int i = 0;
            while (i < this.descs.length) {
                PreferenceListExtension obj;
                PreferenceListDescriptor desc = this.descs[i];
                TableItem item = this.getTableItem(desc.getId());
                if (item != null && (obj = desc.getObject()) != null && obj.equals(ext)) {
                    return item;
                }
                ++i;
            }
        }
        return null;
    }

    protected void refreshTableItems() {
    }

    protected void refreshTableItem(PreferenceListExtension ext) {
    }

    protected Control getTableControl() {
        return this.prefTable;
    }

    public void select(Object obj) {
        block6: {
            block5: {
                if (!(obj instanceof String)) break block5;
                if (this.descs == null) break block6;
                int i = 0;
                while (i < this.descs.length) {
                    PreferenceListDescriptor desc = this.descs[i];
                    if (desc.getId() != null && desc.getId().equals(obj)) {
                        TableItem item = this.getTableItem(desc.getId());
                        this.prefTable.setSelection(item);
                        return;
                    }
                    ++i;
                }
                break block6;
            }
            if (obj instanceof PreferenceListExtension && this.descs != null) {
                int i = 0;
                while (i < this.descs.length) {
                    PreferenceListDescriptor desc = this.descs[i];
                    if (desc.getObject() != null && desc.getObject().equals(obj)) {
                        TableItem item = this.getTableItem(desc.getId());
                        this.prefTable.setSelection(item);
                        return;
                    }
                    ++i;
                }
            }
        }
    }
}

