/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui.internal.registry;

import com.ibm.collaboration.realtime.ui.WorkbenchAdapter;
import com.ibm.collaboration.realtime.ui.internal.registry.ActionSetAdapter;
import com.ibm.collaboration.realtime.ui.internal.registry.WorkbenchFreeActionSetRegistry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.core.runtime.dynamichelpers.IExtensionTracker;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.registry.ActionSetDescriptor;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;

public class WorkbenchFreeActionSetRegistry {
    private final ArrayList children = new ArrayList();
    private final Map mapPartToActionSetIds = new HashMap();
    private final Map mapPartToActionSets = new HashMap();
    private static final Logger logger;
    private static final String ACTION_SETS = "actionSets";
    private final Set actionsToUpdate = Collections.synchronizedSet(new HashSet());
    private boolean updatingActions = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.collaboration.realtime.ui.internal.registry.WorkbenchFreeActionSetRegistry");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public WorkbenchFreeActionSetRegistry() {
        if (WorkbenchAdapter.isStandalone()) {
            RegistryFactory.getRegistry().addRegistryChangeListener(new IRegistryChangeListener(){

                public void registryChanged(IRegistryChangeEvent e) {
                    IExtensionDelta[] deltas = e.getExtensionDeltas();
                    ArrayList<IActionSetDescriptor> setsToActivate = new ArrayList<IActionSetDescriptor>();
                    if (deltas != null) {
                        int i = 0;
                        while (i < deltas.length) {
                            if (WorkbenchFreeActionSetRegistry.ACTION_SETS.equals(deltas[i].getExtensionPoint().getSimpleIdentifier())) {
                                Object[] registeredObjects = PlatformUI.getWorkbench().getExtensionTracker().getObjects(deltas[i].getExtension());
                                int ii = 0;
                                while (ii < registeredObjects.length) {
                                    if (registeredObjects[i] instanceof IActionSetDescriptor) {
                                        IActionSetDescriptor desc = (IActionSetDescriptor)registeredObjects[ii];
                                        setsToActivate.add(desc);
                                    }
                                    ++ii;
                                }
                                if (setsToActivate.isEmpty()) {
                                    return;
                                }
                            }
                            ++i;
                        }
                    }
                    if (!WorkbenchFreeActionSetRegistry.this.updatingActions) {
                        WorkbenchFreeActionSetRegistry.this.updatingActions = true;
                        WorkbenchFreeActionSetRegistry.this.actionsToUpdate.addAll(setsToActivate);
                        IActionSetDescriptor[] descriptors = WorkbenchFreeActionSetRegistry.this.actionsToUpdate.toArray(new IActionSetDescriptor[WorkbenchFreeActionSetRegistry.this.actionsToUpdate.size()]);
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (window == null) {
                            window = PlatformUI.getWorkbench().getWorkbenchWindows()[0];
                        }
                        if (window != null) {
                            WorkbenchWindow ww = (WorkbenchWindow)window;
                            WorkbenchPage currentPage = (WorkbenchPage)window.getActivePage();
                            window.getActivePage().addPartListener(new IPartListener(this, currentPage, ww){
                                final /* synthetic */ 1 this$1;
                                private final /* synthetic */ WorkbenchPage val$currentPage;
                                private final /* synthetic */ WorkbenchWindow val$ww;
                                {
                                    this.this$1 = var1_1;
                                    this.val$currentPage = workbenchPage;
                                    this.val$ww = workbenchWindow;
                                }

                                public void partActivated(IWorkbenchPart arg0) {
                                    if (WorkbenchFreeActionSetRegistry.access$2(1.access$0(this.this$1)) != null) {
                                        IActionSetDescriptor[] descriptors = WorkbenchFreeActionSetRegistry.access$2(1.access$0(this.this$1)).toArray(new IActionSetDescriptor[WorkbenchFreeActionSetRegistry.access$2(1.access$0(this.this$1)).size()]);
                                        IActionSetDescriptor[] ds = this.val$currentPage.getActionSets();
                                        int d = 0;
                                        while (d < ds.length) {
                                            int k = 0;
                                            while (k < descriptors.length) {
                                                if (ds[d].getId().equals(descriptors[k].getId())) {
                                                    ds[d] = descriptors[k];
                                                }
                                                ++k;
                                            }
                                            ++d;
                                        }
                                        IActionSetDescriptor[] set = ds;
                                        Display.getDefault().asyncExec(new Runnable(this, this.val$ww, set){
                                            final /* synthetic */ 2 this$2;
                                            private final /* synthetic */ WorkbenchWindow val$ww;
                                            private final /* synthetic */ IActionSetDescriptor[] val$set;
                                            {
                                                this.this$2 = var1_1;
                                                this.val$ww = workbenchWindow;
                                                this.val$set = iActionSetDescriptorArray;
                                            }

                                            public void run() {
                                                this.val$ww.getActionPresentation().setActionSets(this.val$set);
                                                this.val$ww.getMenuBarManager().update(false);
                                                WorkbenchFreeActionSetRegistry.access$1(1.access$0(2.access$0(this.this$2)), false);
                                            }
                                        });
                                    }
                                }

                                public void partClosed(IWorkbenchPart arg0) {
                                }

                                public void partBroughtToTop(IWorkbenchPart arg0) {
                                }

                                public void partDeactivated(IWorkbenchPart arg0) {
                                }

                                public void partOpened(IWorkbenchPart arg0) {
                                }

                                static /* synthetic */ 1 access$0(2 var0) {
                                    return var0.this$1;
                                }
                            });
                            IActionSetDescriptor[] ds = currentPage.getActionSets();
                            int d = 0;
                            while (d < ds.length) {
                                int k = 0;
                                while (k < descriptors.length) {
                                    if (ds[d].getId().equals(descriptors[k].getId())) {
                                        ds[d] = descriptors[k];
                                    }
                                    ++k;
                                }
                                ++d;
                            }
                            IActionSetDescriptor[] set = ds;
                            Display.getDefault().asyncExec(new Runnable(this, ww, set){
                                final /* synthetic */ 1 this$1;
                                private final /* synthetic */ WorkbenchWindow val$ww;
                                private final /* synthetic */ IActionSetDescriptor[] val$set;
                                {
                                    this.this$1 = var1_1;
                                    this.val$ww = workbenchWindow;
                                    this.val$set = iActionSetDescriptorArray;
                                }

                                public void run() {
                                    this.val$ww.getActionPresentation().clearActionSets();
                                    this.val$ww.getActionPresentation().setActionSets(this.val$set);
                                    this.val$ww.getMenuBarManager().update(false);
                                    WorkbenchFreeActionSetRegistry.access$1(1.access$0(this.this$1), false);
                                }
                            });
                        }
                    } else {
                        WorkbenchFreeActionSetRegistry.this.actionsToUpdate.addAll(setsToActivate);
                    }
                }

                static /* synthetic */ WorkbenchFreeActionSetRegistry access$0(1 var0) {
                    return var0.WorkbenchFreeActionSetRegistry.this;
                }
            });
        }
        this.readFromRegistry();
    }

    private IExtensionPoint getActionSetPartAssociationExtensionPoint() {
        return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", "actionSetPartAssociations");
    }

    private IExtensionPoint getActionSetExtensionPoint() {
        return Platform.getExtensionRegistry().getExtensionPoint("org.eclipse.ui", ACTION_SETS);
    }

    private void addActionSet(ActionSetDescriptor desc) {
        this.children.add(desc);
    }

    private Object addAssociation(String actionSetId, String partId) {
        ArrayList<String> actionSets = (ArrayList<String>)this.mapPartToActionSetIds.get(partId);
        if (actionSets == null) {
            actionSets = new ArrayList<String>();
            this.mapPartToActionSetIds.put(partId, actionSets);
        }
        actionSets.add(actionSetId);
        return new ActionSetPartAssociation(partId, actionSetId);
    }

    public IActionSetDescriptor findActionSet(String id) {
        Iterator i = this.children.iterator();
        while (i.hasNext()) {
            IActionSetDescriptor desc = (IActionSetDescriptor)i.next();
            if (!desc.getId().equals(id)) continue;
            return desc;
        }
        return null;
    }

    public IActionSetDescriptor[] getActionSets() {
        return this.children.toArray(new IActionSetDescriptor[this.children.size()]);
    }

    public IActionSetDescriptor[] getActionSetsFor(String partId) {
        ArrayList<IActionSetDescriptor> actionSets = (ArrayList<IActionSetDescriptor>)this.mapPartToActionSets.get(partId);
        if (actionSets != null) {
            return actionSets.toArray(new IActionSetDescriptor[actionSets.size()]);
        }
        ArrayList actionSetIds = (ArrayList)this.mapPartToActionSetIds.get(partId);
        if (actionSetIds == null) {
            return new IActionSetDescriptor[0];
        }
        actionSets = new ArrayList<IActionSetDescriptor>(actionSetIds.size());
        Iterator i = actionSetIds.iterator();
        while (i.hasNext()) {
            String actionSetId = (String)i.next();
            IActionSetDescriptor actionSet = this.findActionSet(actionSetId);
            if (actionSet != null) {
                actionSets.add(actionSet);
                continue;
            }
            if (!logger.isLoggable(Level.INFO)) continue;
            logger.log(Level.INFO, "Unable to associate action set with part: " + partId + ". Action set " + actionSetId + " not found.");
        }
        this.mapPartToActionSets.put(partId, actionSets);
        return actionSets.toArray(new IActionSetDescriptor[actionSets.size()]);
    }

    private void readFromRegistry() {
        IExtension[] extensions = this.getActionSetExtensionPoint().getExtensions();
        int i = 0;
        while (i < extensions.length) {
            this.addActionSets(null, extensions[i]);
            ++i;
        }
        extensions = this.getActionSetPartAssociationExtensionPoint().getExtensions();
        i = 0;
        while (i < extensions.length) {
            this.addActionSetPartAssociations(null, extensions[i]);
            ++i;
        }
    }

    private void addActionSetPartAssociations(IExtensionTracker tracker, IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals("actionSetPartAssociation")) {
                if (WorkbenchAdapter.isStandalone()) {
                    ActionSetAdapter.getInstance().fixupActionSetPartAssociations(element);
                }
                String actionSetId = element.getAttribute("targetID");
                IConfigurationElement[] children = element.getChildren();
                int j = 0;
                while (j < children.length) {
                    IConfigurationElement child = children[j];
                    if (child.getName().equals("part")) {
                        Object trackingObject;
                        String partId = child.getAttribute("id");
                        if (partId != null && (trackingObject = this.addAssociation(actionSetId, partId)) != null && tracker != null) {
                            tracker.registerObject(extension, trackingObject, 0);
                        }
                    } else if (logger.isLoggable(Level.INFO)) {
                        logger.log(Level.INFO, "Unable to process element: " + child.getName() + " in action set part associations extension: " + extension.getUniqueIdentifier());
                    }
                    ++j;
                }
            }
            ++i;
        }
        this.mapPartToActionSets.clear();
    }

    private void addActionSets(IExtensionTracker tracker, IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement element = elements[i];
            if (element.getName().equals("actionSet")) {
                try {
                    ActionSetDescriptor desc = new ActionSetDescriptor(element);
                    if (WorkbenchAdapter.isStandalone()) {
                        ActionSetAdapter.getInstance().fixupActionSetPaths(desc);
                    }
                    this.addActionSet(desc);
                    if (tracker != null) {
                        tracker.registerObject(extension, (Object)desc, 2);
                    }
                }
                catch (CoreException e) {
                    WorkbenchPlugin.log((String)"Unable to create action set descriptor.", (IStatus)e.getStatus());
                }
            }
            ++i;
        }
    }

    private class ActionSetPartAssociation {
        String partId;
        String actionSetId;

        public ActionSetPartAssociation(String partId, String actionSetId) {
            this.partId = partId;
            this.actionSetId = actionSetId;
        }
    }
}

