/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui;

import com.ibm.collaboration.realtime.ui.util.ColorCache;
import com.ibm.collaboration.realtime.util.OSUtils;
import java.util.ArrayList;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.ToolTip;

public class StatusComposite
extends Composite {
    private static int MIN_HEIGHT = 18;
    private static int MARGIN = 4;
    private static int VERTICAL_MARGIN = 3;
    private Image image = null;
    private String text = null;
    private static final boolean inFocus = false;
    private final Canvas drawable;
    private int internalIndex = 0;
    private boolean setFocusForAccessible = true;
    private ArrayList endStatusImages;

    public StatusComposite(Composite parent, int style) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.drawable = new Canvas(this, 0){

            public Point computeSize(int wHint, int hHint) {
                return this.getTotalSize();
            }

            public Point computeSize(int wHint, int hHint, boolean changed) {
                return this.getTotalSize();
            }

            private Point getTotalSize() {
                int height;
                Point pt = new Point(-1, 0);
                GC gc = new GC((Drawable)this);
                gc.setFont(Display.getCurrent().getSystemFont());
                Point text = gc.textExtent("hi");
                gc.dispose();
                pt.y = text.y + 2 * VERTICAL_MARGIN;
                if (StatusComposite.this.image != null && (height = ((StatusComposite)StatusComposite.this).image.getImageData().height) > pt.y) {
                    pt.y = height;
                }
                if (StatusComposite.this.endStatusImages != null) {
                    int i = 0;
                    while (i < StatusComposite.this.endStatusImages.size()) {
                        int height2;
                        StatusImage im = (StatusImage)StatusComposite.this.endStatusImages.get(i);
                        if (im.image != null && (height2 = im.image.getImageData().height) > pt.y) {
                            pt.y = height2;
                        }
                        ++i;
                    }
                }
                if (pt.y < MIN_HEIGHT) {
                    pt.y = MIN_HEIGHT;
                }
                return pt;
            }
        };
        this.drawable.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                StatusComposite.this.onPaint(e.gc);
            }
        });
        this.drawable.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                if (StatusComposite.this.endStatusImages != null) {
                    int i = 0;
                    while (i < StatusComposite.this.endStatusImages.size()) {
                        StatusImage im = (StatusImage)StatusComposite.this.endStatusImages.get(i);
                        if (im.bounds != null && im.bounds.contains(e.x, e.y)) {
                            StatusComposite.this.drawable.setToolTipText(im.tooltip);
                            return;
                        }
                        ++i;
                    }
                } else {
                    StatusComposite.this.drawable.setToolTipText(null);
                }
            }

            public void mouseExit(MouseEvent arg0) {
                StatusComposite.this.drawable.setToolTipText(null);
            }
        });
        this.drawable.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getValue(AccessibleControlEvent event) {
                event.result = StatusComposite.this.getText();
            }
        });
    }

    private String getAllText() {
        StringBuffer buff = new StringBuffer();
        if (this.text != null) {
            buff.append(this.text);
        }
        if (this.endStatusImages != null) {
            int i = 0;
            while (i < this.endStatusImages.size()) {
                StatusImage im = (StatusImage)this.endStatusImages.get(i);
                if (im.tooltip != null) {
                    buff.append("\n");
                    buff.append(im.tooltip);
                }
                ++i;
            }
        }
        return buff.toString();
    }

    private void onPaint(GC gc) {
        boolean hc = Display.getCurrent().getHighContrast();
        Rectangle rect = this.getClientArea();
        if (!hc) {
            Color backClr = ColorCache.getColor("WINDOW_STATUS_BACKGROUND");
            if (backClr == null) {
                backClr = Display.getCurrent().getSystemColor(29);
            }
            gc.setForeground(backClr);
            Color backClr2 = ColorCache.getColor("WINDOW_STATUS_BACKGROUND2");
            if (backClr2 == null) {
                backClr2 = Display.getCurrent().getSystemColor(29);
            }
            gc.setBackground(backClr2);
            gc.fillGradientRectangle(rect.x, rect.y, rect.width, rect.height, true);
        }
        if (!hc) {
            Color color = ColorCache.getColor("DARK_SEPARATOR_BACKGROUND");
            if (color == null) {
                color = Display.getCurrent().getSystemColor(29);
            }
            gc.setForeground(color);
        }
        gc.drawLine(rect.x, rect.y, rect.x + rect.width, rect.y);
        gc.drawLine(rect.x, rect.y + rect.height - 1, rect.x + rect.width, rect.y + rect.height - 1);
        int right = MARGIN;
        if (this.image != null) {
            gc.drawImage(this.image, right, (rect.height - this.image.getImageData().height) / 2);
            right += this.image.getImageData().width + MARGIN;
        }
        if (this.text != null) {
            if (!hc) {
                gc.setForeground(ColorCache.getColor("WINDOW_STATUS_FOREGROUND"));
            }
            Point extent = gc.textExtent(this.text);
            gc.drawText(this.text, right, (rect.height - extent.y) / 2, true);
        }
        if (this.endStatusImages != null) {
            right = rect.x + rect.width;
            if (OSUtils.isMac()) {
                right -= rect.height;
            }
            int i = 0;
            while (i < this.endStatusImages.size()) {
                StatusImage endImage = (StatusImage)this.endStatusImages.get(i);
                if (endImage.image != null) {
                    endImage.bounds = new Rectangle(right -= endImage.image.getImageData().width + MARGIN, (rect.height - endImage.image.getImageData().height) / 2, endImage.image.getImageData().width, endImage.image.getImageData().height);
                    gc.drawImage(endImage.image, right, (rect.height - endImage.image.getImageData().height) / 2);
                }
                ++i;
            }
        }
    }

    public void setImage(Image im) {
        this.image = im;
        this.redraw();
    }

    public void setEndImage(Image im, String tooltip) {
        if (this.endStatusImages == null) {
            this.endStatusImages = new ArrayList(3);
        }
        StatusImage endImage = new StatusImage();
        endImage.image = im;
        endImage.tooltip = tooltip;
        endImage.index = 0;
        if (this.endStatusImages.size() == 0) {
            this.endStatusImages.add(0, endImage);
        } else {
            this.endStatusImages.set(0, endImage);
        }
        this.redraw();
    }

    public void setText(String txt) {
        this.text = txt;
        this.redraw();
        if (this.text != null && this.text.length() > 0) {
            this.drawable.getAccessible().textChanged(0, 0, this.text.length());
        }
    }

    public void setTextAndImage(String txt, Image img) {
        this.text = txt;
        this.image = img;
        this.redraw();
        if (this.text != null && this.text.length() > 0) {
            this.drawable.getAccessible().textChanged(0, 0, this.text.length());
        }
    }

    public int addEndImage(Image im, String tooltip) {
        if (this.endStatusImages == null) {
            this.endStatusImages = new ArrayList(3);
        }
        StatusImage endImage = new StatusImage();
        endImage.image = im;
        endImage.tooltip = tooltip;
        endImage.index = ++this.internalIndex;
        this.endStatusImages.add(endImage);
        this.redraw();
        return endImage.index;
    }

    public boolean removeEndImage(int index) {
        if (this.endStatusImages == null) {
            return false;
        }
        boolean removed = false;
        StatusImage image = this.findStatusImage(index);
        if (image != null) {
            removed = this.endStatusImages.remove(image);
        }
        this.redraw();
        return removed;
    }

    public void showBubbleToolTip(ToolTip tip, int index) {
        if (this.endStatusImages == null) {
            return;
        }
        StatusImage image = this.findStatusImage(index);
        if (image != null && image.bounds != null) {
            Point toDisplay = this.toDisplay(image.bounds.x + image.bounds.width / 2, image.bounds.y + image.bounds.height / 2);
            tip.setLocation(toDisplay);
            tip.setVisible(true);
        }
    }

    private StatusImage findStatusImage(int index) {
        int i = 0;
        while (i < this.endStatusImages.size()) {
            StatusImage image = (StatusImage)this.endStatusImages.get(i);
            if (image.index == index) {
                return image;
            }
            ++i;
        }
        return null;
    }

    public String getText() {
        return this.text;
    }

    public Image getImage() {
        return this.image;
    }

    public void redraw() {
        super.redraw();
        if (this.drawable != null) {
            this.drawable.redraw();
        }
    }

    public void setFocusEventsForAccessible(boolean access) {
        this.setFocusForAccessible = access;
    }

    private class StatusImage {
        Image image;
        String tooltip;
        Rectangle bounds;
        int index = -1;

        private StatusImage() {
        }
    }
}

