/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui;

import com.ibm.collaboration.realtime.browser.Browser;
import com.ibm.collaboration.realtime.browser.LocationEvent;
import com.ibm.collaboration.realtime.browser.LocationListener;
import com.ibm.collaboration.realtime.ui.ExplorerWindow;
import com.ibm.collaboration.realtime.ui.STBrandingArea;
import com.ibm.collaboration.realtime.ui.strings.LogMessages;
import com.ibm.collaboration.realtime.ui.util.ImageCache;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.osgi.framework.Bundle;

public class STBrandingControl {
    private static final Logger _logger;
    private String id;
    private int height = -1;
    private int width = -1;
    private int align = 16384;
    private int valign = 128;
    private final String parentPlugin;
    private String url;
    private String image;
    private IConfigurationElement element;
    private IConfigurationElement messages;
    private final String brandId;
    private final String restriction;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.collaboration.realtime.ui.STBrandingControl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        _logger = Logger.getLogger(clazz.getPackage().getName());
    }

    public STBrandingControl(String brandId, String namespace, IConfigurationElement element) {
        String restrict;
        this.brandId = brandId;
        this.parentPlugin = namespace;
        String id = element.getAttribute("id");
        String width = element.getAttribute("width");
        String height = element.getAttribute("height");
        String valign = element.getAttribute("valign");
        String align = element.getAttribute("align");
        this.restriction = restrict = element.getAttribute("targetView");
        IConfigurationElement[] children = element.getChildren();
        if (children != null) {
            IConfigurationElement childElmt = children[0];
            if (childElmt.getName().equals("control")) {
                this.element = childElmt;
            } else if (childElmt.getName().equals("website")) {
                String url;
                this.url = url = childElmt.getAttribute("url");
            } else if (childElmt.getName().equals("image")) {
                String file;
                this.image = file = childElmt.getAttribute("file");
            } else if (childElmt.getName().equals("messages")) {
                this.messages = childElmt;
            }
        }
        this.setId(id);
        this.setWidth(this.parseInt(width));
        this.setHeight(this.parseInt(height));
        this.setAlignment(this.parseAlign(align));
        this.setVAlignment(this.parseVAlign(valign));
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getHeight() {
        return this.height;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public int getWidth() {
        return this.width;
    }

    public void setAlignment(int align) {
        this.align = align;
    }

    public int getAlignment() {
        return this.align;
    }

    public void setVAlignment(int valign) {
        this.valign = valign;
    }

    public int getVAlignment() {
        return this.valign;
    }

    public String getRestriction() {
        if (this.restriction != null && this.restriction.length() > 0) {
            return this.restriction;
        }
        return null;
    }

    public Control createControl(Composite composite) {
        if (this.url != null) {
            if (this.url.indexOf("http://") != 0 && this.url.indexOf("https://") != 0) {
                try {
                    String fileurl = FileLocator.toFileURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)this.parentPlugin), (IPath)new Path(this.url), null)).toString();
                    if (fileurl.indexOf("file:/") == 0 && fileurl.indexOf("file://") == -1) {
                        fileurl.replaceAll("file:/", "file://");
                    }
                    this.url = fileurl;
                }
                catch (Throwable throwable) {}
            }
            Browser browser = new Browser(composite, 0);
            browser.setUrl(this.url);
            browser.addLocationListener(new LocationListener(){

                public void changed(LocationEvent arg0) {
                }

                public void changing(LocationEvent arg0) {
                    if (!(arg0.location == null || arg0.location.trim().length() <= 0 || arg0.location.equals("file:///") || arg0.location.equals("about:blank") || arg0.location.startsWith("javascript:") || arg0.location.indexOf("applewebdata://") == 0)) {
                        ExplorerWindow.launchBrowser(arg0.location, arg0.location);
                        arg0.doit = false;
                    } else if (!arg0.location.equals("file:///") && !arg0.location.equals("about:blank")) {
                        arg0.location.indexOf("applewebdata://");
                    }
                }
            });
            return browser;
        }
        if (this.image != null) {
            Label label = new Label(composite, 0);
            label.setImage(ImageCache.getImage(this.parentPlugin, this.image));
            return label;
        }
        if (this.element != null) {
            try {
                STBrandingArea area = (STBrandingArea)this.element.createExecutableExtension("class");
                return area.createControl(composite);
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    public Image getImage() {
        if (this.image != null) {
            return ImageCache.getImage(this.parentPlugin, this.image);
        }
        return null;
    }

    public NLS getMessages() {
        block3: {
            if (this.messages != null) {
                try {
                    NLS customMessages = (NLS)this.messages.createExecutableExtension("class");
                    return customMessages;
                }
                catch (CoreException coreException) {
                    if (!_logger.isLoggable(Level.WARNING)) break block3;
                    _logger.warning(String.valueOf(LogMessages.STBrandingControl_0) + this.messages.getName());
                }
            }
        }
        return null;
    }

    private int parseInt(String width) {
        int defInt = -1;
        try {
            defInt = Integer.parseInt(width);
        }
        catch (NumberFormatException numberFormatException) {}
        return defInt;
    }

    private int parseAlign(String align) {
        if ("center".equals(align)) {
            return 0x1000000;
        }
        if ("right".equals(align)) {
            return 131072;
        }
        return 16384;
    }

    private int parseVAlign(String align) {
        if ("bottom".equals(align)) {
            return 1024;
        }
        if ("top".equals(align)) {
            return 128;
        }
        return -1;
    }

    public String getBrandId() {
        return this.brandId;
    }
}

