/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui;

import com.ibm.collaboration.realtime.magiccarpet.MessageEvent;
import com.ibm.collaboration.realtime.magiccarpet.messageprocessor.MessageProcessor;
import com.ibm.collaboration.realtime.ui.DisplayLoop;
import com.ibm.collaboration.realtime.ui.RtcUIPlugin;
import com.ibm.collaboration.realtime.ui.WorkbenchAdapter;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IWorkbenchPage;

public abstract class RtcUIView
implements IPerspectiveListener {
    protected static final Logger logger;
    private Shell _shell;
    private Composite _composite;
    private boolean _isAlive;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.collaboration.realtime.ui.RtcUIView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getPackage().getName());
    }

    protected abstract RtcUIPlugin getPlugin();

    public void createPartControl(Composite composite) {
        if (!this._isAlive) {
            this._composite = composite;
            this.initWindow();
            this._isAlive = true;
        }
    }

    protected Shell getShell() {
        Shell shell = null;
        if (this._shell != null) {
            shell = this._shell;
        } else if (this._composite != null && !this._composite.isDisposed() && (shell = this._composite.getDisplay().getActiveShell()) == null) {
            shell = this._composite.getShell();
        }
        return shell;
    }

    protected Composite getComposite() {
        return this._composite;
    }

    protected boolean isStandalone() {
        return WorkbenchAdapter.isStandalone();
    }

    public void showWindow() {
        this.initShell();
        this.initWindow();
        this.updateShellImage();
        Shell shell = this.getShell();
        if (shell.getMinimized()) {
            shell.setMinimized(false);
        }
        if (!shell.isVisible()) {
            shell.setVisible(true);
        }
        shell.setActive();
        shell.forceActive();
        this._isAlive = true;
    }

    protected void initShell() {
        Shell shell = this.getShell();
        if (this.isStandalone() && (shell == null || shell.isDisposed())) {
            String text;
            this._shell = new Shell(this.getDisplay());
            this._composite = this._shell;
            Image icon = this.getPlugin().getImageIcon();
            if (icon != null) {
                this._shell.setImage(icon);
            }
            if ((text = this.getPlugin().getAlias()) != null) {
                this._shell.setText(text);
            }
            this.loadShellPositionInformation();
            this._shell.addShellListener((ShellListener)new ShellAdapter(){

                public void shellClosed(ShellEvent e) {
                    e.doit = false;
                    RtcUIView.this.closeWindow();
                }
            });
        }
    }

    protected void initWindow() {
    }

    protected void updateShellImage() {
    }

    protected void closeWindow() {
        this.saveShellPositionInformation();
        this.getPlugin().setProperty("openState", "false");
        this.getPlugin().saveConfig();
        this._shell.setVisible(false);
        this.destroyWindow();
        this._shell.dispose();
        this._shell = null;
        this._isAlive = false;
        System.gc();
    }

    protected Display getDisplay() {
        Display display = null;
        display = this._shell != null && !this._shell.isDisposed() ? this._shell.getDisplay() : DisplayLoop.getDisplay();
        return display;
    }

    protected String getProperty(String propertyKey) {
        return this.getPlugin().getProperty(propertyKey);
    }

    protected void setProperty(String key, String val) {
        this.getPlugin().setProperty(key, val);
    }

    public void loadShellPositionInformation() {
        if (this._composite == null || this._composite.isDisposed()) {
            return;
        }
        String cx = this.getProperty("xpos");
        String cy = this.getProperty("ypos");
        if (cx != null && cy != null) {
            try {
                int xp = Integer.parseInt(cx);
                int yp = Integer.parseInt(cy);
                if (xp <= this.getDisplay().getClientArea().width && yp <= this.getDisplay().getClientArea().height) {
                    this._composite.setLocation(xp, yp);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        cx = this.getProperty("xsize");
        cy = this.getProperty("ysize");
        if (cx != null && cy != null) {
            try {
                this._composite.setSize(Integer.parseInt(cx), Integer.parseInt(cy));
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    protected void saveShellPositionInformation() {
        if (this._composite != null && this._composite.getChildren().length > 0) {
            this.setProperty("xpos", "" + this._composite.getLocation().x);
            this.setProperty("ypos", "" + this._composite.getLocation().y);
            this.setProperty("xsize", "" + this._composite.getSize().x);
            this.setProperty("ysize", "" + this._composite.getSize().y);
        }
    }

    protected void destroyWindow() {
    }

    public Point getShellLocation() {
        Point location = null;
        if (this._shell != null) {
            location = this._shell.getLocation();
        }
        return location;
    }

    public void openMessageBoxError(String title, String msg) {
        MessageDialog.openError((Shell)this._shell, (String)title, (String)msg);
    }

    protected void postMessageEvent(MessageEvent event) {
        MessageProcessor.getInstance().postMessageEvent(event);
    }

    protected boolean isAlive() {
        return this._isAlive;
    }

    protected void setIsAlive(boolean alive) {
        this._isAlive = alive;
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }

    public void perspectiveChanged(IWorkbenchPage page, IPerspectiveDescriptor perspective, String changeId) {
        if (changeId.equals("editorClose")) {
            this.getPlugin().setProperty("openState", "false");
            this.getPlugin().saveConfig();
            this.destroyWindow();
            this._isAlive = false;
            this._composite.dispose();
            this._composite = null;
        }
    }
}

