/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui;

import com.ibm.collaboration.realtime.magiccarpet.MessageEvent;
import java.util.Hashtable;
import java.util.Set;
import org.eclipse.swt.graphics.Image;

public class MessageEventMenuMap {
    Hashtable buttonTable = new Hashtable(1);
    String defaultOptionText;
    String defaultOptionToolTipText;
    MessageEvent defaultOptionMessageEvent;
    Image defaultOptionIcon;
    private boolean closeShellOnAction = true;

    public MessageEventMenuMap(String defaultOptionText, String defaultOptionToolTipText, MessageEvent defaultOptionMessageEvent) {
        this(defaultOptionText, defaultOptionToolTipText, defaultOptionMessageEvent, null);
    }

    public MessageEventMenuMap(String defaultOptionText, String defaultOptionToolTipText, MessageEvent defaultOptionMessageEvent, Image defaultOptionIcon) {
        this.defaultOptionMessageEvent = defaultOptionMessageEvent;
        this.defaultOptionText = defaultOptionText;
        this.defaultOptionToolTipText = defaultOptionToolTipText;
        this.defaultOptionIcon = defaultOptionIcon;
    }

    public void putMenuEntry(String text, String toolTipText, MessageEvent msgEvt) {
        this.putMenuEntry(text, toolTipText, msgEvt, true);
    }

    public void putMenuEntry(String text, String toolTipText, MessageEvent msgEvt, boolean closeAlertOnAction) {
        this.buttonTable.put(text, new ButtonData(toolTipText, msgEvt, closeAlertOnAction));
    }

    public MessageEvent getMessageEvent(String text) {
        ButtonData data = (ButtonData)this.buttonTable.get(text);
        if (data == null) {
            return null;
        }
        return data.msgEvt;
    }

    public String getToolTipText(String text) {
        ButtonData data = (ButtonData)this.buttonTable.get(text);
        if (data == null) {
            return null;
        }
        return data.toolTipText;
    }

    public boolean isCloseShellOnAction(String text) {
        ButtonData data = (ButtonData)this.buttonTable.get(text);
        if (data == null) {
            return false;
        }
        return data.closeShellOnAction;
    }

    public MessageEvent getDefaultOptionMessageEvent() {
        return this.defaultOptionMessageEvent;
    }

    public String getDefaultOptionText() {
        return this.defaultOptionText;
    }

    public String getDefaultOptionToolTipText() {
        return this.defaultOptionToolTipText;
    }

    public boolean hasMultipleEntries() {
        return this.buttonTable.size() > 0;
    }

    public Set keySet() {
        return this.buttonTable.keySet();
    }

    public Image getDefaultOptionIcon() {
        return this.defaultOptionIcon;
    }

    public void setDefaultOptionIcon(Image defaultOptionIcon) {
        this.defaultOptionIcon = defaultOptionIcon;
    }

    public boolean isCloseShellOnAction() {
        return this.closeShellOnAction;
    }

    public void setCloseShellOnAction(boolean closeShellOnAction) {
        this.closeShellOnAction = closeShellOnAction;
    }

    private class ButtonData {
        String toolTipText;
        MessageEvent msgEvt;
        boolean closeShellOnAction = true;

        public ButtonData(String toolTipText, MessageEvent msgEvt, boolean closeShellOnAction) {
            this.toolTipText = toolTipText;
            this.msgEvt = msgEvt;
            this.closeShellOnAction = closeShellOnAction;
        }
    }
}

