/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui;

import com.ibm.collaboration.realtime.ui.UiPlugin;
import com.ibm.collaboration.realtime.ui.strings.Messages;
import com.ibm.collaboration.realtime.ui.util.window.WindowUtils;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class MailInitDialog
extends Dialog {
    public static final String PREF_INIT_MAIL = "external.init.mail";
    private Shell itsParentShell;
    private boolean itsResult = false;
    private Button itsBtnMail;
    private Button itsBtnDefMail;
    private Combo itsMailAppCombo;
    private boolean showUserIsOfflineMsg;

    public static boolean showDialog() {
        boolean result;
        Preferences preferences = UiPlugin.getDefault().getPluginPreferences();
        preferences.setDefault(PREF_INIT_MAIL, false);
        if (!preferences.getBoolean(PREF_INIT_MAIL)) {
            String strMailClient = preferences.getString("external.application.mail");
            if (strMailClient != null && strMailClient.length() > 0) {
                result = true;
                preferences.setValue(PREF_INIT_MAIL, true);
            } else {
                MailInitDialog dlg = new MailInitDialog(Display.getDefault().getActiveShell());
                boolean bl = result = dlg.open() == 0;
                if (result) {
                    preferences.setValue(PREF_INIT_MAIL, true);
                }
            }
        } else {
            result = true;
        }
        return result;
    }

    public MailInitDialog(Shell parent, int style) {
        super(parent);
        this.itsParentShell = parent;
    }

    public MailInitDialog(Shell parent) {
        this(parent, 0x10860 | Window.getDefaultOrientation());
    }

    protected Control createDialogArea(Composite arg0) {
        String strs;
        Composite itsShell = (Composite)super.createDialogArea(arg0);
        Label userIsOfflineLbl = null;
        if (this.showUserIsOfflineMsg) {
            userIsOfflineLbl = new Label(itsShell, 16384);
            userIsOfflineLbl.setText(Messages.maildlg_contact_offline);
        }
        Label lbl = new Label(itsShell, 16384);
        lbl.setText(Messages.maildlg_prompt);
        this.itsBtnDefMail = new Button(itsShell, 16);
        this.itsBtnDefMail.setText(Messages.app_use_default_mail);
        this.itsBtnMail = new Button(itsShell, 16);
        this.itsBtnMail.setText(Messages.app_use_mail);
        this.itsMailAppCombo = new Combo(itsShell, 12);
        Label lbl2 = new Label(itsShell, 16384);
        lbl2.setText(Messages.maildlg_note);
        WindowUtils winutils = new WindowUtils(null);
        if (winutils != null && (strs = winutils.getMailClientNames()) != null) {
            int pos = -1;
            int lastpos = 0;
            while ((pos = strs.indexOf(59, lastpos)) != -1) {
                this.itsMailAppCombo.add(strs.substring(lastpos, pos));
                lastpos = pos + 1;
            }
        }
        this.itsBtnDefMail.setSelection(true);
        this.itsBtnMail.setSelection(false);
        this.itsMailAppCombo.setEnabled(false);
        this.selectMailInit();
        this.itsBtnDefMail.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MailInitDialog.this.itsMailAppCombo.setEnabled(false);
            }
        });
        this.itsBtnMail.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                MailInitDialog.this.itsMailAppCombo.setEnabled(true);
            }
        });
        FormLayout fl = new FormLayout();
        fl.marginWidth = 10;
        fl.marginHeight = 10;
        itsShell.setLayout((Layout)fl);
        FormData fd = new FormData();
        if (userIsOfflineLbl != null) {
            userIsOfflineLbl.setLayoutData((Object)fd);
        }
        fd = new FormData();
        lbl.setLayoutData((Object)fd);
        if (userIsOfflineLbl != null) {
            fd.top = new FormAttachment((Control)userIsOfflineLbl, 10);
        }
        fd = new FormData();
        fd.top = new FormAttachment((Control)lbl, 10);
        this.itsBtnDefMail.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.itsBtnDefMail, 10);
        this.itsBtnMail.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.itsBtnDefMail, 8);
        fd.left = new FormAttachment((Control)this.itsBtnMail, 0);
        fd.right = new FormAttachment(100, 0);
        this.itsMailAppCombo.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.itsBtnMail, 10);
        lbl2.setLayoutData((Object)fd);
        this.itsBtnDefMail.setFocus();
        return itsShell;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.maildlg_title);
    }

    private void selectMailInit() {
        String[] items = this.itsMailAppCombo.getItems();
        if (items != null) {
            int iSel = -1;
            int i = 0;
            while (i < items.length) {
                String item = items[i];
                if (item.indexOf("Lotus Notes") == 0) {
                    iSel = i;
                    break;
                }
                ++i;
            }
            if (items.length > 0) {
                if (iSel == -1) {
                    iSel = 0;
                }
                this.itsMailAppCombo.select(iSel);
            }
        }
    }

    protected void okPressed() {
        this.pressedOK();
        super.okPressed();
    }

    public void pressedOK() {
        Preferences preferences;
        int selected;
        this.itsResult = true;
        if (this.itsBtnMail.getSelection() && (selected = this.itsMailAppCombo.getSelectionIndex()) >= 0 && (preferences = UiPlugin.getDefault().getPluginPreferences()) != null) {
            preferences.setValue("external.application.use.default.mail", false);
            String[] items = this.itsMailAppCombo.getItems();
            preferences.setValue("external.application.mail", items[selected]);
        }
    }
}

