/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui;

import com.ibm.collaboration.realtime.ui.ExplorerWindow;
import com.ibm.collaboration.realtime.ui.ExternalApplicationPreferences;
import com.ibm.collaboration.realtime.ui.MailInitDialog;
import com.ibm.collaboration.realtime.ui.strings.LogMessages;
import com.ibm.collaboration.realtime.ui.util.window.WindowUtils;
import com.ibm.collaboration.realtime.util.OSUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class MailComposer {
    private final String m_title;
    private String m_to;
    private String m_subject;
    private URL m_url = null;
    private File m_File = null;
    private static final Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.collaboration.realtime.core.CorePlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getPackage().getName());
    }

    public MailComposer(String title) {
        this.m_title = title == null ? "" : title;
    }

    public void setTo(String to) {
        this.m_to = to;
    }

    public void setSubject(String subject) {
        this.m_subject = subject;
    }

    public void setFile(File fContents) {
        this.m_File = fContents;
        try {
            this.m_url = fContents.toURL();
        }
        catch (Exception exception) {}
    }

    public boolean invoke() {
        boolean result = true;
        if (OSUtils.isLinux()) {
            String prefCmd = ExternalApplicationPreferences.getMailCommand();
            if (prefCmd != null) {
                prefCmd = prefCmd.trim();
                if (logger.isLoggable(Level.FINE)) {
                    logger.log(Level.FINE, "Email command is: " + prefCmd);
                }
                if (prefCmd.indexOf(" ") < 0) {
                    prefCmd = String.valueOf(prefCmd) + " %s";
                }
                ArrayList<String> cmdList = new ArrayList<String>();
                if (!ExternalApplicationPreferences.useCustomMailer()) {
                    String shortCmd = prefCmd;
                    int spacePos = shortCmd.indexOf(" ");
                    if (spacePos > 0) {
                        shortCmd = shortCmd.substring(0, spacePos);
                    }
                    if (shortCmd.toLowerCase().indexOf("notes") >= 0) {
                        block55: {
                            block54: {
                                if (logger.isLoggable(Level.FINE)) {
                                    logger.log(Level.FINE, "Email application is Lotus Notes.");
                                }
                                cmdList.add("gnome-open");
                                if (this.m_to != null) {
                                    try {
                                        this.m_to = URLEncoder.encode(this.m_to, "UTF-8");
                                    }
                                    catch (UnsupportedEncodingException e) {
                                        if (!logger.isLoggable(Level.SEVERE)) break block54;
                                        logger.log(Level.SEVERE, LogMessages.MailComposer_22, e);
                                    }
                                }
                            }
                            if (this.m_subject != null) {
                                try {
                                    this.m_subject = URLEncoder.encode(this.m_subject, "UTF-8");
                                }
                                catch (UnsupportedEncodingException e) {
                                    if (!logger.isLoggable(Level.SEVERE)) break block55;
                                    logger.log(Level.SEVERE, LogMessages.MailComposer_20, e);
                                }
                            }
                        }
                        if (this.m_to != null && this.m_subject != null) {
                            cmdList.add("mailto:" + this.m_to + "?subject=" + this.m_subject);
                        } else if (this.m_to != null && this.m_subject == null) {
                            cmdList.add("mailto:" + this.m_to);
                        } else if (this.m_to == null && this.m_subject != null) {
                            cmdList.add("mailto:?subject=" + this.m_subject);
                        } else {
                            cmdList.add("mailto:");
                        }
                    } else if (shortCmd.equalsIgnoreCase("kmail")) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "Email application is kmail");
                        }
                        cmdList.add(shortCmd);
                        if (this.m_subject != null) {
                            cmdList.add("-s");
                            cmdList.add("\"" + this.m_subject + "\"");
                        }
                        if (this.m_url != null) {
                            cmdList.add("--attach");
                            cmdList.add(this.m_url.toString());
                        }
                        if (this.m_to != null) {
                            cmdList.add(this.m_to);
                        }
                    } else if (prefCmd.equalsIgnoreCase("mozilla")) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "Email application is mozilla");
                        }
                        String sep = "";
                        cmdList.add(shortCmd);
                        cmdList.add("-compose");
                        if (this.m_to != null) {
                            cmdList.add("to=\"" + this.m_to + "\"");
                            sep = ",";
                        }
                        if (this.m_subject != null) {
                            cmdList.add(String.valueOf(sep) + "subject=" + "\"" + this.m_subject + "\"");
                            sep = ",";
                        }
                        if (this.m_url != null) {
                            String attach = this.m_url.getFile();
                            cmdList.add(String.valueOf(sep) + "attachment=" + attach);
                        }
                    } else {
                        StringTokenizer tokenizer;
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, "Email application is other email (non-customer specified) application.");
                        }
                        if ((tokenizer = new StringTokenizer(prefCmd, " ")).hasMoreTokens()) {
                            while (tokenizer.hasMoreTokens()) {
                                String aToken = tokenizer.nextToken();
                                if (aToken.equals("%s")) {
                                    if (this.m_url != null) {
                                        cmdList.add(this.m_url.toString());
                                        continue;
                                    }
                                    if (this.m_to == null) continue;
                                    cmdList.add(this.m_to);
                                    continue;
                                }
                                cmdList.add(aToken);
                            }
                        }
                    }
                } else {
                    StringTokenizer tokenizer;
                    if (logger.isLoggable(Level.FINE)) {
                        logger.log(Level.FINE, "Email application is customer email program.");
                    }
                    if ((tokenizer = new StringTokenizer(prefCmd, " ")).hasMoreTokens()) {
                        while (tokenizer.hasMoreTokens()) {
                            String aToken = tokenizer.nextToken();
                            if (aToken.equals("%s")) {
                                if (this.m_url != null) {
                                    cmdList.add(this.m_url.toString());
                                    continue;
                                }
                                if (this.m_to == null) continue;
                                cmdList.add(this.m_to);
                                continue;
                            }
                            cmdList.add(aToken);
                        }
                    }
                }
                if (cmdList.size() > 0) {
                    String[] cmdArray = new String[cmdList.size()];
                    cmdList.toArray(cmdArray);
                    try {
                        if (logger.isLoggable(Level.INFO)) {
                            logger.log(Level.INFO, String.valueOf(LogMessages.MailComposer_25) + this.commandArrayToString(cmdArray));
                        }
                        Runtime.getRuntime().exec(cmdArray);
                        result = true;
                    }
                    catch (Throwable t) {
                        if (logger.isLoggable(Level.SEVERE)) {
                            logger.log(Level.SEVERE, LogMessages.MailComposer_26, t);
                        }
                        result = false;
                    }
                }
            }
        } else if (OSUtils.isWin32()) {
            WindowUtils utils;
            if (MailInitDialog.showDialog() && (utils = new WindowUtils(null)) != null) {
                Job job = new Job("InvokeMailCompositionJob"){

                    protected IStatus run(IProgressMonitor monitor) {
                        int rc = 0;
                        String prefClient = ExternalApplicationPreferences.getMailClientName();
                        if (MailComposer.this.m_File != null) {
                            rc = utils.invokeMailComposition(prefClient, MailComposer.this.m_subject, MailComposer.this.m_to, MailComposer.this.m_File.getPath());
                        } else if (MailComposer.this.m_subject != null) {
                            rc = utils.invokeMailComposition(prefClient, MailComposer.this.m_subject, MailComposer.this.m_to, "");
                        } else {
                            boolean bLaunch = true;
                            if (bLaunch) {
                                rc = utils.invokeMailComposition(prefClient, MailComposer.this.m_subject, MailComposer.this.m_to, "");
                            }
                        }
                        if (rc == 0 && logger.isLoggable(Level.SEVERE)) {
                            logger.log(Level.SEVERE, LogMessages.MailComposer_28);
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        } else {
            String mailToString = "mailto:";
            if (this.m_to != null) {
                mailToString = String.valueOf(mailToString) + this.m_to;
            }
            ExplorerWindow.launchBrowser(this.m_title, mailToString);
        }
        return result;
    }

    private String commandArrayToString(String[] cmdArray) {
        StringBuffer resultBuffer = new StringBuffer();
        int index = 0;
        while (index < cmdArray.length) {
            if (index > 0) {
                resultBuffer.append(' ');
            }
            resultBuffer.append(cmdArray[index]);
            ++index;
        }
        return resultBuffer.toString();
    }
}

