/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui;

import com.ibm.collaboration.realtime.ui.UiPlugin;
import com.ibm.collaboration.realtime.ui.strings.LogMessages;
import com.ibm.collaboration.realtime.ui.strings.Messages;
import com.ibm.collaboration.realtime.ui.util.window.WindowUtils;
import com.ibm.collaboration.realtime.ui.widgets.ScrolledPage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ExternalApplicationPreferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final Logger logger;
    public static final String PREF_USE_CUSTOM_BROWSER = "external.application.use.custom.browser";
    public static final String PREF_USE_CUSTOM_MAIL = "external.application.use.custom.mail";
    public static final String PREF_APPLICATION_BROWSER = "external.application.browser";
    public static final String PREF_CUSTOM_BROWSER = "external.custom.browser";
    public static final String PREF_APPLICATION_MAIL = "external.application.mail";
    public static final String PREF_USE_DEFAULT_MAIL = "external.application.use.default.mail";
    public static final String PREF_CUSTOM_MAIL = "external.custom.mail";
    private static final String GCONF_PATH = ".gconf/desktop/gnome/url-handlers";
    private final String osName;
    private String defaultBrowser;
    private String defaultMailer;
    private Button buttonBrowser;
    private Button buttonCustomBrowser;
    private Button buttonMail;
    private Button buttonDefMail;
    private Button buttonCustomMail;
    private Combo browserAppCombo;
    private Combo mailAppCombo;
    private Text customBrowserText;
    private Text customMailText;
    private Label labelSystemBrowser;
    private Label labelSystemMail;
    private Label labelNoPrefs;
    private final Preferences preferences = UiPlugin.getDefault().getPluginPreferences();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.collaboration.realtime.ui.ExternalApplicationPreferences");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getPackage().getName());
    }

    public ExternalApplicationPreferences() {
        super(Messages.pref_external_application);
        this.osName = System.getProperty("os.name").toLowerCase();
    }

    protected Control createContents(Composite parent) {
        ScrolledPage scrolledPage = new ScrolledPage(parent);
        Composite scrolledPageComp = scrolledPage.getBody();
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        scrolledPageComp.setLayout((Layout)layout);
        Composite control = new Composite(scrolledPageComp, 0);
        control.setLayout((Layout)new GridLayout());
        control.setLayoutData((Object)new GridData(1808));
        this.defaultBrowser = ExternalApplicationPreferences.getSystemDefaultBrowser();
        this.defaultMailer = ExternalApplicationPreferences.getSystemDefaultMailer();
        if (this.osName.startsWith("linux")) {
            Group systemSettings = null;
            if (this.defaultBrowser != null || this.defaultMailer != null) {
                systemSettings = new Group(control, 0);
                systemSettings.setText(Messages.pref_current_system_settings);
                systemSettings.setLayout((Layout)new FormLayout());
                systemSettings.setLayoutData((Object)new GridData(768));
            }
            Group browserSettings = new Group(control, 0);
            browserSettings.setText(Messages.pref_browser);
            browserSettings.setLayout((Layout)new FormLayout());
            browserSettings.setLayoutData((Object)new GridData(768));
            Group mailSettings = new Group(control, 0);
            mailSettings.setText(Messages.pref_mail);
            mailSettings.setLayout((Layout)new FormLayout());
            mailSettings.setLayoutData((Object)new GridData(768));
            this.buttonBrowser = new Button((Composite)browserSettings, 16);
            this.buttonBrowser.setText(Messages.app_select_browser);
            this.buttonBrowser.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    ExternalApplicationPreferences.this.browserAppCombo.setEnabled(true);
                    ExternalApplicationPreferences.this.customBrowserText.setEnabled(false);
                }
            });
            this.browserAppCombo = new Combo((Composite)browserSettings, 12);
            if (this.osName.startsWith("win") || this.defaultBrowser != null) {
                this.browserAppCombo.add(Messages.system_default);
            }
            this.browserAppCombo.add(Messages.browser_name_firefox);
            if (this.osName.startsWith("linux")) {
                this.browserAppCombo.add(Messages.browser_name_mozilla);
                this.browserAppCombo.add(Messages.browser_name_konqueror);
                this.browserAppCombo.add(Messages.browser_name_galeon);
            } else if (this.osName.startsWith("win")) {
                this.browserAppCombo.add(Messages.browser_name_ie);
            }
            this.buttonCustomBrowser = new Button((Composite)browserSettings, 16);
            this.buttonCustomBrowser.setText(Messages.app_custom_browser);
            this.buttonCustomBrowser.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    ExternalApplicationPreferences.this.browserAppCombo.setEnabled(false);
                    ExternalApplicationPreferences.this.customBrowserText.setEnabled(true);
                }
            });
            this.customBrowserText = new Text((Composite)browserSettings, 2048);
            this.customBrowserText.setText(this.getPreferences().getString(PREF_CUSTOM_BROWSER));
            this.buttonMail = new Button((Composite)mailSettings, 16);
            this.buttonMail.setText(Messages.app_select_mail);
            this.buttonMail.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    ExternalApplicationPreferences.this.mailAppCombo.setEnabled(true);
                    ExternalApplicationPreferences.this.customMailText.setEnabled(false);
                }
            });
            this.mailAppCombo = new Combo((Composite)mailSettings, 12);
            if (this.osName.startsWith("win") || this.defaultMailer != null) {
                this.mailAppCombo.add(Messages.system_default);
            }
            if (this.osName.startsWith("linux")) {
                this.mailAppCombo.add(Messages.mail_name_mozilla);
                this.mailAppCombo.add(Messages.mail_name_kmail);
                this.mailAppCombo.add(Messages.mail_name_thunderbird);
            }
            this.buttonCustomMail = new Button((Composite)mailSettings, 16);
            this.buttonCustomMail.setText(Messages.app_custom_mail);
            this.buttonCustomMail.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    ExternalApplicationPreferences.this.mailAppCombo.setEnabled(false);
                    ExternalApplicationPreferences.this.customMailText.setEnabled(true);
                }
            });
            this.customMailText = new Text((Composite)mailSettings, 2048);
            this.customMailText.setText(this.getPreferences().getString(PREF_CUSTOM_MAIL));
            if (systemSettings != null) {
                this.labelSystemBrowser = new Label((Composite)systemSettings, 16384);
                if (this.defaultBrowser != null) {
                    this.labelSystemBrowser.setText(NLS.bind((String)Messages.system_browser_setting, (Object)this.defaultBrowser));
                } else {
                    this.labelSystemBrowser.setText("");
                }
                if (this.defaultMailer != null) {
                    this.labelSystemMail = new Label((Composite)systemSettings, 16384);
                    this.labelSystemMail.setText(NLS.bind((String)Messages.system_mail_setting, (Object)this.defaultMailer));
                }
            }
            FormData fd = new FormData();
            fd.top = new FormAttachment(0, 10);
            fd.left = new FormAttachment(0, 4);
            this.buttonBrowser.setLayoutData((Object)fd);
            fd = new FormData();
            fd.top = new FormAttachment((Control)this.buttonBrowser, 0, 0x1000000);
            fd.left = new FormAttachment((Control)this.buttonBrowser, 5, 131072);
            fd.width = 200;
            this.browserAppCombo.setLayoutData((Object)fd);
            fd = new FormData();
            fd.top = new FormAttachment((Control)this.buttonBrowser, 20);
            fd.left = new FormAttachment((Control)this.buttonBrowser, 0, 16384);
            this.buttonCustomBrowser.setLayoutData((Object)fd);
            fd = new FormData();
            fd.top = new FormAttachment((Control)this.buttonCustomBrowser, 0, 0x1000000);
            fd.left = new FormAttachment((Control)this.buttonCustomBrowser, 5, 131072);
            fd.right = new FormAttachment((Control)this.buttonCustomBrowser, -3);
            fd.right = new FormAttachment(100, 0);
            this.customBrowserText.setLayoutData((Object)fd);
            fd = new FormData();
            fd.top = new FormAttachment(0, 10);
            fd.left = new FormAttachment(0, 4);
            this.buttonMail.setLayoutData((Object)fd);
            fd = new FormData();
            fd.top = new FormAttachment((Control)this.buttonMail, 0, 0x1000000);
            fd.left = new FormAttachment((Control)this.buttonMail, 5, 131072);
            fd.width = 200;
            this.mailAppCombo.setLayoutData((Object)fd);
            fd = new FormData();
            fd.top = new FormAttachment((Control)this.buttonMail, 20);
            fd.left = new FormAttachment((Control)this.buttonMail, 0, 16384);
            this.buttonCustomMail.setLayoutData((Object)fd);
            fd = new FormData();
            fd.top = new FormAttachment((Control)this.buttonCustomMail, 0, 0x1000000);
            fd.left = new FormAttachment((Control)this.buttonCustomMail, 5, 131072);
            fd.right = new FormAttachment(100, 0);
            this.customMailText.setLayoutData((Object)fd);
            if (systemSettings != null) {
                fd = new FormData();
                fd.top = new FormAttachment(0, 10);
                fd.left = new FormAttachment(0, 4);
                this.labelSystemBrowser.setLayoutData((Object)fd);
                if (this.labelSystemMail != null) {
                    fd = new FormData();
                    fd.top = new FormAttachment((Control)this.labelSystemBrowser, 5);
                    fd.left = new FormAttachment((Control)this.labelSystemBrowser, 0, 16384);
                    this.labelSystemMail.setLayoutData((Object)fd);
                }
            }
            this.initSettings(false);
        } else if (this.osName.startsWith("win")) {
            String strs;
            Group mailSettings = new Group(control, 0);
            mailSettings.setText(Messages.pref_mail);
            this.buttonDefMail = new Button((Composite)mailSettings, 16);
            this.buttonDefMail.setText(Messages.app_use_default_mail);
            this.buttonMail = new Button((Composite)mailSettings, 16);
            this.buttonMail.setText(Messages.app_use_mail);
            this.mailAppCombo = new Combo((Composite)mailSettings, 12);
            WindowUtils winutils = new WindowUtils(null);
            if (winutils != null && (strs = winutils.getMailClientNames()) != null) {
                int pos = -1;
                int lastpos = 0;
                while ((pos = strs.indexOf(59, lastpos)) != -1) {
                    this.mailAppCombo.add(strs.substring(lastpos, pos));
                    lastpos = pos + 1;
                }
            }
            this.buttonDefMail.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    ExternalApplicationPreferences.this.mailAppCombo.setEnabled(false);
                }
            });
            this.buttonMail.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    ExternalApplicationPreferences.this.mailAppCombo.setEnabled(true);
                }
            });
            mailSettings.setLayout((Layout)new FormLayout());
            mailSettings.setLayoutData((Object)new GridData(768));
            FormData fd = new FormData();
            fd.top = new FormAttachment(0, 5);
            fd.left = new FormAttachment(0, 5);
            this.buttonDefMail.setLayoutData((Object)fd);
            fd = new FormData();
            fd.top = new FormAttachment((Control)this.buttonDefMail, 5);
            fd.left = new FormAttachment(0, 5);
            this.buttonMail.setLayoutData((Object)fd);
            fd = new FormData();
            fd.top = new FormAttachment((Control)this.buttonDefMail, 3);
            fd.left = new FormAttachment((Control)this.buttonMail, 0);
            fd.right = new FormAttachment(100, -5);
            this.mailAppCombo.setLayoutData((Object)fd);
            this.initSettings(false);
        } else {
            Group explainSettings = new Group(control, 0);
            explainSettings.setLayout((Layout)new FormLayout());
            explainSettings.setLayoutData((Object)new GridData(768));
            this.labelNoPrefs = new Label((Composite)explainSettings, 0x1000000);
            this.labelNoPrefs.setText(Messages.no_external_app_prefs);
            FormData fd = new FormData();
            fd.top = new FormAttachment(0, 10);
            fd.left = new FormAttachment(0, 4);
            fd.right = new FormAttachment(100, -10);
            this.labelNoPrefs.setLayoutData((Object)fd);
        }
        return scrolledPage;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        if (this.osName.startsWith("linux")) {
            boolean useCustomBrowser = false;
            if (this.buttonCustomBrowser.getSelection()) {
                useCustomBrowser = true;
            }
            this.getPreferences().setValue(PREF_USE_CUSTOM_BROWSER, useCustomBrowser);
            if (useCustomBrowser) {
                String browserText = this.customBrowserText.getText().trim();
                if (browserText.length() > 0) {
                    this.getPreferences().setValue(PREF_CUSTOM_BROWSER, browserText);
                }
            } else {
                int selected = this.browserAppCombo.getSelectionIndex();
                if (selected >= 0) {
                    String[] items = this.browserAppCombo.getItems();
                    this.getPreferences().setValue(PREF_APPLICATION_BROWSER, items[selected]);
                }
            }
            boolean useCustomMail = false;
            if (this.buttonCustomMail.getSelection()) {
                useCustomMail = true;
            }
            this.getPreferences().setValue(PREF_USE_CUSTOM_MAIL, useCustomMail);
            if (useCustomMail) {
                String mailText = this.customMailText.getText().trim();
                if (mailText.length() > 0) {
                    this.getPreferences().setValue(PREF_CUSTOM_MAIL, mailText);
                }
            } else {
                int selected = this.mailAppCombo.getSelectionIndex();
                if (selected >= 0) {
                    String[] items = this.mailAppCombo.getItems();
                    this.getPreferences().setValue(PREF_APPLICATION_MAIL, items[selected]);
                }
            }
        } else if (this.osName.startsWith("win")) {
            this.getPreferences().setValue(PREF_USE_DEFAULT_MAIL, this.buttonDefMail.getSelection());
            int selected = this.mailAppCombo.getSelectionIndex();
            if (selected >= 0) {
                String[] items = this.mailAppCombo.getItems();
                this.getPreferences().setValue(PREF_APPLICATION_MAIL, items[selected]);
            }
        }
        return super.performOk();
    }

    protected void performDefaults() {
        this.initSettings(true);
        super.performDefaults();
    }

    private void initSettings(boolean bDefaults) {
        if (this.osName.startsWith("win")) {
            String strMailClient;
            boolean bDefMail;
            if (bDefaults) {
                bDefMail = this.getPreferences().getDefaultBoolean(PREF_USE_DEFAULT_MAIL);
                strMailClient = this.getPreferences().getDefaultString(PREF_APPLICATION_MAIL);
            } else {
                bDefMail = this.getPreferences().getBoolean(PREF_USE_DEFAULT_MAIL);
                strMailClient = this.getPreferences().getString(PREF_APPLICATION_MAIL);
            }
            if (bDefMail) {
                this.buttonDefMail.setSelection(true);
                this.buttonMail.setSelection(false);
                this.mailAppCombo.setEnabled(false);
            } else {
                this.buttonDefMail.setSelection(false);
                this.buttonMail.setSelection(true);
                this.mailAppCombo.setEnabled(true);
            }
            if (strMailClient == null || strMailClient.length() == 0) {
                if (this.mailAppCombo.getItemCount() > 0) {
                    this.selectMailInit();
                }
            } else {
                String[] strs = this.mailAppCombo.getItems();
                boolean bSet = false;
                int i = 0;
                while (i < strs.length) {
                    if (strs[i].compareTo(strMailClient) == 0) {
                        this.mailAppCombo.select(i);
                        bSet = true;
                        break;
                    }
                    ++i;
                }
                if (!bSet && this.mailAppCombo.getItemCount() > 0) {
                    this.selectMailInit();
                }
            }
        } else if (this.osName.startsWith("linux")) {
            int index;
            String[] items;
            int foundIndex;
            String mailApp;
            String browserApp;
            if (bDefaults) {
                this.buttonBrowser.setSelection(!this.getPreferences().getDefaultBoolean(PREF_USE_CUSTOM_BROWSER));
                this.buttonCustomBrowser.setSelection(this.getPreferences().getDefaultBoolean(PREF_USE_CUSTOM_BROWSER));
                this.customBrowserText.setText(this.getPreferences().getDefaultString(PREF_CUSTOM_BROWSER));
                browserApp = this.getPreferences().getDefaultString(PREF_APPLICATION_BROWSER);
                this.buttonMail.setSelection(!this.getPreferences().getDefaultBoolean(PREF_USE_CUSTOM_MAIL));
                this.buttonCustomMail.setSelection(this.getPreferences().getDefaultBoolean(PREF_USE_CUSTOM_MAIL));
                mailApp = this.getPreferences().getDefaultString(PREF_APPLICATION_MAIL);
                this.customMailText.setText(this.getPreferences().getDefaultString(PREF_CUSTOM_MAIL));
            } else {
                this.buttonBrowser.setSelection(!this.getPreferences().getBoolean(PREF_USE_CUSTOM_BROWSER));
                this.buttonCustomBrowser.setSelection(this.getPreferences().getBoolean(PREF_USE_CUSTOM_BROWSER));
                this.customBrowserText.setText(this.getPreferences().getString(PREF_CUSTOM_BROWSER));
                browserApp = this.getPreferences().getString(PREF_APPLICATION_BROWSER);
                this.buttonMail.setSelection(!this.getPreferences().getBoolean(PREF_USE_CUSTOM_MAIL));
                this.buttonCustomMail.setSelection(this.getPreferences().getBoolean(PREF_USE_CUSTOM_MAIL));
                this.customMailText.setText(this.getPreferences().getString(PREF_CUSTOM_MAIL));
                mailApp = this.getPreferences().getString(PREF_APPLICATION_MAIL);
            }
            if (browserApp != null) {
                foundIndex = -1;
                items = this.browserAppCombo.getItems();
                index = 0;
                while (foundIndex < 0 && index < items.length) {
                    if (items[index].equals(browserApp)) {
                        foundIndex = index;
                    }
                    ++index;
                }
                if (foundIndex >= 0) {
                    this.browserAppCombo.select(foundIndex);
                }
            }
            if (mailApp != null) {
                foundIndex = -1;
                items = this.mailAppCombo.getItems();
                index = 0;
                while (foundIndex < 0 && index < items.length) {
                    if (items[index].equals(mailApp)) {
                        foundIndex = index;
                    }
                    ++index;
                }
                if (foundIndex >= 0) {
                    this.mailAppCombo.select(foundIndex);
                }
            }
            if (this.buttonBrowser.getSelection()) {
                this.customBrowserText.setEnabled(false);
                this.browserAppCombo.setEnabled(true);
            } else {
                this.browserAppCombo.setEnabled(false);
                this.customBrowserText.setEnabled(true);
            }
            if (this.buttonMail.getSelection()) {
                this.customMailText.setEnabled(false);
                this.mailAppCombo.setEnabled(true);
            } else {
                this.mailAppCombo.setEnabled(false);
                this.customMailText.setEnabled(true);
            }
        }
    }

    private void selectMailInit() {
        String[] items = this.mailAppCombo.getItems();
        if (items != null) {
            int iSel = -1;
            int i = 0;
            while (i < items.length) {
                String item = items[i];
                if (item.indexOf("Lotus Notes") == 0) {
                    iSel = i;
                    break;
                }
                ++i;
            }
            if (items.length > 0) {
                if (iSel == -1) {
                    iSel = 0;
                }
                this.mailAppCombo.select(iSel);
            }
        }
    }

    public static boolean useSystemDefaultBrowser() {
        String browser;
        boolean result = false;
        Preferences preferences = UiPlugin.getDefault().getPluginPreferences();
        boolean useCustomBrowser = preferences.getBoolean(PREF_USE_CUSTOM_BROWSER);
        if (!useCustomBrowser && (browser = preferences.getString(PREF_APPLICATION_BROWSER)).equals(Messages.system_default)) {
            result = true;
        }
        return result;
    }

    public static boolean useSystemDefaultMailer() {
        String mailer;
        boolean result = false;
        Preferences preferences = UiPlugin.getDefault().getPluginPreferences();
        boolean useCustomMailer = preferences.getBoolean(PREF_USE_CUSTOM_MAIL);
        if (!useCustomMailer && (mailer = preferences.getString(PREF_APPLICATION_MAIL)).equals(Messages.system_default)) {
            result = true;
        }
        return result;
    }

    public static boolean useCustomBrowser() {
        boolean result = false;
        Preferences preferences = UiPlugin.getDefault().getPluginPreferences();
        boolean useCustomBrowser = preferences.getBoolean(PREF_USE_CUSTOM_BROWSER);
        if (useCustomBrowser) {
            result = true;
        }
        return result;
    }

    public static boolean useCustomMailer() {
        boolean result = false;
        Preferences preferences = UiPlugin.getDefault().getPluginPreferences();
        boolean useCustomMailer = preferences.getBoolean(PREF_USE_CUSTOM_MAIL);
        if (useCustomMailer) {
            result = true;
        }
        return result;
    }

    public static String getBrowserCommand() {
        String result = null;
        if (ExternalApplicationPreferences.useSystemDefaultBrowser()) {
            result = ExternalApplicationPreferences.getSystemDefaultBrowser();
        } else {
            Preferences preferences = UiPlugin.getDefault().getPluginPreferences();
            boolean useCustomBrowser = preferences.getBoolean(PREF_USE_CUSTOM_BROWSER);
            if (!useCustomBrowser) {
                String name = preferences.getString(PREF_APPLICATION_BROWSER);
                result = ExternalApplicationPreferences.convertBrowserSelection(name);
            } else {
                result = preferences.getString(PREF_CUSTOM_BROWSER);
            }
        }
        return result;
    }

    public static String getMailCommand() {
        String result = null;
        if (ExternalApplicationPreferences.useSystemDefaultMailer()) {
            result = ExternalApplicationPreferences.getSystemDefaultMailer();
        } else {
            Preferences preferences = UiPlugin.getDefault().getPluginPreferences();
            boolean useCustomMailer = preferences.getBoolean(PREF_USE_CUSTOM_MAIL);
            if (!useCustomMailer) {
                String name = preferences.getString(PREF_APPLICATION_MAIL);
                result = ExternalApplicationPreferences.convertMailSelection(name);
            } else {
                result = preferences.getString(PREF_CUSTOM_MAIL);
            }
        }
        return result;
    }

    public static String getMailClientName() {
        String result = null;
        Preferences preferences = UiPlugin.getDefault().getPluginPreferences();
        if (!preferences.getBoolean(PREF_USE_DEFAULT_MAIL)) {
            result = preferences.getString(PREF_APPLICATION_MAIL);
        }
        return result;
    }

    protected Preferences getPreferences() {
        return this.preferences;
    }

    protected void savePreferences() {
        UiPlugin.getDefault().savePluginPreferences();
    }

    protected static String getSystemDefaultBrowser() {
        String result;
        block5: {
            String path;
            File gconfFile;
            result = null;
            if (System.getProperty("os.name").toLowerCase().startsWith("linux") && (gconfFile = new File(path = String.valueOf(System.getProperty("user.home")) + "/" + GCONF_PATH + "/http/%gconf.xml")).exists() && gconfFile.canRead()) {
                try {
                    GConfParser parser = new GConfParser();
                    FileReader reader = new FileReader(gconfFile);
                    parser.parseInfo(new InputSource(new BufferedReader(reader)));
                    if (parser.enabled) {
                        result = parser.command;
                        if (logger.isLoggable(Level.INFO)) {
                            logger.log(Level.INFO, String.valueOf(LogMessages.ExternalApplicationPreferences_0) + result);
                        }
                    }
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(Level.WARNING)) break block5;
                    logger.log(Level.WARNING, t.getMessage(), t);
                }
            }
        }
        return result;
    }

    protected static String getSystemDefaultMailer() {
        String result;
        block5: {
            String path;
            File gconfFile;
            result = null;
            if (System.getProperty("os.name").toLowerCase().startsWith("linux") && (gconfFile = new File(path = String.valueOf(System.getProperty("user.home")) + "/" + GCONF_PATH + "/mailto/%gconf.xml")).exists() && gconfFile.canRead()) {
                try {
                    GConfParser parser = new GConfParser();
                    FileReader reader = new FileReader(gconfFile);
                    parser.parseInfo(new InputSource(new BufferedReader(reader)));
                    if (parser.enabled) {
                        result = parser.command;
                        if (logger.isLoggable(Level.INFO)) {
                            logger.log(Level.INFO, String.valueOf(LogMessages.ExternalApplicationPreferences_1) + result);
                        }
                    }
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(Level.WARNING)) break block5;
                    logger.log(Level.WARNING, t.getMessage(), t);
                }
            }
        }
        return result;
    }

    private static String convertBrowserSelection(String selection) {
        String result = null;
        if (selection.equals(Messages.browser_name_firefox)) {
            result = "firefox";
        } else if (selection.equals(Messages.browser_name_mozilla)) {
            result = "mozilla";
        } else if (selection.equals(Messages.browser_name_galeon)) {
            result = "galeon";
        } else if (selection.equals(Messages.browser_name_konqueror)) {
            result = "konqueror";
        } else if (selection.equals(Messages.browser_name_ie)) {
            result = "ie";
        }
        return result;
    }

    private static String convertMailSelection(String selection) {
        String result = null;
        if (selection.equals(Messages.mail_name_kmail)) {
            result = "kmail";
        } else if (selection.equals(Messages.mail_name_mozilla)) {
            result = "mozilla";
        } else if (selection.equals(Messages.mail_name_notes)) {
            result = "notes";
        } else if (selection.equals(Messages.mail_name_thunderbird)) {
            result = "thunderbird";
        }
        return result;
    }

    private static class GConfParser
    extends DefaultHandler {
        String command = null;
        boolean enabled = true;
        private boolean inCommand = false;
        private boolean inCommandValue = false;

        private GConfParser() {
        }

        public void parseInfo(InputSource inputSrc) {
            block2: {
                try {
                    SAXParserFactory factory = SAXParserFactory.newInstance();
                    factory.setNamespaceAware(true);
                    SAXParser parser = factory.newSAXParser();
                    parser.parse(inputSrc, (DefaultHandler)this);
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.WARNING)) break block2;
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
        }

        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            if (localName.equals("entry")) {
                int index = attrs.getIndex("name");
                if (index >= 0) {
                    String sEnabled;
                    int vindex;
                    String name = attrs.getValue(index);
                    if (name.equals("command")) {
                        this.inCommand = true;
                    } else if (name.equals("enabled") && (vindex = attrs.getIndex("value")) >= 0 && (sEnabled = attrs.getValue(vindex)).equals("false")) {
                        this.enabled = false;
                    }
                }
            } else if (localName.equals("stringvalue") && this.inCommand) {
                this.inCommandValue = true;
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (localName.equals("entry")) {
                if (this.inCommand) {
                    this.inCommand = false;
                } else if (this.inCommandValue) {
                    this.inCommandValue = false;
                }
            }
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inCommandValue) {
                this.command = new String(ch, start, length);
                this.inCommandValue = false;
            }
        }
    }
}

