/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.ui;

import com.ibm.collaboration.realtime.ui.BrowserLauncher;
import com.ibm.collaboration.realtime.ui.UiPlugin;
import com.ibm.collaboration.realtime.ui.strings.LogMessages;
import com.ibm.collaboration.realtime.util.OSUtils;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public class ExplorerWindow {
    static final Logger logger;
    Shell shell;
    Display display;
    Thread th;
    String message = null;
    String currentUrl = null;
    static int s_counter;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.collaboration.realtime.ui.ExplorerWindow");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getPackage().getName());
        s_counter = 1;
    }

    public static void launchBrowser(String message, String location) {
        block10: {
            try {
                if (OSUtils.isWin32()) {
                    Program.launch((String)location);
                } else if (OSUtils.isMac()) {
                    try {
                        Runtime.getRuntime().exec("open " + location);
                    }
                    catch (IOException e) {
                        if (logger.isLoggable(Level.WARNING)) {
                            logger.log(Level.WARNING, NLS.bind((String)LogMessages.ExplorerWindow_errorlinux, (Object)location), e);
                        }
                    }
                } else if (OSUtils.isLinux()) {
                    BrowserLauncher launcher = new BrowserLauncher();
                    launcher.launch(location);
                }
            }
            catch (Throwable ioe) {
                if (!logger.isLoggable(Level.WARNING)) break block10;
                logger.log(Level.WARNING, NLS.bind((String)LogMessages.ExplorerWindow_error, (Object)location), ioe);
            }
        }
    }

    public static void openBrowserSpecial(String header, String url) {
        ExplorerWindow.openBrowserSpecial(header, url, null);
    }

    public static void openBrowserSpecial(String header, String url, String proxyPrefs) {
        String application = "[App]\nVendor=IBM\nName=OpenUrl" + s_counter + "\nVersion=1.0\nBuildID=20070613\nCopyright=Copyright (c) IBM\nID=openurl@ibm" + "\n\n[Gecko]\nMinVersion=1.8\nMaxVersion=1.8";
        Bundle xulBundle = Platform.getBundle((String)"com.ibm.swt.xulrunner");
        if (xulBundle == null || xulBundle.getState() == 2 || !OSUtils.isWin32()) {
            ExplorerWindow.launchBrowser("Fallback to regular browser", url);
            return;
        }
        String xulFile = "";
        if (OSUtils.isWin32()) {
            xulFile = "xulrunner.exe";
        } else if (OSUtils.isLinux()) {
            xulFile = "xulrunner";
        } else if (OSUtils.isMac()) {
            xulFile = "xulrunner";
        }
        String pathToXul = "";
        try {
            URL url2 = FileLocator.find((Bundle)xulBundle, (IPath)new Path("/xulrunner/" + xulFile), null);
            pathToXul = FileLocator.toFileURL((URL)url2).getFile();
        }
        catch (IOException e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.fine("problems locating xulruner.ini " + pathToXul + " , defaulting to regular mode");
                logger.log(Level.WARNING, e.getMessage(), e);
            }
            ExplorerWindow.launchBrowser("", url);
            return;
        }
        String pathToApplication = "";
        try {
            pathToApplication = UiPlugin.getDefault().getStateLocation() + "/xulapp/application.ini";
            FileWriter fw = new FileWriter(pathToApplication, false);
            fw.write(application);
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.fine("problems locating application.ini " + pathToApplication + " , defaulting to regular mode");
                logger.log(Level.WARNING, e.getMessage(), e);
            }
            ExplorerWindow.launchBrowser("", url);
            return;
        }
        ++s_counter;
        String extraFlags = "";
        if (OSUtils.isWin32()) {
            extraFlags = "";
        } else if (OSUtils.isLinux()) {
            extraFlags = "";
        } else if (OSUtils.isMac()) {
            extraFlags = "";
        }
        StringBuffer execBuffer = new StringBuffer();
        execBuffer.append("\"");
        execBuffer.append(pathToXul.substring(1));
        execBuffer.append(extraFlags);
        execBuffer.append("\" \"");
        execBuffer.append(pathToApplication);
        execBuffer.append("\" \"");
        execBuffer.append(url);
        execBuffer.append("\" \"");
        execBuffer.append(header);
        execBuffer.append("\"");
        if (proxyPrefs != null) {
            execBuffer.append(" " + proxyPrefs);
        }
        try {
            Runtime.getRuntime().exec(execBuffer.toString());
        }
        catch (IOException iOException) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.fine("Cannot run XulRunner, defaulting to regular mode");
            }
            ExplorerWindow.launchBrowser("", url);
            return;
        }
    }
}

