/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.annotate;

import com.ibm.collaboration.realtime.annotate.AbstractLifecycleManager;
import com.ibm.collaboration.realtime.annotate.ActivationEvent;
import com.ibm.collaboration.realtime.annotate.AnnotationManager;
import com.ibm.collaboration.realtime.annotate.AnnotationProvider;
import com.ibm.collaboration.realtime.annotate.EclipsePlugin;
import com.ibm.collaboration.realtime.annotate.IActivationListener;
import com.ibm.collaboration.realtime.annotate.IAnnotationProperties;
import com.ibm.collaboration.realtime.annotate.ILifecycleManaged;
import com.ibm.collaboration.realtime.annotate.IReadOnlyListener;
import com.ibm.collaboration.realtime.annotate.LinkRange;
import com.ibm.collaboration.realtime.annotate.strings.Messages;
import com.ibm.collaboration.realtime.annotate.ui.InsertLinkDialog;
import com.ibm.collaboration.realtime.ui.ExplorerWindow;
import com.ibm.collaboration.realtime.ui.util.HTMLUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class LinkifyAnnotationProvider
extends AnnotationProvider
implements IReadOnlyListener {
    private static final String TOOL_TIP = Messages.linkify_tooltip;
    private static AbstractLifecycleManager theAbstractLifecycleManager;
    private static Pattern linkPattern;
    private static Pattern protocolPattern;
    private static String[] allowedProtocolsList;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.collaboration.realtime.annotate.LinkifyAnnotationProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        theAbstractLifecycleManager = new AbstractLifecycleManager(clazz){

            protected ILifecycleManaged constructInstance() {
                return new LinkifyAnnotationProvider(null);
            }
        };
    }

    public static AbstractLifecycleManager getLifecycleManager() {
        return theAbstractLifecycleManager;
    }

    public static Pattern getLinkPattern() {
        return linkPattern;
    }

    public static Pattern getProtocolPattern() {
        return protocolPattern;
    }

    private LinkifyAnnotationProvider() {
        super(new IActivationListener(){

            public void activated(ActivationEvent e) {
                Menu menu = null;
                AnnotationManager manager = AnnotationManager.getAnnotationManager(e.annotation.getStyledText());
                menu = manager != null ? manager.getContextMenu() : new Menu((Decorations)e.annotation.getStyledText().getShell(), 8);
                new MenuItem(menu, 2);
                MenuItem item = new MenuItem(menu, 0);
                item.setText(Messages.linkify_edit);
                item.addSelectionListener((SelectionListener)new SelectionAdapter(this, e, manager){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ ActivationEvent val$e;
                    private final /* synthetic */ AnnotationManager val$manager;
                    {
                        this.this$1 = var1_1;
                        this.val$e = activationEvent;
                        this.val$manager = annotationManager;
                    }

                    public void widgetSelected(SelectionEvent event) {
                        String text = this.val$e.annotation.getAnnotatedText();
                        String url = null;
                        StyleRange style = this.val$e.annotation.getStyle();
                        if (style instanceof LinkRange) {
                            url = ((LinkRange)style).link;
                        }
                        InsertLinkDialog dialog = new InsertLinkDialog(this.val$e.annotation.getStyledText());
                        if (!this.val$manager.isRichTextEnabled()) {
                            dialog.setNameEnabled(false);
                        } else {
                            dialog.setName(text);
                        }
                        dialog.setUrl(url);
                        if (style != null) {
                            dialog.setCurrentRange(style);
                        }
                        dialog.open();
                    }
                });
                item = new MenuItem(menu, 0);
                item.setText(Messages.linkify_open);
                item.addSelectionListener((SelectionListener)new SelectionAdapter(this, e){
                    final /* synthetic */ 2 this$1;
                    private final /* synthetic */ ActivationEvent val$e;
                    {
                        this.this$1 = var1_1;
                        this.val$e = activationEvent;
                    }

                    public void widgetSelected(SelectionEvent event) {
                        String text;
                        String url = text = this.val$e.annotation.getAnnotatedText();
                        StyleRange style = this.val$e.annotation.getStyle();
                        if (style instanceof LinkRange) {
                            url = ((LinkRange)style).link;
                        }
                        if (url.toLowerCase().startsWith("www.")) {
                            url = "http://" + url;
                        }
                        ExplorerWindow.launchBrowser((String)url, (String)url);
                    }
                });
                menu.setLocation(e.getAbsoluteCursorPosition());
                menu.setVisible(true);
            }
        });
        String userAllowed;
        String[] stringArray = new String[2];
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.ibm.collaboration.realtime.annotate.AnnotatedRange");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[0] = clazz.getName();
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("com.ibm.collaboration.realtime.annotate.LinkRange");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        stringArray[1] = clazz2.getName();
        this.setHandledRangeTypes(stringArray);
        String allowedProtocols = EclipsePlugin.getDefault().getPreferenceStore().getString("validprotocols");
        if (allowedProtocols == null || allowedProtocols.length() == 0) {
            allowedProtocols = "http://|ftp://|news://|https://|callto://|notes://|mailto:|im:|ictbp:|ictim:|voicejam:";
        }
        if ((userAllowed = EclipsePlugin.getDefault().getPreferenceStore().getString("userprotocols")) != null && userAllowed.length() > 0) {
            StringBuffer b = new StringBuffer();
            b.append(allowedProtocols);
            b.append("|");
            b.append(userAllowed);
            allowedProtocols = b.toString();
        }
        if (allowedProtocolsList == null) {
            allowedProtocolsList = allowedProtocols.split("\\|");
        }
        StringBuffer pattern = new StringBuffer(500);
        pattern.append("\\b(");
        pattern.append(allowedProtocols);
        pattern.append("|www\\.");
        pattern.append(")[^\\s]*");
        linkPattern = Pattern.compile(pattern.toString(), 2);
        pattern = new StringBuffer(200);
        pattern.append("\\b(");
        pattern.append(allowedProtocols);
        pattern.append(")[^\\s]*");
        protocolPattern = Pattern.compile(pattern.toString(), 2);
    }

    public static String[] getAllowedProtocols() {
        return allowedProtocolsList;
    }

    public void dispose() {
    }

    public String getToolTip(IAnnotationProperties annotationProperties) {
        StyleRange range = annotationProperties.getStyle();
        if (range instanceof LinkRange) {
            if (annotationProperties.isReadOnly()) {
                return ((LinkRange)range).link;
            }
            return String.valueOf(TOOL_TIP) + ":\n" + ((LinkRange)range).link;
        }
        return TOOL_TIP;
    }

    public boolean isAnnotatable(IAnnotationProperties annotationProperties) {
        int beginOffset = 0;
        int endOffset = 0;
        String text = annotationProperties.getAnnotatedText();
        int i = 0;
        while (i < text.length()) {
            if (Character.isLetter(text.charAt(i))) break;
            ++beginOffset;
            ++i;
        }
        i = text.length() - 1;
        while (i >= beginOffset) {
            char curChar = text.charAt(i);
            if (curChar != '.' && curChar != ',' && curChar != '!' && curChar != ')' && curChar != '}' && curChar != ';' && curChar != '?' && curChar != ']' && curChar != '|') break;
            ++endOffset;
            --i;
        }
        if ((beginOffset != 0 || endOffset != 0) && (text = text.substring(0 + beginOffset, text.length() - endOffset)).length() == 0) {
            return false;
        }
        Matcher matcher = linkPattern.matcher(text);
        if (matcher.matches()) {
            String group = matcher.group();
            LinkRange range = new LinkRange();
            range.foreground = Display.getCurrent().getSystemColor(9);
            range.fontStyle = 1;
            if (group != null) {
                String link = group;
                if (link.toLowerCase().indexOf("www.") == 0) {
                    link = "http://" + link;
                }
                String amped = group;
                try {
                    amped = HTMLUtils.convertPlainTextToHTML((String)amped);
                }
                catch (Throwable throwable) {}
                range.link = link;
                range.replacementText = NLS.bind((String)Messages.linkHtml, (Object)link, (Object)amped);
            }
            annotationProperties.setOffsetModifier(beginOffset, endOffset);
            annotationProperties.registerAnnotationProvider((AnnotationProvider)this, range, null);
            return true;
        }
        return false;
    }

    public boolean isChangeOnToken() {
        return false;
    }

    public static void insertLink(StyledText styledText, String theUrl, String theName, String replaceText) {
        LinkRange range = new LinkRange();
        range.link = theUrl;
        if (replaceText != null) {
            range.replacementText = replaceText;
        } else {
            String amped = theName;
            try {
                amped = HTMLUtils.convertPlainTextToHTML((String)amped);
            }
            catch (Throwable throwable) {}
            range.replacementText = NLS.bind((String)Messages.linkHtml, (Object)theUrl, (Object)amped);
        }
        AnnotationManager.getAnnotationManager(styledText).disableModify();
        AnnotationManager annotationManager = AnnotationManager.getAnnotationManager(styledText);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.collaboration.realtime.annotate.LinkifyAnnotationProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        annotationManager.insertAnnotation(clazz, theName, range);
        AnnotationManager.getAnnotationManager(styledText).enableModify();
        styledText.setCaretOffset(styledText.getCaretOffset() + theName.length());
    }

    public void activateSelection(ActivationEvent e) {
        String text;
        String url = text = e.annotation.getAnnotatedText();
        StyleRange style = e.annotation.getStyle();
        if (style instanceof LinkRange) {
            url = ((LinkRange)style).link;
        }
        if (url.toLowerCase().startsWith("www.")) {
            url = "http://" + url;
        }
        ExplorerWindow.launchBrowser((String)url, (String)url);
    }

    /* synthetic */ LinkifyAnnotationProvider(LinkifyAnnotationProvider linkifyAnnotationProvider) {
        this();
    }
}

