/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.annotate;

import com.ibm.collaboration.realtime.annotate.AnnotationManager;
import com.ibm.collaboration.realtime.annotate.strings.Messages;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class EditMenu
implements MenuListener {
    private final Menu editMenu;
    private final MenuItem cut;
    private final MenuItem copy;
    private final MenuItem paste;
    private final MenuItem delete;
    private final MenuItem selectAll;
    private final StyledText annotatedText;
    private static final int editMenuItemCount = 6;
    private int additions = 0;

    public EditMenu(StyledText parent) {
        this.editMenu = new Menu((Control)parent);
        this.annotatedText = parent;
        this.cut = new MenuItem(this.editMenu, 64);
        this.cut.setText(String.valueOf(Messages.cut) + "\t" + AnnotationManager.MODIFIER_KEY_NAME + "+X");
        this.cut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!EditMenu.this.annotatedText.isDisposed()) {
                    EditMenu.this.annotatedText.cut();
                }
            }
        });
        this.copy = new MenuItem(this.editMenu, 64);
        this.copy.setText(String.valueOf(Messages.copy) + "\t" + AnnotationManager.MODIFIER_KEY_NAME + "+C");
        this.copy.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!EditMenu.this.annotatedText.isDisposed()) {
                    EditMenu.this.annotatedText.copy();
                }
            }
        });
        this.paste = new MenuItem(this.editMenu, 64);
        this.paste.setText(String.valueOf(Messages.paste) + "\t" + AnnotationManager.MODIFIER_KEY_NAME + "+V");
        this.paste.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!EditMenu.this.annotatedText.isDisposed()) {
                    EditMenu.this.annotatedText.paste();
                }
            }
        });
        this.delete = new MenuItem(this.editMenu, 64);
        this.delete.setText(Messages.delete);
        this.delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (EditMenu.this.annotatedText.isDisposed()) {
                    return;
                }
                EditMenu.this.annotatedText.setText("");
            }
        });
        new MenuItem(this.editMenu, 2);
        this.selectAll = new MenuItem(this.editMenu, 64);
        this.selectAll.setText(String.valueOf(Messages.selectAll) + "\t" + AnnotationManager.MODIFIER_KEY_NAME + "+A");
        this.selectAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!EditMenu.this.annotatedText.isDisposed()) {
                    EditMenu.this.annotatedText.selectAll();
                }
            }
        });
        this.editMenu.addMenuListener((MenuListener)this);
    }

    public boolean isDisposed() {
        return this.editMenu.isDisposed();
    }

    public void dispose() {
        this.editMenu.dispose();
    }

    public void setVisible(boolean visible) {
        this.editMenu.setVisible(visible);
    }

    public void menuShown(MenuEvent e) {
        if (this.additions > 0) {
            int i = 5 + this.additions;
            while (i >= 6) {
                this.editMenu.getItem(i).dispose();
                --i;
            }
        }
        this.additions = this.editMenu.getItemCount() - 6;
        boolean isEnabled = this.annotatedText.getSelectionCount() != 0;
        this.cut.setEnabled(isEnabled);
        this.copy.setEnabled(isEnabled);
        isEnabled = this.annotatedText.getText().length() > 0;
        this.delete.setEnabled(isEnabled);
        this.selectAll.setEnabled(isEnabled);
        Clipboard cb = new Clipboard(Display.getDefault());
        String[] data = cb.getAvailableTypeNames();
        if (data == null || data.length == 0) {
            this.paste.setEnabled(false);
        } else {
            this.paste.setEnabled(true);
        }
        cb.dispose();
    }

    public void menuHidden(MenuEvent e) {
    }

    public Menu getMenu() {
        return this.editMenu;
    }
}

