/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.annotate;

import com.ibm.collaboration.realtime.annotate.AbstractLifecycleManager;
import com.ibm.collaboration.realtime.annotate.AnnotationManager;
import com.ibm.collaboration.realtime.annotate.AnnotationProviderManager;
import com.ibm.collaboration.realtime.annotate.strings.LogMessages;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.BundleContext;

public class EclipsePlugin
extends AbstractUIPlugin {
    private static EclipsePlugin plugin;
    private static final String ANNOTATION_PROVIDER = "annotationProvider";
    protected static final String PREF_ALLOWED_PROTOCOLS = "validprotocols";
    protected static final String PREF_USER_ALLOWED = "userprotocols";
    private ArrayList annotationProviders;
    private static boolean created;
    static final Logger logger;
    private boolean extensionsLoaded;
    static /* synthetic */ Class class$0;

    static {
        created = false;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.collaboration.realtime.annotate.EclipsePlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public EclipsePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, LogMessages.EclipsePlugin_0);
        }
    }

    protected void createAnnotationProviders() {
        if (this.annotationProviders != null && !created) {
            final IConfigurationElement[] el = this.annotationProviders.toArray(new IConfigurationElement[this.annotationProviders.size()]);
            Job loader = new Job("annotationLoader"){

                protected IStatus run(IProgressMonitor arg0) {
                    int i = 0;
                    while (i < el.length) {
                        block5: {
                            try {
                                IConfigurationElement element = el[i];
                                Object provider = element.createExecutableExtension("class");
                                Object lifecycleManager = element.createExecutableExtension("lifecycleManager");
                                if (provider != null && lifecycleManager != null) {
                                    AbstractLifecycleManager man = (AbstractLifecycleManager)lifecycleManager;
                                    AnnotationProviderManager.getInstance().addAnnotationProvider(provider.getClass(), man);
                                    if (man.isEnabled()) {
                                        AnnotationProviderManager.getInstance().setAnnotationProviderStatus(provider.getClass(), false, false);
                                    }
                                }
                            }
                            catch (Throwable t) {
                                if (!logger.isLoggable(Level.INFO)) break block5;
                                logger.log(Level.INFO, LogMessages.EclipsePlugin_2, t);
                            }
                        }
                        ++i;
                    }
                    return Status.OK_STATUS;
                }
            };
            loader.setSystem(true);
            loader.schedule();
            loader.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (event.getResult() == Status.OK_STATUS) {
                        UIJob job = new UIJob(this, "refresh job"){
                            final /* synthetic */ 2 this$1;
                            {
                                this.this$1 = var1_1;
                                super($anonymous0);
                            }

                            public IStatus runInUIThread(IProgressMonitor arg0) {
                                AnnotationManager.refreshAnnotationManagers(true);
                                return Status.OK_STATUS;
                            }
                        };
                        job.setSystem(true);
                        job.schedule();
                    }
                }
            });
            created = true;
        }
    }

    protected void enableAnnotationProviders() {
        AbstractLifecycleManager[] managers = AnnotationProviderManager.getInstance().getAnnotationProviders();
        if (managers != null) {
            int i = 0;
            while (i < managers.length) {
                if (!managers[i].isConstrcuted() && managers[i].isEnabled()) {
                    AnnotationProviderManager.getInstance().enableAnnotationProvider(managers[i].getManagedClass());
                }
                ++i;
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static EclipsePlugin getDefault() {
        return plugin;
    }

    public String getPluginFilePath() {
        try {
            URL pluginURL = EclipsePlugin.getDefault().find((IPath)new Path(""));
            URL resolvedURL = Platform.resolve((URL)pluginURL);
            if (resolvedURL.getProtocol().equals("file")) {
                String giniePath = resolvedURL.getPath();
                if (File.separatorChar == '\\') {
                    if (giniePath.charAt(0) == '/' && giniePath.length() > 3 && giniePath.charAt(2) == ':') {
                        giniePath = giniePath.substring(1);
                    }
                    giniePath = giniePath.replace('/', '\\');
                }
                return giniePath;
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public void loadExtensions() {
        if (!this.extensionsLoaded) {
            IExtensionPoint pt = Platform.getExtensionRegistry().getExtensionPoint(this.getBundle().getSymbolicName(), ANNOTATION_PROVIDER);
            IExtension[] extensions = pt.getExtensions();
            if (extensions != null) {
                int i = 0;
                while (i < extensions.length) {
                    IConfigurationElement[] extension = extensions[i].getConfigurationElements();
                    int j = 0;
                    while (j < extension.length) {
                        if (logger.isLoggable(Level.FINE)) {
                            String id = extension[j].getAttribute("id");
                            logger.log(Level.FINE, NLS.bind((String)LogMessages.EclipsePlugin_1, (Object)id));
                        }
                        if (this.annotationProviders == null) {
                            this.annotationProviders = new ArrayList();
                        }
                        this.annotationProviders.add(extension[j]);
                        ++j;
                    }
                    ++i;
                }
            }
            this.extensionsLoaded = true;
        }
    }
}

