/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.annotate;

import com.ibm.collaboration.realtime.annotate.AbstractLifecycleManager;
import com.ibm.collaboration.realtime.annotate.AnnotatedRange;
import com.ibm.collaboration.realtime.annotate.AnnotationManager;
import com.ibm.collaboration.realtime.annotate.AnnotationProvider;
import com.ibm.collaboration.realtime.annotate.IAnnotationProperties;
import com.ibm.collaboration.realtime.annotate.IRichTextProvider;
import com.ibm.collaboration.realtime.annotate.LinkifyAnnotationProvider;
import com.ibm.collaboration.realtime.annotate.strings.Errors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class AnnotationProviderManager {
    private static AnnotationProviderManager theInstance;
    private static final Logger s_logger;
    private AbstractLifecycleManager[] registeredAnnotationProviders;
    private int providersEnabled = 0;
    protected boolean forceRefresh = false;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.collaboration.realtime.annotate.AnnotationProviderManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        s_logger = Logger.getLogger(clazz.getPackage().getName());
        theInstance = new AnnotationProviderManager(new AbstractLifecycleManager[]{LinkifyAnnotationProvider.getLifecycleManager()});
    }

    public static AnnotationProviderManager getInstance() {
        return theInstance;
    }

    private AnnotationProviderManager(AbstractLifecycleManager[] registeredAnnotationProviders) {
        this.registeredAnnotationProviders = registeredAnnotationProviders;
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("com.ibm.collaboration.realtime.annotate.LinkifyAnnotationProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.enableAnnotationProvider(clazz);
    }

    public void disableAnnotationProvider(final Class annotationProvider) {
        Job job = new Job("disableAnnotationProvider"){

            protected IStatus run(IProgressMonitor arg0) {
                AnnotationProviderManager.this.setAnnotationProviderStatus(annotationProvider, true);
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void enableAnnotationProvider(final Class annotationProvider) {
        Job job = new Job("enableAnnotationProvider"){

            protected IStatus run(IProgressMonitor arg0) {
                AnnotationProviderManager.this.setAnnotationProviderStatus(annotationProvider, false);
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    private void setAnnotationProviderStatus(Class annotationProvider, boolean disable) {
        this.setAnnotationProviderStatus(annotationProvider, disable, true);
    }

    protected synchronized void setAnnotationProviderStatus(Class annotationProvider, boolean disable, boolean refreshManagers) {
        int i = 0;
        while (i < this.registeredAnnotationProviders.length) {
            if (this.registeredAnnotationProviders[i].getManagedClass().equals(annotationProvider)) {
                if (!this.registeredAnnotationProviders[i].isConstrcuted() && disable) {
                    return;
                }
                if (disable) {
                    this.registeredAnnotationProviders[i].releaseInstance();
                } else if (!this.registeredAnnotationProviders[i].isConstrcuted()) {
                    this.registeredAnnotationProviders[i].generateInstance();
                }
                if (refreshManagers) {
                    if (this.providersEnabled == 1 && disable) {
                        AnnotationManager.refreshAnnotationManagers(false);
                    } else {
                        AnnotationManager.refreshAnnotationManagers(true);
                    }
                }
                this.providersEnabled += disable ? -1 : 1;
                return;
            }
            ++i;
        }
    }

    public boolean isRegisteredProvider(Class annotationProvider) {
        int i = 0;
        while (i < this.registeredAnnotationProviders.length) {
            if (this.registeredAnnotationProviders[i].getClass().isInstance(annotationProvider)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean isEnabled(Class annotationProvider) {
        int i = 0;
        while (i < this.registeredAnnotationProviders.length) {
            if (this.registeredAnnotationProviders[i].getManagedClass().equals(annotationProvider)) {
                return this.registeredAnnotationProviders[i].isConstrcuted();
            }
            ++i;
        }
        return false;
    }

    public boolean canAnnotate(IAnnotationProperties annotationProperties, boolean isRichTextEnabled) {
        boolean canAnnotate = false;
        int i = 0;
        while (i < this.registeredAnnotationProviders.length) {
            if (this.registeredAnnotationProviders[i].isConstrcuted()) {
                AnnotationProvider provider = (AnnotationProvider)this.registeredAnnotationProviders[i].getManagedInstance();
                if (!isRichTextEnabled && provider instanceof IRichTextProvider) {
                    canAnnotate = false;
                } else if (provider != null) {
                    try {
                        if (provider.isAnnotatable(annotationProperties)) {
                            if (annotationProperties.getAnnotationProvider() == null) {
                                throw new RuntimeException(Errors.failed_to_get_provider);
                            }
                            canAnnotate = true;
                        }
                    }
                    catch (Throwable throwable) {}
                }
            }
            ++i;
        }
        return canAnnotate;
    }

    public boolean canAnnotate(char endChar, IAnnotationProperties annotationProperties, boolean isRichTextEnabled) {
        boolean canAnnotate = false;
        int i = 0;
        while (i < this.registeredAnnotationProviders.length) {
            if (this.registeredAnnotationProviders[i].isConstrcuted()) {
                AnnotationProvider provider = (AnnotationProvider)this.registeredAnnotationProviders[i].getManagedInstance();
                if (!isRichTextEnabled && provider instanceof IRichTextProvider) {
                    canAnnotate = false;
                } else if (provider != null) {
                    try {
                        if ((this.forceRefresh || !provider.canAnnotateMultipleWords() && (!provider.isChangeOnToken() || provider.isChangeOnToken() && Character.isWhitespace(endChar))) && provider.isAnnotatable(annotationProperties)) {
                            if (annotationProperties.getAnnotationProvider() == null) {
                                throw new RuntimeException(Errors.failed_to_get_provider);
                            }
                            canAnnotate = true;
                        }
                    }
                    catch (Throwable throwable) {}
                }
            }
            ++i;
        }
        return canAnnotate;
    }

    public boolean canAnnotateMultipleWords(IAnnotationProperties annotationProperties, boolean isRichTextEnabled) {
        boolean canAnnotate = false;
        int i = 0;
        while (i < this.registeredAnnotationProviders.length) {
            block9: {
                if (this.registeredAnnotationProviders[i].isConstrcuted()) {
                    AnnotationProvider provider = (AnnotationProvider)this.registeredAnnotationProviders[i].getManagedInstance();
                    if (!isRichTextEnabled && provider instanceof IRichTextProvider) {
                        canAnnotate = false;
                    } else if (provider != null) {
                        try {
                            if (provider.canAnnotateMultipleWords() && provider.isAnnotatable(annotationProperties)) {
                                if (annotationProperties.getAnnotationProvider() == null) {
                                    throw new RuntimeException(Errors.failed_to_get_provider);
                                }
                                canAnnotate = true;
                            }
                        }
                        catch (Throwable t) {
                            if (!s_logger.isLoggable(Level.WARNING)) break block9;
                            s_logger.log(Level.WARNING, t.getMessage(), t);
                        }
                    }
                }
            }
            ++i;
        }
        return canAnnotate;
    }

    public boolean hasProvidersEnabled() {
        return this.providersEnabled > 0;
    }

    public void addAnnotationProvider(Class provider, AbstractLifecycleManager manager) {
        AbstractLifecycleManager[] newarray = new AbstractLifecycleManager[this.registeredAnnotationProviders.length + 1];
        System.arraycopy(this.registeredAnnotationProviders, 0, newarray, 0, this.registeredAnnotationProviders.length);
        newarray[newarray.length - 1] = manager;
        this.registeredAnnotationProviders = newarray;
        newarray = null;
    }

    public void addAnnotationProvider(Class provider, AbstractLifecycleManager manager, boolean enable) {
        this.addAnnotationProvider(provider, manager);
        if (manager.isEnabled()) {
            this.enableAnnotationProvider(provider);
        }
    }

    protected boolean insertAnnotation(Class providerClass, IAnnotationProperties annotationProperties, String text, AnnotatedRange range, boolean isRichTextEnabled) {
        boolean inserted = false;
        int i = 0;
        while (i < this.registeredAnnotationProviders.length) {
            AnnotationProvider provider;
            if (this.registeredAnnotationProviders[i].isConstrcuted() && (provider = (AnnotationProvider)this.registeredAnnotationProviders[i].getManagedInstance()).getClass().equals(providerClass)) {
                if (!isRichTextEnabled && provider instanceof IRichTextProvider) {
                    inserted = false;
                }
                if (provider.canHandleRange(range)) {
                    annotationProperties.registerAnnotationProvider(provider, range, null);
                    inserted = true;
                }
                return inserted;
            }
            ++i;
        }
        return inserted;
    }

    protected AbstractLifecycleManager[] getAnnotationProviders() {
        return this.registeredAnnotationProviders;
    }

    public void setForceRefresh(boolean force) {
        this.forceRefresh = force;
    }
}

