/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.annotate;

import com.ibm.collaboration.realtime.annotate.ILifecycleManaged;
import org.eclipse.core.runtime.jobs.Job;

public abstract class AbstractLifecycleManager {
    private boolean isConstructed;
    private final Class managedClass;
    private ILifecycleManaged managedInstance;
    private Job spellCheckerJob = null;
    private boolean enabled = true;

    public AbstractLifecycleManager(Class managedClass) {
        this.managedClass = managedClass;
        this.isConstructed = false;
    }

    protected abstract ILifecycleManaged constructInstance();

    public final synchronized void generateInstance() {
        if (this.isConstructed) {
            throw new RuntimeException("Unable to generate new instance because one is already constructed.");
        }
        try {
            this.managedInstance = this.constructInstance();
        }
        catch (Exception exception) {}
        if (this.managedInstance == null) {
            throw new RuntimeException("Could not create provider");
        }
        this.isConstructed = true;
    }

    public final synchronized void releaseInstance() {
        if (this.managedInstance != null) {
            this.managedInstance.dispose();
        }
        this.managedInstance = null;
        this.isConstructed = false;
        this.spellCheckerJob = null;
    }

    public boolean isConstrcuted() {
        return this.isConstructed;
    }

    public Class getManagedClass() {
        return this.managedClass;
    }

    public ILifecycleManaged getManagedInstance() {
        return this.managedInstance;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }
}

