/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.sametime.connection;

import com.ibm.mqttclient.MqttAdvancedCallback;
import com.ibm.mqttclient.MqttCallback;
import com.ibm.mqttclient.MqttClient;
import com.ibm.mqttclient.MqttException;
import com.ibm.mqttclient.MqttNotConnectedException;
import com.ibm.mqttclient.factory.MqttClientFactory;
import com.ibm.mqttclient.factory.MqttFactoryException;
import com.ibm.mqttclient.factory.MqttProperties;
import com.ibm.mqttclient.utils.MqttPayload;
import com.ibm.team.collaboration.internal.sametime.BrokerMessages;
import com.ibm.team.collaboration.internal.sametime.connection.XMLMessage;
import com.ibm.team.collaboration.sametime.connection.ISametimeConnectionListener;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;

public final class SametimeConnection {
    private static final String PLUGIN_ID = "com.ibm.team.collaboration.sametime.rcp.broker";
    static final boolean TRACE_CONNECTION;
    final String fConnectionId;
    final ListenerList fConnectionListeners = new ListenerList(1);
    MQTTCallBack fMQTTCallback = null;
    MqttClient fMQTTClient = null;
    private final int fPort;

    static {
        String value = Platform.getDebugOption((String)"com.ibm.team.collaboration.sametime.rcp.broker/traceSametimeConnection");
        TRACE_CONNECTION = value != null && value.equalsIgnoreCase("true");
    }

    public SametimeConnection(String id, int port) {
        Assert.isNotNull((Object)id);
        Assert.isLegal((!"".equals(id) ? 1 : 0) != 0, (String)"Id must not be empty.");
        Assert.isLegal((id.length() <= 23 ? 1 : 0) != 0, (String)"Length of id must be less or equal 23.");
        Assert.isLegal((port > 0 ? 1 : 0) != 0, (String)"Port must be greater than 0");
        this.fConnectionId = id;
        this.fPort = port;
    }

    public void addConnectionListener(ISametimeConnectionListener listener) {
        Assert.isNotNull((Object)listener);
        this.fConnectionListeners.add((Object)listener);
        if (TRACE_CONNECTION) {
            System.out.println("Added listener to connection: Listener is " + listener.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized IStatus connect() {
        block12: {
            Assert.isTrue((this.fMQTTClient == null ? 1 : 0) != 0, (String)"Client must be null.");
            Assert.isTrue((this.fMQTTCallback == null ? 1 : 0) != 0, (String)"Callback must be null.");
            MqttProperties properties = new MqttProperties();
            properties.setCleanStart(true);
            properties.setMaxInflight(50);
            try {
                this.fMQTTClient = MqttClientFactory.INSTANCE.createMqttClient(this.fConnectionId, "tcp://127.0.0.1:" + this.fPort, properties);
            }
            catch (MqttFactoryException exception) {
                if (!TRACE_CONNECTION) break block12;
                System.out.println("Factory creation problem in 'connect()': Got exception:");
                exception.printStackTrace(System.out);
            }
        }
        if (this.fMQTTClient != null) {
            try {
                int index;
                this.fMQTTCallback = new MQTTCallBack();
                this.fMQTTClient.registerCallback((MqttCallback)this.fMQTTCallback);
                this.fMQTTClient.connect();
                this.fMQTTClient.subscribe(new String[]{"STOIC/FROM-ST", "STOIC/HYPERLINK", "STOIC/PING"}, new byte[]{2, 2, 2});
                Object[] listeners = this.fConnectionListeners.getListeners();
                if (TRACE_CONNECTION) {
                    System.out.println("Following listeners are notified about 'connect':");
                    index = 0;
                    while (index < listeners.length) {
                        System.out.println(listeners[index].toString());
                        ++index;
                    }
                }
                index = 0;
                while (index < listeners.length) {
                    final ISametimeConnectionListener extended = (ISametimeConnectionListener)listeners[index];
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void handleException(Throwable throwable) {
                            if (TRACE_CONNECTION) {
                                System.out.println("Event handling problem in 'connected()': Got exception:");
                                throwable.printStackTrace(System.out);
                            }
                        }

                        public void run() throws Exception {
                            extended.connected();
                        }
                    });
                    ++index;
                }
                return Status.OK_STATUS;
            }
            catch (Throwable throwable) {
                if (this.fMQTTClient != null) {
                    try {
                        this.fMQTTClient.disconnect();
                    }
                    catch (MqttException mqttException) {}
                }
                this.fMQTTClient = null;
                this.fMQTTCallback = null;
                if (TRACE_CONNECTION) {
                    System.out.println("Connection problem: Got exception while connecting:");
                    throwable.printStackTrace(System.out);
                }
                if (!(throwable instanceof MqttNotConnectedException)) return new Status(4, PLUGIN_ID, 3, BrokerMessages.SametimeConnection_0, throwable);
                return new Status(4, PLUGIN_ID, 3, BrokerMessages.SametimeConnection_2, throwable);
            }
        }
        if (!TRACE_CONNECTION) return new Status(4, PLUGIN_ID, 3, BrokerMessages.SametimeConnection_0, null);
        System.out.println("Connection problem: MQTT client factory returned null when creating client!");
        return new Status(4, PLUGIN_ID, 3, BrokerMessages.SametimeConnection_0, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized IStatus disconnect() {
        Assert.isTrue((this.fMQTTClient != null ? 1 : 0) != 0, (String)"Client must be non-null.");
        Assert.isTrue((this.fMQTTCallback != null ? 1 : 0) != 0, (String)"Callback must be non-null.");
        try {
            try {
                int index;
                this.fMQTTClient.disconnect();
                Object[] listeners = this.fConnectionListeners.getListeners();
                if (TRACE_CONNECTION) {
                    System.out.println("Following listeners are notified about 'disconnect':");
                    index = 0;
                    while (index < listeners.length) {
                        System.out.println(listeners[index].toString());
                        ++index;
                    }
                }
                index = 0;
                while (index < listeners.length) {
                    final ISametimeConnectionListener extended = (ISametimeConnectionListener)listeners[index];
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void handleException(Throwable throwable) {
                            if (TRACE_CONNECTION) {
                                System.out.println("Event handling problem in 'disconnected()': Got exception:");
                                throwable.printStackTrace(System.out);
                            }
                        }

                        public void run() throws Exception {
                            extended.disconnected();
                        }
                    });
                    ++index;
                }
            }
            catch (Throwable throwable) {
                if (TRACE_CONNECTION) {
                    System.out.println("Connection problem: Got exception while connecting:");
                    throwable.printStackTrace(System.out);
                }
                Status status = new Status(4, PLUGIN_ID, 7, BrokerMessages.SametimeConnection_1, throwable);
                Object var4_6 = null;
                this.fMQTTClient = null;
                this.fMQTTCallback = null;
                return status;
            }
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.fMQTTClient = null;
            this.fMQTTCallback = null;
            throw throwable;
        }
        {
            Object var4_8 = null;
            this.fMQTTClient = null;
            this.fMQTTCallback = null;
            return Status.OK_STATUS;
        }
    }

    public String getConnectionId() {
        return this.fConnectionId;
    }

    public boolean isConnected() {
        return this.fMQTTClient != null && this.fMQTTCallback != null;
    }

    public void openHyperlink(String uri, String conversationId) {
        Assert.isNotNull((Object)uri);
        Assert.isNotNull((Object)conversationId);
        try {
            HashMap<String, String> arguments = new HashMap<String, String>(3);
            arguments.put("connectionId", this.fConnectionId);
            arguments.put("conversationID", conversationId);
            arguments.put("hyperlinkURI", XMLMessage.encode(uri));
            this.publishMessage("STOIC/HYPERLINK", new XMLMessage("openHyperlink", arguments));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Assert.isLegal((boolean)false);
        }
    }

    public void openNwayChat(String[] userIds, String message) {
        HashMap<String, Object> arguments = new HashMap<String, Object>(3);
        arguments.put("chatTopic", message);
        arguments.put("partnerID", userIds);
        arguments.put("conversationID", String.valueOf(userIds[0]) + ":jazznwaychat");
        this.publishMessage("STOIC/TO-ST", new XMLMessage("nwayChatConnectionOpen", arguments));
        this.publishMessage("STOIC/TO-ST", new XMLMessage("ImChatWindowForceFocus", arguments));
    }

    public void openNwayVoice(String[] userIds) {
        Assert.isNotNull((Object)userIds);
        HashMap<String, Object> arguments = new HashMap<String, Object>(2);
        arguments.put("partnerID", userIds);
        arguments.put("conversationID", String.valueOf(userIds[0]) + ":jazznwayphone");
        this.publishMessage("STOIC/TO-ST", new XMLMessage("phoneConnectionOpen", arguments));
        this.publishMessage("STOIC/TO-ST", new XMLMessage("ImChatWindowForceFocus", arguments));
    }

    public void openPeerChat(String userId, String message, boolean html) {
        Assert.isNotNull((Object)userId);
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("partnerID", userId);
        arguments.put("conversationID", String.valueOf(userId) + ":jazzpeerchat");
        this.publishMessage("STOIC/TO-ST", new XMLMessage("ImTextConnectionOpen", arguments));
        this.publishMessage("STOIC/TO-ST", new XMLMessage("ImChatWindowForceFocus", arguments));
        if (message != null) {
            HashMap<String, String> attributes = new HashMap<String, String>(4);
            attributes.put("conversationID", String.valueOf(userId) + ":jazzpeerchat");
            attributes.put("eventType", "replaceText");
            attributes.put("text", message);
            if (html) {
                attributes.put("hasRichText", Boolean.toString(true));
            }
            this.publishMessage("STOIC/TO-ST", new XMLMessage("ImChatWindowEventResponse", attributes));
        }
    }

    public void openPeerVoice(String userId) {
        Assert.isNotNull((Object)userId);
        HashMap<String, String> arguments = new HashMap<String, String>(2);
        arguments.put("partnerID", userId);
        arguments.put("conversationID", String.valueOf(userId) + ":jazzpeerphone");
        this.publishMessage("STOIC/TO-ST", new XMLMessage("phoneConnectionOpen", arguments));
        this.publishMessage("STOIC/TO-ST", new XMLMessage("ImChatWindowForceFocus", arguments));
    }

    private void publishMessage(String topic, XMLMessage message) {
        block12: {
            Assert.isNotNull((Object)topic);
            Assert.isNotNull((Object)message);
            try {
                byte[] bytes = message.toBytes();
                if (this.isConnected() && bytes != null) {
                    this.fMQTTClient.publish(topic, new MqttPayload(bytes, 0), (byte)2, false);
                } else if (TRACE_CONNECTION) {
                    System.out.println("Problem while publishing message: Connected: " + this.isConnected() + ", Message: ");
                    if (bytes != null) {
                        try {
                            System.out.println(new String(bytes, 0, bytes.length, "UTF-16LE"));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            Assert.isLegal((boolean)false);
                        }
                    } else {
                        System.out.println("<None>");
                    }
                }
            }
            catch (MqttNotConnectedException exception) {
                if (TRACE_CONNECTION) {
                    System.out.println("Problem while publishing message: Got exception:");
                    exception.printStackTrace(System.out);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Assert.isTrue((boolean)false);
            }
            catch (MqttException exception) {
                if (!TRACE_CONNECTION) break block12;
                System.out.println("Problem while publishing message: Got exception:");
                exception.printStackTrace(System.out);
            }
        }
    }

    public void removeConnectionListener(ISametimeConnectionListener listener) {
        Assert.isNotNull((Object)listener);
        this.fConnectionListeners.remove((Object)listener);
        if (TRACE_CONNECTION) {
            System.out.println("Removed listener from connection: Listener is " + listener.toString());
        }
    }

    public void retrieveContacts(String group) {
        Assert.isNotNull((Object)group);
        HashMap<String, String> arguments = new HashMap<String, String>(2);
        arguments.put("messageUid", "jazz" + System.currentTimeMillis());
        arguments.put("groupName", group);
        this.publishMessage("STOIC/TO-ST", new XMLMessage("getContacts", arguments));
    }

    public void retrieveGroups(String type) {
        Assert.isNotNull((Object)type);
        HashMap<String, String> arguments = new HashMap<String, String>(2);
        arguments.put("messageUid", "jazz" + System.currentTimeMillis());
        arguments.put("groupType", type);
        this.publishMessage("STOIC/TO-ST", new XMLMessage("getGroups", arguments));
    }

    public void retrieveStatus(String[] userIds) {
        Assert.isNotNull((Object)userIds);
        HashMap<String, String[]> arguments = new HashMap<String, String[]>(1);
        arguments.put("lookupNames", userIds);
        this.publishMessage("STOIC/TO-ST", new XMLMessage("liveNameResolve", arguments));
    }

    public void returnOpenHyperlink(String conversationId, int severity, String message, String uri) {
        Assert.isNotNull((Object)uri);
        HashMap<String, String> arguments = new HashMap<String, String>(5);
        arguments.put("connectionId", this.fConnectionId);
        arguments.put("conversationID", conversationId);
        arguments.put("hyperlinkSeverity", String.valueOf(severity));
        arguments.put("hyperlinkURI", uri);
        if (message != null && !"".equals(message)) {
            arguments.put("hyperlinkMessage", message);
        }
        this.publishMessage("STOIC/HYPERLINK", new XMLMessage("openHyperlinkReturn", arguments));
    }

    public void returnPing(String type) {
        Assert.isNotNull((Object)type);
        HashMap<String, String> arguments = new HashMap<String, String>(2);
        arguments.put("connectionId", this.fConnectionId);
        arguments.put("pingType", type);
        this.publishMessage("STOIC/PING", new XMLMessage("pingReturn", arguments));
    }

    public void sendPing(String type) {
        Assert.isNotNull((Object)type);
        HashMap<String, String> arguments = new HashMap<String, String>(2);
        arguments.put("connectionId", this.fConnectionId);
        arguments.put("pingType", type);
        this.publishMessage("STOIC/PING", new XMLMessage("pingSend", arguments));
    }

    public void setStatus(int code, String text) {
        HashMap<String, String> arguments = new HashMap<String, String>(2);
        arguments.put("statusCode", Integer.toString(code));
        if (text != null) {
            arguments.put("statusText", text);
        }
        this.publishMessage("STOIC/TO-ST", new XMLMessage("imConnectionStatusChangeRequest", arguments));
    }

    private final class MQTTCallBack
    implements MqttAdvancedCallback {
        MQTTCallBack() {
        }

        public void connectionLost(Throwable throwable) {
            int index;
            SametimeConnection.this.fMQTTCallback = null;
            SametimeConnection.this.fMQTTClient = null;
            if (TRACE_CONNECTION) {
                System.out.print("Received 'connectionLost' event: ");
                if (throwable != null) {
                    System.out.println("Exception occurred:");
                    throwable.printStackTrace(System.out);
                    System.out.println();
                } else {
                    System.out.println("No exception available");
                }
            }
            Object[] listeners = SametimeConnection.this.fConnectionListeners.getListeners();
            if (TRACE_CONNECTION) {
                System.out.println("Following listeners have been notified about 'connectionLost':");
                index = 0;
                while (index < listeners.length) {
                    System.out.println(listeners[index]);
                    ++index;
                }
            }
            index = 0;
            while (index < listeners.length) {
                ISametimeConnectionListener extended = (ISametimeConnectionListener)listeners[index];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(this, extended){
                    final /* synthetic */ MQTTCallBack this$1;
                    private final /* synthetic */ ISametimeConnectionListener val$extended;
                    {
                        this.this$1 = mQTTCallBack;
                        this.val$extended = iSametimeConnectionListener;
                    }

                    public void handleException(Throwable exception) {
                        if (TRACE_CONNECTION) {
                            System.out.println("Event handling problem in 'disconnected()': Got exception:");
                            exception.printStackTrace(System.out);
                        }
                    }

                    public void run() throws Exception {
                        this.val$extended.disconnected();
                    }
                });
                ++index;
            }
        }

        public boolean publishArrived(String topic, MqttPayload payload, byte qos, boolean retained, int messageId) {
            Assert.isNotNull((Object)topic);
            Assert.isNotNull((Object)payload);
            XMLMessage message = new XMLMessage(payload.getTrimmedBuffer(), null);
            Map arguments = message.getArguments();
            Object[] listeners = SametimeConnection.this.fConnectionListeners.getListeners();
            if (TRACE_CONNECTION) {
                System.out.println("Received 'publishArrived' event: Associated message:");
                byte[] bytes = message.toBytes();
                try {
                    System.out.println(new String(bytes, 0, bytes.length, "UTF-16LE"));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    Assert.isLegal((boolean)false);
                }
                System.out.println("Following listeners are notified about 'publishArrived':");
                int index = 0;
                while (index < listeners.length) {
                    System.out.println(listeners[index].toString());
                    ++index;
                }
            }
            int index = 0;
            while (index < listeners.length) {
                ISametimeConnectionListener extended = (ISametimeConnectionListener)listeners[index];
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(this, message, topic, arguments, extended){
                    final /* synthetic */ MQTTCallBack this$1;
                    private final /* synthetic */ XMLMessage val$message;
                    private final /* synthetic */ String val$topic;
                    private final /* synthetic */ Map val$arguments;
                    private final /* synthetic */ ISametimeConnectionListener val$extended;
                    {
                        this.this$1 = mQTTCallBack;
                        this.val$message = xMLMessage;
                        this.val$topic = string;
                        this.val$arguments = map;
                        this.val$extended = iSametimeConnectionListener;
                    }

                    public void handleException(Throwable throwable) {
                        if (TRACE_CONNECTION) {
                            System.out.println("Event handling problem in 'publishArrived()': Got exception:");
                            throwable.printStackTrace(System.out);
                        }
                    }

                    public void run() throws Exception {
                        String type = this.val$message.getType();
                        if ("STOIC/FROM-ST".equals(this.val$topic)) {
                            if ("PartnerStatusUpdate".equals(type)) {
                                String userId = (String)this.val$arguments.get("partnerID");
                                String code = (String)this.val$arguments.get("statusCode");
                                String text = (String)this.val$arguments.get("statusText");
                                if (userId != null && code != null) {
                                    try {
                                        this.val$extended.presenceUpdate(userId, Integer.parseInt(code), text);
                                    }
                                    catch (NumberFormatException numberFormatException) {
                                        if (TRACE_CONNECTION) {
                                            System.out.println("Invalid message received:" + type);
                                        }
                                    }
                                } else if (TRACE_CONNECTION) {
                                    System.out.println("Invalid message received: " + type);
                                }
                            } else if ("getGroupsResponse".equals(type)) {
                                String groupType = (String)this.val$arguments.get("groupType");
                                String[] groups = (String[])this.val$arguments.get("groups");
                                if (groupType != null && groups != null) {
                                    this.val$extended.groupsRetrieved(groupType, groups);
                                } else if (TRACE_CONNECTION) {
                                    System.out.println("Invalid message received: " + type);
                                }
                            } else if ("getContactsResponse".equals(type)) {
                                String name = (String)this.val$arguments.get("groupName");
                                String[] userIds = (String[])this.val$arguments.get("contacts");
                                if (name != null && userIds != null) {
                                    this.val$extended.contactsRetrieved(name, userIds);
                                } else if (TRACE_CONNECTION) {
                                    System.out.println("Invalid message received:" + type);
                                }
                            } else if ("ImDisconnected".equals(type)) {
                                this.val$extended.disconnected();
                            } else if (TRACE_CONNECTION) {
                                System.out.println("Unknown message received:" + type);
                            }
                        } else if ("STOIC/HYPERLINK".equals(this.val$topic)) {
                            if ("openHyperlink".equals(type)) {
                                String connectionId = (String)this.val$arguments.get("connectionId");
                                if (connectionId != null && !MQTTCallBack.access$0((MQTTCallBack)this.this$1).fConnectionId.equals(connectionId)) {
                                    String conversationId = (String)this.val$arguments.get("conversationID");
                                    String uri = (String)this.val$arguments.get("hyperlinkURI");
                                    if (uri != null && conversationId != null) {
                                        this.val$extended.openHyperlink(conversationId, XMLMessage.decode(uri));
                                    } else if (TRACE_CONNECTION) {
                                        System.out.println("Invalid message received:" + type);
                                    }
                                } else if (TRACE_CONNECTION && connectionId == null) {
                                    System.out.println("Invalid message received:" + type);
                                }
                            } else if ("openHyperlinkReturn".equals(type)) {
                                String connectionId = (String)this.val$arguments.get("connectionId");
                                if (connectionId != null && !MQTTCallBack.access$0((MQTTCallBack)this.this$1).fConnectionId.equals(connectionId)) {
                                    String conversationId = (String)this.val$arguments.get("conversationID");
                                    String uri = (String)this.val$arguments.get("hyperlinkURI");
                                    String severity = (String)this.val$arguments.get("hyperlinkSeverity");
                                    if (conversationId != null && uri != null && severity != null) {
                                        try {
                                            int value = Integer.parseInt(severity);
                                            switch (value) {
                                                case 0: 
                                                case 1: 
                                                case 2: 
                                                case 4: 
                                                case 8: {
                                                    this.val$extended.hyperlinkOpened(conversationId, value, (String)this.val$arguments.get("hyperlinkMessage"), uri);
                                                    break;
                                                }
                                            }
                                        }
                                        catch (NumberFormatException numberFormatException) {
                                            if (TRACE_CONNECTION) {
                                                System.out.println("Invalid message received:" + type);
                                            }
                                        }
                                    } else if (TRACE_CONNECTION) {
                                        System.out.println("Invalid message received:" + type);
                                    }
                                } else if (TRACE_CONNECTION && connectionId == null) {
                                    System.out.println("Invalid message received:" + type);
                                }
                            } else if (TRACE_CONNECTION) {
                                System.out.println("Unknown message received:" + type);
                            }
                        } else if ("STOIC/PING".equals(this.val$topic)) {
                            if ("pingSend".equals(type)) {
                                String connectionId = (String)this.val$arguments.get("connectionId");
                                String pingType = (String)this.val$arguments.get("pingType");
                                if (connectionId != null && pingType != null) {
                                    this.val$extended.pingReceived(connectionId, pingType);
                                } else if (TRACE_CONNECTION) {
                                    System.out.println("Invalid message received:" + type);
                                }
                            } else if ("pingReturn".equals(type)) {
                                String connectionId = (String)this.val$arguments.get("connectionId");
                                String pingType = (String)this.val$arguments.get("pingType");
                                if (connectionId != null && pingType != null) {
                                    this.val$extended.pingAnswered(connectionId, pingType);
                                } else if (TRACE_CONNECTION) {
                                    System.out.println("Invalid message received:" + type);
                                }
                            } else if (TRACE_CONNECTION) {
                                System.out.println("Unknown message received:" + type);
                            }
                        } else if (TRACE_CONNECTION) {
                            System.out.println("Unknown topic received:" + this.val$topic);
                        }
                    }
                });
                ++index;
            }
            return true;
        }

        public void published(int messageId) {
            if (TRACE_CONNECTION) {
                System.out.println("Received 'published' event: Message ID: " + messageId);
            }
        }

        public void subscribed(int messageId, byte[] qos) {
            if (TRACE_CONNECTION) {
                System.out.println("Received 'subscribed' event: Message ID: " + messageId + ", QoS: " + qos);
            }
        }

        public void unsubscribed(int messageId) {
            if (TRACE_CONNECTION) {
                System.out.println("Received 'unsubscribed' event: Message ID: " + messageId);
            }
        }

        static /* synthetic */ SametimeConnection access$0(MQTTCallBack mQTTCallBack) {
            return mQTTCallBack.SametimeConnection.this;
        }
    }
}

