/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.internal.sametime.connection;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.Assert;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XMLMessage {
    private static final String ATTRIBUTE_LENGTH = "length";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_SIGNED = "signed";
    private static final String ATTRIBUTE_TYPE_VERSION = "typeVersion";
    private static final String ATTRIBUTE_VALUE = "value";
    private static final String ATTRIBUTE_VALUE_TYPE = "valueType";
    private static final String ATTRIBUTE_VERSION = "version";
    private static final String ELEMENT_DATA = "data";
    private static final String ELEMENT_ENTRY = "entry";
    private static final String ELEMENT_MAP = "map";
    private static final String ELEMENT_MESSAGE_SET = "messageSet";
    private static final String ELEMENT_STRING_ARRAY = "stringArray";
    private static DocumentBuilder fgDocumentBuilder;
    private static DOMImplementation fgDOMImplementation;
    public static final String MESSAGE_ENCODING = "UTF-16LE";
    private static final String MESSAGE_VERSION = "1.0";
    private static final String VALUE_FALSE = "false";
    private static final String VALUE_MAP_ARRAY = "mapArray";
    private static final String VALUE_STRING_ARRAY = "stringArray";
    private static final String VALUE_YES = "yes";
    private final Map fArguments;
    private String fType;
    private String fVersion = "1.0";

    public static String decode(String string) throws UnsupportedEncodingException {
        Assert.isNotNull((Object)string);
        return URLDecoder.decode(string, MESSAGE_ENCODING);
    }

    private static byte[] documentToBytes(Document document) throws TransformerFactoryConfigurationError, TransformerException, UnsupportedEncodingException {
        Assert.isNotNull((Object)document);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", VALUE_YES);
        StreamResult result = new StreamResult(new StringWriter(512));
        transformer.transform(new DOMSource(document), result);
        return result.getWriter().toString().getBytes(MESSAGE_ENCODING);
    }

    public static String encode(String string) throws UnsupportedEncodingException {
        Assert.isNotNull((Object)string);
        return URLEncoder.encode(string, MESSAGE_ENCODING);
    }

    private static Element getFirstElement(Element parent) {
        Assert.isNotNull((Object)parent);
        Node child = parent.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 1) {
                return (Element)child;
            }
            child = child.getNextSibling();
        }
        return null;
    }

    private static String getText(Node node) {
        Assert.isNotNull((Object)node);
        String output = "";
        Node child = node.getFirstChild();
        while (child != null) {
            if (child.getNodeType() == 3) {
                output = String.valueOf(output) + child.getNodeValue();
            }
            child = child.getNextSibling();
        }
        return output;
    }

    public XMLMessage(byte[] bytes, Map arguments) {
        Assert.isNotNull((Object)bytes);
        this.initializeComponents();
        this.fArguments = new HashMap(4);
        if (arguments != null) {
            this.fArguments.putAll(arguments);
        }
        this.parseBytes(bytes);
    }

    public XMLMessage(String type, Map arguments) {
        Assert.isNotNull((Object)type);
        Assert.isNotNull((Object)arguments);
        this.initializeComponents();
        this.fType = type;
        this.fArguments = new HashMap(arguments);
    }

    public Map getArguments() {
        return new HashMap(this.fArguments);
    }

    public String getType() {
        return this.fType;
    }

    public String getVersion() {
        return this.fVersion;
    }

    private void initializeComponents() {
        if (fgDOMImplementation != null && fgDocumentBuilder != null) {
            return;
        }
        try {
            fgDocumentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            fgDOMImplementation = fgDocumentBuilder.getDOMImplementation();
        }
        catch (ParserConfigurationException parserConfigurationException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseBytes(byte[] bytes) {
        Assert.isNotNull((Object)bytes);
        String input = null;
        try {
            input = new String(bytes, MESSAGE_ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            input = new String(bytes);
        }
        String string = input.substring(0, 5);
        if (!string.equalsIgnoreCase("<?xml")) {
            input = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + input;
        }
        try {
            Document document;
            DocumentBuilder documentBuilder = fgDocumentBuilder;
            synchronized (documentBuilder) {
                document = fgDocumentBuilder.parse(new InputSource(new StringReader(input)));
            }
            Element typeElement = XMLMessage.getFirstElement(document.getDocumentElement());
            this.fType = typeElement.getNodeName();
            this.fVersion = typeElement.getAttribute(ATTRIBUTE_TYPE_VERSION);
            if (this.fVersion == null || this.fVersion.equals("")) {
                this.fVersion = MESSAGE_VERSION;
            }
            Node childNode = typeElement.getFirstChild();
            while (childNode != null) {
                if (childNode.getNodeType() != 3) {
                    Node dataNode;
                    int position;
                    Node typeNode;
                    String name = childNode.getNodeName();
                    NamedNodeMap attributes = childNode.getAttributes();
                    Node node = typeNode = attributes != null ? attributes.getNamedItem(ATTRIBUTE_VALUE_TYPE) : null;
                    if (typeNode != null && "stringArray".equals(typeNode.getNodeValue())) {
                        Node stringArrayNode = childNode.getFirstChild();
                        while (stringArrayNode != null) {
                            if (stringArrayNode.getNodeName().equals("stringArray")) break;
                            stringArrayNode = stringArrayNode.getNextSibling();
                        }
                        if (stringArrayNode != null && stringArrayNode.getAttributes() != null) {
                            String[] array = new String[Integer.parseInt(stringArrayNode.getAttributes().getNamedItem(ATTRIBUTE_LENGTH).getNodeValue())];
                            position = 0;
                            dataNode = stringArrayNode.getFirstChild();
                            while (dataNode != null) {
                                if (dataNode.getNodeName().equals(ELEMENT_DATA)) {
                                    array[position] = XMLMessage.getText(dataNode);
                                    ++position;
                                }
                                dataNode = dataNode.getNextSibling();
                            }
                            this.fArguments.put(name, array);
                        }
                    } else if (typeNode != null && VALUE_MAP_ARRAY.equals(typeNode.getNodeValue())) {
                        Node mapArrayNode = childNode.getFirstChild();
                        while (mapArrayNode != null) {
                            if (mapArrayNode.getNodeName().equals(VALUE_MAP_ARRAY)) break;
                            mapArrayNode = mapArrayNode.getNextSibling();
                        }
                        if (mapArrayNode != null && mapArrayNode.getAttributes() != null) {
                            Map[] mapArray = new Map[Integer.parseInt(mapArrayNode.getAttributes().getNamedItem(ATTRIBUTE_LENGTH).getNodeValue())];
                            position = 0;
                            dataNode = mapArrayNode.getFirstChild();
                            while (dataNode != null) {
                                if (dataNode.getNodeName().equals(ELEMENT_MAP)) {
                                    HashMap<String, String> currentMap = new HashMap<String, String>(4);
                                    Node mapEntry = dataNode.getFirstChild();
                                    while (mapEntry != null) {
                                        if (mapEntry.getNodeName().equals(ELEMENT_ENTRY)) {
                                            String entryName = null;
                                            String value = null;
                                            Node entryChild = mapEntry.getFirstChild();
                                            while (entryChild != null) {
                                                if (entryChild.getNodeName().equals(ATTRIBUTE_NAME)) {
                                                    entryName = XMLMessage.getText(entryChild);
                                                } else if (entryChild.getNodeName().equals(ATTRIBUTE_VALUE)) {
                                                    value = XMLMessage.getText(entryChild);
                                                }
                                                entryChild = entryChild.getNextSibling();
                                            }
                                            if (entryName != null && value != null) {
                                                currentMap.put(entryName, value);
                                            }
                                        }
                                        mapEntry = mapEntry.getNextSibling();
                                    }
                                    mapArray[position++] = currentMap;
                                }
                                dataNode = dataNode.getNextSibling();
                            }
                            this.fArguments.put(name, mapArray);
                        }
                    } else {
                        this.fArguments.put(name, XMLMessage.getText(childNode));
                    }
                }
                childNode = childNode.getNextSibling();
            }
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {}
    }

    public byte[] toBytes() {
        Document document = fgDOMImplementation.createDocument(null, ELEMENT_MESSAGE_SET, null);
        Element documentElement = document.getDocumentElement();
        documentElement.setAttribute(ATTRIBUTE_SIGNED, VALUE_FALSE);
        documentElement.setAttribute(ATTRIBUTE_VERSION, this.fVersion);
        Element typeElement = document.createElement(this.fType);
        typeElement.setAttribute(ATTRIBUTE_TYPE_VERSION, this.fVersion);
        documentElement.appendChild(typeElement);
        Iterator iterator = this.fArguments.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            Element element = null;
            if (value instanceof String) {
                element = document.createElement(key);
                element.appendChild(document.createTextNode((String)value));
            } else if (value instanceof String[]) {
                String[] strings = (String[])value;
                element = document.createElement(key);
                element.setAttribute(ATTRIBUTE_VALUE_TYPE, "stringArray");
                Element arrayElement = document.createElement("stringArray");
                arrayElement.setAttribute(ATTRIBUTE_LENGTH, String.valueOf(strings.length));
                int index = 0;
                while (index < strings.length) {
                    Element dataElement = document.createElement(ELEMENT_DATA);
                    dataElement.appendChild(document.createTextNode(strings[index]));
                    arrayElement.appendChild(dataElement);
                    ++index;
                }
                element.appendChild(arrayElement);
            }
            if (element == null) continue;
            typeElement.appendChild(element);
        }
        try {
            return XMLMessage.documentToBytes(document);
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
        }
        catch (TransformerException transformerException) {
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Assert.isLegal((boolean)false);
        }
        return null;
    }
}

