/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.chatwindow.ui;

import com.ibm.collaboration.realtime.annotate.AnnotatedRange;
import com.ibm.collaboration.realtime.annotate.AnnotationManager;
import com.ibm.collaboration.realtime.annotate.AnnotationProviderManager;
import com.ibm.collaboration.realtime.annotate.ImageStyleRange;
import com.ibm.collaboration.realtime.annotate.InvisibleStyleRange;
import com.ibm.collaboration.realtime.chat.logging.IChatLoggingService;
import com.ibm.collaboration.realtime.chat.logging.IChatTranscript;
import com.ibm.collaboration.realtime.chatwindow.ChatWindowHandler;
import com.ibm.collaboration.realtime.chatwindow.ChatWindowPreferences;
import com.ibm.collaboration.realtime.chatwindow.ImChatPlugin;
import com.ibm.collaboration.realtime.chatwindow.ImChatWindowHandler;
import com.ibm.collaboration.realtime.chatwindow.addon.ChatWindowExtension;
import com.ibm.collaboration.realtime.chatwindow.addon.Embeddable;
import com.ibm.collaboration.realtime.chatwindow.addon.FileEmbeddable;
import com.ibm.collaboration.realtime.chatwindow.addon.ImageFileEmbeddable;
import com.ibm.collaboration.realtime.chatwindow.strings.Messages;
import com.ibm.collaboration.realtime.magiccarpet.messageprocessor.MessageProcessor;
import com.ibm.collaboration.realtime.ui.dnd.DragAndDropSupportRegistry;
import com.ibm.collaboration.realtime.ui.dnd.ExtendibleDragSourceListener;
import com.ibm.collaboration.realtime.ui.dnd.ExtendibleDropTargetListener;
import com.ibm.collaboration.realtime.ui.dnd.TransferOperationContext;
import com.ibm.collaboration.realtime.ui.util.AnimatedGifTimer;
import com.ibm.collaboration.realtime.ui.util.ChatTextTransfer;
import com.ibm.collaboration.realtime.ui.util.SwtUtils;
import com.ibm.collaboration.realtime.util.DataMessage;
import com.ibm.collaboration.realtime.util.FileUtils;
import com.ibm.collaboration.realtime.util.OSUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.SortedSet;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.ExtendedModifyEvent;
import org.eclipse.swt.custom.ExtendedModifyListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.internal.BidiUtil;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class StyledTextChatArea
extends StyledText {
    static final Logger logger = Logger.getLogger(StyledTextChatArea.class.getName());
    private boolean isBoldOn = false;
    private boolean isItalicOn = false;
    private boolean isUnderlineOn = false;
    private boolean isStrikeOn = false;
    private boolean resetToDefaultFont = false;
    private Color currForegroundColor = null;
    private Color currBackgroundColor = null;
    private Font currFont = null;
    private Font originalFont = null;
    private Font bidiFont = null;
    public static final String STYLE = "style";
    private boolean doStyles = false;
    MenuItem bold;
    private ArrayList listeners;
    private ArrayList fontsToDispose;
    private Hashtable embeddedObjects;
    IChatTranscript chatTranscript;
    private boolean isRichTextEnabled = true;
    private ImChatWindowHandler handler = null;
    private LocalResourceManager resouceManager;
    private AnnotationManager annotationManager;
    private String accText = null;
    private StringBuffer unmixed = null;
    private boolean bidi = false;

    public StyledTextChatArea(Composite parent, int style) {
        super(parent, style);
        String orientation;
        this.resouceManager = new LocalResourceManager(JFaceResources.getResources((Display)parent.getDisplay()), (Control)this);
        this.originalFont = this.getFont();
        this.currFont = this.getFont();
        this.annotationManager = AnnotationManager.getAnnotationManager((StyledText)this);
        TransferOperationContextImpl context = new TransferOperationContextImpl();
        final DropTarget dropTarget = new DropTarget((Control)this, 23);
        dropTarget.addDropListener((DropTargetListener)new ExtendibleDropTargetListener((TransferOperationContext)context));
        DragAndDropSupportRegistry.getInstance().loadTransfers(dropTarget);
        final DragSource dragSource = new DragSource((Control)this, 23);
        dragSource.addDragListener((DragSourceListener)new ExtendibleDragSourceListener((TransferOperationContext)context));
        DragAndDropSupportRegistry.getInstance().loadTransfers(dragSource);
        this.addExtendedModifyListener(new ExtendedModifyListener(){

            public void modifyText(ExtendedModifyEvent e) {
                if (StyledTextChatArea.this.annotationManager.getIsKeepStyle() && StyledTextChatArea.this.getText().length() > e.start && Character.isWhitespace(StyledTextChatArea.this.getText().charAt(e.start))) {
                    StyledTextChatArea.this.doStyles = true;
                }
                if (StyledTextChatArea.this.doStyles) {
                    if (e.length == 1) {
                        StyleRange oldStyle;
                        int style = 0;
                        if (StyledTextChatArea.this.isBoldOn) {
                            style |= 1;
                        }
                        if (StyledTextChatArea.this.isItalicOn) {
                            style |= 2;
                        }
                        if (style == 0) {
                            style = 0;
                        }
                        StyleRange sr = null;
                        sr = BidiUtil.getKeyboardLanguage() == 1 ? new BidiStyleRange(e.start, 1, StyledTextChatArea.this.currForegroundColor, StyledTextChatArea.this.currBackgroundColor, style) : new StyleRange(e.start, 1, StyledTextChatArea.this.currForegroundColor, StyledTextChatArea.this.currBackgroundColor, style);
                        if (StyledTextChatArea.this.getText() != null && StyledTextChatArea.this.getText().length() > 0 && (oldStyle = StyledTextChatArea.this.getStyleRangeAtOffset(e.start)) != null) {
                            sr = oldStyle;
                            sr.fontStyle = style;
                        }
                        if (StyledTextChatArea.this.currFont != null) {
                            sr.font = StyledTextChatArea.this.currFont;
                            if (style != 0) {
                                FontData fd = StyledTextChatArea.this.currFont.getFontData()[0];
                                fd.setStyle(style);
                                Font f = new Font(null, fd);
                                StyledTextChatArea.this.addToDispose(f);
                                sr.font = f;
                            }
                        }
                        sr.underline = StyledTextChatArea.this.isUnderlineOn;
                        sr.strikeout = StyledTextChatArea.this.isStrikeOn;
                        StyledTextChatArea.this.setStyleRange(sr);
                        StyledTextChatArea.this.doStyles = false;
                        StyledTextChatArea.this.annotationManager.setIsKeepStyle(false);
                    }
                } else {
                    StyleRange[] oldRanges = StyledTextChatArea.this.getStyleRanges();
                    if (oldRanges != null) {
                        int i = 0;
                        while (i < oldRanges.length) {
                            if (!(oldRanges[i] instanceof AnnotatedRange)) {
                                StyleRange oldRange = oldRanges[i];
                                if (StyledTextChatArea.this.annotationManager.getIsKeepStyle()) {
                                    if (e.start >= oldRange.start && e.start <= oldRange.start + oldRange.length && e.start != e.start + e.length) {
                                        oldRange.length = e.replacedText.length() == 0 ? ++oldRange.length : (oldRange.length += e.length - e.replacedText.length() + 1);
                                        try {
                                            StyledTextChatArea.this.setStyleRange(oldRange);
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {}
                                        StyledTextChatArea.this.annotationManager.setIsKeepStyle(false);
                                    }
                                } else {
                                    if (e.start >= oldRange.start && e.start <= oldRange.start + oldRange.length && e.start != e.start + e.length) {
                                        oldRange.length += e.length - e.replacedText.length();
                                    } else {
                                        int cfr_ignored_0 = e.length;
                                    }
                                    try {
                                        StyledTextChatArea.this.setStyleRange(oldRange);
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {}
                                }
                            }
                            ++i;
                        }
                    }
                    if (StyledTextChatArea.this.getText() != null && StyledTextChatArea.this.getText().length() == 0) {
                        StyledTextChatArea.this.doStyles = true;
                    }
                }
            }
        });
        this.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
                if (event.detail == 64 || event.detail == 32) {
                    StyledTextChatArea.this.updateStyleControls();
                }
            }
        });
        this.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.keyCode == 0x1000002 || event.keyCode == 0x1000001) {
                    StyledTextChatArea.this.updateStyleControls();
                }
            }
        });
        this.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                if (StyledTextChatArea.this.getSelectionCount() > 0) {
                    Point sel = StyledTextChatArea.this.getSelectionRange();
                    int i = sel.x;
                    while (i < sel.x + sel.y) {
                        try {
                            StyleRange range = StyledTextChatArea.this.getStyleRangeAtOffset(i);
                            if (range instanceof ImageStyleRange) {
                                ImageStyleRange sr = (ImageStyleRange)range;
                                if (sr.uid != null && StyledTextChatArea.this.embeddedObjects.containsKey(sr.uid)) {
                                    StyledTextChatArea.this.embeddedObjects.remove(sr.uid);
                                }
                                if (sr.runnable != null) {
                                    sr.runnable.cancel();
                                    AnimatedGifTimer.cancelTask((Widget)StyledTextChatArea.this, (TimerTask)sr.runnable);
                                }
                                e.doit = true;
                            }
                        }
                        catch (Exception exception) {}
                        ++i;
                    }
                }
            }
        });
        this.addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent e) {
                block9: {
                    if ((e.stateMask & 0x20000) != 0 && e.keyCode == 65536 || (e.stateMask & 0x10000) != 0 && e.keyCode == 131072) {
                        StyledTextChatArea.this.doStyles = true;
                    }
                    if (e.character == '\b' || e.character == '\u007f') {
                        Point sel = StyledTextChatArea.this.getSelectionRange();
                        int start = sel.x;
                        int end = start + StyledTextChatArea.this.getSelectionCount();
                        if (start == end) {
                            try {
                                int input;
                                int n = input = e.character == '\b' ? start - 1 : start;
                                if (input >= 0) {
                                    StyleRange st = StyledTextChatArea.this.getStyleRangeAtOffset(input);
                                    if (st instanceof ImageStyleRange) {
                                        ImageStyleRange sr = (ImageStyleRange)st;
                                        if (sr.uid != null && StyledTextChatArea.this.embeddedObjects.containsKey(sr.uid)) {
                                            StyledTextChatArea.this.embeddedObjects.remove(sr.uid);
                                        }
                                        if (sr.runnable != null) {
                                            sr.runnable.cancel();
                                            AnimatedGifTimer.cancelTask((Widget)StyledTextChatArea.this, (TimerTask)sr.runnable);
                                        }
                                    }
                                    e.doit = true;
                                }
                            }
                            catch (Throwable t) {
                                if (!logger.isLoggable(Level.FINER)) break block9;
                                logger.log(Level.FINER, t.getMessage(), t);
                            }
                        }
                    }
                }
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                if (!SwtUtils.rightClick((MouseEvent)e)) {
                    StyledTextChatArea.this.updateStyleControls();
                }
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                dragSource.dispose();
                dropTarget.dispose();
                StyledTextChatArea.this.disposeAllFonts();
                StyledTextChatArea.this.disposeAllImages();
                if (StyledTextChatArea.this.listeners != null) {
                    StyledTextChatArea.this.listeners.clear();
                    StyledTextChatArea.this.listeners = null;
                }
                if (StyledTextChatArea.this.resouceManager != null) {
                    StyledTextChatArea.this.resouceManager.dispose();
                    StyledTextChatArea.this.resouceManager = null;
                }
                StyledTextChatArea.this.handler = null;
            }
        });
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                StyledTextChatArea.this.onPaint(e.gc);
            }
        });
        this.addListener(39, new Listener(){

            public void handleEvent(Event event) {
                if (Display.getDefault().getHighContrast()) {
                    StyledTextChatArea.this.handler.updateColor(Display.getDefault().getSystemColor(24).getRGB());
                } else {
                    StyledTextChatArea.this.handler.updateColor(ChatWindowPreferences.getFontColorFromPrefs(ImChatPlugin.getDefault().getPreferenceStore(), false));
                }
            }
        });
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = StyledTextChatArea.this.accText != null ? StyledTextChatArea.this.accText : Messages.type_your_text;
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getValue(AccessibleControlEvent e) {
                if (StyledTextChatArea.this.hasEmbeddableObjects()) {
                    for (Embeddable em : StyledTextChatArea.this.embeddedObjects.values()) {
                        if (!(em instanceof FileEmbeddable)) continue;
                        FileEmbeddable fe = (FileEmbeddable)em;
                        e.result = fe.getFileName();
                    }
                } else {
                    e.result = StyledTextChatArea.this.getText();
                }
            }
        });
        Locale locale = Locale.getDefault();
        if (locale.getLanguage().equals(new Locale("he", "", "").getLanguage()) || locale.getLanguage().equals(new Locale("ar", "", "").getLanguage())) {
            this.setBidi();
        }
        if ("rtl".equals(orientation = System.getProperty("eclipse.orientation"))) {
            this.setBidi();
        }
    }

    private void setBidi() {
        this.bidi = true;
    }

    private void onPaint(GC gc) {
    }

    private void addToDispose(Object o) {
        if (this.fontsToDispose == null) {
            this.fontsToDispose = new ArrayList();
        }
        this.fontsToDispose.add(o);
    }

    private void disposeAllFonts() {
        if (this.bidiFont != null) {
            this.bidiFont.dispose();
            this.bidiFont = null;
        }
        if (this.fontsToDispose != null) {
            int i = 0;
            while (i < this.fontsToDispose.size()) {
                Object obj = this.fontsToDispose.get(i);
                if (obj instanceof Font) {
                    Font f = (Font)obj;
                    if (!f.isDisposed()) {
                        f.dispose();
                    }
                    f = null;
                } else if (obj instanceof Color) {
                    Color c = (Color)obj;
                    if (!c.isDisposed()) {
                        c.dispose();
                    }
                    Object var3_3 = null;
                }
                ++i;
            }
        }
        this.fontsToDispose = null;
    }

    private void disposeAllImages() {
        if (this.fontsToDispose != null) {
            int i = 0;
            while (i < this.fontsToDispose.size()) {
                Object obj = this.fontsToDispose.get(i);
                if (obj instanceof Image) {
                    Image f = (Image)obj;
                    if (!f.isDisposed()) {
                        f.dispose();
                    }
                    Object var3_3 = null;
                }
                ++i;
            }
        }
        this.fontsToDispose = null;
    }

    public void resetControls() {
        this.doStyles = true;
        if (!this.isRichTextEnabled) {
            if (!this.resetToDefaultFont) {
                this.resetToDefaultFontStyleAndHeight();
                this.resetToDefaultFont = true;
            }
        } else {
            this.resetToDefaultFont = false;
        }
    }

    public void resetToDefaultFontStyleAndHeight() {
        this.isBoldOn = false;
        this.isItalicOn = false;
        this.isUnderlineOn = false;
        this.isStrikeOn = false;
        this.currFont = this.getFont();
        this.resetBackgroundColor();
        this.resetForegroundColor();
        StyleRange range = new StyleRange(0, 0, null, null, 0);
        range.font = null;
        this.updateStyleControls(null);
        Point sel = this.getSelectionRange();
        if (sel == null) {
            return;
        }
        if (sel.y == 0) {
            this.doStyles = true;
            return;
        }
        StyleRange style = null;
        StyleRange[] existingRanges = this.getStyleRanges(sel.x, sel.y, true);
        int i = 0;
        while (i < existingRanges.length) {
            style = existingRanges[i];
            style.font = this.currFont;
            style.fontStyle = this.currFont.getFontData()[0].getStyle();
            this.setStyleRange(style);
            ++i;
        }
        this.setFocus();
    }

    private void resetBackgroundColor() {
        this.currBackgroundColor = null;
    }

    private void resetForegroundColor() {
        this.currForegroundColor = null;
    }

    public void setBold(boolean boldicize) {
        this.isBoldOn = boldicize;
        Point sel = this.getSelectionRange();
        if (sel == null) {
            return;
        }
        if (sel.y == 0) {
            if (this.currFont != null) {
                FontData fd = this.currFont.getFontData()[0];
                int fontStyle = (this.isBoldOn ? 1 : 0) | (this.isItalicOn ? 2 : 0);
                Font newFont = new Font((Device)this.getDisplay(), fd.getName(), fd.getHeight(), fontStyle);
                this.addToDispose(newFont);
                this.currFont = newFont;
            }
            this.doStyles = true;
            return;
        }
        StyleRange style = null;
        StyleRange[] existingRanges = this.getStyleRanges(sel.x, sel.y, true);
        int i = 0;
        while (i < existingRanges.length) {
            style = existingRanges[i];
            style.fontStyle = !this.isBoldOn ? (style.fontStyle &= 0xFFFFFFFE) : (style.fontStyle |= 1);
            if (style.font != null) {
                FontData fd = style.font.getFontData()[0];
                Font newFont = new Font((Device)this.getDisplay(), fd.getName(), fd.getHeight(), style.fontStyle);
                this.addToDispose(newFont);
                style.font = newFont;
            }
            this.setStyleRange(style);
            ++i;
        }
    }

    public boolean isBold() {
        return this.isBoldOn;
    }

    public boolean isItalic() {
        return this.isItalicOn;
    }

    public boolean isUnderline() {
        return this.isUnderlineOn;
    }

    public void setTranscript(IChatTranscript transcript) {
        this.chatTranscript = transcript;
    }

    public void setItalic(boolean italicize) {
        this.isItalicOn = italicize;
        Point sel = this.getSelectionRange();
        if (sel == null) {
            return;
        }
        if (sel.y == 0) {
            if (this.currFont != null) {
                FontData fd = this.currFont.getFontData()[0];
                int fontStyle = (this.isBoldOn ? 1 : 0) | (this.isItalicOn ? 2 : 0);
                Font newFont = new Font((Device)this.getDisplay(), fd.getName(), fd.getHeight(), fontStyle);
                this.addToDispose(newFont);
                this.currFont = newFont;
            }
            this.doStyles = true;
            return;
        }
        StyleRange[] existingRanges = this.getStyleRanges(sel.x, sel.y, true);
        int i = 0;
        while (i < existingRanges.length) {
            StyleRange style = existingRanges[i];
            style.fontStyle = !this.isItalicOn ? (style.fontStyle &= 0xFFFFFFFD) : (style.fontStyle |= 2);
            if (style.font != null) {
                FontData fd = style.font.getFontData()[0];
                Font newFont = new Font((Device)this.getDisplay(), fd.getName(), fd.getHeight(), style.fontStyle);
                this.addToDispose(newFont);
                style.font = newFont;
            }
            this.setStyleRange(style);
            ++i;
        }
    }

    public void setUnderline(boolean underline) {
        this.isUnderlineOn = underline;
        Point sel = this.getSelectionRange();
        if (sel == null) {
            return;
        }
        if (sel.y == 0) {
            this.doStyles = true;
            return;
        }
        StyleRange[] existingRanges = this.getStyleRanges(sel.x, sel.y, true);
        int i = 0;
        while (i < existingRanges.length) {
            StyleRange style = existingRanges[i];
            style.underline = this.isUnderlineOn;
            this.setStyleRange(style);
            ++i;
        }
    }

    public void setStrikeOut(boolean strikeout) {
        this.isStrikeOn = strikeout;
        Point sel = this.getSelectionRange();
        if (sel == null) {
            return;
        }
        if (sel.y == 0) {
            this.doStyles = true;
            return;
        }
        StyleRange[] existingRanges = this.getStyleRanges(sel.x, sel.y, true);
        int i = 0;
        while (i < existingRanges.length) {
            StyleRange style = existingRanges[i];
            style.strikeout = this.isStrikeOn;
            this.setStyleRange(style);
            ++i;
        }
    }

    public void setForegroundColor(Color color) {
        this.currForegroundColor = color;
        Point sel = this.getSelectionRange();
        if (sel == null) {
            return;
        }
        if (sel.y == 0) {
            this.doStyles = true;
            return;
        }
        StyleRange[] existingRanges = this.getStyleRanges(sel.x, sel.y, true);
        int i = 0;
        while (i < existingRanges.length) {
            StyleRange style = existingRanges[i];
            style.foreground = this.currForegroundColor;
            this.setStyleRange(style);
            ++i;
        }
        this.setFocus();
    }

    public Color selectForegroundColor() {
        return this.selectForegroundColor(this.currForegroundColor);
    }

    public Color selectForegroundColor(Color currentColor) {
        Color foreColor;
        block5: {
            ColorDialog colorDlg = new ColorDialog(this.getShell(), 2144);
            if (currentColor != null) {
                colorDlg.setRGB(currentColor.getRGB());
            } else {
                colorDlg.setRGB(this.getForeground().getRGB());
            }
            RGB rgb = colorDlg.open();
            if (rgb == null) {
                return null;
            }
            foreColor = currentColor;
            try {
                foreColor = this.resouceManager.createColor(rgb);
                this.setForegroundColor(foreColor);
            }
            catch (DeviceResourceException e) {
                if (!logger.isLoggable(Level.WARNING)) break block5;
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return foreColor;
    }

    public void setBackgroundColor(Color color) {
        this.currBackgroundColor = color;
        Point sel = this.getSelectionRange();
        if (sel == null) {
            return;
        }
        if (sel.y == 0) {
            this.doStyles = true;
            return;
        }
        StyleRange[] existingRanges = this.getStyleRanges(sel.x, sel.y, true);
        int i = 0;
        while (i < existingRanges.length) {
            StyleRange style = existingRanges[i];
            style.background = this.currBackgroundColor;
            this.setStyleRange(style);
            ++i;
        }
        this.setFocus();
    }

    public Color selectBackgroundColor() {
        return this.selectBackgroundColor(this.currBackgroundColor);
    }

    public Color selectBackgroundColor(Color currBack) {
        Color backColor;
        block5: {
            ColorDialog colorDlg = new ColorDialog(this.getShell(), 2144);
            if (currBack != null) {
                colorDlg.setRGB(currBack.getRGB());
            } else {
                colorDlg.setRGB(this.getBackground().getRGB());
            }
            RGB rgb = colorDlg.open();
            if (rgb == null) {
                return null;
            }
            backColor = currBack;
            try {
                backColor = this.resouceManager.createColor(rgb);
                this.setBackgroundColor(backColor);
            }
            catch (DeviceResourceException e) {
                if (!logger.isLoggable(Level.WARNING)) break block5;
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        this.setFocus();
        return backColor;
    }

    public void increaseFontSize() {
        this.changeFontSize(true);
    }

    public void changeFontSize(int height) {
        Point sel = this.getSelectionRange();
        if (sel == null) {
            return;
        }
        if (sel.y == 0) {
            Font defaultFont = this.currFont != null ? this.currFont : this.getFont();
            FontData fd = defaultFont.getFontData()[0];
            fd.height = height;
            int fontStyle = (this.isBoldOn ? 1 : 0) | (this.isItalicOn ? 2 : 0);
            Font newFont = new Font((Device)this.getDisplay(), fd.getName(), fd.getHeight(), fontStyle);
            this.addToDispose(newFont);
            this.currFont = newFont;
            this.doStyles = true;
            return;
        }
        StyleRange[] existingRanges = this.getStyleRanges(sel.x, sel.y, true);
        int i = 0;
        while (i < existingRanges.length) {
            StyleRange style = existingRanges[i];
            if (style.font != null) {
                FontData fd = style.font.getFontData()[0];
                Font newFont = new Font((Device)this.getDisplay(), fd.getName(), height, style.fontStyle);
                this.addToDispose(newFont);
                style.font = newFont;
            }
            this.setStyleRange(style);
            ++i;
        }
        this.setFocus();
    }

    private void changeFontSize(boolean up) {
        Point sel = this.getSelectionRange();
        if (sel == null) {
            return;
        }
        if (sel.y == 0) {
            Font defaultFont = this.currFont != null ? this.currFont : this.getFont();
            FontData fd = defaultFont.getFontData()[0];
            fd.height = this.getIncrementedHeight(fd.getHeight(), up);
            int fontStyle = (this.isBoldOn ? 1 : 0) | (this.isItalicOn ? 2 : 0);
            Font newFont = new Font((Device)this.getDisplay(), fd.getName(), fd.getHeight(), fontStyle);
            this.addToDispose(newFont);
            this.currFont = newFont;
            this.doStyles = true;
            return;
        }
        Font lastIncrementedFont = null;
        Font lastFont = null;
        int lastStyle = 0;
        int i = sel.x;
        while (i < sel.x + sel.y) {
            StyleRange style;
            Font currentFont = null;
            int currentStyle = 0;
            StyleRange range = this.getStyleRangeAtOffset(i);
            if (range != null) {
                style = (StyleRange)range.clone();
                style.start = i;
                style.length = 1;
                currentStyle = style.fontStyle;
                currentFont = style.font != null ? style.font : this.originalFont;
            } else {
                style = new StyleRange(i, 1, null, null, 0);
                currentFont = this.originalFont;
                currentStyle = 0;
            }
            if (lastFont == null || lastFont != currentFont || lastStyle != currentStyle) {
                lastFont = currentFont;
                lastStyle = currentStyle;
                FontData fd = currentFont.getFontData()[0];
                fd.height = this.getIncrementedHeight(fd.getHeight(), up);
                Font newFont = new Font((Device)this.getDisplay(), fd.getName(), fd.getHeight(), currentStyle);
                this.addToDispose(newFont);
                lastIncrementedFont = newFont;
            }
            style.font = lastIncrementedFont;
            style.fontStyle = currentStyle;
            this.setStyleRange(style);
            ++i;
        }
        this.setFocus();
    }

    private int getIncrementedHeight(int initialHeight, boolean up) {
        if (up) {
            if (initialHeight < 72) {
                ++initialHeight;
            }
        } else if (initialHeight > 7) {
            --initialHeight;
        }
        return initialHeight;
    }

    public void decreaseFontSize() {
        this.changeFontSize(false);
    }

    private StyleRange getStyleRangeForOffset(int i) {
        try {
            StyleRange[] ranges = this.getStyleRanges();
            int j = 0;
            while (j < ranges.length) {
                if (!(ranges[j] instanceof InvisibleStyleRange) && ranges[j].start == i) {
                    return ranges[j];
                }
                ++j;
            }
        }
        catch (Throwable throwable) {}
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public Object[] getMixedContent() {
        v0 = isMultiChat = this.handler != null && this.handler.isMultiChat() != false;
        if (this.handler.isRichTextEnabled()) {
            isMultiChat = false;
        }
        addedFileBytes = false;
        this.unmixed = new StringBuffer();
        content = new ArrayList<String>();
        buffer = new StringBuffer();
        textText = super.getText().toCharArray();
        span = this.getMyFontStyle();
        closeSpan = false;
        dir = "";
        dir = this.getAlignment() == 131072 || this.getOrientation() == 0x4000000 ? " class=\"right\"" : " class=\"left\"";
        if (!isMultiChat) {
            if (span != null) {
                buffer.append("<span style=\"");
                buffer.append(span);
                buffer.append("\"");
                buffer.append(dir);
                buffer.append(">");
                closeSpan = true;
            } else if (this.bidi) {
                buffer.append("<span");
                buffer.append(dir);
                buffer.append(">");
                closeSpan = true;
            }
        }
        i = 0;
        while (i < textText.length) {
            block58: {
                try {
                    range = null;
                    while ((range = this.getStyleRangeForOffset(i)) != null) {
                        block59: {
                            innerspan = new StringBuffer();
                            linkColorStyle = new StringBuffer(" style=\"color:");
                            if (!isMultiChat && range.background != null && !range.background.equals((Object)this.getBackground())) {
                                innerspan.append("background-color:");
                                innerspan.append(StyledTextChatArea.hexify(range.background.getRGB()));
                                innerspan.append(";");
                            }
                            if (!isMultiChat && range.foreground != null && !range.foreground.equals((Object)this.getForeground())) {
                                innerspan.append("color:");
                                innerspan.append(StyledTextChatArea.hexify(range.foreground.getRGB()));
                                innerspan.append(";");
                                linkColorStyle.append(StyledTextChatArea.hexify(range.foreground.getRGB()));
                                linkColorStyle.append("\"");
                            }
                            if (!this.fontMatches(range)) {
                                if (!isMultiChat && range.font != null && !range.font.equals((Object)this.bidiFont)) {
                                    innerspan.append("font-size:");
                                    innerspan.append(range.font.getFontData()[0].getHeight());
                                    innerspan.append("pt;");
                                    innerspan.append("font-family:");
                                    innerspan.append(range.font.getFontData()[0].getName());
                                    innerspan.append(";");
                                }
                                if (!isMultiChat) {
                                    if ((range.fontStyle & 1) == 0) {
                                        innerspan.append("font-weight:normal;");
                                    }
                                    if ((range.fontStyle & 2) == 0) {
                                        innerspan.append("font-style:normal;");
                                    }
                                }
                            }
                            if (!isMultiChat && innerspan.length() > 0) {
                                buffer.append("<span style=\"");
                                if (!Display.getDefault().getHighContrast()) {
                                    buffer.append(innerspan);
                                }
                                buffer.append("\">");
                            }
                            if (!isMultiChat && (range.fontStyle & 1) != 0) {
                                buffer.append("<b>");
                            }
                            if (!isMultiChat && (range.fontStyle & 2) != 0) {
                                buffer.append("<i>");
                            }
                            if (!isMultiChat && range.underline) {
                                buffer.append("<u>");
                            }
                            if (!isMultiChat && range.strikeout) {
                                buffer.append("<strike>");
                            }
                            insides = new StringBuffer();
                            if (!(range instanceof AnnotatedRange)) ** GOTO lbl222
                            if (!(range instanceof ImageStyleRange)) ** GOTO lbl199
                            sr = (ImageStyleRange)range;
                            image = sr.image;
                            if (range.length > 0) {
                                i += range.length;
                            }
                            if (image == null) break block59;
                            if (insides.length() > 0) {
                                buffer.append(insides);
                            }
                            if (buffer.length() > 0) {
                                this.unmixed.append(buffer.toString());
                                content.add(buffer.toString());
                                buffer = new StringBuffer();
                            }
                            imgTag = null;
                            if (sr.replacementText != null) {
                                imgTag = sr.replacementText;
                                this.unmixed.append(sr.replacementText);
                            } else if (sr.originalFile != null) {
                                img = new StringBuffer();
                                img.append("<img src=\"");
                                strFile = sr.originalFile;
                                strFile = strFile.replaceAll("[%]", "cas42");
                                newFilename = FileUtils.getLocalUrl((String)strFile);
                                newFilename = newFilename.replaceAll("cas42", "%25");
                                img.append(newFilename);
                                img.append("\" border=\"0\"");
                                if (sr.plainText != null) {
                                    img.append(" alt=\"");
                                    img.append(sr.plainText);
                                    img.append("\"");
                                }
                                img.append("/>");
                                this.unmixed.append(img.toString());
                                imgTag = img.toString();
                                img = null;
                            }
                            bytes = this.getFileBytes(sr.originalFile);
                            if (bytes != null) {
                                if (!isMultiChat && imgTag != null) {
                                    content.add(imgTag);
                                }
                                if (isMultiChat) {
                                    if (sr.alt != null) {
                                        b = new StringBuffer();
                                        b.append("IMAGE [");
                                        b.append(sr.alt);
                                        b.append("]");
                                        content.add(b.toString());
                                    } else if (sr.plainText != null && sr.plainText.length() > 0) {
                                        b = new StringBuffer();
                                        b.append("IMAGE [");
                                        b.append(sr.plainText);
                                        b.append("]");
                                        content.add(b.toString());
                                    }
                                    data = new DataMessage();
                                    data.msgType = "data";
                                    data.msgSubtype = "image";
                                    data.bytes = bytes;
                                    data.filename = sr.originalFile;
                                    content.add((String)data);
                                    addedFileBytes = true;
                                } else {
                                    data = new DataMessage();
                                    data.msgType = "data";
                                    data.msgSubtype = "image";
                                    data.bytes = bytes;
                                    data.filename = sr.originalFile;
                                    content.add((String)data);
                                    addedFileBytes = true;
                                }
                            }
                            insides = null;
                            buffer = new StringBuffer();
                            break block59;
lbl-1000:
                            // 1 sources

                            {
                                insides.append(StyledTextChatArea.escapeChar(textText[i]));
                                ++i;
lbl199:
                                // 2 sources

                                ** while (i < range.start + range.length)
                            }
lbl200:
                            // 1 sources

                            ar = (AnnotatedRange)range;
                            if (!isMultiChat && ar.replacementText != null) {
                                str = ar.replacementText;
                                intTmp = str.indexOf("<a");
                                if (intTmp >= 0) {
                                    str1 = str.substring(0, "<a".length());
                                    str2 = str.substring(intTmp + "<a".length());
                                    str = String.valueOf(str1) + linkColorStyle + str2;
                                }
                                buffer.append(str);
                                insides = null;
                            } else {
                                if (isMultiChat) {
                                    insides.append(" ");
                                }
                                buffer.append(insides);
                                insides = null;
                            }
                            break block59;
lbl-1000:
                            // 1 sources

                            {
                                insides.append(StyledTextChatArea.escapeChar(textText[i]));
                                ++i;
lbl222:
                                // 2 sources

                                ** while (i < range.start + range.length)
                            }
lbl223:
                            // 1 sources

                            buffer.append(insides);
                            insides = null;
                        }
                        if (!isMultiChat && range.strikeout) {
                            buffer.append("</strike>");
                        }
                        if (!isMultiChat && range.underline) {
                            buffer.append("</u>");
                        }
                        if (!isMultiChat && (range.fontStyle & 2) != 0) {
                            buffer.append("</i>");
                        }
                        if (!isMultiChat && (range.fontStyle & 1) != 0) {
                            buffer.append("</b>");
                        }
                        if (!isMultiChat && innerspan.length() > 0) {
                            buffer.append("</span>");
                        }
                        innerspan = null;
                        if (buffer.length() > 0) {
                            this.unmixed.append(buffer);
                            content.add(buffer.toString());
                        }
                        buffer = new StringBuffer();
                    }
                }
                catch (Throwable t) {
                    if (!StyledTextChatArea.logger.isLoggable(Level.WARNING)) break block58;
                    StyledTextChatArea.logger.log(Level.WARNING, t.getMessage(), t);
                }
            }
            if (i < textText.length) {
                buffer.append(StyledTextChatArea.escapeChar(textText[i]));
            }
            ++i;
        }
        if (closeSpan) {
            buffer.append("</span>");
        }
        if (buffer.length() > 0) {
            this.unmixed.append(buffer);
            content.add(buffer.toString());
        }
        if (addedFileBytes) {
            data = new DataMessage();
            data.msgType = "data";
            data.msgSubtype = "command";
            data.bytes = new byte[]{-126};
            content.add((String)data);
            data = new DataMessage();
            data.msgType = "data";
            data.msgSubtype = "command";
            data.bytes = new byte[]{-34};
            content.add(0, (String)data);
        } else {
            whole = new StringBuffer();
            i = 0;
            while (i < content.size()) {
                stuff = content.get(i);
                if (stuff instanceof String) {
                    whole.append((String)stuff);
                }
                ++i;
            }
            content.clear();
            content.add(whole.toString());
        }
        return content.toArray();
    }

    public String getUnmixed() {
        return this.unmixed.toString();
    }

    public String getPlainText() {
        StringBuffer buffer = new StringBuffer();
        char[] textText = this.getText().toCharArray();
        int i = 0;
        while (i < textText.length) {
            try {
                StyleRange range = null;
                while ((range = this.getStyleRangeForOffset(i)) != null) {
                    StringBuffer insides = new StringBuffer();
                    while (i < range.start + range.length) {
                        insides.append(textText[i]);
                        ++i;
                    }
                    if (range instanceof AnnotatedRange) {
                        AnnotatedRange ar = (AnnotatedRange)range;
                        if (ar.plainText != null) {
                            buffer.append(ar.plainText);
                            insides = null;
                            continue;
                        }
                        buffer.append(insides);
                        insides = null;
                        continue;
                    }
                    buffer.append(insides);
                    insides = null;
                }
            }
            catch (Throwable throwable) {}
            if (i < textText.length) {
                buffer.append(textText[i]);
            }
            ++i;
        }
        return buffer.toString();
    }

    public String getHTML() {
        StringBuffer buffer = new StringBuffer();
        String tmpTxt = SwtUtils.getBIDITextWithNumbers((String)super.getText(), (int)this.handler.getSendArea().getOrientation());
        char[] textText = tmpTxt.toCharArray();
        if (textText.length == 0) {
            return "<span style=\"myself\">&#160;</span>";
        }
        String span = null;
        span = this.getMyFontStyle();
        String dir = "";
        dir = this.getAlignment() == 131072 || this.getOrientation() == 0x4000000 ? " class=\"right\"" : " class=\"left\"";
        if (span != null) {
            buffer.append("<span style=\"");
            buffer.append(span);
            buffer.append("\"");
            buffer.append(dir);
            buffer.append(">");
        } else if (this.bidi) {
            buffer.append("<span" + dir + ">");
        }
        int i = 0;
        while (i < textText.length) {
            try {
                StyleRange range = null;
                while ((range = this.getStyleRangeForOffset(i)) != null) {
                    StringBuffer innerspan = new StringBuffer();
                    StringBuffer linkColorStyle = new StringBuffer();
                    if (range.background != null && !range.background.equals((Object)this.getBackground())) {
                        innerspan.append("background-color:");
                        innerspan.append(StyledTextChatArea.hexify(range.background.getRGB()));
                        innerspan.append(";");
                    }
                    if (range.foreground != null && !range.foreground.equals((Object)this.getForeground())) {
                        innerspan.append("color:");
                        innerspan.append(StyledTextChatArea.hexify(range.foreground.getRGB()));
                        innerspan.append(";");
                        linkColorStyle.append(" style=\"color:");
                        linkColorStyle.append(StyledTextChatArea.hexify(range.foreground.getRGB()));
                        linkColorStyle.append("\"");
                    }
                    if (!this.fontMatches(range)) {
                        if (range.font != null) {
                            innerspan.append("font-size:");
                            innerspan.append(range.font.getFontData()[0].getHeight());
                            innerspan.append("pt;");
                            innerspan.append("font-family:");
                            innerspan.append(range.font.getFontData()[0].getName());
                            innerspan.append(";");
                        }
                        if ((range.fontStyle & 1) == 0) {
                            innerspan.append("font-weight:normal;");
                        }
                        if ((range.fontStyle & 2) == 0) {
                            innerspan.append("font-style:normal;");
                        }
                    }
                    if (innerspan.length() > 0) {
                        buffer.append("<span style=\"");
                        if (!Display.getDefault().getHighContrast()) {
                            buffer.append(innerspan);
                        }
                        buffer.append("\">");
                    }
                    if ((range.fontStyle & 1) != 0) {
                        buffer.append("<b>");
                    }
                    if ((range.fontStyle & 2) != 0) {
                        buffer.append("<i>");
                    }
                    if (range.underline) {
                        buffer.append("<u>");
                    }
                    if (range.strikeout) {
                        buffer.append("<strike>");
                    }
                    StringBuffer insides = new StringBuffer();
                    while (i < range.start + range.length) {
                        insides.append(StyledTextChatArea.escapeChar(textText[i]));
                        ++i;
                    }
                    if (range instanceof AnnotatedRange) {
                        AnnotatedRange ar = (AnnotatedRange)range;
                        if (ar.replacementText != null) {
                            int intTmp;
                            String str = ar.replacementText;
                            if (linkColorStyle.length() > 0 && (intTmp = str.indexOf("<a")) >= 0) {
                                String str1 = str.substring(0, "<a".length());
                                String str2 = str.substring(intTmp + "<a".length());
                                str = String.valueOf(str1) + linkColorStyle + str2;
                            }
                            buffer.append(str);
                            insides = null;
                        } else {
                            buffer.append(insides);
                            insides = null;
                        }
                    } else {
                        buffer.append(insides);
                        insides = null;
                    }
                    if (range.strikeout) {
                        buffer.append("</strike>");
                    }
                    if (range.underline) {
                        buffer.append("</u>");
                    }
                    if ((range.fontStyle & 2) != 0) {
                        buffer.append("</i>");
                    }
                    if ((range.fontStyle & 1) != 0) {
                        buffer.append("</b>");
                    }
                    if (innerspan.length() > 0) {
                        buffer.append("</span>");
                    }
                    innerspan = null;
                }
            }
            catch (Throwable throwable) {}
            if (i < textText.length) {
                buffer.append(StyledTextChatArea.escapeChar(textText[i]));
            }
            ++i;
        }
        if (span != null) {
            buffer.append("</span>");
        }
        return buffer.toString();
    }

    private boolean fontMatches(StyleRange range) {
        Font font = range.font;
        if (font != null) {
            FontData data = font.getFontData()[0];
            FontData currData = this.getFont().getFontData()[0];
            if (data.getHeight() == currData.getHeight() && data.getName().equals(currData.getName())) {
                return currData.getStyle() == 0 || data.getStyle() != 0;
            }
        }
        return false;
    }

    private byte[] getImageBytes(Image image) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ImageLoader loader = new ImageLoader();
        loader.data = new ImageData[]{image.getImageData()};
        loader.save((OutputStream)os, 4);
        return os.toByteArray();
    }

    private byte[] getFileBytes(String filename) {
        if (filename == null) {
            return null;
        }
        File file = new File(filename);
        if (file.exists()) {
            try {
                int len;
                FileInputStream fis = new FileInputStream(file);
                BufferedInputStream in = new BufferedInputStream(fis);
                ByteArrayOutputStream output = new ByteArrayOutputStream();
                byte[] buffer = new byte[4096];
                while ((len = in.read(buffer)) != -1) {
                    output.write(buffer, 0, len);
                }
                in.close();
                fis.close();
                return output.toByteArray();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public boolean hasInlineContent() {
        if (this.embeddedObjects != null && this.embeddedObjects.size() > 0) {
            Enumeration e = this.embeddedObjects.elements();
            while (e.hasMoreElements()) {
                Embeddable embed = (Embeddable)e.nextElement();
                if (!(embed instanceof FileEmbeddable)) continue;
                return false;
            }
            return true;
        }
        StyleRange[] ranges = this.getStyleRanges();
        int i = 0;
        while (i < ranges.length) {
            if (ranges[i] instanceof ImageStyleRange && (this.isRichTextEnabled || this.handler != null && this.handler.isMultiChat())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String escapeChar(char c) {
        switch (c) {
            case '<': {
                return "&lt;";
            }
            case '>': {
                return "&gt;";
            }
            case '&': {
                return "&amp;";
            }
        }
        return "" + c;
    }

    private StyleRange[] getCurrentRanges(int offset, int length) {
        SortedSet<StyleRange> sorter = Collections.synchronizedSortedSet(new TreeSet(new StyleRangeSorter()));
        try {
            StyleRange[] oldRanges = this.getStyleRanges();
            int i = 0;
            while (i < oldRanges.length) {
                if (offset <= oldRanges[i].start && oldRanges[i].start <= offset + length) {
                    sorter.add(oldRanges[i]);
                }
                ++i;
            }
        }
        catch (Throwable throwable) {}
        if (sorter.isEmpty()) {
            return null;
        }
        return sorter.toArray(new StyleRange[sorter.size()]);
    }

    static String hexify(RGB rgb) {
        String red = Integer.toHexString(rgb.red);
        String green = Integer.toHexString(rgb.green);
        String blue = Integer.toHexString(rgb.blue);
        StringBuffer hexBuffer = new StringBuffer(6);
        hexBuffer.append("#");
        if (rgb.red == 0) {
            hexBuffer.append("00");
        } else if (red.length() == 1) {
            hexBuffer.append("0");
            hexBuffer.append(red);
        } else {
            hexBuffer.append(red);
        }
        if (rgb.green == 0) {
            hexBuffer.append("00");
        } else if (green.length() == 1) {
            hexBuffer.append("0");
            hexBuffer.append(green);
        } else {
            hexBuffer.append(green);
        }
        if (rgb.blue == 0) {
            hexBuffer.append("00");
        } else if (blue.length() == 1) {
            hexBuffer.append("0");
            hexBuffer.append(blue);
        } else {
            hexBuffer.append(blue);
        }
        return hexBuffer.toString();
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(listener);
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.currFont = font;
    }

    public void updateStyleControls(StyleRange sr) {
        FontData fd = null;
        if (sr != null) {
            if (sr.font != null) {
                this.currFont = sr.font;
                fd = sr.font.getFontData()[0];
            }
        } else if (this.currFont != null) {
            fd = this.currFont.getFontData()[0];
        }
        if (fd != null) {
            if ((fd.getStyle() & 1) != 0) {
                this.setBold(true);
            } else {
                this.setBold(false);
            }
            if ((fd.getStyle() & 2) != 0) {
                this.setItalic(true);
            } else {
                this.setItalic(false);
            }
            if (sr != null) {
                this.setUnderline(sr.underline);
                this.setStrikeOut(sr.strikeout);
                this.setForegroundColor(sr.foreground);
                if (sr.background != null) {
                    this.setBackgroundColor(sr.background);
                } else {
                    sr.background = this.currBackgroundColor;
                }
                this.changeFontSize(fd.getHeight());
            } else {
                block25: {
                    if (OSUtils.isWin32() && fd != null) {
                        byte b;
                        Object data;
                        block24: {
                            try {
                                data = fd.getClass().getField("data").get(fd);
                                if (data != null && (b = data.getClass().getField("lfUnderline").getByte(data)) == 1) {
                                    sr.underline = true;
                                }
                            }
                            catch (Exception e) {
                                if (!logger.isLoggable(Level.WARNING)) break block24;
                                logger.log(Level.WARNING, e.getMessage(), e);
                            }
                        }
                        try {
                            data = fd.getClass().getField("data").get(fd);
                            if (data != null && (b = data.getClass().getField("lfStrikeOut").getByte(data)) == 1) {
                                sr.strikeout = true;
                            }
                            break block25;
                        }
                        catch (Exception e) {
                            if (logger.isLoggable(Level.WARNING)) {
                                logger.log(Level.WARNING, e.getMessage(), e);
                            }
                            break block25;
                        }
                    }
                    if (OSUtils.isLinux()) {
                        // empty if block
                    }
                }
                this.setForegroundColor(this.getForeground());
            }
        }
        if (this.listeners == null) {
            return;
        }
        for (IPropertyChangeListener listener : this.listeners) {
            PropertyChangeEvent event = new PropertyChangeEvent((Object)this, STYLE, null, (Object)sr);
            listener.propertyChange(event);
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (Display.getDefault().getHighContrast()) {
                    if (StyledTextChatArea.this.listeners == null) {
                        return;
                    }
                    for (IPropertyChangeListener listener : StyledTextChatArea.this.listeners) {
                        PropertyChangeEvent event = new PropertyChangeEvent((Object)this, "HC", null, (Object)Boolean.TRUE);
                        listener.propertyChange(event);
                    }
                }
            }
        });
    }

    public Font getCurrFont() {
        return this.currFont;
    }

    public boolean isCurrentBold() {
        Point sel = this.getSelection();
        if (sel != null) {
            try {
                StyleRange sr = this.getStyleRangeAtOffset(sel.x);
                if ((sr.fontStyle & 1) != 0) {
                    return true;
                }
            }
            catch (Exception exception) {}
        }
        return this.isBold();
    }

    public boolean isCurrentItalic() {
        Point sel = this.getSelection();
        if (sel != null) {
            try {
                StyleRange sr = this.getStyleRangeAtOffset(sel.x);
                if ((sr.fontStyle & 2) != 0) {
                    return true;
                }
            }
            catch (Exception exception) {}
        }
        return this.isItalic();
    }

    public boolean isCurrentUnderline() {
        Point sel = this.getSelection();
        if (sel != null) {
            try {
                StyleRange sr = this.getStyleRangeAtOffset(sel.x);
                if (sr.underline) {
                    return true;
                }
            }
            catch (Exception exception) {}
        }
        return this.isUnderline();
    }

    public void addEmbeddableObject(Embeddable embed) {
        if (this.embeddedObjects == null) {
            this.embeddedObjects = new Hashtable();
        }
        String objectUid = MessageProcessor.generateUniqueID();
        this.embeddedObjects.put(objectUid, embed);
        Image image = embed.createDisplayImage();
        if (image != null) {
            try {
                ImageStyleRange range;
                int caret;
                block15: {
                    caret = this.getCaretOffset();
                    this.insert(" ");
                    range = new ImageStyleRange();
                    range.start = caret;
                    range.length = 1;
                    range.uid = objectUid;
                    range.image = image;
                    range.metrics = new GlyphMetrics(image.getImageData().height, 0, image.getImageData().width);
                    if (embed instanceof ImageFileEmbeddable) {
                        range.originalFile = ((ImageFileEmbeddable)embed).getOriginalFile();
                        range.replacementText = ((ImageFileEmbeddable)embed).getReplacementText();
                        range.plainText = ((ImageFileEmbeddable)embed).getPlainReplacementText();
                        range.alt = ((ImageFileEmbeddable)embed).getAltText();
                    } else {
                        try {
                            IChatLoggingService service;
                            String uid = MessageProcessor.generateUniqueID();
                            ImageLoader loader = new ImageLoader();
                            loader.data = new ImageData[]{image.getImageData()};
                            String imageDirPath = null;
                            if (this.chatTranscript != null && this.chatTranscript.getContentsFile() != null && (service = ImChatPlugin.getDefault().getImChatController().getChatLoggingService()) != null && service.isLogging()) {
                                imageDirPath = this.chatTranscript.getContentsFile().getParentFile().getPath();
                                File imageDir = new File(imageDirPath);
                                if (!imageDir.exists()) {
                                    if (!imageDir.mkdirs()) {
                                        imageDirPath = null;
                                    }
                                } else if (!imageDir.isDirectory()) {
                                    imageDirPath = null;
                                }
                            }
                            if (imageDirPath == null) {
                                imageDirPath = System.getProperty("java.io.tmpdir");
                            }
                            String filename = String.valueOf(imageDirPath) + File.separator + uid + ".jpg";
                            FileOutputStream fos = new FileOutputStream(new File(filename));
                            loader.save((OutputStream)fos, 4);
                            fos.close();
                            range.originalFile = filename;
                            if (!(embed instanceof FileEmbeddable)) {
                                range.alt = "[" + uid + ".jpg]";
                                range.isAnnotatable = false;
                            }
                        }
                        catch (Exception e) {
                            if (!logger.isLoggable(Level.WARNING)) break block15;
                            logger.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
                this.setStyleRange((StyleRange)range);
                this.addToDispose(image);
                this.setCaretOffset(caret + 1);
                this.doStyles = true;
            }
            catch (Exception exception) {}
        }
        this.redraw();
    }

    public void clearEmbeddableObjects(boolean run) {
        if (this.embeddedObjects != null) {
            Embeddable embed;
            Enumeration e;
            if (run) {
                e = this.embeddedObjects.elements();
                while (e.hasMoreElements()) {
                    embed = (Embeddable)e.nextElement();
                    embed.run();
                }
            }
            e = this.embeddedObjects.elements();
            while (e.hasMoreElements()) {
                embed = (Embeddable)e.nextElement();
                embed.destroy();
            }
            this.embeddedObjects.clear();
        }
        this.redraw();
    }

    public boolean hasEmbeddableObjects() {
        return this.embeddedObjects != null && this.embeddedObjects.size() > 0;
    }

    public void setRichTextEnabled(boolean enabled) {
        this.isRichTextEnabled = enabled;
        AnnotationManager mgr = AnnotationManager.getAnnotationManager((StyledText)this);
        mgr.setRichTextEnabled(enabled);
        this.resetControls();
    }

    public void setChatWindowHandler(ImChatWindowHandler h) {
        this.handler = h;
    }

    public ImChatWindowHandler getChatWindowHandler() {
        return this.handler;
    }

    public void setCurrentlyUsedFont(Font f) {
        Point sel;
        this.currFont = f;
        if (this.currFont != null) {
            this.addToDispose(this.currFont);
        }
        if ((sel = this.getSelectionRange()) == null) {
            return;
        }
        if (sel.y == 0) {
            this.doStyles = true;
            return;
        }
        StyleRange style = null;
        int i = sel.x;
        while (i < sel.x + sel.y) {
            StyleRange range = this.getStyleRangeAtOffset(i);
            if (range != null) {
                style = (StyleRange)range.clone();
                style.start = i;
                style.length = 1;
            } else {
                style = new StyleRange(i, 1, null, null, 0);
            }
            style.font = f;
            this.setStyleRange(style);
            ++i;
        }
    }

    private void updateStyleControls() {
        StyleRange sr = null;
        StyleRange endsr = null;
        Point range = this.getSelectionRange();
        try {
            if (range != null) {
                sr = this.getStyleRangeAtOffset(range.x - 1);
                endsr = this.getStyleRangeAtOffset(range.x - 1 + range.y);
            }
        }
        catch (Exception exception) {}
        if (sr == null && this.doStyles && this.getText() != null && range.x >= this.getText().length()) {
            return;
        }
        if (range != null && this.getText() != null && range.x == this.getText().length()) {
            return;
        }
        if (sr != null && !sr.equals(endsr) || endsr != null && !endsr.equals((Object)sr)) {
            return;
        }
        this.updateStyleControls(sr);
    }

    public StyleRange getCurrentStyleRange() {
        try {
            if (this.getSelectionRange() != null) {
                return this.getStyleRangeAtOffset(this.getSelectionRange().x);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    private boolean hasChatTextType(Clipboard cp) {
        TransferData[] data = cp.getAvailableTypes();
        boolean isSupported = false;
        int i = 0;
        while (i < data.length) {
            isSupported = ChatTextTransfer.getInstance().isSupportedType(data[i]);
            if (isSupported) {
                return isSupported;
            }
            ++i;
        }
        return isSupported;
    }

    public void paste() {
        block9: {
            if (this.handler != null && !this.handler.pasteImageFromClipboard()) {
                try {
                    Object pasted;
                    Clipboard cp = new Clipboard(this.getDisplay());
                    if (this.hasChatTextType(cp) && (pasted = cp.getContents((Transfer)ChatTextTransfer.getInstance())) instanceof String) {
                        try {
                            this.handler.appendText((String)pasted, true);
                            cp.dispose();
                            return;
                        }
                        catch (Throwable throwable) {
                            AnnotationManager.getAnnotationManager((StyledText)this).enableModify();
                        }
                    }
                    pasted = cp.getContents((Transfer)TextTransfer.getInstance());
                    cp.dispose();
                    if (pasted instanceof String) {
                        String pastedText = (String)pasted;
                        String currentText = this.getText();
                        int currentLength = currentText == null ? 0 : currentText.length();
                        AnnotationProviderManager.getInstance().setForceRefresh(true);
                        if (pastedText.length() + currentLength <= ImChatWindowHandler.MAX_TEXT_CHARS) {
                            super.paste();
                        } else {
                            int selection = this.getSelectionRange() != null ? this.getSelectionRange().y : 0;
                            pastedText = pastedText.substring(0, ImChatWindowHandler.MAX_TEXT_CHARS - (currentLength - selection));
                            this.insert(pastedText);
                            this.setCaretOffset(this.getText().length());
                        }
                        AnnotationProviderManager.getInstance().setForceRefresh(false);
                    }
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(Level.INFO)) break block9;
                    logger.log(Level.INFO, "couldn't paste text", t);
                }
            }
        }
    }

    private String getMyFontStyle() {
        int style;
        if (Display.getDefault().getHighContrast()) {
            return null;
        }
        StringBuffer span = new StringBuffer();
        if (this.getFont().getFontData()[0].getHeight() > 0) {
            span.append("font-size:");
            span.append(this.getFont().getFontData()[0].getHeight());
            span.append("pt;");
        }
        if (this.getFont().getFontData()[0].getName() != null) {
            span.append("font-family:");
            span.append(this.getFont().getFontData()[0].getName());
            span.append(";");
        }
        if (((style = this.getFont().getFontData()[0].getStyle()) & 1) == 1) {
            span.append("font-weight:bold;");
        } else if ((style & 2) == 2) {
            span.append("font-style:italic;");
        }
        if (this.getForeground() != null) {
            span.append("color:");
            span.append(StyledTextChatArea.hexify(this.getForeground().getRGB()));
            span.append(";");
        }
        return span.toString();
    }

    public void setAccessibleText(String text) {
        this.accText = text;
    }

    public Color getCurrentForegroundColor() {
        return this.currForegroundColor;
    }

    public Color getCurrentBackgroundColor() {
        return this.currBackgroundColor;
    }

    public boolean isStrikeout() {
        return this.isStrikeOn;
    }

    public class BidiStyleRange
    extends StyleRange {
        public boolean isBidi;

        public BidiStyleRange() {
            this.isBidi = true;
        }

        public BidiStyleRange(int offset, int length, Color fore, Color back) {
            super(offset, length, fore, back);
            this.isBidi = true;
        }

        public BidiStyleRange(int offset, int length, Color fore, Color back, int style) {
            super(offset, length, fore, back, style);
            this.isBidi = true;
        }
    }

    private class TransferOperationContextImpl
    implements TransferOperationContext,
    ChatWindowExtension {
        private TransferOperationContextImpl() {
        }

        public Control getControl() {
            return StyledTextChatArea.this;
        }

        public ChatWindowHandler getChatWindowHandler() {
            return StyledTextChatArea.this.handler;
        }

        public void setChatWindowHandler(ChatWindowHandler handler) {
        }
    }

    private class StyleRangeSorter
    implements Comparator {
        private StyleRangeSorter() {
        }

        public int compare(Object arg0, Object arg1) {
            if (arg0 instanceof StyleRange && arg1 instanceof StyleRange) {
                StyleRange sr0 = (StyleRange)arg0;
                StyleRange sr1 = (StyleRange)arg1;
                if (sr0.start < sr1.start) {
                    return -1;
                }
                if (sr0.start == sr1.start) {
                    return 0;
                }
                return 1;
            }
            return -1;
        }
    }
}

