/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.chatwindow.ui;

import com.ibm.collaboration.realtime.chatwindow.ImChatPlugin;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Display;

public class ForegroundColorIcon {
    private final List toDispose = new ArrayList();
    private Image newImage;
    private ImageDescriptor imageDesc;
    private Image newHoverImage;
    private ImageDescriptor hoverImageDesc;
    private final Display display;
    private Color foregroundColor;
    private final String imageFile;
    private String hoverImageFile;
    private static int MARGIN = 2;
    private static int ICON_SIZE = 18;
    private static int ICON_HEIGHT = 21;
    private int top = MARGIN;
    private int left = 0;

    public ForegroundColorIcon(Display display, String imageFile, int left, int top) {
        this.display = display;
        this.imageFile = imageFile;
        this.top = top;
        this.left = left;
        this.foregroundColor = display.getSystemColor(24);
    }

    public ForegroundColorIcon(Display display, String imageFile, int top) {
        this.display = display;
        this.imageFile = imageFile;
        this.top = top;
        this.foregroundColor = display.getSystemColor(24);
    }

    public ForegroundColorIcon(Display display, String imageFile) {
        this.display = display;
        this.imageFile = imageFile;
        this.foregroundColor = display.getSystemColor(24);
    }

    public void setHoverImageFile(String image) {
        this.hoverImageFile = image;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.imageDesc == null) {
            Image newImage = this.createImage(this.imageFile, this.display);
            this.toDispose.add(newImage);
            this.imageDesc = ImageDescriptor.createFromImage((Image)newImage, (Device)this.display);
        }
        return this.imageDesc;
    }

    public ImageDescriptor getHoverImageDescriptor() {
        if (this.hoverImageDesc == null) {
            Image newImage = this.createImage(this.hoverImageFile, this.display);
            this.toDispose.add(newImage);
            this.hoverImageDesc = ImageDescriptor.createFromImage((Image)newImage, (Device)this.display);
        }
        return this.hoverImageDesc;
    }

    public boolean setForeground(Color color) {
        if (color != null && color.equals((Object)this.foregroundColor)) {
            return false;
        }
        this.foregroundColor = color;
        if (this.newImage != null) {
            this.toDispose.add(this.newImage);
        }
        this.newImage = this.createImage(this.imageFile, this.display);
        this.imageDesc = ImageDescriptor.createFromImage((Image)this.newImage, (Device)this.display);
        if (this.hoverImageFile != null) {
            if (this.newHoverImage != null) {
                this.toDispose.add(this.newHoverImage);
            }
            this.newHoverImage = this.createImage(this.hoverImageFile, this.display);
            this.hoverImageDesc = ImageDescriptor.createFromImage((Image)this.newHoverImage, (Device)this.display);
        }
        return true;
    }

    public void disposeOfOldImage() {
        for (Resource resource : this.toDispose) {
            if (resource.isDisposed()) continue;
            resource.dispose();
        }
        this.toDispose.clear();
    }

    public void dispose() {
        if (this.newImage != null) {
            this.toDispose.add(this.newImage);
        }
        if (this.newHoverImage != null) {
            this.toDispose.add(this.newHoverImage);
        }
        this.disposeOfOldImage();
    }

    public Image createImage(String file, Display display) {
        Image baseImage = ImChatPlugin.getCachedImage(file);
        Image image = new Image((Device)display, ICON_SIZE, ICON_HEIGHT);
        GC gc = new GC((Drawable)image);
        RGB transparent = new RGB(200, 200, 200);
        Color transColor = new Color((Device)display, transparent);
        gc.setBackground(transColor);
        gc.fillRectangle(0, 0, ICON_SIZE, ICON_HEIGHT);
        gc.drawImage(baseImage, this.left, this.top);
        gc.setBackground(this.foregroundColor);
        gc.setForeground(display.getSystemColor(16));
        gc.fillRectangle(1, ICON_HEIGHT - 4, ICON_SIZE - 3, 3);
        gc.drawRectangle(1, ICON_HEIGHT - 4, ICON_SIZE - 3, 3);
        ImChatPlugin.returnCachedImage(file);
        gc.dispose();
        ImageData data = image.getImageData();
        data.type = 2;
        int i = 0;
        while (i < ICON_SIZE) {
            int j = 0;
            while (j < ICON_HEIGHT) {
                int pixel = data.getPixel(i, j);
                RGB rgb = data.palette.getRGB(pixel);
                if (rgb.red == 200 && rgb.green == 200 && rgb.blue == 200) {
                    data.setAlpha(i, j, 0);
                } else {
                    data.setAlpha(i, j, 255);
                }
                ++j;
            }
            ++i;
        }
        Image newImage = new Image((Device)display, data);
        transColor.dispose();
        image.dispose();
        return newImage;
    }
}

