/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.chatwindow.ui;

import com.ibm.collaboration.realtime.browser.Browser;
import com.ibm.collaboration.realtime.browser.LocationEvent;
import com.ibm.collaboration.realtime.browser.LocationListener;
import com.ibm.collaboration.realtime.browser.ProgressEvent;
import com.ibm.collaboration.realtime.browser.ProgressListener;
import com.ibm.collaboration.realtime.chat.logging.IChatLoggingService;
import com.ibm.collaboration.realtime.chat.logging.IChatTranscript;
import com.ibm.collaboration.realtime.chatwindow.ChatWindowPreferences;
import com.ibm.collaboration.realtime.chatwindow.ImChatPlugin;
import com.ibm.collaboration.realtime.chatwindow.ShowHideEmoticonsHistory;
import com.ibm.collaboration.realtime.chatwindow.strings.Messages;
import com.ibm.collaboration.realtime.chatwindow.template.TranscriptCss;
import com.ibm.collaboration.realtime.ui.ExplorerWindow;
import com.ibm.collaboration.realtime.ui.UiPlugin;
import com.ibm.collaboration.realtime.ui.util.CustomAccessibleEvent;
import com.ibm.collaboration.realtime.ui.util.ImageCache;
import com.ibm.collaboration.realtime.ui.util.SwtUtils;
import java.net.URL;
import java.util.logging.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BrowserChatTranscript {
    private static final Logger logger = Logger.getLogger(BrowserChatTranscript.class.getName());
    Browser browser;
    StringBuffer internalTranscript;
    private static String tailText = "</div></body></html>";
    private StringBuffer header;
    private StringBuffer fileHeader;
    boolean timestampsOn = true;
    boolean showContext = true;
    boolean isLogging = true;
    boolean hasContent = false;
    URL transcriptLocation;
    IChatTranscript chatTranscript;
    private boolean isConverting = false;
    private FontData browserFontData;
    private static String cssText = null;
    private String partnerCss = null;
    private String conversationID = null;
    private static final String NEWLINE = "\r\n";
    private static String bodyStyle = "body { margin: 0 0 0 0; padding:0 0 0 0 }";
    private static String transcriptStyle = ".transcript { background-color:#d2d2d2; }";
    private static String messageBlockStyle = ".messageBlock { margin-left:4px; margin-bottom:3px }";
    private static String messageStyle = ".message { margin-left:100px; word-wrap:break-word; }";
    private static String messageContStyle = ".messageCont { margin-left:100px; word-wrap:break-word; }";
    private static String otherStyle = ".other { color:#39577a;font-family:Tahoma,Arial,Lucida Grande;vertical-align:top;font-weight:bold;font-style:normal; float:left; width:95px; }";
    private static String myselfStyle = ".myself { color:#da8103;font-family:Tahoma,Arial,Lucida Grande;font-style:normal;font-weight:bold; float:left; width:95px; }";
    private static String otherContStyle = ".otherCont { font-size:8px;text-align:right; color:#39577a;font-family:Arial,Lucida Grande;font-style:normal;vertical-align:top;font-weight:bold; float:left; width:95px; }";
    private static String myselfContStyle = ".myselfCont { font-size:8px;text-align:right; color:#da8103;font-family:Arial,Lucida Grande;font-style:normal;vertical-align:top;font-weight:bold; float:left; width:95px; }";
    private static String systemStyle = ".system { margin-left:4px; word-wrap:break-word;color:#da8103;font-family:Tahoma,Arial,Lucida Grande; }";
    private static String showTimestampStyle = ".showTimestamp { margin-right:3px; float:right; color:#999999;font-family:Tahoma,Arial,Lucida Grande;font-style:normal; }";
    private int nwayStartIndex = 0;
    private boolean firstNewMessage = true;
    private String currentName = "";
    private String currentValue = "";
    private String alertImage = null;
    private String alertTitle = null;
    private String alertDesc = null;
    private boolean alertCloseable = false;
    private boolean isSetting = false;
    int tabindex = 0;
    private StringBuffer tempbuffer = null;
    private final LocationListener locationListener = new LocationListener(){

        public void changed(LocationEvent arg0) {
        }

        public void changing(LocationEvent arg0) {
            if (!(arg0.location == null || arg0.location.trim().length() <= 0 || arg0.location.equals("file:///") || arg0.location.equals("about:blank") || arg0.location.startsWith("javascript:") || arg0.location.indexOf("applewebdata://") == 0)) {
                if (!arg0.location.equals("file:///#")) {
                    ExplorerWindow.launchBrowser((String)arg0.location, (String)arg0.location);
                }
                arg0.doit = false;
            } else if (!arg0.location.equals("file:///") && !arg0.location.equals("about:blank")) {
                arg0.location.indexOf("applewebdata://");
            }
        }
    };
    private boolean doneSettingTranscript = false;

    public static void resetStyleFromPrefs(IPreferenceStore store) {
        cssText = TranscriptCss.getCssContents(null);
        String body = store.getString(ChatWindowPreferences.STYLE_BODY);
        String transcript = store.getString(ChatWindowPreferences.STYLE_TRANSCRIPT);
        String mb = store.getString(ChatWindowPreferences.STYLE_MESSAGE_BLOCK);
        String ms = store.getString(ChatWindowPreferences.STYLE_MESSAGE);
        String cont = store.getString(ChatWindowPreferences.STYLE_MESSAGE_CONT);
        String other = store.getString(ChatWindowPreferences.STYLE_OTHER);
        String myself = store.getString(ChatWindowPreferences.STYLE_MYSELF);
        String system = store.getString(ChatWindowPreferences.STYLE_SYSTEM);
        String time = store.getString(ChatWindowPreferences.STYLE_TIMESTAMP);
        String otherCont = store.getString(ChatWindowPreferences.STYLE_OTHER_CONT);
        String myselfCont = store.getString(ChatWindowPreferences.STYLE_MYSELF_CONT);
        if (body != null && body.length() > 0) {
            bodyStyle = body;
        }
        if (transcript != null && transcript.length() > 0) {
            transcriptStyle = transcript;
        }
        if (mb != null && mb.length() > 0) {
            messageBlockStyle = mb;
        }
        if (ms != null && ms.length() > 0) {
            messageStyle = ms;
        }
        if (cont != null && cont.length() > 0) {
            messageContStyle = cont;
        }
        if (other != null && other.length() > 0) {
            otherStyle = other;
        }
        if (myself != null && myself.length() > 0) {
            myselfStyle = myself;
        }
        if (system != null && system.length() > 0) {
            systemStyle = system;
        }
        if (time != null && time.length() > 0) {
            showTimestampStyle = time;
        }
        if (otherCont != null && otherCont.length() > 0) {
            otherContStyle = other;
        }
        if (myselfCont != null && myselfCont.length() > 0) {
            myselfContStyle = myself;
        }
    }

    public BrowserChatTranscript() {
        this.internalTranscript = new StringBuffer(65536);
        this.header = new StringBuffer(65536);
    }

    public void setLogging(boolean islogging) {
        this.isLogging = islogging;
    }

    public void setTranscriptLocation(URL url) {
        this.transcriptLocation = url;
    }

    public IChatTranscript getTranscript() {
        return this.chatTranscript;
    }

    public void setConverting(boolean isConverting) {
        this.isConverting = isConverting;
        if (this.internalTranscript != null) {
            this.nwayStartIndex = this.internalTranscript.length();
        }
    }

    public void resetTranscript() {
        this.internalTranscript = new StringBuffer(65536);
        this.chatTranscript = null;
        this.redraw();
    }

    public String getContents() {
        if (this.isConverting || this.chatTranscript == null) {
            this.isConverting = false;
            String transcript = this.getText();
            if (this.nwayStartIndex > 0 && transcript.length() > this.nwayStartIndex) {
                return transcript.substring(this.nwayStartIndex);
            }
            return transcript;
        }
        return this.chatTranscript.getContentsWithoutHeaderAndFooter();
    }

    public String getContentsIncludingHistory() {
        return this.internalTranscript.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTranscript(IChatTranscript transcript) {
        boolean bAddClass;
        IChatLoggingService service;
        this.doneSettingTranscript = false;
        String history = null;
        boolean showing = ImChatPlugin.getDefault().getPrefAsBoolean(ChatWindowPreferences.PREF_SHOW_EMOTICONS);
        if (transcript == null) {
            this.chatTranscript = transcript;
            return;
        }
        if (this.isConverting) {
            this.isConverting = false;
        }
        if ((service = ImChatPlugin.getDefault().getImChatController().getChatLoggingService()) != null) {
            this.showContext = service.isShowingContext();
            bAddClass = service.isShowingContextBackground();
        } else {
            bAddClass = false;
        }
        if (this.showContext && history == null && (history = transcript.getContentsWithoutHeaderAndFooter()) != null) {
            history = ShowHideEmoticonsHistory.parseContent(history, !showing);
        }
        if (this.hasContent) {
            this.hasContent = false;
            String previousContent = this.getText();
            if (this.internalTranscript.length() > 0) {
                transcript.append(previousContent);
            }
        }
        boolean hasHistory = false;
        StringBuffer stringBuffer = this.internalTranscript;
        synchronized (stringBuffer) {
            if (history != null && history.length() > 0 && !"null".equals(history.trim())) {
                hasHistory = true;
                if (history.indexOf("<tr>") == 0) {
                    this.internalTranscript.insert(0, "</tbody></table>");
                    this.internalTranscript.insert(0, history);
                    if (bAddClass) {
                        this.internalTranscript.insert(0, "<table width=\"100%\" cellpadding=\"2\" cellspacing=\"0\"><tbody class=\"transcript\">");
                    } else {
                        this.internalTranscript.insert(0, "<table width=\"100%\" cellpadding=\"2\" cellspacing=\"0\"><tbody>");
                    }
                } else {
                    this.internalTranscript.insert(0, "</div>");
                    this.internalTranscript.insert(0, history);
                    if (bAddClass) {
                        this.internalTranscript.insert(0, "<div class=\"transcript\" style=\"border-bottom:1px dashed\">");
                    } else {
                        this.internalTranscript.insert(0, "<div style=\"border-bottom:1px dashed\">");
                    }
                }
            }
        }
        this.chatTranscript = transcript;
        this.doneSettingTranscript = true;
        this.redoHeader();
        if (this.firstNewMessage) {
            this.firstNewMessage = false;
            this.redraw();
        } else if (hasHistory) {
            final StringBuffer aheader = new StringBuffer();
            aheader.append("var mydiv = document.getElementById('divTranscript');");
            aheader.append("var adiv = document.createElement('div');");
            aheader.append("adiv.setAttribute('class', 'transcript');");
            aheader.append("adiv.setAttribute('style', 'border-bottom:1px dashed');");
            aheader.append("adiv.innerHTML = '");
            aheader.append(this.escape(history));
            aheader.append("';");
            aheader.append("var firstChild = mydiv.firstChild; ");
            aheader.append("if (firstChild) { mydiv.insertBefore(adiv, firstChild); resizeNewChat(); }");
            this.browser.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    Element divTranscript;
                    Document document = BrowserChatTranscript.this.browser.getDocument();
                    if (document != null && (divTranscript = document.getElementById("divTranscript")) == null) {
                        BrowserChatTranscript.this.redraw();
                        return;
                    }
                    boolean done = BrowserChatTranscript.this.browser.execute(aheader.toString());
                    if (!done) {
                        BrowserChatTranscript.this.redraw();
                    }
                }
            });
        }
    }

    public Composite createControl(Composite parent) {
        int direction = Window.getDefaultOrientation();
        this.browser = new Browser(parent, direction);
        this.browser.addLocationListener(this.locationListener);
        this.browserFontData = this.browser.getFont().getFontData()[0];
        if (this.header == null) {
            this.redoHeader();
        }
        this.browser.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getValue(AccessibleControlEvent e) {
                e.result = BrowserChatTranscript.this.currentValue;
            }
        });
        this.browser.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = BrowserChatTranscript.this.currentName;
            }
        });
        this.browser.setCreatorClassLoader(ImChatPlugin.class.getClassLoader());
        this.browser.addJavaScriptAllowedClass(ImChatPlugin.class.getName());
        this.browser.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent arg0) {
                if (BrowserChatTranscript.this.browser.getParent() != null && BrowserChatTranscript.this.browser.getParent().isDisposed()) {
                    return;
                }
                UIJob job = new UIJob("scrollJob"){

                    public IStatus runInUIThread(IProgressMonitor arg0) {
                        if ((this).BrowserChatTranscript.this.browser != null && (this).BrowserChatTranscript.this.browser.isDisposed()) {
                            return Status.OK_STATUS;
                        }
                        (this).BrowserChatTranscript.this.browser.execute("resize();");
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
        });
        final ProgressListener pl = new ProgressListener(){

            public void changed(ProgressEvent event) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void completed(ProgressEvent event) {
                BrowserChatTranscript.this.isSetting = false;
                if (BrowserChatTranscript.this.tempbuffer != null && BrowserChatTranscript.this.tempbuffer.length() > 0) {
                    String str = null;
                    StringBuffer stringBuffer = BrowserChatTranscript.this.tempbuffer;
                    synchronized (stringBuffer) {
                        str = BrowserChatTranscript.this.tempbuffer.toString();
                    }
                    BrowserChatTranscript.this.tempbuffer = null;
                    final String toappend = str;
                    UIJob job = new UIJob("append buffered"){

                        public IStatus runInUIThread(IProgressMonitor arg0) {
                            Document doc = (this).BrowserChatTranscript.this.browser.getDocument();
                            if (doc != null && doc.getElementById("divTranscript") == null) {
                                BrowserChatTranscript.this.appendText(toappend, true);
                                return Status.OK_STATUS;
                            }
                            BrowserChatTranscript.this.appendText(toappend, false);
                            return Status.OK_STATUS;
                        }
                    };
                    job.schedule();
                } else {
                    UIJob job = new UIJob("scrollJob"){

                        public IStatus runInUIThread(IProgressMonitor arg0) {
                            if ((this).BrowserChatTranscript.this.browser != null && (this).BrowserChatTranscript.this.browser.isDisposed()) {
                                return Status.OK_STATUS;
                            }
                            (this).BrowserChatTranscript.this.browser.execute("resize();");
                            return Status.OK_STATUS;
                        }
                    };
                    job.setSystem(true);
                    job.schedule(250L);
                }
            }
        };
        this.browser.addProgressListener(pl);
        this.browser.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                BrowserChatTranscript.this.browser.removeLocationListener(BrowserChatTranscript.this.locationListener);
                BrowserChatTranscript.this.browser.removeProgressListener(pl);
            }
        });
        return this.browser;
    }

    public void saveTranscript() {
        if (this.chatTranscript != null && this.isLogging) {
            this.chatTranscript.save();
        }
    }

    public void closeTranscript() {
        if (this.chatTranscript != null) {
            this.chatTranscript.close();
        }
    }

    public String getFooter() {
        return tailText;
    }

    public String getHeader() {
        return this.header.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText() {
        String transcriptString = "";
        StringBuffer stringBuffer = this.internalTranscript;
        synchronized (stringBuffer) {
            transcriptString = this.internalTranscript.toString();
        }
        return transcriptString;
    }

    public void setText(String text) {
        this.browser.setText(text);
    }

    public void replaceContents(String text) {
        boolean logging = this.isLogging;
        this.isLogging = false;
        this.internalTranscript = new StringBuffer(65536);
        if (this.isSetting) {
            this.isSetting = false;
        }
        this.appendText(text, true);
        this.isLogging = logging;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendText(String text) {
        if (!this.doneSettingTranscript && (this.internalTranscript.length() == 0 || this.firstNewMessage)) {
            this.firstNewMessage = false;
            this.appendText(text, true);
        } else {
            if (this.tempbuffer == null) {
                this.tempbuffer = new StringBuffer();
            }
            StringBuffer stringBuffer = this.tempbuffer;
            synchronized (stringBuffer) {
                if (this.isSetting) {
                    this.tempbuffer.append(text);
                }
            }
            if (!this.isSetting) {
                this.appendText(text, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendText(String text, boolean redraw) {
        boolean textAppended = false;
        if (text != null && text.length() > 0) {
            StringBuffer stringBuffer = this.internalTranscript;
            synchronized (stringBuffer) {
                this.internalTranscript.append(text);
            }
            if (this.chatTranscript != null && this.isLogging && this.doneSettingTranscript) {
                stringBuffer = this.chatTranscript;
                synchronized (stringBuffer) {
                    this.chatTranscript.append(text);
                }
            } else if (this.chatTranscript == null || this.chatTranscript != null && this.isLogging && !this.doneSettingTranscript) {
                this.hasContent = true;
            }
            textAppended = true;
        }
        if (textAppended) {
            boolean useJavascript = ImChatPlugin.getDefault().getPrefAsBoolean("jsappend");
            if (redraw || !useJavascript) {
                this.redraw();
            } else {
                Element divTranscript;
                boolean hasImage = text.indexOf("<img ") > -1;
                boolean doAppend = true;
                Document document = this.browser.getDocument();
                if (document != null && (divTranscript = document.getElementById("divTranscript")) == null) {
                    this.redraw();
                    doAppend = false;
                }
                if (doAppend) {
                    StringBuffer aheader = new StringBuffer(16384);
                    aheader.append("var mydiv = document.getElementById('divTranscript');");
                    aheader.append("var adiv = document.createElement('div');");
                    aheader.append("adiv.innerHTML = '");
                    aheader.append(this.escape(text));
                    aheader.append("';");
                    aheader.append("mydiv.appendChild(adiv); resizeNewChat();");
                    boolean done = this.browser.execute(aheader.toString());
                    if (!done) {
                        this.redraw();
                    }
                    aheader = null;
                }
                if (hasImage) {
                    UIJob job = new UIJob("scrollJob"){

                        public IStatus runInUIThread(IProgressMonitor arg0) {
                            if (BrowserChatTranscript.this.browser != null && !BrowserChatTranscript.this.browser.isDisposed()) {
                                BrowserChatTranscript.this.browser.execute("gotoEnd();");
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.setSystem(true);
                    job.schedule(100L);
                }
            }
            if (this.isLogging && text.length() > 0) {
                this.saveTranscript();
            }
        }
    }

    private String escape(String text) {
        StringBuffer aheader = new StringBuffer();
        char[] repl = text.toCharArray();
        int i = 0;
        while (i < repl.length) {
            switch (repl[i]) {
                case '\\': {
                    aheader.append('\\');
                    aheader.append('\\');
                    break;
                }
                case '\'': {
                    aheader.append('\\');
                    aheader.append('\'');
                    break;
                }
                case '%': {
                    aheader.append("&#37;");
                    break;
                }
                case '$': {
                    aheader.append("&#36;");
                    break;
                }
                default: {
                    aheader.append(repl[i]);
                }
            }
            ++i;
        }
        return aheader.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void redoHeader() {
        StringBuffer tempheader = new StringBuffer(4096);
        StringBuffer tempfileHeader = new StringBuffer(4096);
        String orientation = "";
        orientation = Window.getDefaultOrientation() == 0x4000000 ? " dir=\"rtl\"" : " dir=\"ltr\"";
        tempheader.append("<html");
        tempheader.append(orientation);
        tempheader.append("><head>");
        tempheader.append(NEWLINE);
        tempheader.append("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\"/>");
        tempheader.append(NEWLINE);
        tempheader.append("<style type=\"text/css\">");
        tempheader.append(NEWLINE);
        tempheader.append(bodyStyle);
        tempheader.append(NEWLINE);
        tempheader.append("td,div { ");
        tempheader.append(this.convertFontToHtml());
        tempheader.append("vertical-align:top }");
        tempheader.append(NEWLINE);
        if (this.partnerCss != null) {
            tempheader.append(this.partnerCss);
        } else if (cssText != null) {
            tempheader.append(cssText);
        } else {
            tempheader.append(messageBlockStyle);
            tempheader.append(NEWLINE);
            tempheader.append(messageStyle);
            tempheader.append(NEWLINE);
            tempheader.append(messageContStyle);
            tempheader.append(NEWLINE);
            tempheader.append(otherStyle);
            tempheader.append(NEWLINE);
            tempheader.append(myselfStyle);
            tempheader.append(NEWLINE);
            tempheader.append(otherContStyle);
            tempheader.append(NEWLINE);
            tempheader.append(myselfContStyle);
            tempheader.append(NEWLINE);
            tempheader.append(systemStyle);
            tempheader.append(NEWLINE);
            tempheader.append(showTimestampStyle);
        }
        tempheader.append(NEWLINE);
        tempfileHeader.append(tempheader.toString());
        tempfileHeader.append(".tsDisplay { display:block }");
        if (this.timestampsOn) {
            tempheader.append(".tsDisplay { display:block }");
        } else {
            tempheader.append(".tsDisplay { display:none }");
        }
        tempfileHeader.append(".dsDisplay { display:block }");
        if (ImChatPlugin.getDefault().getPrefAsBoolean(ChatWindowPreferences.PREF_SHOW_DATESTAMPS)) {
            tempheader.append(".dsDisplay { display:block }");
        } else {
            tempheader.append(".dsDisplay { display:none }");
        }
        if (!ImChatPlugin.isUsingXulrunner) {
            tempheader.append("\n");
            tempheader.append(".right { float:right }\n");
            tempheader.append(".left { float:left }\n");
        }
        tempheader.append("</style>");
        tempfileHeader.append("</style>");
        this.setMetaInfo(tempfileHeader);
        try {
            StringBuffer script = new StringBuffer();
            tempheader.append("<script language=\"javascript\" src=\"");
            tempheader.append(FileLocator.toFileURL((URL)FileLocator.find((Bundle)ImChatPlugin.getDefault().getBundle(), (IPath)new Path("/css/highlight.js"), null)).toString());
            tempheader.append("\"></script>");
            if (this.conversationID != null) {
                script.append("<script language=\"javascript\">conversationID = '");
                script.append(this.conversationID);
                script.append("'; \nvar newMessage='");
                script.append(Messages.newMessageClickToGo);
                script.append("'; \nvar closeSrc ='");
                script.append(ImageCache.getImageUrl((Plugin)UiPlugin.getDefault(), (String)"/images/ST_Close_x_h1.png"));
                script.append("'; \nvar closeHoverSrc='");
                script.append(ImageCache.getImageUrl((Plugin)UiPlugin.getDefault(), (String)"/images/ST_Close_x_h2.png"));
                script.append("'; \nvar alertGradient='");
                script.append(ImageCache.getImageUrl((Plugin)ImChatPlugin.getDefault(), (String)"/images/chat_gradient.gif"));
                script.append("'; \nvar closeTooltip='");
                script.append(SwtUtils.removeMnemonic((String)Messages.ImChatWindowHandler_34));
                script.append("';");
                script.append("</script>");
            }
            tempfileHeader.append(script.toString());
            tempfileHeader.append("<script language=\"javascript\">\n");
            tempfileHeader.append("function resize() { var divT = document.getElementById(\"divTranscript\"); divT.style.height = (document.body.clientHeight - getTopAreaHeight()) + \"px\"; ");
            tempfileHeader.append("divT.style.width = (document.body.clientWidth) + \"px\"; divT.style.overflow = \"auto\"; divT.style.position = \"absolute\"; divT.style.left = \"0px\"; divT.style.top = getTopAreaHeight() + \"px\";");
            tempfileHeader.append("}\n function getTopAreaHeight() { var chatAlert = document.getElementById(\"chatAlert\"); if (chatAlert) { return chatAlert.clientHeight; } return document.getElementById(\"divBody\").clientHeight;");
            tempfileHeader.append("}\n isChat=false; window.onresize=resize;\n</script>");
            tempheader.append(script.toString());
        }
        catch (Exception exception) {}
        tempfileHeader.append("</head>");
        tempheader.append("</head>");
        String onload = "<body onload=\"resize();";
        onload = Window.getDefaultOrientation() == 0x4000000 ? String.valueOf(onload) + "document.dir='rtl';\">" : String.valueOf(onload) + "\">";
        tempfileHeader.append(onload);
        tempfileHeader.append(NEWLINE);
        tempheader.append(onload);
        tempheader.append(NEWLINE);
        tempfileHeader.append("<div id=\"divBody\"></div><div id=\"divTranscript\">");
        tempheader.append("<div id=\"divBody\"></div><div id=\"divTranscript\">");
        StringBuffer stringBuffer = this.header;
        synchronized (stringBuffer) {
            this.header = tempheader;
            this.fileHeader = tempfileHeader;
        }
        if (this.chatTranscript != null) {
            stringBuffer = this.chatTranscript;
            synchronized (stringBuffer) {
                this.chatTranscript.setHeader(this.fileHeader.toString());
                this.chatTranscript.setFooter(tailText);
            }
        }
    }

    private void setMetaInfo(StringBuffer buffer) {
        if (this.chatTranscript == null) {
            return;
        }
        String[] metaInfo = this.chatTranscript.getMetaInfo();
        if (metaInfo != null) {
            int i = 0;
            while (i < metaInfo.length) {
                buffer.append(NEWLINE);
                buffer.append(metaInfo[i]);
                ++i;
            }
        }
    }

    public void setShowTimestamps(boolean show) {
        this.timestampsOn = show;
        this.redoHeader();
    }

    public void setShowDatestamps(boolean show) {
        this.redoHeader();
        this.redraw();
    }

    public void updateFont(Font font) {
        if (font != null) {
            this.browser.setFont(font);
            this.browserFontData = font.getFontData()[0];
            this.redoHeader();
        }
    }

    public void redraw() {
        if (this.isSetting) {
            return;
        }
        if (Thread.currentThread() != Display.getDefault().getThread() || Thread.currentThread() != Display.getCurrent().getThread()) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    StringBuffer buff = new StringBuffer(65536);
                    buff.append(BrowserChatTranscript.this.getHeader());
                    buff.append(BrowserChatTranscript.this.getText());
                    buff.append(BrowserChatTranscript.this.getFooter());
                    BrowserChatTranscript.this.isSetting = true;
                    BrowserChatTranscript.this.browser.setText(buff.toString());
                    if (BrowserChatTranscript.this.alertImage != null || BrowserChatTranscript.this.alertTitle != null || BrowserChatTranscript.this.alertDesc != null) {
                        BrowserChatTranscript.this.showChatAlertArea(BrowserChatTranscript.this.alertImage, BrowserChatTranscript.this.alertTitle, BrowserChatTranscript.this.alertDesc, BrowserChatTranscript.this.alertCloseable);
                    }
                    buff = null;
                }
            });
        } else {
            StringBuffer buff = new StringBuffer(65536);
            buff.append(this.getHeader());
            buff.append(this.getText());
            buff.append(this.getFooter());
            this.isSetting = true;
            this.browser.setText(buff.toString());
            if (this.alertImage != null || this.alertTitle != null || this.alertDesc != null) {
                this.showChatAlertArea(this.alertImage, this.alertTitle, this.alertDesc, this.alertCloseable);
            }
            Object var1_1 = null;
        }
    }

    public Browser getBrowser() {
        return this.browser;
    }

    private String convertFontToHtml() {
        return BrowserChatTranscript.convertFontToHtml(this.browserFontData);
    }

    public static String convertFontToHtml(FontData fd) {
        if (fd != null) {
            String name = fd.getName();
            int height = fd.getHeight();
            StringBuffer b = new StringBuffer(64);
            b.append("font-family:");
            b.append(name);
            b.append(";font-size:");
            b.append(height);
            b.append("pt;");
            return b.toString();
        }
        return "";
    }

    public void setAccessibleMessage(String name, String value) {
        this.currentName = name;
        this.currentValue = value;
        CustomAccessibleEvent.notifyEvent((Composite)this.browser, (int)-839909668, (int)-34812433);
    }

    public void setPartnerCss(String css) {
        this.partnerCss = css;
        this.redoHeader();
    }

    public void setConversationID(String convID) {
        this.conversationID = convID;
    }

    public void showChatAlertArea(String imageUrl, String line1, String line2) {
        this.showChatAlertArea(imageUrl, line1, line2, true);
    }

    public void showChatAlertArea(String imageUrl, String line1, String line2, boolean closeable) {
        this.alertImage = imageUrl;
        this.alertTitle = line1;
        this.alertDesc = line2;
        this.alertCloseable = closeable;
        UIJob job = new UIJob("showAlertArea"){

            public IStatus runInUIThread(IProgressMonitor arg0) {
                StringBuffer call = new StringBuffer();
                call.append("showChatAlertArea(");
                if (BrowserChatTranscript.this.alertImage != null) {
                    call.append("'");
                    call.append(BrowserChatTranscript.this.alertImage);
                    call.append("',");
                } else {
                    call.append("null,");
                }
                if (BrowserChatTranscript.this.alertTitle != null) {
                    call.append("'");
                    call.append(BrowserChatTranscript.this.escape(BrowserChatTranscript.this.alertTitle));
                    call.append("',");
                } else {
                    call.append("null,");
                }
                if (BrowserChatTranscript.this.alertDesc != null) {
                    call.append("'");
                    call.append(BrowserChatTranscript.this.escape(BrowserChatTranscript.this.alertDesc));
                    call.append("',");
                } else {
                    call.append("null,");
                }
                call.append(BrowserChatTranscript.this.alertCloseable);
                call.append(");");
                if (BrowserChatTranscript.this.browser != null && !BrowserChatTranscript.this.browser.isDisposed()) {
                    BrowserChatTranscript.this.browser.execute(call.toString());
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule(250L);
    }

    public void hideChatAlertArea() {
        this.alertImage = null;
        this.alertTitle = null;
        this.alertDesc = null;
        this.browser.getDisplay().asyncExec(new Runnable(){

            public void run() {
                BrowserChatTranscript.this.browser.execute("hideChatAlertArea();");
            }
        });
    }
}

