/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.chatwindow.template;

import com.ibm.collaboration.realtime.chatwindow.ImChatPlugin;
import com.ibm.collaboration.realtime.people.Person;
import com.ibm.collaboration.realtime.ui.RtcMessages;
import com.ibm.icu.text.DateFormat;
import java.util.Date;
import org.eclipse.jface.window.Window;
import org.eclipse.osgi.util.NLS;

public class TranscriptWriter
extends RtcMessages {
    public static String startRow = "<tr>\n";
    public static String systemMsg = "<td class=\"system\"></td><td class=\"system\">:: {0} ::</td>\n";
    public static String contSender = "<td align=\"right\" class=\"{0}\">&#9668;</td>\n";
    public static String sender = "<td nowrap=\"yes\" class=\"{0}\" title=\"{1}\">{2}</td>\n";
    public static String message = "<td width=\"100%\">{0}</td>\n";
    public static String timestamp = "<td align=\"right\" valign=\"top\" nowrap=\"yes\" class=\"showTimestamp\">{0}</td>\n";
    public static String endRow = "</tr>\n";
    public static String nametitle = "{0} [{1}]";
    public static String datestamp = "{0}";

    static {
        NLS.initializeMessages((String)"com.ibm.collaboration.realtime.chatwindow.template.transcript", TranscriptWriter.class);
    }

    public static String getMessage(String displayName, String shortened, String text, boolean isUser, String when, boolean isSystemMessage, boolean isContinuedMessage, String cssClass, boolean adjustDierction) {
        StringBuffer transcriptText = new StringBuffer();
        if (startRow.indexOf("{0}") > -1) {
            if (displayName != null) {
                transcriptText.append(NLS.bind((String)startRow, (Object[])new String[]{displayName, ""}));
            } else {
                transcriptText.append(startRow);
            }
        } else {
            transcriptText.append(startRow);
        }
        transcriptText.append(NLS.bind((String)timestamp, (Object)when));
        String tooltip = NLS.bind((String)nametitle, (Object[])new String[]{displayName, when});
        if (isSystemMessage) {
            transcriptText.append(NLS.bind((String)systemMsg, (Object)text));
        } else {
            String direction = " dir=\"ltr\" ";
            if (adjustDierction) {
                if (Window.getDefaultOrientation() == 0x4000000) {
                    direction = " dir=\"rtl\" ";
                }
            } else if (text.indexOf("class=\"right\"") > -1) {
                direction = " dir=\"rtl\" ";
            }
            if (isContinuedMessage) {
                String className = cssClass != null ? cssClass : (isUser ? "myselfCont" : "otherCont");
                transcriptText.append(NLS.bind((String)contSender, (Object[])new String[]{className, tooltip, direction}));
            } else {
                String className = cssClass != null ? cssClass : (isUser ? "myself" : "other");
                transcriptText.append(NLS.bind((String)sender, (Object[])new String[]{className, tooltip, shortened, direction}));
            }
            transcriptText.append(NLS.bind((String)message, (Object)text));
            if (!ImChatPlugin.isUsingXulrunner) {
                transcriptText.append("<div style=\"clear:both\"></div>");
            }
        }
        transcriptText.append(endRow);
        return transcriptText.toString();
    }

    public static String getMessage(String displayName, String shortened, String text, boolean isUser, String when, boolean isSystemMessage, boolean isContinuedMessage, String cssClass, boolean adjustDierction, Person person, Date date) {
        StringBuffer transcriptText = new StringBuffer();
        if (!(displayName != null || shortened != null || text != null || isUser || when != null || isSystemMessage || isContinuedMessage || date == null)) {
            transcriptText.append(NLS.bind((String)datestamp, (Object)DateFormat.getDateInstance().format(date)));
            return transcriptText.toString();
        }
        if (startRow.indexOf("{0}") > -1) {
            String name = displayName;
            String dateString = "";
            if (person != null) {
                name = person.getName();
            }
            if (date != null) {
                dateString = String.valueOf(dateString) + date.getTime();
            }
            transcriptText.append(NLS.bind((String)startRow, (Object[])new String[]{name, dateString}));
        } else {
            transcriptText.append(startRow);
        }
        transcriptText.append(NLS.bind((String)timestamp, (Object)when));
        String tooltip = NLS.bind((String)nametitle, (Object[])new String[]{displayName, when});
        if (isSystemMessage) {
            transcriptText.append(NLS.bind((String)systemMsg, (Object)text));
        } else {
            String direction = " dir=\"ltr\" ";
            if (adjustDierction) {
                if (Window.getDefaultOrientation() == 0x4000000) {
                    direction = " dir=\"rtl\" ";
                }
            } else if (text.indexOf("class=\"right\"") > -1) {
                direction = " dir=\"rtl\" ";
            }
            if (isContinuedMessage) {
                String className = cssClass != null ? cssClass : (isUser ? "myselfCont" : "otherCont");
                transcriptText.append(NLS.bind((String)contSender, (Object[])new String[]{className, tooltip, direction}));
            } else {
                String className = cssClass != null ? cssClass : (isUser ? "myself" : "other");
                transcriptText.append(NLS.bind((String)sender, (Object[])new String[]{className, tooltip, shortened, direction}));
            }
            transcriptText.append(NLS.bind((String)message, (Object)text));
            if (!ImChatPlugin.isUsingXulrunner) {
                transcriptText.append("<div style=\"clear:both\"></div>");
            }
        }
        transcriptText.append(endRow);
        return transcriptText.toString();
    }

    public void appendSystemMessage(String message) {
    }
}

