/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.chatwindow.actionset;

import com.ibm.collaboration.realtime.chat.actions.RichTextAction;
import com.ibm.collaboration.realtime.chatwindow.ChatWindowPreferences;
import com.ibm.collaboration.realtime.chatwindow.ImChatPlugin;
import com.ibm.collaboration.realtime.chatwindow.strings.Messages;
import com.ibm.collaboration.realtime.ui.util.SwtUtils;
import com.ibm.collaboration.realtime.util.OSUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.FontDialog;

public class TextPropertiesAction
extends RichTextAction {
    private static final Logger logger = Logger.getLogger(TextPropertiesAction.class.getName());

    public TextPropertiesAction(String text, int style) {
        super(text, style);
    }

    public void run() {
        if (this.getChatWindowHandlerInternal() != null) {
            FontData flist;
            FontDialog fd;
            StyleRange range;
            block29: {
                FontData[] data;
                range = this.getChatWindowHandlerInternal().getSendArea().getCurrentStyleRange();
                fd = new FontDialog(this.getChatWindowHandlerInternal().getShell());
                flist = null;
                RGB defaultColor = PreferenceConverter.getColor((IPreferenceStore)ImChatPlugin.getDefault().getPreferenceStore(), (String)ChatWindowPreferences.PREF_FONT_COLOR);
                if (defaultColor != null) {
                    fd.setRGB(defaultColor);
                }
                flist = (data = PreferenceConverter.getFontDataArray((IPreferenceStore)ImChatPlugin.getDefault().getPreferenceStore(), (String)ChatWindowPreferences.PREF_CHAT_FONT)) != null && data.length > 0 ? data[0] : this.getChatWindowHandlerInternal().getSendArea().getFont().getFontData()[0];
                if (range != null) {
                    if (range.font != null) {
                        flist = range.font.getFontData()[0];
                    }
                    if ((range.fontStyle & 1) != 0 || (range.fontStyle & 2) != 0) {
                        int style = flist.getStyle();
                        flist.setStyle(style | range.fontStyle);
                    }
                    if (range.foreground != null) {
                        fd.setRGB(range.foreground.getRGB());
                    }
                } else {
                    if (this.getChatWindowHandlerInternal().getSendArea().getCurrFont() != null) {
                        flist = this.getChatWindowHandlerInternal().getSendArea().getCurrFont().getFontData()[0];
                    }
                    if (this.getChatWindowHandlerInternal().getSendArea().getCurrentForegroundColor() != null) {
                        fd.setRGB(this.getChatWindowHandlerInternal().getSendArea().getCurrentForegroundColor().getRGB());
                    }
                }
                if (flist != null && OSUtils.isWin32()) {
                    try {
                        Object d = flist.getClass().getField("data").get(flist);
                        if (d != null) {
                            if (range != null && range.underline || this.getChatWindowHandlerInternal().getSendArea().isUnderline()) {
                                d.getClass().getField("lfUnderline").setByte(d, (byte)1);
                            }
                            if (range != null && range.strikeout || this.getChatWindowHandlerInternal().getSendArea().isStrikeout()) {
                                d.getClass().getField("lfStrikeOut").setByte(d, (byte)1);
                            }
                        }
                    }
                    catch (Exception e) {
                        if (!logger.isLoggable(Level.WARNING)) break block29;
                        logger.log(Level.WARNING, e.getMessage(), e);
                    }
                }
            }
            if (flist != null) {
                fd.setFontList(new FontData[]{flist});
            }
            FontData fdata = null;
            try {
                fdata = fd.open();
            }
            catch (Exception exception) {}
            if (fdata != null) {
                RGB rgb;
                block31: {
                    Font newFont;
                    range = new StyleRange();
                    range.font = newFont = new Font((Device)this.getChatWindowHandlerInternal().getShell().getDisplay(), fdata);
                    if (OSUtils.isWin32()) {
                        byte b;
                        Object d;
                        block30: {
                            try {
                                d = fdata.getClass().getField("data").get(fdata);
                                if (d != null && (b = d.getClass().getField("lfUnderline").getByte(d)) == 1) {
                                    range.underline = true;
                                }
                            }
                            catch (Exception e) {
                                if (!logger.isLoggable(Level.WARNING)) break block30;
                                logger.log(Level.WARNING, e.getMessage(), e);
                            }
                        }
                        try {
                            d = fdata.getClass().getField("data").get(fdata);
                            if (d != null && (b = d.getClass().getField("lfStrikeOut").getByte(d)) == 1) {
                                range.strikeout = true;
                            }
                        }
                        catch (Exception e) {
                            if (!logger.isLoggable(Level.WARNING)) break block31;
                            logger.log(Level.WARNING, e.getMessage(), e);
                        }
                    }
                }
                if ((rgb = fd.getRGB()) != null) {
                    Color color;
                    range.foreground = color = new Color((Device)this.getChatWindowHandlerInternal().getSendArea().getDisplay(), rgb);
                }
                this.getChatWindowHandlerInternal().getSendArea().updateStyleControls(range);
            }
            try {
                this.getChatWindowHandlerInternal().getSendArea().setFocus();
            }
            catch (Exception exception) {}
        }
    }

    public void dispose() {
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public String getToolTipText() {
        return SwtUtils.removeMnemonic((String)Messages.edit_text_properties);
    }
}

