/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.chatwindow;

import com.ibm.collaboration.realtime.chat.actions.ChatWindowAction;
import com.ibm.collaboration.realtime.chatwindow.ChatWindowHandler;
import com.ibm.collaboration.realtime.chatwindow.ImChatPlugin;
import com.ibm.collaboration.realtime.chatwindow.ImChatWindowHandler;
import com.ibm.collaboration.realtime.chatwindow.strings.Messages;
import com.ibm.collaboration.realtime.ui.util.ImageCache;
import com.ibm.collaboration.realtime.ui.util.SwtUtils;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.ui.progress.UIJob;

public class ToggleTranscriptArea
extends ChatWindowAction {
    public static final String ID = "com.ibm.collaboration.realtime.chatwindow.toggleTranscript";
    private boolean hasIncoming = false;
    private int blink = 0;
    private static final int BLINK_MAX = 6;
    private boolean clicked = false;

    public void setIncoming(boolean incoming) {
        this.hasIncoming = incoming;
        if (this.hasIncoming) {
            this.blink = 0;
            UIJob job = new UIJob(ID){

                public IStatus runInUIThread(IProgressMonitor arg0) {
                    ToggleTranscriptArea toggleTranscriptArea = ToggleTranscriptArea.this;
                    toggleTranscriptArea.blink = toggleTranscriptArea.blink + 1;
                    ToggleTranscriptArea.this.hasIncoming = !ToggleTranscriptArea.this.hasIncoming;
                    ToggleTranscriptArea.this.firePropertyChange("image", null, null);
                    if (ToggleTranscriptArea.this.blink < 6) {
                        this.schedule(500L);
                    } else {
                        ToggleTranscriptArea.this.hasIncoming = true;
                        ToggleTranscriptArea.this.firePropertyChange("image", null, null);
                    }
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule(500L);
        }
    }

    public boolean isVisible() {
        return this.getChatWindowHandlerInternal().isMultiChat();
    }

    public void run() {
        this.clicked = true;
        boolean hideChatArea = this.getChatWindowHandlerInternal().hideChatArea;
        this.getChatWindowHandlerInternal().setChatDisabled(!hideChatArea);
    }

    public String getToolTipText() {
        if (this.getChatWindowHandlerInternal().hideChatArea) {
            if (this.hasIncoming) {
                StringBuffer b = new StringBuffer(100);
                b.append(Messages.systray_message_header);
                b.append("\n");
                b.append(this.getChatWindowHandlerInternal().getLatestSender());
                b.append("\n");
                b.append(Messages.showTranscriptArea);
                return b.toString();
            }
            return Messages.showTranscriptArea;
        }
        this.hasIncoming = false;
        return Messages.hideTranscriptArea;
    }

    public ImageDescriptor getImageDescriptor() {
        ImageDescriptor desc = this.getChatWindowHandlerInternal().hideChatArea ? (this.hasIncoming ? ImageCache.getImageDescriptor((Plugin)ImChatPlugin.getDefault(), (String)"images/Chat_Transcript_Win_Open.png") : ImageCache.getImageDescriptor((Plugin)ImChatPlugin.getDefault(), (String)"images/Chat_Window_Open.png")) : ImageCache.getImageDescriptor((Plugin)ImChatPlugin.getDefault(), (String)"images/Chat_Window_Close.png");
        if (SwtUtils.usingHighContrast()) {
            return SwtUtils.getScaledImageDescriptor((ImageDescriptor)desc);
        }
        return desc;
    }

    public void setChatWindowHandler(ChatWindowHandler chat) {
        super.setChatWindowHandler(chat);
        ((ImChatWindowHandler)chat).getShell().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ToggleTranscriptArea.this.firePropertyChange("image", null, null);
                ToggleTranscriptArea.this.firePropertyChange("toolTipText", null, null);
            }
        });
    }

    public boolean wasClicked() {
        return this.clicked;
    }
}

