/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.chatwindow;

import com.ibm.collaboration.realtime.chat.actions.RichTextAction;
import com.ibm.collaboration.realtime.chatwindow.addon.Embeddable;
import com.ibm.collaboration.realtime.chatwindow.strings.Messages;
import com.ibm.collaboration.realtime.ui.util.BitmapTransfer;
import com.ibm.collaboration.realtime.ui.widgets.ScreenShotShell;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ScreenshotAction
extends RichTextAction {
    private Image selectedImage;
    private ScreenShotShell shell;

    public void run() {
        if (this.shell != null && this.shell.getShell() != null && !this.shell.getShell().isDisposed()) {
            this.shell.getShell().forceFocus();
            return;
        }
        this.getChatWindowHandlerInternal().getShell().setMinimized(true);
        this.shell = new ScreenShotShell(this.getChatWindowHandlerInternal().getShell()){

            public void addShellListeners(Shell s) {
                s.addTraverseListener(new TraverseListener(){

                    public void keyTraversed(TraverseEvent e) {
                        if (e.detail == 4) {
                            ScreenshotAction.this.pasteAndSend();
                        }
                    }
                });
                s.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        if (ScreenshotAction.this.getChatWindowHandlerInternal().getShell().getMinimized()) {
                            ScreenshotAction.this.getChatWindowHandlerInternal().getShell().setMinimized(false);
                        }
                    }
                });
            }
        };
        this.shell.addActionToActionBar("start", (IAction)new Action(Messages.sendScreenshot){

            public void run() {
                ScreenshotAction.this.pasteAndSend();
            }
        });
        this.shell.addActionToActionBar("start", (IAction)new Action(Messages.pasteIntoChat){

            public void run() {
                ScreenshotAction.this.pasteOnly();
            }
        });
        Rectangle bounds = this.getToolItemBounds();
        if (bounds != null) {
            this.shell.open(bounds.x, bounds.y + bounds.height);
        } else {
            this.shell.open();
        }
    }

    private void pasteAndSend() {
        this.pasteOnly();
        this.getChatWindowHandlerInternal().sendText();
    }

    private void pasteOnly() {
        Image im = this.shell.getScreenshot();
        if (im == null) {
            this.shell.performScreenshot();
            im = this.shell.getScreenshot();
        }
        if (im != null) {
            this.selectedImage = im;
            this.getChatWindowHandler().embedObject(new Embeddable(){

                public Image createDisplayImage() {
                    return ScreenshotAction.this.selectedImage;
                }

                public void run() {
                }

                public void destroy() {
                    if (ScreenshotAction.this.selectedImage != null && !ScreenshotAction.this.selectedImage.isDisposed()) {
                        ScreenshotAction.this.selectedImage.dispose();
                    }
                }
            });
            Clipboard cBoard = new Clipboard(Display.getDefault());
            BitmapTransfer transfer = BitmapTransfer.getInstance();
            cBoard.setContents(new Object[]{this.selectedImage}, new Transfer[]{transfer});
            cBoard.dispose();
            this.shell.dispose();
            this.shell = null;
        }
    }

    public boolean isVisible() {
        return this.getChatWindowHandlerInternal().hasActivity("AllowImageCaptures");
    }

    public boolean isEnabled() {
        return this.getChatWindowHandlerInternal().isMultiChat() ? this.isVisible() : super.isEnabled();
    }
}

