/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.chatwindow;

import com.ibm.collaboration.realtime.chatwindow.ImChatActionDescriptor;
import com.ibm.collaboration.realtime.chatwindow.ImChatWindowHandler;
import com.ibm.collaboration.realtime.tableextension.NwayTableCellSelectionListener;
import com.ibm.collaboration.realtime.tableextension.NwayTableLabelProvider;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public class ListExtension {
    protected static final String BOTTOM = "BOTTOM";
    protected static final String TOP = "TOP";
    IConfigurationElement extension;
    ArrayList extraColumns;
    ArrayList cellListeners;
    ArrayList chatActions;
    NwayTableLabelProvider labelProvider;
    String viewClass;
    String id;
    boolean enabled = false;
    String activity = null;
    boolean outsideShelf = false;
    String region = "TOP";

    public ListExtension(IConfigurationElement extension) {
        this.extension = extension;
        this.id = extension.getAttribute("id");
        String enabledAtt = extension.getAttribute("enabled");
        if (enabledAtt != null) {
            this.enabled = "true".equals(enabledAtt);
        }
        this.activity = extension.getAttribute("activity");
    }

    public ListExtension() {
    }

    public ListExtension create(ImChatWindowHandler handler) {
        ListExtension li = new ListExtension();
        li.id = this.extension.getAttribute("id");
        String enabledAtt = this.extension.getAttribute("enabled");
        if (enabledAtt != null) {
            li.enabled = "true".equals(enabledAtt);
        }
        li.activity = this.extension.getAttribute("activity");
        IConfigurationElement[] children = this.extension.getChildren();
        int i = 0;
        while (i < children.length) {
            block29: {
                IConfigurationElement element = children[i];
                if ("labelProvider".compareTo(element.getName()) == 0) {
                    try {
                        Object provider = element.createExecutableExtension("class");
                        String global = element.getAttribute("isGlobal");
                        if (!(provider instanceof NwayTableLabelProvider)) break block29;
                        li.labelProvider = (NwayTableLabelProvider)((Object)provider);
                        li.labelProvider.setChatWindowHandler(handler);
                        if (global != null && global.length() > 0) {
                            li.labelProvider.setGlobal(Boolean.valueOf(global));
                        }
                    }
                    catch (CoreException coreException) {}
                } else if ("extraColumns".compareTo(element.getName()) == 0) {
                    IConfigurationElement[] columns = element.getChildren();
                    if (columns != null) {
                        li.extraColumns = new ArrayList();
                        int j = 0;
                        while (j < columns.length) {
                            Column column = new Column();
                            column.columnIndex = Integer.parseInt(columns[j].getAttribute("columnIndex"));
                            String initialWidth = columns[j].getAttribute("initialWidth");
                            if (initialWidth != null) {
                                try {
                                    column.initialWidth = Integer.parseInt(initialWidth);
                                }
                                catch (NumberFormatException numberFormatException) {}
                            }
                            li.extraColumns.add(column);
                            ++j;
                        }
                    }
                } else if ("cellListeners".compareTo(element.getName()) == 0) {
                    IConfigurationElement[] listeners = element.getChildren();
                    if (listeners != null) {
                        li.cellListeners = new ArrayList();
                        int j = 0;
                        while (j < listeners.length) {
                            block30: {
                                try {
                                    Object listener = listeners[j].createExecutableExtension("class");
                                    String index = listeners[j].getAttribute("columnIndex");
                                    if (!(listener instanceof NwayTableCellSelectionListener)) break block30;
                                    NwayTableCellSelectionListener csl = (NwayTableCellSelectionListener)((Object)listener);
                                    csl.setChatWindowHandler(handler);
                                    if (index != null) {
                                        try {
                                            csl.setColumnIndex(Integer.parseInt(index));
                                        }
                                        catch (NumberFormatException numberFormatException) {}
                                    }
                                    li.cellListeners.add(csl);
                                }
                                catch (CoreException coreException) {}
                            }
                            ++j;
                        }
                    }
                } else if ("toolView".compareTo(element.getName()) == 0) {
                    String region;
                    li.viewClass = element.getAttribute("view");
                    String plugin = this.extension.getNamespaceIdentifier();
                    if (plugin.indexOf("com.ibm.collaboration.realtime.telephony") == 0) {
                        li.outsideShelf = true;
                    }
                    if ((region = element.getAttribute("region")) != null) {
                        li.region = region;
                    }
                } else if ("chatAction".compareTo(element.getName()) == 0) {
                    ImChatActionDescriptor desc = new ImChatActionDescriptor(this.extension.getNamespaceIdentifier(), element);
                    if (li.chatActions == null) {
                        li.chatActions = new ArrayList();
                    }
                    li.chatActions.add(desc);
                }
            }
            ++i;
        }
        return li;
    }

    public NwayTableLabelProvider getLabelProvider() {
        return this.labelProvider;
    }

    public Column[] getExtraColumns() {
        if (this.extraColumns != null) {
            return this.extraColumns.toArray(new Column[this.extraColumns.size()]);
        }
        return null;
    }

    public int getColumnCount() {
        if (this.extraColumns != null) {
            return this.extraColumns.size();
        }
        return -1;
    }

    public NwayTableCellSelectionListener[] getTableCellListeners() {
        if (this.cellListeners != null) {
            return this.cellListeners.toArray(new NwayTableCellSelectionListener[this.cellListeners.size()]);
        }
        return null;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getId() {
        return this.id;
    }

    public String getActivity() {
        return this.activity;
    }

    public ImChatActionDescriptor[] getChatActionDescriptors() {
        if (this.chatActions == null) {
            return null;
        }
        return this.chatActions.toArray(new ImChatActionDescriptor[this.chatActions.size()]);
    }

    public class Column {
        public int columnIndex = -1;
        public int initialWidth = 20;
    }
}

