/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.chatwindow;

import com.ibm.collaboration.realtime.chatwindow.ChatWindowPartner;
import com.ibm.collaboration.realtime.im.community.CommunityUtil;
import com.ibm.collaboration.realtime.people.Person;
import java.util.Hashtable;

public class ImChatWindowPartner
implements ChatWindowPartner {
    public static final int JOINED = 1;
    public static final int NOT_JOINED = -1;
    public static final int LEFT = 0;
    boolean typing = false;
    boolean speaking = false;
    boolean muted = false;
    boolean callPaused = false;
    private boolean onCall = false;
    boolean moderator = false;
    int status = -99;
    String statusText = null;
    boolean usingICT = false;
    private static Hashtable capabilities = new Hashtable();
    private Person person;
    private String personLoginId;
    private String name;
    private String id;
    private boolean joined = true;
    int colorIndex = 0;
    protected int lastLocalOnlineStatus = -99;
    protected boolean changed = false;
    private int joinstate = -1;

    protected static synchronized void setCapabiltiy(String partnerID, String capability) {
        if (capability != null) {
            capabilities.put(partnerID, capability);
        }
    }

    protected String getCapabilities() {
        if (capabilities.containsKey(this.person.getContactId())) {
            return (String)capabilities.get(this.person.getContactId());
        }
        return "";
    }

    public ImChatWindowPartner(Person person) {
        this.setPerson(person);
    }

    public ImChatWindowPartner(Person person, String personLoginId) {
        this.setPerson(person);
        this.personLoginId = personLoginId;
    }

    public ImChatWindowPartner(String name, String id) {
        this.name = name;
        this.id = id;
    }

    public boolean isOnCall() {
        return this.onCall;
    }

    public void setOnCall(boolean onCall) {
        this.onCall = onCall;
        if (!onCall) {
            this.moderator = false;
            this.muted = false;
        }
    }

    public void setStatusText(String stText) {
        this.statusText = stText;
    }

    public void setStatus(int stat) {
        if (stat != this.status) {
            this.changed = true;
        }
        if (this.lastLocalOnlineStatus == stat) {
            this.changed = false;
        }
        if (this.person != null) {
            boolean loggedIn = CommunityUtil.getCommunity((String)this.person.getCommunityId()).isLoggedIn();
            this.lastLocalOnlineStatus = !loggedIn && this.status > 0 ? this.status : -99;
        }
        this.status = stat;
    }

    public int getStatus() {
        if (this.person != null) {
            return this.person.getStatus();
        }
        return this.status;
    }

    public String getStatusText() {
        if (this.person != null) {
            return this.person.getStatusMessage();
        }
        return this.statusText;
    }

    public void setPerson(Person person) {
        this.person = person;
    }

    public Person getPerson() {
        return this.person;
    }

    public String getName() {
        if (this.person != null) {
            String displayName;
            if (this.person.getDirectoryInfo() != null && (displayName = (String)this.person.getDirectoryInfo().get("Name")) != null && displayName.length() > 0) {
                return displayName;
            }
            return this.person.getDisplayName();
        }
        return this.name;
    }

    public String getContactId() {
        if (this.person != null) {
            return this.person.getContactId();
        }
        return this.id;
    }

    public void setJoined(boolean isjoined) {
        this.joined = isjoined;
        this.joinstate = this.joined ? 1 : -1;
    }

    public boolean isJoined() {
        return this.joined;
    }

    public String getPersonLoginId() {
        return this.personLoginId;
    }

    public void setPersonLoginId(String loginId) {
        this.personLoginId = loginId;
    }

    public int getJoinState() {
        return this.joinstate;
    }

    public void setJoinState(int state) {
        this.joinstate = state;
        this.joined = state == 1;
    }
}

