/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.chatwindow;

import com.ibm.collaboration.realtime.chat.actions.ChatActionWindowDelegate;
import com.ibm.collaboration.realtime.chat.actions.ChatWindowAction;
import com.ibm.collaboration.realtime.chatwindow.ImChatPlugin;
import com.ibm.collaboration.realtime.chatwindow.strings.LogMessages;
import com.ibm.collaboration.realtime.ui.util.SwtUtils;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IConfigurationElement;

public class ImChatActionDescriptor {
    private static Logger logger = null;
    private final IConfigurationElement element;
    private final String parentNamespace;
    private int buttonType = ChatWindowAction.CHAT_ACTION;
    private final String id;
    private final boolean useInAnyStyledText;

    public ImChatActionDescriptor(String parentNamespace, IConfigurationElement element) {
        String id;
        this.element = element;
        this.parentNamespace = parentNamespace;
        String type = element.getAttribute("type");
        if (type != null) {
            if (type.compareTo("format") == 0) {
                this.buttonType = ChatWindowAction.FORMAT_ACTION;
            } else if (type.compareTo("buddy") == 0) {
                this.buttonType = ChatWindowAction.CHAT_ACTION;
            } else if (type.compareTo("list") == 0) {
                this.buttonType = ChatWindowAction.NWAY_ACTION;
            } else if (type.compareTo("menu") == 0) {
                this.buttonType = ChatWindowAction.MENU_ACTION;
            } else if (type.compareTo("buddyright") == 0) {
                this.buttonType = ChatWindowAction.CHAT_ACTION_OTHER;
            }
        }
        this.id = id = element.getAttribute("id");
        String any = element.getAttribute("anyStyledText");
        this.useInAnyStyledText = "true".equals(any);
    }

    public String getId() {
        return this.id;
    }

    public int getButtonType() {
        return this.buttonType;
    }

    public ChatWindowAction getAction() {
        block15: {
            try {
                Object action = this.element.createExecutableExtension("class");
                String id = this.element.getAttribute("id");
                String label = this.element.getAttribute("displayName");
                this.element.getAttribute("type");
                String requiredCaps = this.element.getAttribute("requiredCapabilities");
                String activity = this.element.getAttribute("activity");
                if (action instanceof ChatActionWindowDelegate) {
                    ChatActionWindowDelegate delegate = (ChatActionWindowDelegate)action;
                    String style = this.element.getAttribute("style");
                    int styleFlag = 1;
                    if (style != null) {
                        if (style.compareTo("dropdown") == 0) {
                            styleFlag = 4;
                        } else if (style.compareTo("check") == 0) {
                            styleFlag = 2;
                        }
                    }
                    ChatWindowAction a = new ChatWindowAction(styleFlag);
                    a.setActionDelegate(delegate);
                    a.setId(id);
                    a.setText(label);
                    a.setToolTipText(SwtUtils.removeMnemonic((String)this.element.getAttribute("tooltipText")));
                    a.setRequiredCapabilities(requiredCaps);
                    a.setToolbarPath(this.element.getAttribute("path"));
                    a.setMenubarPath(this.element.getAttribute("menubarPath"));
                    a.setActivity(activity);
                    if (this.element.getAttribute("image") != null && this.element.getAttribute("image").length() > 0) {
                        a.setImageDescriptor(ImChatPlugin.loadImageInJob(this.parentNamespace, this.element.getAttribute("image")));
                    }
                    if (this.element.getAttribute("disabledImage") != null && this.element.getAttribute("disabledImage").length() > 0) {
                        a.setDisabledImageDescriptor(ImChatPlugin.loadImageInJob(this.parentNamespace, this.element.getAttribute("disabledImage")));
                    }
                    if (this.element.getAttribute("hoverImage") != null && this.element.getAttribute("hoverImage").length() > 0) {
                        a.setHoverImageDescriptor(ImChatPlugin.loadImageInJob(this.parentNamespace, this.element.getAttribute("hoverImage")));
                    }
                    a.setShowsFor(this.element.getAttribute("showsFor"));
                    a.setButtonType(this.getButtonType());
                    return a;
                }
                if (action instanceof ChatWindowAction) {
                    ChatWindowAction a = (ChatWindowAction)action;
                    a.setId(id);
                    a.setText(label);
                    a.setToolTipText(SwtUtils.removeMnemonic((String)this.element.getAttribute("tooltipText")));
                    a.setRequiredCapabilities(requiredCaps);
                    a.setToolbarPath(this.element.getAttribute("path"));
                    a.setMenubarPath(this.element.getAttribute("menubarPath"));
                    a.setActivity(activity);
                    if (this.element.getAttribute("image") != null && this.element.getAttribute("image").length() > 0) {
                        a.setImageDescriptor(ImChatPlugin.loadImageInJob(this.parentNamespace, this.element.getAttribute("image")));
                    }
                    if (this.element.getAttribute("disabledImage") != null && this.element.getAttribute("disabledImage").length() > 0) {
                        a.setDisabledImageDescriptor(ImChatPlugin.loadImageInJob(this.parentNamespace, this.element.getAttribute("disabledImage")));
                    }
                    if (this.element.getAttribute("hoverImage") != null && this.element.getAttribute("hoverImage").length() > 0) {
                        a.setHoverImageDescriptor(ImChatPlugin.loadImageInJob(this.parentNamespace, this.element.getAttribute("hoverImage")));
                    }
                    a.setShowsFor(this.element.getAttribute("showsFor"));
                    a.setButtonType(this.getButtonType());
                    return a;
                }
            }
            catch (Throwable e) {
                if (logger == null) {
                    logger = Logger.getLogger(ImChatActionDescriptor.class.getName());
                }
                if (!logger.isLoggable(Level.INFO)) break block15;
                logger.log(Level.INFO, String.valueOf(LogMessages.ImChatActionDescriptor_0) + this.id, e);
            }
        }
        return null;
    }

    public boolean canUseInAnyStyledText() {
        return this.useInAnyStyledText;
    }

    public String getActivity() {
        String activity = this.element.getAttribute("activity");
        if (activity != null && activity.length() == 0) {
            return null;
        }
        return activity;
    }
}

