/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.chatwindow;

import com.ibm.collaboration.realtime.annotate.LinkifyAnnotationProvider;
import com.ibm.collaboration.realtime.chatwindow.ChatWindowPreferences;
import com.ibm.collaboration.realtime.chatwindow.ImChatPlugin;
import com.ibm.collaboration.realtime.chatwindow.ShowHideEmoticonsJob;
import com.ibm.collaboration.realtime.chatwindow.strings.Messages;
import com.ibm.collaboration.realtime.chatwindow.template.TranscriptWriter;
import com.ibm.collaboration.realtime.magiccarpet.messageprocessor.MessageProcessor;
import com.ibm.collaboration.realtime.people.Person;
import com.ibm.collaboration.realtime.util.DataMessage;
import com.ibm.collaboration.realtime.util.FileUtils;
import com.ibm.icu.text.DateFormat;
import java.io.File;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;

public class CreateHTMLJob
extends Job {
    String displayName;
    String shortened;
    String text;
    Object[] transcriptObject;
    boolean isUser = false;
    Date when;
    boolean isSystemMessage = false;
    boolean isContinuedMessage = false;
    boolean createHTML = false;
    boolean escapeText = false;
    private final DateFormat dateFormat;
    private final Object message;
    private int colorIndex = -1;
    private final boolean adjustDirection;
    private String transcriptDir = null;
    protected Person person = null;
    private boolean printDatestamp = false;
    static Pattern br = Pattern.compile("<br>");
    static Pattern BR = Pattern.compile("<BR>");
    static Pattern tags = Pattern.compile("<[^>]*>");
    static Pattern lt = Pattern.compile("&lt;");
    static Pattern gt = Pattern.compile("&gt;");
    static Pattern apos = Pattern.compile("&apos;");
    static Pattern quot = Pattern.compile("&quot;");
    static Pattern amp = Pattern.compile("&amp;");
    static Pattern nbsp = Pattern.compile("&nbsp;");
    static Pattern escapeAmp = Pattern.compile("&");
    static Pattern escapeLt = Pattern.compile("<");
    static Pattern escapeGt = Pattern.compile(">");
    static Pattern escapeQuot = Pattern.compile("\"");
    private static final Logger logger = Logger.getLogger(CreateHTMLJob.class.getName());
    public static String[] disallowedAttrs = new String[]{"onabort", "onblur", "onchange", "onclick", "ondblclick", "onerror", "onfocus", "onkeydown", "onkeypress", "onkeyup", "onload", "onmousedown", "onmousemove", "onmouseout", "onmouseover", "onmouseup", "onreset", "onresize", "onselect", "onsubmit", "onunload"};

    public CreateHTMLJob(String displayName, String shortened, Object textOrArrayList, boolean isUser, Date when, DateFormat format, boolean isSystemMessage, boolean isContinuedMessage, boolean createHTML, boolean escapeText, boolean adjustDirection) {
        super("CreateHTMLJob");
        this.displayName = displayName;
        this.shortened = shortened;
        this.message = textOrArrayList;
        this.isUser = isUser;
        this.when = when;
        this.isSystemMessage = isSystemMessage;
        this.isContinuedMessage = isContinuedMessage;
        this.createHTML = createHTML;
        this.escapeText = escapeText;
        this.dateFormat = format;
        this.adjustDirection = adjustDirection;
    }

    protected void setTranscriptDir(String dir) {
        this.transcriptDir = dir;
    }

    protected void setColorIndex(int index) {
        this.colorIndex = index;
    }

    protected void setPerson(Person person) {
        this.person = person;
    }

    protected void setPrintDatestamp(boolean print) {
        this.printDatestamp = print;
    }

    protected IStatus run(IProgressMonitor arg0) {
        if (this.message instanceof ArrayList) {
            Object next;
            StringBuffer messageBuffer = new StringBuffer();
            ArrayList msgBuffer = (ArrayList)this.message;
            int i = 0;
            while (i < msgBuffer.size()) {
                block29: {
                    next = msgBuffer.get(i);
                    if (next instanceof DataMessage) {
                        DataMessage data = (DataMessage)next;
                        if (data.filename == null && data.bytes != null && "image".equals(data.msgSubtype) && this.transcriptDir != null) {
                            StringBuffer filename = new StringBuffer();
                            filename.append(this.transcriptDir);
                            String fileExt = null;
                            if (i >= 0) {
                                Object prevMessage = null;
                                if (i - 1 < msgBuffer.size() && i - 1 >= 0) {
                                    prevMessage = msgBuffer.get(i - 1);
                                }
                                if (prevMessage instanceof String) {
                                    fileExt = this.getImgExtension(prevMessage);
                                }
                            }
                            filename.append("IMAGE");
                            filename.append(MessageProcessor.generateUniqueID());
                            if (fileExt != null) {
                                filename.append(fileExt);
                            }
                            data.filename = filename.toString();
                            filename = null;
                        }
                        if (data.filename != null) {
                            try {
                                FileOutputStream fos = new FileOutputStream(new File(data.filename));
                                fos.write(data.bytes);
                                fos.close();
                                if (i < 0) break block29;
                                Object prevMessage = null;
                                if (i - 1 < msgBuffer.size() && i - 1 >= 0) {
                                    prevMessage = msgBuffer.get(i - 1);
                                }
                                if (!(prevMessage instanceof String) && i != 0) break block29;
                                String strFile = data.filename;
                                strFile = strFile.replaceAll("[%]", "cas42");
                                String newFilename = FileUtils.getLocalUrl((String)strFile);
                                newFilename = newFilename.replaceAll("cas42", "%25");
                                String newImg = null;
                                if (prevMessage != null) {
                                    newImg = this.replaceImgSrc(prevMessage, newFilename);
                                }
                                if (newImg == null) {
                                    Object imgSrc;
                                    String prevString = prevMessage;
                                    if (prevString != null && prevString.indexOf("IMAGE [") == 0 && prevString.charAt(prevString.length() - 1) == ']') {
                                        String alt = prevString.substring("IMAGE [".length(), prevString.length() - 1);
                                        StringBuffer b = new StringBuffer();
                                        b.append("<img src=\"");
                                        b.append(newFilename);
                                        b.append("\" alt=\"");
                                        b.append(alt);
                                        b.append("\" title=\"");
                                        b.append(alt);
                                        b.append("\" />");
                                        msgBuffer.set(i - 1, b.toString());
                                    } else {
                                        msgBuffer.set(i, "<img src=\"" + newFilename + "\" />");
                                    }
                                    if (i - 2 >= msgBuffer.size() || i - 2 < 0 || !((imgSrc = msgBuffer.get(i - 2)) instanceof DataMessage)) break block29;
                                    DataMessage imgData = (DataMessage)imgSrc;
                                    if (!"html".equals(imgData.msgType) || !"img".equals(imgData.msgSubtype) || imgData.bytes == null) break block29;
                                    try {
                                        imgSrc = new String(imgData.bytes, "UTF-8");
                                    }
                                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                                        imgSrc = new String(imgData.bytes);
                                    }
                                    newImg = this.replaceImgSrc((String)imgSrc, newFilename);
                                    if (newImg != null) {
                                        msgBuffer.set(i - 2, newImg);
                                        msgBuffer.set(i - 1, "");
                                    }
                                    break block29;
                                }
                                msgBuffer.set(i - 1, newImg);
                            }
                            catch (Exception e) {
                                if (!logger.isLoggable(Level.WARNING)) break block29;
                                logger.log(Level.WARNING, e.getMessage(), e);
                            }
                        }
                    }
                }
                ++i;
            }
            i = 0;
            while (i < msgBuffer.size()) {
                next = msgBuffer.get(i);
                if (next instanceof String) {
                    messageBuffer.append((String)next);
                }
                ++i;
            }
            this.text = messageBuffer.toString();
            messageBuffer = null;
        } else if (this.message instanceof String) {
            this.text = (String)this.message;
        }
        if (this.text == null) {
            return Status.OK_STATUS;
        }
        if (this.escapeText) {
            this.text = CreateHTMLJob.escapeText(this.text);
        }
        if (this.createHTML) {
            this.text = this.createHTML(this.text);
        } else {
            this.text = this.text.replaceAll("\r\n", "<br />");
            this.text = this.text.replaceAll("\n", "<br />");
            this.text = this.text.replaceAll("\r", "<br />");
            this.text = this.text.replaceAll("\t", "&#x0009;");
        }
        String className = null;
        String nwayIndex = "";
        if (this.colorIndex > 0) {
            nwayIndex = "" + this.colorIndex;
        }
        className = this.isContinuedMessage ? (this.isUser ? "myselfCont" : "otherCont" + nwayIndex) : (this.isUser ? "myself" : "other" + nwayIndex);
        this.transcriptObject = new Object[]{this.when, this.displayName, CreateHTMLJob.deHTMLize(this.text), this.isUser ? "true" : "false"};
        this.text = this.person != null ? TranscriptWriter.getMessage(this.displayName, this.shortened, this.text, this.isUser, this.dateFormat.format(this.when), this.isSystemMessage, this.isContinuedMessage, className, this.adjustDirection, this.person, this.when) : TranscriptWriter.getMessage(this.displayName, this.shortened, this.text, this.isUser, this.dateFormat.format(this.when), this.isSystemMessage, this.isContinuedMessage, className, this.adjustDirection);
        if (this.printDatestamp) {
            this.text = String.valueOf(TranscriptWriter.getMessage(null, null, null, false, null, false, false, null, false, null, this.when)) + this.text;
        }
        return Status.OK_STATUS;
    }

    public static String deHTMLize(String html) {
        String nonhtml = br.matcher(html).replaceAll("\r\n");
        nonhtml = BR.matcher(nonhtml).replaceAll("\r\n");
        nonhtml = tags.matcher(nonhtml).replaceAll("");
        nonhtml = lt.matcher(nonhtml).replaceAll("<");
        nonhtml = gt.matcher(nonhtml).replaceAll(">");
        nonhtml = apos.matcher(nonhtml).replaceAll("'");
        nonhtml = quot.matcher(nonhtml).replaceAll("\"");
        nonhtml = amp.matcher(nonhtml).replaceAll("&");
        nonhtml = nbsp.matcher(nonhtml).replaceAll(" ");
        nonhtml = nonhtml.replaceAll("&#160;", "");
        return nonhtml;
    }

    public static String escapeText(String html) {
        String nonhtml = escapeAmp.matcher(html).replaceAll("&amp;");
        nonhtml = escapeLt.matcher(nonhtml).replaceAll("&lt;");
        nonhtml = escapeGt.matcher(nonhtml).replaceAll("&gt;");
        nonhtml = escapeQuot.matcher(nonhtml).replaceAll("&quot;");
        return nonhtml;
    }

    public String createHTML(String text) {
        Pattern urlPattern = LinkifyAnnotationProvider.getLinkPattern();
        if (urlPattern != null) {
            Matcher matcher = urlPattern.matcher(text);
            try {
                int start = 0;
                StringBuffer sb = new StringBuffer();
                while (matcher.find()) {
                    String found = matcher.group();
                    String substr = text.substring(start, matcher.start());
                    int prevIndex = substr.lastIndexOf("<a ");
                    if (prevIndex == -1) {
                        prevIndex = substr.lastIndexOf("&lt;a ");
                    }
                    if (prevIndex == -1 && matcher.start() - 1 >= 0 && (text.charAt(matcher.start() - 1) == '\'' || text.charAt(matcher.start() - 1) == '\"')) {
                        prevIndex = 0;
                    }
                    if (prevIndex != -1) continue;
                    sb.append(substr);
                    int span = found.indexOf("</span>");
                    if (span > -1) {
                        int startLength = found.length();
                        found = found.substring(0, span);
                        start = matcher.end() - (startLength - span);
                    } else {
                        span = found.indexOf("&lt;");
                        if (span > -1) {
                            int startLength = found.length();
                            found = found.substring(0, span);
                            start = matcher.end() - (startLength - span);
                        } else {
                            if (matcher.start() > 0 && text.charAt(matcher.start() - 1) == '(' && found.charAt(found.length() - 1) == ')') {
                                found = found.substring(0, found.length() - 1);
                                start = matcher.end() - 1;
                            } else {
                                start = matcher.end();
                            }
                            if ("_http://".equals(substr)) {
                                sb.append(found);
                                start = matcher.end();
                                continue;
                            }
                        }
                    }
                    if (!LinkifyAnnotationProvider.getProtocolPattern().matcher(found).matches()) {
                        String link = "http://" + found.trim();
                        sb.append(NLS.bind((String)Messages.linkHtml, (Object[])new String[]{link, found}));
                        continue;
                    }
                    sb.append(NLS.bind((String)Messages.linkHtml, (Object[])new String[]{found, found}));
                }
                sb.append(text.substring(start));
                text = sb.toString();
            }
            catch (Throwable throwable) {}
        }
        text = text.replaceAll("(?i)<script", "&lt;script");
        text = text.replaceAll("(?i)</script", "&lt;/script");
        text = text.replaceAll("(?i)<embed", "&lt;embed");
        text = text.replaceAll("(?i)</embed", "&lt;/embed");
        text = text.replaceAll("\r\n", "<br />");
        text = text.replaceAll("\n", "<br />");
        text = text.replaceAll("\r", "<br />");
        text = text.replaceAll("\t", "&#x0009;");
        this.removeNonStyleAttributes(text);
        if (!this.isUser && ImChatPlugin.getDefault().getPrefAsBoolean(ChatWindowPreferences.PREF_FONT_OVERRIDE)) {
            if (text.indexOf("<span") > -1) {
                text = text.replaceAll("<span[^>]*>", "");
                text = text.replaceAll("</span>", "");
            }
            if (text.indexOf("<b>") > -1) {
                text = text.replaceAll("<b>", "");
                text = text.replaceAll("</b>", "");
            }
            if (text.indexOf("<i>") > -1) {
                text = text.replaceAll("<i>", "");
                text = text.replaceAll("</i>", "");
            }
            if (text.indexOf("<u>") > -1) {
                text = text.replaceAll("<u>", "");
                text = text.replaceAll("</u>", "");
            }
        }
        text = ShowHideEmoticonsJob.processText(text, !ImChatPlugin.getDefault().getPrefAsBoolean(ChatWindowPreferences.PREF_SHOW_EMOTICONS));
        return text;
    }

    private void removeNonStyleAttributes(String text) {
        Pattern match = Pattern.compile("<span(?:[^<>]*)>");
        Matcher matcher = match.matcher(text);
        StringBuffer sb = new StringBuffer();
        try {
            int start = 0;
            while (matcher.find()) {
                String span = matcher.group();
                String substr = text.substring(start, matcher.start());
                sb.append(substr);
                int altindex = span.indexOf("style=\"");
                String style = "";
                if (altindex > -1) {
                    try {
                        style = span.substring(altindex, span.indexOf("\"", altindex + "style=\"".length() + 1) + 1);
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                        style = "";
                    }
                } else {
                    altindex = span.indexOf("style='");
                    if (altindex > -1) {
                        try {
                            style = span.substring(altindex, span.indexOf("'", altindex + "style='".length() + 1) + 1);
                        }
                        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                            style = "";
                        }
                    }
                }
                sb.append("<span");
                if (style != null && style.length() > 0) {
                    sb.append(" ");
                    sb.append(style);
                }
                sb.append(">");
                start = matcher.end();
            }
            sb.append(text.substring(start));
        }
        catch (Exception exception) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getImgExtension(String imgTag) {
        try {
            Matcher matcher = ShowHideEmoticonsJob.imgPattern.matcher(imgTag);
            if (matcher.find()) {
                String filepath;
                int index;
                String img = matcher.group();
                int srcindex = img.indexOf("src=\"");
                int endindex = -1;
                if (srcindex > -1 && (index = (filepath = img.substring(srcindex += "src=\"".length(), endindex = img.indexOf("\"", srcindex))).lastIndexOf(".")) > -1) {
                    String ext = filepath.substring(index);
                    if (ext.length() <= 3) return ext;
                    return null;
                }
            }
            if (imgTag.indexOf("IMAGE [") != 0) return null;
            int index = imgTag.lastIndexOf(".");
            if (index <= -1) return null;
            return imgTag.substring(index, imgTag.indexOf("]", index));
        }
        catch (Throwable throwable) {}
        return null;
    }

    private String replaceImgSrc(String before, String filename) {
        block5: {
            Matcher matcher = ShowHideEmoticonsJob.imgPattern.matcher(before);
            StringBuffer sb = new StringBuffer();
            try {
                int start = 0;
                boolean found = false;
                while (matcher.find()) {
                    found = true;
                    String img = matcher.group();
                    String substr = before.substring(start, matcher.start());
                    sb.append(substr);
                    int srcindex = img.indexOf("src=\"");
                    int endindex = -1;
                    if (srcindex > -1) {
                        endindex = img.indexOf("\"", srcindex += "src=\"".length());
                        sb.append(img.substring(0, srcindex));
                        sb.append(filename);
                        sb.append(img.substring(endindex));
                    }
                    start = matcher.end();
                }
                if (found) {
                    sb.append(before.substring(start));
                    String returnString = sb.toString();
                    sb = null;
                    return returnString;
                }
                sb = null;
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.WARNING)) break block5;
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
        return null;
    }

    public static void main(String[] args) {
    }
}

