/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.chatwindow;

import com.ibm.collaboration.realtime.chatwindow.ChatWindowPreferences;
import com.ibm.collaboration.realtime.chatwindow.ImChatPlugin;
import com.ibm.collaboration.realtime.chatwindow.strings.Messages;
import com.ibm.collaboration.realtime.util.AudioManager;
import com.ibm.collaboration.realtime.util.OSUtils;
import java.io.File;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class ChatWindowAlertPreferences
extends PreferencePage
implements IWorkbenchPreferencePage {
    Button setOnTop;
    Button flashWindow;
    Button showSystray;
    Button playSound;
    Button changeSoundFile;
    Text soundFileText;

    public ChatWindowAlertPreferences() {
        super(Messages.prefs_chat_window_notification);
        this.setPreferenceStore(ImChatPlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout());
        control.setLayoutData((Object)new GridData(1808));
        Group incomingChatSettings = new Group(control, 0);
        incomingChatSettings.setText(Messages.prefs_incoming_settings);
        incomingChatSettings.setLayout((Layout)new FormLayout());
        incomingChatSettings.setLayoutData((Object)new GridData(768));
        Label whenChat = new Label((Composite)incomingChatSettings, 0);
        whenChat.setText(Messages.prefs_when_chat);
        this.setOnTop = new Button((Composite)incomingChatSettings, 32);
        this.setOnTop.setText(Messages.prefs_setontop);
        this.flashWindow = new Button((Composite)incomingChatSettings, 32);
        this.flashWindow.setText(Messages.prefs_flash_window);
        this.showSystray = new Button((Composite)incomingChatSettings, 32);
        this.showSystray.setText(Messages.prefs_show_tray_icon);
        this.playSound = new Button((Composite)incomingChatSettings, 32);
        this.playSound.setText(Messages.prefs_play_sound);
        this.playSound.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ChatWindowAlertPreferences.this.changeSoundFile.setEnabled(ChatWindowAlertPreferences.this.playSound.getSelection());
                ChatWindowAlertPreferences.this.soundFileText.setEnabled(ChatWindowAlertPreferences.this.playSound.getSelection());
            }
        });
        this.changeSoundFile = new Button((Composite)incomingChatSettings, 8);
        this.changeSoundFile.setText(Messages.prefs_change);
        this.changeSoundFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                String fileName;
                FileDialog fd = new FileDialog(ChatWindowAlertPreferences.this.getShell(), 4096);
                if (!ChatWindowAlertPreferences.this.soundFileText.getText().equals(Messages.file_none)) {
                    File f;
                    String filePath = ChatWindowAlertPreferences.this.soundFileText.getText();
                    if (filePath.startsWith("audio")) {
                        filePath = String.valueOf(OSUtils.getInstallPath()) + File.separator + filePath;
                    }
                    if ((f = new File(filePath)).exists()) {
                        fd.setFileName(f.getAbsolutePath());
                        f = f.getParentFile();
                        if (f.exists()) {
                            fd.setFilterPath(f.getAbsolutePath());
                        }
                    }
                }
                if ((fileName = fd.open()) != null) {
                    ChatWindowAlertPreferences.this.soundFileText.setText(fileName);
                }
            }
        });
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 10);
        fd.right = new FormAttachment(100, -10);
        whenChat.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)whenChat, 10);
        fd.left = new FormAttachment(0, 10);
        fd.right = new FormAttachment(100, -10);
        this.setOnTop.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.setOnTop, 6);
        fd.left = new FormAttachment(0, 10);
        fd.right = new FormAttachment(100, -10);
        this.flashWindow.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.flashWindow, 6);
        fd.left = new FormAttachment(0, 10);
        fd.right = new FormAttachment(100, -10);
        this.showSystray.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.showSystray, 6);
        fd.left = new FormAttachment(0, 10);
        fd.right = new FormAttachment(100, -10);
        this.playSound.setLayoutData((Object)fd);
        Label labelSoundFile = new Label((Composite)incomingChatSettings, 0);
        labelSoundFile.setText(Messages.prefs_sound_file);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.playSound, 6);
        fd.left = new FormAttachment((Control)this.playSound, 4, 16384);
        labelSoundFile.setLayoutData((Object)fd);
        this.soundFileText = new Text((Composite)incomingChatSettings, 2048);
        this.soundFileText.setText(this.getPreferenceStore().getString(ChatWindowPreferences.PREF_SOUND_FILE));
        fd = new FormData();
        fd.top = new FormAttachment((Control)labelSoundFile, 0, 0x1000000);
        fd.left = new FormAttachment((Control)labelSoundFile, 3);
        fd.right = new FormAttachment((Control)this.changeSoundFile, -3);
        this.soundFileText.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment((Control)this.soundFileText, 0, 0x1000000);
        fd.right = new FormAttachment(100, -3);
        this.changeSoundFile.setLayoutData((Object)fd);
        this.setOnTop.setSelection(this.getPreferenceStore().getBoolean(ChatWindowPreferences.PREF_BRING_TO_FRONT));
        this.flashWindow.setSelection(this.getPreferenceStore().getBoolean(ChatWindowPreferences.PREF_FLASH_WINDOW));
        this.showSystray.setSelection(this.getPreferenceStore().getBoolean(ChatWindowPreferences.PREF_TRAY_ICON));
        this.playSound.setSelection(this.getPreferenceStore().getBoolean(ChatWindowPreferences.PREF_PLAY_SOUND));
        return control;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        String filePath;
        boolean shouldPlaySound = this.playSound.getSelection();
        this.getPreferenceStore().setValue(ChatWindowPreferences.PREF_PLAY_SOUND, shouldPlaySound);
        if (shouldPlaySound && (filePath = this.soundFileText.getText()) != null) {
            File audioFile;
            String realPath = null;
            this.getPreferenceStore().setValue(ChatWindowPreferences.PREF_SOUND_FILE, this.soundFileText.getText());
            AudioManager audioManager = ImChatPlugin.getDefault().getImChatController()._audioManager;
            if (filePath.startsWith("audio")) {
                File soundFile;
                realPath = String.valueOf(OSUtils.getInstallPath()) + File.separator + filePath;
                if (!(realPath == null || (soundFile = new File(realPath)).exists() && soundFile.canRead())) {
                    realPath = null;
                }
                if (realPath == null) {
                    realPath = OSUtils.getFilePath((Plugin)ImChatPlugin.getDefault(), (String)filePath);
                }
            } else {
                realPath = OSUtils.getFilePath((Plugin)ImChatPlugin.getDefault(), (String)filePath);
            }
            if (realPath != null && (audioFile = new File(realPath)).exists() && audioFile.canRead()) {
                audioManager.removeAudioClip("MessageReceived");
                audioManager.addAudioClip("MessageReceived", realPath);
            }
        }
        this.getPreferenceStore().setValue(ChatWindowPreferences.PREF_BRING_TO_FRONT, this.setOnTop.getSelection());
        this.getPreferenceStore().setValue(ChatWindowPreferences.PREF_FLASH_WINDOW, this.flashWindow.getSelection());
        this.getPreferenceStore().setValue(ChatWindowPreferences.PREF_TRAY_ICON, this.showSystray.getSelection());
        return super.performOk();
    }
}

