/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.chat.actions;

import com.ibm.collaboration.realtime.chat.actions.ChatActionDelegate;
import com.ibm.collaboration.realtime.chat.actions.ChatActionEventDelegate;
import com.ibm.collaboration.realtime.chat.actions.ChatActionWindowDelegate;
import com.ibm.collaboration.realtime.chatwindow.ChatWindowHandler;
import com.ibm.collaboration.realtime.chatwindow.ImChatWindowHandler;
import com.ibm.collaboration.realtime.chatwindow.addon.ChatWindowExtension;
import com.ibm.collaboration.realtime.magiccarpet.MessageEvent;
import com.ibm.collaboration.realtime.people.PeopleUtil;
import com.ibm.collaboration.realtime.people.Person;
import com.ibm.collaboration.realtime.people.PersonInternal;
import com.ibm.collaboration.realtime.ui.util.SwtUtils;
import com.ibm.rcp.jface.action.SActionContributionItem;
import com.ibm.rcp.jface.action.SToolBarManager;
import com.ibm.rcp.swt.swidgets.SToolBar;
import com.ibm.rcp.swt.swidgets.SToolItem;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;

public class ChatWindowAction
extends Action
implements ChatWindowExtension {
    public static int CHAT_ACTION = 0;
    public static int FORMAT_ACTION = 1;
    public static int NWAY_ACTION = 2;
    public static int MENU_ACTION = 3;
    public static int CHAT_ACTION_OTHER = 4;
    private String requiredCaps;
    private MessageEvent event;
    private ImChatWindowHandler chatwindow;
    private MenuManager manager;
    private int buttonType = 0;
    private String path;
    private String menupath;
    private String activity = null;
    private boolean isVisible = true;
    private StyledText textArea;
    public static int ENABLES_SINGLE = 1;
    public static int ENABLES_MULTI = 2;
    public static int ENABLES_BOTH = 3;
    private int showsFor = ENABLES_BOTH;
    private SToolBarManager parentManager;
    private ChatActionDelegate actionDelegate;

    public ChatWindowAction() {
    }

    public ChatWindowAction(MessageEvent me) {
        this.event = me;
    }

    public ChatWindowAction(ImChatWindowHandler chatwindow) {
        this.chatwindow = chatwindow;
    }

    public ChatWindowAction(int style) {
        super(null, style);
    }

    public ChatWindowAction(String label, int style) {
        super(label, style);
    }

    public MessageEvent getMessageEvent() {
        return this.event;
    }

    public ChatWindowHandler getChatWindowHandler() {
        return this.chatwindow;
    }

    public ImChatWindowHandler getChatWindowHandlerInternal() {
        return this.chatwindow;
    }

    public void setMessageEvent(MessageEvent me) {
        this.event = me;
    }

    public ImageDescriptor getImageDescriptor() {
        if (super.getImageDescriptor() != null) {
            if (SwtUtils.usingHighContrast()) {
                return SwtUtils.getScaledImageDescriptor((ImageDescriptor)super.getImageDescriptor());
            }
            return super.getImageDescriptor();
        }
        return null;
    }

    public ImageDescriptor getDisabledImageDescriptor() {
        if (super.getDisabledImageDescriptor() != null) {
            if (SwtUtils.usingHighContrast()) {
                return SwtUtils.getScaledImageDescriptor((ImageDescriptor)super.getDisabledImageDescriptor());
            }
            return super.getDisabledImageDescriptor();
        }
        return null;
    }

    public void setChatWindowHandler(ChatWindowHandler chat) {
        this.chatwindow = (ImChatWindowHandler)chat;
    }

    public void setMenuManager(MenuManager menuManager) {
        this.manager = menuManager;
        this.setMenuCreator(new IMenuCreator(){

            public void dispose() {
                if (ChatWindowAction.this.manager.getMenu() != null) {
                    ChatWindowAction.this.manager.getMenu().dispose();
                    ChatWindowAction.this.manager.dispose();
                }
            }

            public Menu getMenu(Control parent) {
                return ChatWindowAction.this.manager.createContextMenu(parent);
            }

            public Menu getMenu(Menu parent) {
                return this.getMenu((Control)parent.getShell());
            }
        });
    }

    public MenuManager getMenuManager() {
        return this.manager;
    }

    public void setButtonType(int type) {
        this.buttonType = type;
    }

    public int getButtonType() {
        return this.buttonType;
    }

    public void setActionDelegate(ChatActionDelegate delegate) {
        this.actionDelegate = delegate;
    }

    public ChatActionDelegate getActionDelegate() {
        return this.actionDelegate;
    }

    public void run() {
        ChatActionDelegate delegate = this.getActionDelegate();
        if (delegate instanceof ChatActionWindowDelegate) {
            ((ChatActionWindowDelegate)delegate).run((IAction)this, this.chatwindow);
        } else if (delegate instanceof ChatActionEventDelegate) {
            ((ChatActionEventDelegate)delegate).run((IAction)this, this.event);
        }
    }

    public void setRequiredCapabilities(String caps) {
        this.requiredCaps = caps;
    }

    public String getRequiredCapabilities() {
        return this.requiredCaps;
    }

    public String getToolbarPath() {
        return this.path;
    }

    public void setToolbarPath(String path) {
        if (path != null && path.length() == 0) {
            path = null;
        }
        this.path = path;
    }

    public String getMenubarPath() {
        return this.menupath;
    }

    public void setMenubarPath(String path) {
        if (path != null && path.length() == 0) {
            path = null;
        }
        this.menupath = path;
    }

    public String getActivity() {
        return this.activity;
    }

    public void setActivity(String activity) {
        this.activity = activity;
    }

    public void dispose() {
        this.chatwindow = null;
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    public boolean isCapable(Person person) {
        String[] caps;
        if (person == null) {
            return false;
        }
        boolean capable = true;
        if (this.requiredCaps != null && (caps = this.requiredCaps.split(",")) != null && caps.length > 0) {
            int i = 0;
            while (i < caps.length) {
                capable = ((PersonInternal)person).isCapabilitySupported(caps[i]);
                ++i;
            }
        }
        return capable;
    }

    public boolean isRTCTransferCapable(Person person) {
        return PeopleUtil.hasCapability((Person)person, (String)"fileTransfer");
    }

    public boolean isP2pTransferCapable(Person person) {
        return PeopleUtil.hasCapability((Person)person, (String)"p2pFileTransfer");
    }

    public void setShowsFor(String enable) {
        if ("single".equals(enable)) {
            this.showsFor = ENABLES_SINGLE;
        } else if ("multi".equals(enable)) {
            this.showsFor = ENABLES_MULTI;
        } else if ("both".equals(enable)) {
            this.showsFor = ENABLES_BOTH;
        }
    }

    public int getShowsFor() {
        return this.showsFor;
    }

    public void doEnablement() {
        boolean isEnabled = this.isEnabled();
        if (this.getChatWindowHandler() != null) {
            isEnabled = this.isCapable(this.getChatWindowHandler().getFirstPartner().getPerson());
            isEnabled = this.getChatWindowHandlerInternal().isMultiChat() ? this.getShowsFor() != ENABLES_SINGLE : this.getShowsFor() != ENABLES_MULTI;
        }
        this.setEnabled(isEnabled);
    }

    public void setSToolBarManager(SToolBarManager mgr) {
        this.parentManager = mgr;
    }

    public Rectangle getToolItemBounds() {
        SToolBar bar;
        if (this.parentManager != null && (bar = (SToolBar)this.parentManager.getControl2()) != null) {
            SToolItem[] items = bar.getItems();
            int i = 0;
            while (i < items.length) {
                SActionContributionItem sac;
                if (items[i].getData() instanceof SActionContributionItem && (sac = (SActionContributionItem)items[i].getData()).getId() != null && sac.getId().equals(this.getId())) {
                    Rectangle rect = items[i].getBounds();
                    Point toDisp = bar.toDisplay(rect.x, rect.y);
                    rect.x = toDisp.x;
                    rect.y = toDisp.y;
                    return rect;
                }
                ++i;
            }
        }
        return null;
    }

    public void setStyledText(StyledText text) {
        this.textArea = text;
    }

    public StyledText getStyledText() {
        return this.textArea;
    }
}

