/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.collaboration.common.uri;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import org.eclipse.core.runtime.Assert;

public final class CollaborationUriUtilities {
    private static final String JAZZ_COMMENT_SCHEMA = "comment";
    private static final String JAZZ_STACKTRACE_SCHEMA = "javaline";
    private static final String JAZZ_WORKITEM_COMMENT = "/jazz/action/com.ibm.team.workitem.WorkItem/";
    private static final String JAZZ_WORKITEM_NAME = "itemName/com.ibm.team.workitem.WorkItem/";
    private static final String JAZZ_WORKITEM_OID = "itemOid/com.ibm.team.workitem.WorkItem/";

    public static String createStacktraceElementURI(String line) {
        Assert.isNotNull((Object)line);
        try {
            StringBuffer buffer = new StringBuffer(64);
            buffer.append(JAZZ_STACKTRACE_SCHEMA);
            buffer.append("://");
            buffer.append(URLEncoder.encode(line, "UTF-8"));
            return buffer.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Assert.isTrue((boolean)false);
            return null;
        }
    }

    public static String createWorkItemCommentURI(String comment) {
        Assert.isLegal((comment != null || !"".equals(comment) ? 1 : 0) != 0, (String)"Comment must be non-null and non-empty");
        try {
            StringBuffer buffer = new StringBuffer(64);
            buffer.append(JAZZ_COMMENT_SCHEMA);
            buffer.append("://localhost");
            buffer.append(JAZZ_WORKITEM_COMMENT);
            buffer.append(URLEncoder.encode(comment, "UTF-8"));
            return buffer.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Assert.isTrue((boolean)false);
            return null;
        }
    }

    public static String createWorkItemURI(URI repositoryURI, int id) {
        StringBuffer buffer = new StringBuffer(128);
        if (repositoryURI != null) {
            buffer.append(repositoryURI.toString());
            buffer.append("/resource/");
        } else {
            buffer.append("http://localhost/jazz/resource/");
        }
        buffer.append(JAZZ_WORKITEM_NAME);
        buffer.append(id);
        return buffer.toString();
    }

    public static boolean isWorkitemURI(String uri) {
        Assert.isNotNull((Object)uri);
        return uri.indexOf(JAZZ_WORKITEM_NAME) > 0 || uri.indexOf(JAZZ_WORKITEM_OID) > 0;
    }
}

