/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.chatwindow.ui;

import com.ibm.collaboration.realtime.chat.actions.ChatWindowAction;
import com.ibm.collaboration.realtime.chat.actions.RichTextAction;
import com.ibm.collaboration.realtime.chatwindow.ChatActionContributionItem;
import com.ibm.collaboration.realtime.chatwindow.ImChatActionDescriptor;
import com.ibm.collaboration.realtime.chatwindow.ImChatPlugin;
import com.ibm.collaboration.realtime.chatwindow.ImChatWindowHandler;
import com.ibm.collaboration.realtime.chatwindow.ImChatWindowMenuManager;
import com.ibm.collaboration.realtime.chatwindow.actionset.TextPropertiesAction;
import com.ibm.collaboration.realtime.chatwindow.strings.Messages;
import com.ibm.collaboration.realtime.chatwindow.ui.ForegroundColorIcon;
import com.ibm.collaboration.realtime.chatwindow.ui.StyledTextChatArea;
import com.ibm.collaboration.realtime.ui.STStyleManager;
import com.ibm.collaboration.realtime.ui.util.ColorCache;
import com.ibm.collaboration.realtime.ui.util.SwtUtils;
import com.ibm.rcp.jface.action.SActionContributionItem;
import com.ibm.rcp.jface.action.SToolBarManager;
import com.ibm.rcp.swt.swidgets.SToolBar;
import com.ibm.rcp.swt.swidgets.SToolItem;
import com.ibm.rcp.swt.swidgets.StyledWidget;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MenuItem;

public class ToolPallete
extends Composite
implements IPropertyChangeListener {
    private boolean isRichTextEnabled = false;
    private ForegroundColorIcon foregroundColorIcon;
    private ForegroundColorIcon backgroundColorIcon;
    private boolean addedMenuListener = false;
    private boolean isHighContrast = false;
    private static final Logger logger;
    private final SActionContributionItem underlineAction = new SActionContributionItem((IAction)new UnderlineAction());
    private final SActionContributionItem boldAction = new SActionContributionItem((IAction)new BoldAction());
    private final SActionContributionItem italicAction = new SActionContributionItem((IAction)new ItalicAction());
    private final ReduceFontSizeAction reduceFontSizeAction = new ReduceFontSizeAction();
    private final IncreaseFontSizeAction increaseFontSizeAction = new IncreaseFontSizeAction();
    private final DefaultFontAction defaultFontAction = new DefaultFontAction();
    private final TextBackgroundColorAction textBackgroundColorAction = new TextBackgroundColorAction();
    private final TextForgroundColorAction textForgroundColorAction = new TextForgroundColorAction();
    private final TextPropertiesAction textPropertiesAction = new TextPropertiesAction(Messages.edit_text_properties, 1){

        public ImageDescriptor getImageDescriptor() {
            if (SwtUtils.usingHighContrast()) {
                return SwtUtils.getScaledImageDescriptor((ImageDescriptor)ImChatPlugin.getImageDesc("images/toolbar/tb_18_textbox_n.png"));
            }
            return ImChatPlugin.getImageDesc("images/toolbar/tb_18_textbox_n.png");
        }

        public ImageDescriptor getDisabledImageDescriptor() {
            if (SwtUtils.usingHighContrast()) {
                return SwtUtils.getScaledImageDescriptor((ImageDescriptor)ImChatPlugin.getImageDesc("images/toolbar/tb_18_textbox_d.png"));
            }
            return ImChatPlugin.getImageDesc("images/toolbar/tb_18_textbox_d.png");
        }
    };
    private final ChatActionContributionItem bgColorItem = new ChatActionContributionItem((IAction)this.textBackgroundColorAction);
    private final ChatActionContributionItem fgColorItem = new ChatActionContributionItem((IAction)this.textForgroundColorAction);
    private ChatActionContributionItem textPropsItem = null;
    private final SToolBar toolBar;
    private SToolBarManager _manager;
    StyledTextChatArea _textAreaControl;
    private ImChatWindowHandler _handler;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.collaboration.realtime.chatwindow.ui.ToolPallete");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public ToolPallete(Composite parent, int style) {
        this(parent, style, null);
    }

    public ToolPallete(Composite parent, int style, ImChatWindowHandler handler) {
        super(parent, style);
        this._handler = handler;
        FormLayout layout = new FormLayout();
        layout.marginBottom = 1;
        this.setLayout((Layout)layout);
        if (!this.isHighContrast) {
            this.setBackground(ColorCache.getColor((String)"DARK_SEPARATOR_BACKGROUND"));
        }
        this._manager = new SToolBarManager(0x800000);
        this._manager.add((IContributionItem)new Separator("color"));
        this._manager.add((IContributionItem)new Separator("font"));
        this._manager.add((IContributionItem)new Separator("style"));
        this._manager.add((IContributionItem)new Separator("insert"));
        this._manager.add((IContributionItem)new GroupMarker("insertStart"));
        this._manager.add((IContributionItem)new GroupMarker("insertMiddle"));
        this._manager.add((IContributionItem)new GroupMarker("insertEnd"));
        this._manager.add((IContributionItem)new Separator("send"));
        this._manager.add((IContributionItem)new GroupMarker("sendStart"));
        this._manager.add((IContributionItem)new GroupMarker("sendMiddle"));
        this._manager.add((IContributionItem)new GroupMarker("sendEnd"));
        this._manager.add((IContributionItem)new Separator("additions"));
        this._manager.add((IContributionItem)new Separator("end"));
        ArrayList actions = ImChatPlugin.getDefault().getChatWindowActions();
        if (actions != null) {
            int i = 0;
            while (i < actions.size()) {
                ImChatActionDescriptor a = (ImChatActionDescriptor)actions.get(i);
                if (a.getButtonType() == ChatWindowAction.FORMAT_ACTION) {
                    this.addToolBarItem(a);
                }
                ++i;
            }
        }
        this._manager.prependToGroup("color", (IContributionItem)this.bgColorItem);
        this._manager.prependToGroup("color", (IContributionItem)this.fgColorItem);
        this._manager.prependToGroup("style", (IContributionItem)this.underlineAction);
        this._manager.prependToGroup("style", (IContributionItem)this.italicAction);
        this._manager.prependToGroup("style", (IContributionItem)this.boldAction);
        this._manager.appendToGroup("font", (IContributionItem)new ChatActionContributionItem((IAction)this.defaultFontAction));
        this.textPropertiesAction.setChatWindowHandler(this._handler);
        this.textPropsItem = new ChatActionContributionItem((IAction)this.textPropertiesAction);
        this._manager.appendToGroup("font", (IContributionItem)this.textPropsItem);
        this._manager.appendToGroup("font", (IContributionItem)new ChatActionContributionItem((IAction)this.increaseFontSizeAction));
        this._manager.appendToGroup("font", (IContributionItem)new ChatActionContributionItem((IAction)this.reduceFontSizeAction));
        this.toolBar = (SToolBar)this._manager.createControl2((Composite)this);
        STStyleManager.setStyles((StyledWidget)this.toolBar);
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.left = new FormAttachment(0, 0);
        this.toolBar.setLayoutData((Object)fd);
        SToolBar overflow = SwtUtils.createOverflowButton((SToolBar)this.toolBar);
        STStyleManager.setStyles((StyledWidget)overflow);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (ToolPallete.this.foregroundColorIcon != null) {
                    ToolPallete.this.foregroundColorIcon.dispose();
                    ToolPallete.this.foregroundColorIcon = null;
                }
                if (ToolPallete.this.backgroundColorIcon != null) {
                    ToolPallete.this.backgroundColorIcon.dispose();
                    ToolPallete.this.backgroundColorIcon = null;
                }
                if (ToolPallete.this._manager != null) {
                    ToolPallete.this._manager.dispose();
                    ToolPallete.this._manager = null;
                }
                if (ToolPallete.this.textPropsItem != null) {
                    ToolPallete.this.textPropsItem.dispose();
                    ToolPallete.this.textPropsItem = null;
                }
                ToolPallete.this._handler = null;
            }
        });
    }

    protected void setlectDefaultFont() {
    }

    protected void selectBackgroundColor() {
        ColorDialog colorDlg = new ColorDialog(this.getShell(), 65536);
        colorDlg.setRGB(this._textAreaControl.getBackground().getRGB());
        RGB rgb = colorDlg.open();
        if (rgb == null) {
            return;
        }
        Point p = this._textAreaControl.getSelectionRange();
        Color color = new Color((Device)Display.getCurrent(), rgb);
        this._textAreaControl.setStyleRange(new StyleRange(p.x, p.y, this._textAreaControl.getForeground(), color));
    }

    protected void selectForgroundColor() {
        ColorDialog colorDlg = new ColorDialog(this.getShell(), 65536);
        colorDlg.setRGB(this._textAreaControl.getForeground().getRGB());
        RGB rgb = colorDlg.open();
        if (rgb == null) {
            return;
        }
        Point p = this._textAreaControl.getSelectionRange();
        Color color = new Color((Device)Display.getCurrent(), rgb);
        this._textAreaControl.setStyleRange(new StyleRange(p.x, p.y, color, this._textAreaControl.getBackground()));
    }

    public void dispose() {
        super.dispose();
    }

    protected void checkSubclass() {
    }

    public void setControl(StyledTextChatArea textAreaControl) {
        this._textAreaControl = textAreaControl;
        this._textAreaControl.addPropertyChangeListener(this);
        if (this._textAreaControl.getMenu() != null && !this.addedMenuListener) {
            this._textAreaControl.getMenu().addMenuListener(new MenuListener(){

                public void menuShown(MenuEvent e) {
                    if (!ToolPallete.this._handler.isMultiChat()) {
                        MenuItem[] items = ToolPallete.this._textAreaControl.getMenu().getItems();
                        int i = 0;
                        while (i < items.length) {
                            if (items[i].getText().compareTo(Messages.edit_text_properties) == 0) {
                                return;
                            }
                            ++i;
                        }
                        new MenuItem(ToolPallete.this._textAreaControl.getMenu(), 2);
                        MenuItem item = new MenuItem(ToolPallete.this._textAreaControl.getMenu(), 0);
                        item.setText(Messages.edit_text_properties);
                        item.addSelectionListener((SelectionListener)new SelectionAdapter(this){
                            final /* synthetic */ 3 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void widgetSelected(SelectionEvent e) {
                                ToolPallete.access$13(3.access$0(this.this$1)).run();
                            }
                        });
                    }
                }

                public void menuHidden(MenuEvent e) {
                }

                static /* synthetic */ ToolPallete access$0(3 var0) {
                    return var0.ToolPallete.this;
                }
            });
            this.addedMenuListener = true;
        }
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty() != null) {
            if (event.getProperty().equals("style")) {
                StyleRange sr = (StyleRange)event.getNewValue();
                this.boldAction.update("checked");
                this.italicAction.update("checked");
                this.underlineAction.update("checked");
                if (sr != null) {
                    if (sr.background != null) {
                        this.textBackgroundColorAction.setBackgroundColor(sr.background);
                    } else {
                        this.textBackgroundColorAction.setBackgroundColor(Display.getDefault().getSystemColor(25));
                    }
                    if (sr.foreground != null) {
                        this.textForgroundColorAction.setForegroundColor(sr.foreground);
                    } else {
                        this.textForgroundColorAction.setForegroundColor(Display.getDefault().getSystemColor(24));
                    }
                } else {
                    this.textBackgroundColorAction.setBackgroundColor(Display.getDefault().getSystemColor(25));
                    if (this._textAreaControl.getForeground() != null) {
                        this.textForgroundColorAction.setForegroundColor(this._textAreaControl.getForeground());
                    } else {
                        this.textForgroundColorAction.setForegroundColor(Display.getDefault().getSystemColor(24));
                    }
                }
            } else if (event.getProperty().equals("HC")) {
                Boolean newProp = (Boolean)event.getNewValue();
                if (newProp != null) {
                    this.isHighContrast = newProp;
                }
                this.bgColorItem.update("enabled");
                this.fgColorItem.update("enabled");
                if (this.textPropsItem != null) {
                    this.textPropsItem.update("enabled");
                }
            }
        }
    }

    public SToolBar getSToolBar() {
        return this.toolBar;
    }

    public SToolBarManager getSToolBarManager() {
        return this._manager;
    }

    public void setRichTextEnabled(boolean enabled) {
        if (enabled != this.isRichTextEnabled) {
            this.isRichTextEnabled = enabled;
            SToolItem[] items = this.getSToolBar().getItems();
            int i = 0;
            while (i < items.length) {
                SActionContributionItem item;
                Object o = items[i].getData();
                if (o instanceof SActionContributionItem && (item = (SActionContributionItem)o).getAction() instanceof RichTextAction) {
                    item.update("enabled");
                }
                ++i;
            }
            if (this._handler != null && this._handler.getMenuManager() != null) {
                IContributionItem[] citems = this._handler.getMenuManager().getItems();
                this.updateMenuItems(citems);
            }
        }
    }

    private void updateMenuItems(IContributionItem[] citems) {
        if (citems != null) {
            int i = 0;
            while (i < citems.length) {
                if (citems[i] instanceof ActionContributionItem) {
                    ActionContributionItem actionItem = (ActionContributionItem)citems[i];
                    if (actionItem.getAction() instanceof RichTextAction) {
                        actionItem.update("enabled");
                    }
                } else if (citems[i] instanceof IMenuManager) {
                    IMenuManager mm = (IMenuManager)citems[i];
                    this.updateMenuItems(mm.getItems());
                }
                ++i;
            }
        }
    }

    public void addToolBarItem(ImChatActionDescriptor a) {
        block9: {
            if (this._manager == null) {
                return;
            }
            try {
                if (this._manager.find(a.getId()) != null) break block9;
                ChatWindowAction clone = a.getAction();
                clone.setChatWindowHandler(this._handler);
                clone.setSToolBarManager(this._manager);
                if (clone.isVisible()) {
                    block10: {
                        String path = clone.getToolbarPath();
                        path = path == null || path.length() == 0 ? "additions" : (path.indexOf("format/") == -1 ? "additions" : path.substring("format/".length()));
                        this._manager.prependToGroup(path, (IContributionItem)new ChatActionContributionItem((IAction)clone));
                        String menubarPath = clone.getMenubarPath();
                        if (menubarPath != null && this._handler != null) {
                            try {
                                ChatWindowAction menuClone = a.getAction();
                                menuClone.setChatWindowHandler(this._handler);
                                menuClone.doEnablement();
                                menuClone.setImageDescriptor(null);
                                menuClone.setDisabledImageDescriptor(null);
                                menuClone.setHoverImageDescriptor(null);
                                ImChatWindowMenuManager.appendToGroup((IMenuManager)this._handler.getMenuManager(), menubarPath, (IAction)menuClone);
                                this._handler.getMenuManager().update();
                            }
                            catch (Exception e) {
                                if (!logger.isLoggable(Level.WARNING)) break block10;
                                logger.log(Level.WARNING, e.getMessage(), e);
                            }
                        }
                    }
                    try {
                        clone.doEnablement();
                    }
                    catch (Exception exception) {
                        clone.dispose();
                        this._manager.remove(a.getId());
                    }
                    break block9;
                }
                clone.dispose();
            }
            catch (Throwable e) {
                if (!logger.isLoggable(Level.WARNING)) break block9;
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    static /* synthetic */ TextPropertiesAction access$13(ToolPallete toolPallete) {
        return toolPallete.textPropertiesAction;
    }

    private class UnderlineAction
    extends RichTextAction {
        public UnderlineAction() {
            super(null, 2);
            this.setImageDescriptor(ImChatPlugin.getImageDesc("images/toolbar/tb_18_underline_n.png"));
            this.setDisabledImageDescriptor(ImChatPlugin.getImageDesc("images/toolbar/tb_18_underline_d.png"));
            this.setToolTipText(Messages.ImChatWindowHandler_underlineTT);
        }

        public void run() {
            ToolPallete.this._textAreaControl.setUnderline(!ToolPallete.this._textAreaControl.isCurrentUnderline());
            this.firePropertyChange("checked", null, null);
            ToolPallete.this._textAreaControl.setFocus();
        }

        public boolean isChecked() {
            if (ToolPallete.this._textAreaControl != null) {
                return ToolPallete.this._textAreaControl.isCurrentUnderline();
            }
            return false;
        }

        public boolean isEnabled() {
            if (ToolPallete.this._handler != null) {
                return ToolPallete.this._handler.isRichTextEnabled();
            }
            return true;
        }

        public String getId() {
            return "toolpalette.underline";
        }
    }

    private class BoldAction
    extends RichTextAction {
        public BoldAction() {
            super(null, 2);
            this.setImageDescriptor(ImChatPlugin.getImageDesc("images/toolbar/tb_18_bold_n.png"));
            this.setDisabledImageDescriptor(ImChatPlugin.getImageDesc("images/toolbar/tb_18_bold_d.png"));
            this.setToolTipText(Messages.ImChatWindowHandler_boldTT);
        }

        public void run() {
            ToolPallete.this._textAreaControl.setBold(!ToolPallete.this._textAreaControl.isCurrentBold());
            this.firePropertyChange("checked", null, null);
            ToolPallete.this._textAreaControl.setFocus();
        }

        public boolean isChecked() {
            if (ToolPallete.this._textAreaControl != null) {
                return ToolPallete.this._textAreaControl.isCurrentBold();
            }
            return false;
        }

        public boolean isEnabled() {
            if (ToolPallete.this._handler != null) {
                return ToolPallete.this._handler.isRichTextEnabled();
            }
            return true;
        }

        public String getId() {
            return "toolpalette.bold";
        }
    }

    private class ItalicAction
    extends RichTextAction {
        public ItalicAction() {
            super(null, 2);
            this.setImageDescriptor(ImChatPlugin.getImageDesc("images/toolbar/tb_18_italic_n.png"));
            this.setDisabledImageDescriptor(ImChatPlugin.getImageDesc("images/toolbar/tb_18_italic_d.png"));
            this.setToolTipText(Messages.ImChatWindowHandler_italicTT);
        }

        public void run() {
            ToolPallete.this._textAreaControl.setItalic(!ToolPallete.this._textAreaControl.isCurrentItalic());
            this.firePropertyChange("checked", null, null);
            ToolPallete.this._textAreaControl.setFocus();
        }

        public boolean isChecked() {
            if (ToolPallete.this._textAreaControl != null) {
                return ToolPallete.this._textAreaControl.isCurrentItalic();
            }
            return false;
        }

        public boolean isEnabled() {
            if (ToolPallete.this._handler != null) {
                return ToolPallete.this._handler.isRichTextEnabled();
            }
            return true;
        }

        public String getId() {
            return "toolpalette.italic";
        }
    }

    private class ReduceFontSizeAction
    extends RichTextAction {
        public ReduceFontSizeAction() {
            super(null, 1);
            this.setImageDescriptor(ImChatPlugin.getImageDesc("images/toolbar/tb_18_reduce_text_n.png"));
            this.setDisabledImageDescriptor(ImChatPlugin.getImageDesc("images/toolbar/tb_18_reduce_text_d.png"));
            this.setToolTipText(Messages.ImChatWindowHandler_reduceFontSizeTT);
        }

        public void run() {
            ToolPallete.this._textAreaControl.decreaseFontSize();
            ToolPallete.this._textAreaControl.setFocus();
        }

        public boolean isChecked() {
            return true;
        }

        public boolean isEnabled() {
            if (ToolPallete.this._handler != null) {
                return ToolPallete.this._handler.isRichTextEnabled();
            }
            return true;
        }
    }

    private class IncreaseFontSizeAction
    extends RichTextAction {
        public IncreaseFontSizeAction() {
            super(null, 1);
            this.setImageDescriptor(ImChatPlugin.getImageDesc("images/toolbar/tb_18_enlarge_text_n.png"));
            this.setDisabledImageDescriptor(ImChatPlugin.getImageDesc("images/toolbar/tb_18_enlarge_d.png"));
            this.setToolTipText(Messages.ImChatWindowHandler_increaseFontSizeTT);
        }

        public void run() {
            ToolPallete.this._textAreaControl.increaseFontSize();
            ToolPallete.this._textAreaControl.setFocus();
        }

        public boolean isEnabled() {
            if (ToolPallete.this._handler != null) {
                return ToolPallete.this._handler.isRichTextEnabled();
            }
            return true;
        }
    }

    private class DefaultFontAction
    extends RichTextAction {
        public DefaultFontAction() {
            super(null, 1);
            this.setImageDescriptor(ImChatPlugin.getImageDesc("images/toolbar/tb_18_style_n.png"));
            this.setDisabledImageDescriptor(ImChatPlugin.getImageDesc("images/toolbar/tb_18_style_d.png"));
            this.setToolTipText(Messages.ImChatWindowHandler_returnToDefaultFontTT);
        }

        public void run() {
            if (ToolPallete.this.textBackgroundColorAction != null) {
                ToolPallete.this.textBackgroundColorAction.setBackgroundColor(Display.getDefault().getSystemColor(25));
                ToolPallete.this.textForgroundColorAction.setForegroundColor(ToolPallete.this._textAreaControl.getForeground());
            }
            ToolPallete.this._textAreaControl.resetToDefaultFontStyleAndHeight();
            ToolPallete.this._textAreaControl.setFocus();
        }

        public boolean isEnabled() {
            if (ToolPallete.this._handler != null) {
                return ToolPallete.this._handler.isRichTextEnabled();
            }
            return true;
        }
    }

    private class TextBackgroundColorAction
    extends RichTextAction {
        public TextBackgroundColorAction() {
            super(null, 1);
            ToolPallete.this.backgroundColorIcon = new ForegroundColorIcon(Display.getDefault(), "images/toolbar/Background_Color_n.png", 1, 1);
            ToolPallete.this.backgroundColorIcon.setForeground(Display.getDefault().getSystemColor(25));
            this.setImageDescriptor(ToolPallete.this.backgroundColorIcon.getImageDescriptor());
            this.setDisabledImageDescriptor(ImChatPlugin.getImageDesc("images/toolbar/Background_Color_d.png"));
            this.setToolTipText(Messages.ImChatWindowHandler_textBackgroundTT);
        }

        public void run() {
            Color foreground = ToolPallete.this._textAreaControl.selectBackgroundColor();
            if (foreground != null && ToolPallete.this.backgroundColorIcon.setForeground(foreground)) {
                this.setImageDescriptor(ToolPallete.this.backgroundColorIcon.getImageDescriptor());
                ToolPallete.this.backgroundColorIcon.disposeOfOldImage();
            }
            ToolPallete.this._textAreaControl.setFocus();
        }

        public boolean isEnabled() {
            if (ToolPallete.this.isHighContrast || SwtUtils.usingHighContrast()) {
                return false;
            }
            if (ToolPallete.this._handler != null) {
                return ToolPallete.this._handler.isRichTextEnabled();
            }
            return true;
        }

        public void setBackgroundColor(Color foreground) {
            if (foreground != null && ToolPallete.this.backgroundColorIcon.setForeground(foreground)) {
                this.setImageDescriptor(ToolPallete.this.backgroundColorIcon.getImageDescriptor());
                ToolPallete.this.backgroundColorIcon.disposeOfOldImage();
            }
        }
    }

    private class TextForgroundColorAction
    extends RichTextAction {
        public TextForgroundColorAction() {
            super(null, 1);
            ToolPallete.this.foregroundColorIcon = new ForegroundColorIcon(Display.getDefault(), "images/toolbar/Font_Color_n.png", 0, 0);
            this.setImageDescriptor(ToolPallete.this.foregroundColorIcon.getImageDescriptor());
            this.setDisabledImageDescriptor(ImChatPlugin.getImageDesc("images/toolbar/Font_Color_d.png"));
            this.setToolTipText(Messages.ImChatWindowHandler_textColorTT);
        }

        public void run() {
            Color foreground = ToolPallete.this._textAreaControl.selectForegroundColor();
            if (foreground != null && ToolPallete.this.foregroundColorIcon.setForeground(foreground)) {
                this.setImageDescriptor(ToolPallete.this.foregroundColorIcon.getImageDescriptor());
                ToolPallete.this.foregroundColorIcon.disposeOfOldImage();
            }
            ToolPallete.this._textAreaControl.setFocus();
        }

        public boolean isEnabled() {
            if (ToolPallete.this.isHighContrast || SwtUtils.usingHighContrast()) {
                return false;
            }
            if (ToolPallete.this._handler != null) {
                return ToolPallete.this._handler.isRichTextEnabled();
            }
            return true;
        }

        public void setForegroundColor(Color foreground) {
            if (foreground != null && ToolPallete.this.foregroundColorIcon.setForeground(foreground)) {
                this.setImageDescriptor(ToolPallete.this.foregroundColorIcon.getImageDescriptor());
                ToolPallete.this.foregroundColorIcon.disposeOfOldImage();
            }
        }
    }
}

