/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.chatwindow.ui;

import com.ibm.collaboration.realtime.chatwindow.ImChatPlugin;
import com.ibm.collaboration.realtime.chatwindow.strings.Messages;
import java.util.ArrayList;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class SendButton
extends Canvas {
    private Image corner;
    private Image background;
    private String sendText = Messages.sendButton;
    private boolean isFocus = false;
    private ArrayList listeners = null;
    private Region clickable = null;
    private int[] clickablePts = null;
    private boolean dispose = false;
    private static final int MARGIN = 11;

    static ImageData flip(ImageData srcData, boolean vertical) {
        int bytesPerPixel = srcData.bytesPerLine / srcData.width;
        int destBytesPerLine = srcData.width * bytesPerPixel;
        byte[] newData = new byte[srcData.data.length];
        int srcY = 0;
        while (srcY < srcData.height) {
            int srcX = 0;
            while (srcX < srcData.width) {
                int destX = 0;
                int destY = 0;
                int destIndex = 0;
                int srcIndex = 0;
                if (vertical) {
                    destX = srcX;
                    destY = srcData.height - srcY - 1;
                } else {
                    destX = srcData.width - srcX - 1;
                    destY = srcY;
                }
                destIndex = destY * destBytesPerLine + destX * bytesPerPixel;
                srcIndex = srcY * srcData.bytesPerLine + srcX * bytesPerPixel;
                System.arraycopy(srcData.data, srcIndex, newData, destIndex, bytesPerPixel);
                ++srcX;
            }
            ++srcY;
        }
        return new ImageData(srcData.width, srcData.height, srcData.depth, srcData.palette, destBytesPerLine, newData);
    }

    public SendButton(Composite parent, int style) {
        super(parent, style);
        if (!Display.getDefault().getHighContrast()) {
            if (Window.getDefaultOrientation() == 0x4000000) {
                Image image = ImChatPlugin.findImage("images/send_corner.png");
                ImageData data = SendButton.flip(image.getImageData(), false);
                this.corner = new Image((Device)this.getDisplay(), data);
                this.dispose = true;
            } else {
                this.corner = ImChatPlugin.findImage("images/send_corner.png");
                this.dispose = false;
            }
            this.background = ImChatPlugin.findImage("images/send_bg.png");
            this.resetRegion();
        }
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 9: {
                        SendButton.this.onPaint(event.gc);
                        break;
                    }
                    case 12: {
                        SendButton.this.onDispose(event);
                        break;
                    }
                    case 15: {
                        SendButton.this.onFocus(event, true);
                        break;
                    }
                    case 16: {
                        SendButton.this.onFocus(event, false);
                        break;
                    }
                    case 31: {
                        SendButton.this.onTraverse(event);
                        break;
                    }
                    case 1: {
                        SendButton.this.onKeyDown(event);
                        break;
                    }
                    case 4: {
                        SendButton.this.onMouseUp(event);
                    }
                }
            }
        };
        int[] events = new int[]{9, 12, 15, 16, 31, 1, 4};
        int i = 0;
        while (i < events.length) {
            this.addListener(events[i], listener);
            ++i;
        }
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getValue(AccessibleControlEvent arg0) {
                arg0.result = SendButton.this.sendText;
            }

            public void getRole(AccessibleControlEvent arg0) {
                arg0.detail = 43;
            }

            public void getDefaultAction(AccessibleControlEvent arg0) {
                arg0.result = "Press";
            }
        });
        this.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent arg0) {
                arg0.result = SendButton.this.sendText;
            }
        });
    }

    private void onPaint(GC gc) {
        Rectangle rect = this.getClientArea();
        if (this.isEnabled()) {
            gc.setBackground(this.getDisplay().getSystemColor(25));
        } else {
            gc.setBackground(this.getDisplay().getSystemColor(22));
        }
        gc.fillRectangle(rect);
        int cornerWidth = 11;
        if (this.corner != null) {
            cornerWidth = this.corner.getImageData().width;
            gc.drawImage(this.corner, rect.x, rect.y);
            gc.drawImage(this.background, 0, 0, this.background.getImageData().width, this.background.getImageData().height, rect.x + this.corner.getImageData().width, rect.y, rect.width - cornerWidth, rect.height);
        }
        FontData fd = gc.getFont().getFontData()[0];
        fd.setStyle(1);
        Font f = new Font((Device)this.getDisplay(), fd);
        gc.setFont(f);
        Point ext = gc.textExtent(this.sendText);
        if (this.getDisplay().getHighContrast()) {
            gc.setForeground(this.getDisplay().getSystemColor(24));
        } else {
            gc.setForeground(this.getDisplay().getSystemColor(25));
        }
        if (this.getDisplay().getHighContrast()) {
            gc.drawText(this.sendText, rect.x + cornerWidth, (rect.y + rect.height - ext.y) / 2, true);
        } else {
            gc.drawText(this.sendText, rect.x + cornerWidth, (rect.y + 18 - ext.y) / 2, true);
        }
        int yoffset = 2;
        if (Display.getDefault().getHighContrast()) {
            gc.drawRectangle(rect.x, rect.y, rect.width - 1, rect.height - 1);
            yoffset = 11;
        }
        if (this.isFocus) {
            gc.setForeground(this.getDisplay().getSystemColor(21));
            gc.drawFocus(rect.x + cornerWidth - 2, rect.y + yoffset, ext.x + 4, ext.y + 2);
        }
        f.dispose();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (!Display.getDefault().getHighContrast()) {
            if (Window.getDefaultOrientation() == 0x4000000) {
                if (this.corner != null && this.dispose) {
                    this.corner.dispose();
                }
                Image image = this.getCornerImage();
                ImageData data = SendButton.flip(image.getImageData(), false);
                this.corner = new Image((Device)this.getDisplay(), data);
                this.dispose = true;
            } else {
                this.corner = this.getCornerImage();
                this.dispose = false;
            }
            this.background = this.getBackgImage();
            this.resetRegion();
        }
        this.redraw();
    }

    private Image getCornerImage() {
        if (Display.getDefault().getHighContrast()) {
            return null;
        }
        if (this.isEnabled()) {
            return ImChatPlugin.findImage("images/send_corner.png");
        }
        return ImChatPlugin.findImage("images/send_corner_off.png");
    }

    private Image getBackgImage() {
        if (Display.getDefault().getHighContrast()) {
            return null;
        }
        if (this.isEnabled()) {
            return ImChatPlugin.findImage("images/send_bg.png");
        }
        return ImChatPlugin.findImage("images/send_bg_off.png");
    }

    public void setText(String text) {
        this.sendText = text;
        this.resetRegion();
        this.setToolTipText(this.sendText);
    }

    public String getText() {
        return this.sendText;
    }

    public void addSelectionListener(SelectionListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList(1);
        }
        this.listeners.add(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
            if (this.listeners.isEmpty()) {
                this.listeners = null;
            }
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        if (wHint != -1 || hHint != -1) {
            return new Point(wHint, hHint);
        }
        Point pt = new Point(0, 0);
        GC gc = new GC((Drawable)this);
        FontData fd = gc.getFont().getFontData()[0];
        fd.setStyle(1);
        Font f = new Font((Device)this.getDisplay(), fd);
        gc.setFont(f);
        Point ext = gc.textExtent(this.sendText);
        f.dispose();
        gc.dispose();
        if (this.corner != null) {
            pt.x = this.corner.getImageData().width + 11 + ext.x;
            pt.y = this.corner.getImageData().height;
        } else {
            pt.x = 22 + ext.x;
            pt.y = 22 + ext.y;
        }
        return pt;
    }

    public Point computeSize(int wHint, int hHint) {
        return this.computeSize(wHint, hHint, true);
    }

    private void onDispose(Event event) {
        if (this.dispose && this.corner != null) {
            this.corner.dispose();
        }
        this.corner = null;
        this.background = null;
        if (this.clickable != null && !this.clickable.isDisposed()) {
            this.clickable.dispose();
            this.clickable = null;
        }
    }

    private void onTraverse(Event event) {
        switch (event.detail) {
            case 2: 
            case 8: 
            case 16: 
            case 256: 
            case 512: {
                event.doit = true;
                break;
            }
            case 4: {
                this.doSelection(event);
            }
        }
    }

    private void onFocus(Event event, boolean focus) {
        this.isFocus = focus;
        this.redraw();
    }

    private void onKeyDown(Event event) {
        if (this.isFocus && this.isEnabled() && event.character == ' ') {
            this.doSelection(event);
        }
    }

    private void onMouseUp(Event event) {
        if (this.isEnabled() && this.clickable != null && this.clickable.contains(event.x, event.y)) {
            this.doSelection(event);
        }
    }

    private void doSelection(Event event) {
        if (this.isEnabled()) {
            this.notifyListeners(13, event);
            if (this.listeners != null) {
                int i = 0;
                while (i < this.listeners.size()) {
                    SelectionListener l = (SelectionListener)this.listeners.get(i);
                    SelectionEvent e = new SelectionEvent(event);
                    l.widgetSelected(e);
                    ++i;
                }
            }
        }
    }

    private void resetRegion() {
        if (this.clickable != null && !this.clickable.isDisposed()) {
            this.clickable.dispose();
        }
        if (Display.getDefault().getHighContrast()) {
            this.clickable = new Region((Device)this.getDisplay());
            Point size = this.computeSize(-1, -1);
            Rectangle rect = new Rectangle(0, 0, size.x, size.y);
            this.clickable.add(rect);
            return;
        }
        int cornerWidth = this.corner.getImageData().width;
        Point size = this.computeSize(-1, -1);
        Rectangle rect = new Rectangle(0, 0, size.x, size.y);
        this.clickablePts = new int[]{rect.x + 1, rect.y + 1, rect.x + rect.width + 1, rect.y + 1, rect.x + rect.width + 1, rect.y + rect.height - 1, rect.x + cornerWidth - 2, rect.y + rect.height - 1};
        this.clickable = new Region((Device)this.getDisplay());
        this.clickable.add(this.clickablePts);
    }
}

