/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.chatwindow.addon;

import com.ibm.collaboration.realtime.chatwindow.ChatWindowHandler;
import com.ibm.collaboration.realtime.chatwindow.ImChatPlugin;
import com.ibm.collaboration.realtime.chatwindow.ImChatWindowHandler;
import com.ibm.collaboration.realtime.chatwindow.addon.ChatWindowExtension;
import com.ibm.collaboration.realtime.chatwindow.addon.Embeddable;
import com.ibm.collaboration.realtime.chatwindow.strings.LogMessages;
import com.ibm.collaboration.realtime.chatwindow.strings.Messages;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Display;

public abstract class FileEmbeddable
implements Embeddable,
ChatWindowExtension {
    static final Logger logger;
    String filename;
    String filesize;
    long filesizeLong = 0L;
    String filepath;
    String ext;
    ImageData fileImage;
    ImChatWindowHandler handler;
    private Image image;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.collaboration.realtime.chatwindow.ImChatWindowHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public FileEmbeddable(File file) {
        this(file.getName(), null);
        long kbsize;
        this.filesizeLong = kbsize = file.length() / 1024L;
        if (kbsize == 0L) {
            kbsize = 1L;
        }
        this.filesize = NLS.bind((String)Messages.filesize_kb, (Object)Long.toString(kbsize));
        this.filepath = file.getAbsolutePath();
    }

    public FileEmbeddable(String fileName, String size) {
        Program p;
        this.filename = fileName;
        this.filesize = size;
        this.ext = fileName.substring(fileName.lastIndexOf(".") + 1);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, LogMessages.tryingToFindLaunch);
        }
        if ((p = Program.findProgram((String)this.ext)) != null) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, NLS.bind((String)LogMessages.launchableProgramIs, (Object)p.getName()));
            }
            this.fileImage = Program.findProgram((String)this.ext).getImageData();
            if (this.fileImage == null) {
                this.fileImage = ImChatPlugin.getDefault().getImage("images/ST_SendFile.png").getImageData();
            }
        } else {
            this.fileImage = ImChatPlugin.getDefault().getImage("images/ST_SendFile.png").getImageData();
        }
    }

    public Image createDisplayImage() {
        Rectangle rect = new Rectangle(0, 0, 0, 0);
        if (this.fileImage != null) {
            rect.width += this.fileImage.width;
        }
        Point extent = null;
        if (this.filename != null) {
            Image im = new Image(null, 100, 100);
            GC gc2 = new GC((Drawable)im);
            gc2.setFont(Display.getDefault().getSystemFont());
            gc2.setBackground(Display.getDefault().getSystemColor(25));
            gc2.setForeground(Display.getDefault().getSystemColor(24));
            extent = gc2.textExtent(this.filename);
            int maxwidth = extent.x;
            extent = gc2.textExtent(this.filesize);
            maxwidth = Math.max(maxwidth, extent.x);
            gc2.dispose();
            im.dispose();
            rect.width += 3 + maxwidth;
        }
        if (this.filesize != null) {
            rect.height = 3 + 2 * extent.y;
        }
        if (this.image != null) {
            this.image.dispose();
        }
        this.image = new Image(null, rect.width, rect.height);
        GC gc = new GC((Drawable)this.image);
        gc.setFont(Display.getDefault().getSystemFont());
        gc.setBackground(Display.getDefault().getSystemColor(25));
        gc.setForeground(Display.getDefault().getSystemColor(24));
        gc.fillRectangle(rect);
        int x = 0;
        if (this.fileImage != null) {
            Image im = new Image(null, this.fileImage);
            gc.drawImage(im, 0, 0);
            x = this.fileImage.width;
            int cfr_ignored_0 = this.fileImage.height;
            im.dispose();
        }
        if (this.filename != null) {
            gc.drawString(this.filename, x + 3, 0, true);
        }
        if (this.filesize != null) {
            gc.drawString(this.filesize, x + 3, extent.y + 3, true);
        }
        gc.dispose();
        return this.image;
    }

    public ChatWindowHandler getChatWindowHandler() {
        return this.handler;
    }

    public ImChatWindowHandler getImChatWindowHandler() {
        return this.handler;
    }

    public void setChatWindowHandler(ChatWindowHandler handler) {
        this.handler = (ImChatWindowHandler)handler;
    }

    public void destroy() {
        this.handler = null;
        if (this.image != null) {
            this.image.dispose();
        }
    }

    public String getFileName() {
        return this.filename;
    }

    public String getFileSize() {
        return this.filesize;
    }

    public String getFileExtension() {
        return this.ext;
    }

    public long getFileSizeLong() {
        return this.filesizeLong;
    }

    public String getFilePath() {
        return this.filepath;
    }
}

