/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.chatwindow;

import com.ibm.collaboration.realtime.chatwindow.ImChatActionDescriptor;
import com.ibm.collaboration.realtime.chatwindow.ImChatPlugin;
import com.ibm.collaboration.realtime.chatwindow.ImChatWindowHandler;
import com.ibm.collaboration.realtime.chatwindow.ImChatWindowLabelProvider;
import com.ibm.collaboration.realtime.chatwindow.ImChatWindowPartner;
import com.ibm.collaboration.realtime.chatwindow.ListExtension;
import com.ibm.collaboration.realtime.chatwindow.NwayViewResizer;
import com.ibm.collaboration.realtime.chatwindow.addon.ChatWindowExtension;
import com.ibm.collaboration.realtime.chatwindow.strings.LogMessages;
import com.ibm.collaboration.realtime.people.Group;
import com.ibm.collaboration.realtime.people.NestableGroup;
import com.ibm.collaboration.realtime.people.PeopleUtil;
import com.ibm.collaboration.realtime.people.Person;
import com.ibm.collaboration.realtime.people.PersonInternal;
import com.ibm.collaboration.realtime.people.internal.PersonGroupTransfer;
import com.ibm.collaboration.realtime.people.internal.livenames.LiveNameServiceUtil;
import com.ibm.collaboration.realtime.people.internal.livenames.LiveNameUtil;
import com.ibm.collaboration.realtime.people.internal.ui.HoverBusinessCard;
import com.ibm.collaboration.realtime.tableextension.NwayTableCellSelectionListener;
import com.ibm.collaboration.realtime.tableextension.NwayTableLabelProvider;
import com.ibm.collaboration.realtime.ui.STStyleManager;
import com.ibm.collaboration.realtime.ui.util.ColorCache;
import com.ibm.collaboration.realtime.ui.util.SwtUtils;
import com.ibm.collaboration.realtime.util.OSUtils;
import com.ibm.rcp.realtime.livenames.LiveNameContextMenu;
import com.ibm.rcp.realtime.livenames.LiveNameService;
import com.ibm.rcp.swt.custom.GrabbyBar;
import com.ibm.rcp.swt.swidgets.SViewForm;
import com.ibm.rcp.swt.swidgets.StyledWidget;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.IViewDescriptor;

public class NwayParticipantList {
    TableViewer tableViewer;
    ImChatWindowHandler handler;
    ArrayList cellListeners;
    TableViewer tbdViewer;
    ArrayList enabledExts;
    Composite control;
    CLabel bottomLabel;
    TableCursor cursor;
    HoverBusinessCard card;
    private static Logger logger = null;
    private boolean uiCreated = false;
    private int preCursor = -1;
    boolean useTextOnly = false;
    private ControlListener resizeListener = new ControlListener(){

        public void controlResized(ControlEvent arg0) {
            Table stable;
            int columnCount;
            if (NwayParticipantList.this.tableViewer != null && (columnCount = (stable = NwayParticipantList.this.tableViewer.getTable()).getColumnCount()) > 2) {
                int more;
                int totalWidth = 0;
                int i = 0;
                while (i < columnCount) {
                    Integer col_width = (Integer)stable.getColumn(i).getData("COL_WIDTH");
                    int width = stable.getColumn(i).getWidth();
                    if (col_width != null) {
                        if (width < col_width) {
                            stable.getColumn(i).setWidth(col_width.intValue());
                            totalWidth += col_width.intValue();
                        } else {
                            totalWidth += width;
                        }
                    } else {
                        totalWidth += width;
                    }
                    ++i;
                }
                if (totalWidth < stable.getParent().getClientArea().width) {
                    more = stable.getParent().getClientArea().width - totalWidth;
                    int curr = stable.getColumn(2).getWidth();
                    stable.getColumn(2).setWidth(curr + more);
                } else if (totalWidth > stable.getParent().getClientArea().width) {
                    more = totalWidth - stable.getParent().getClientArea().width;
                    int curr = stable.getColumn(2).getWidth();
                    if (curr - more > 100) {
                        stable.getColumn(2).setWidth(curr - more);
                    }
                }
            }
        }

        public void controlMoved(ControlEvent arg0) {
        }
    };
    private String bLabel;
    private Image bImage;
    LiveNameContextMenu liveNameCtxMenu;
    ISelectionProvider liveNameSelProvider;
    IMenuManager liveNameMenuManager;
    static /* synthetic */ Class class$0;

    public NwayParticipantList(ImChatWindowHandler icw) {
        this.handler = icw;
        this.useTextOnly = ImChatPlugin.getDefault().getPrefAsBoolean("usingAccTranscript");
    }

    public void createControl(Composite parent) {
        this.control = new Composite(parent, 0);
        this.control.setBackground(ColorCache.getColor((String)"WINDOW_STATUS_BACKGROUND"));
        this.control.setLayout((Layout)new FormLayout());
        this.tableViewer = new TableViewer(this.control, 65538);
        this.tableViewer.setUseHashlookup(true);
        this.tableViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public void dispose() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof ArrayList) {
                    return ((ArrayList)inputElement).toArray(new ImChatWindowPartner[0]);
                }
                return null;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ImChatWindowLabelProvider(this));
        this.tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection isel = (IStructuredSelection)event.getSelection();
                if (isel == null || isel.size() == 0) {
                    return;
                }
                ImChatWindowPartner ip = (ImChatWindowPartner)isel.getFirstElement();
                if (NwayParticipantList.this.handler != null && ip != null && ip.getPerson() != null) {
                    NwayParticipantList.this.handler.setBusinessCardTo(ip.getPerson());
                }
                Person[] selPersons = NwayParticipantList.this.getSelectedPersons(isel);
                if (NwayParticipantList.this.liveNameSelProvider != null && selPersons != null) {
                    isel = LiveNameUtil.getStructuredSelection((Person[])selPersons, (String)"Unspecified");
                    NwayParticipantList.this.liveNameSelProvider.setSelection((ISelection)isel);
                }
                if (NwayParticipantList.this.handler != null && ip != null) {
                    NwayParticipantList.this.handler.highlightPartnerText(ip);
                }
                NwayParticipantList.this.tableViewer.refresh();
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                if (event.getSelection() instanceof IStructuredSelection) {
                    IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                    NwayParticipantList.this.handleDoubleClick(sel);
                }
            }
        });
        this.registerContextMenu();
        final Table stable = this.tableViewer.getTable();
        stable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent arg0) {
                TableItem item;
                NwayParticipantList.this.cursor.setVisible(false);
                if (stable.getSelection() != null && (item = stable.getSelection()[0]) != null) {
                    int i = 0;
                    while (i < stable.getColumnCount()) {
                        if (item.getBounds(i).contains(arg0.x, arg0.y)) {
                            Point pt = stable.toDisplay(item.getBounds((int)i).x, item.getBounds((int)i).y);
                            NwayTableCellSelectionListener[] listeners = NwayParticipantList.this.getCellListeners(i);
                            if (listeners != null) {
                                Event e = new Event();
                                e.button = arg0.button;
                                e.item = item;
                                e.widget = stable;
                                e.detail = i;
                                e.x = pt.x;
                                e.y = pt.y;
                                e.height = item.getBounds((int)i).height;
                                Object data = item.getData();
                                if (data instanceof ImChatWindowPartner) {
                                    e.data = data;
                                }
                                int l = 0;
                                while (l < listeners.length) {
                                    listeners[l].handleEvent(e);
                                    ++l;
                                }
                                return;
                            }
                        }
                        ++i;
                    }
                }
            }
        });
        stable.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent event) {
                TableItem item = stable.getItem(new Point(event.x, event.y));
                if (item != null) {
                    int i = 0;
                    while (i < stable.getColumnCount()) {
                        IBaseLabelProvider provider;
                        if (item.getBounds(i).contains(event.x, event.y) && (provider = NwayParticipantList.this.getTableViewer().getLabelProvider()) instanceof ImChatWindowLabelProvider) {
                            ImChatWindowLabelProvider labelProv = (ImChatWindowLabelProvider)provider;
                            stable.setToolTipText(labelProv.getColumnToolTipText(item.getData(), i));
                            return;
                        }
                        ++i;
                    }
                }
            }
        });
        stable.getParent().addControlListener(this.resizeListener);
        Listener paintListener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 41: {
                        TableItem item = (TableItem)event.item;
                        int index = event.index;
                        Image im = (Image)item.getData("image" + index);
                        if (im == null || im.isDisposed()) break;
                        Rectangle rect = im.getBounds();
                        event.width += rect.width;
                        event.height = Math.max(event.height, rect.height + 2);
                        break;
                    }
                    case 42: {
                        int x = event.x;
                        TableItem item = (TableItem)event.item;
                        int index = event.index;
                        Image im = (Image)item.getData("image" + index);
                        TableColumn col = NwayParticipantList.this.tableViewer.getTable().getColumn(index);
                        if (im == null || im.isDisposed()) break;
                        Rectangle rect = im.getBounds();
                        int offset = Math.max(0, (event.height - rect.height) / 2);
                        int xoffset = Math.max(0, (col.getWidth() - rect.width) / 2);
                        event.gc.drawImage(im, x + xoffset, event.y + offset);
                        break;
                    }
                    case 40: {
                        int width;
                        if ((event.detail & 2) == 0 || !stable.isFocusControl()) break;
                        GC gc = event.gc;
                        Rectangle area = stable.getClientArea();
                        int columnCount = stable.getColumnCount();
                        if ((event.index == columnCount - 1 || columnCount == 0) && (width = area.x + area.width - event.x) > 0) {
                            Region region = new Region();
                            gc.getClipping(region);
                            region.add(event.x, event.y, width, event.height);
                            gc.setClipping(region);
                            region.dispose();
                        }
                        Rectangle rect = event.getBounds();
                        Color fore = gc.getForeground();
                        Color back = gc.getBackground();
                        if (stable.isFocusControl()) {
                            gc.setForeground(stable.getDisplay().getSystemColor(27));
                            gc.setBackground(stable.getDisplay().getSystemColor(26));
                        }
                        gc.fillRectangle(0, rect.y, area.width, rect.height);
                        gc.setForeground(fore);
                        gc.setBackground(back);
                    }
                }
            }
        };
        stable.addListener(41, paintListener);
        stable.addListener(42, paintListener);
        if (OSUtils.isWin32() && !Display.getDefault().getHighContrast()) {
            stable.addListener(40, paintListener);
        }
        this.cursor = new TableCursor(stable, 0);
        this.cursor.setBackground(stable.getDisplay().getSystemColor(26));
        this.cursor.setForeground(stable.getDisplay().getSystemColor(27));
        this.cursor.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                Image im = (Image)NwayParticipantList.this.cursor.getRow().getData("image" + NwayParticipantList.this.cursor.getColumn());
                if (im != null && !im.isDisposed()) {
                    Rectangle rect = im.getBounds();
                    int offset = Math.max(0, (event.height - rect.height) / 2);
                    int xoffset = Math.max(0, (event.width - rect.width) / 2);
                    event.gc.drawImage(im, event.x + xoffset, event.y + offset);
                }
            }
        });
        stable.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (NwayParticipantList.this.cursor != null && !NwayParticipantList.this.cursor.isDisposed()) {
                    NwayParticipantList.this.cursor.dispose();
                    NwayParticipantList.this.cursor = null;
                }
            }
        });
        this.cursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                stable.setSelection(new TableItem[]{NwayParticipantList.this.cursor.getRow()});
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                NwayParticipantList.this.handleCellSelection((TypedEvent)e);
            }
        });
        this.cursor.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent arg0) {
                if (arg0.button == 1) {
                    IStructuredSelection sel = (IStructuredSelection)NwayParticipantList.this.tableViewer.getSelection();
                    NwayParticipantList.this.handleDoubleClick(sel);
                }
            }

            public void mouseDown(MouseEvent arg0) {
                if (arg0.button == 1) {
                    NwayParticipantList.this.handleCellSelection((TypedEvent)arg0);
                }
            }

            public void mouseUp(MouseEvent e) {
                if (SwtUtils.rightClick((MouseEvent)e)) {
                    IStructuredSelection isel = (IStructuredSelection)NwayParticipantList.this.tableViewer.getSelection();
                    if (isel == null || isel.size() == 0) {
                        return;
                    }
                    Person[] selPersons = NwayParticipantList.this.getSelectedPersons(isel);
                    isel = LiveNameUtil.getStructuredSelection((Person[])selPersons, (String)"Unspecified");
                    NwayParticipantList.this.liveNameSelProvider.setSelection((ISelection)isel);
                }
            }
        });
        this.cursor.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent event) {
                TableItem item = NwayParticipantList.this.cursor.getRow();
                if (item != null) {
                    int i = 0;
                    while (i < stable.getColumnCount()) {
                        IBaseLabelProvider provider;
                        if (item.getBounds(i).contains(event.x, event.y) && (provider = NwayParticipantList.this.getTableViewer().getLabelProvider()) instanceof ImChatWindowLabelProvider) {
                            ImChatWindowLabelProvider labelProv = (ImChatWindowLabelProvider)provider;
                            NwayParticipantList.this.cursor.setToolTipText(labelProv.getColumnToolTipText(item.getData(), i));
                            return;
                        }
                        ++i;
                    }
                }
            }
        });
        this.cursor.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent arg0) {
                NwayParticipantList.this.cursor.setVisible(false);
            }

            public void focusGained(FocusEvent arg0) {
            }
        });
        this.cursor.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent arg0) {
            }

            public void keyReleased(KeyEvent arg0) {
                if (NwayParticipantList.this.preCursor == NwayParticipantList.this.cursor.getColumn()) {
                    if (NwayParticipantList.this.cursor.getColumn() == 0 && arg0.keyCode == 0x1000003) {
                        NwayParticipantList.this.cursor.setVisible(false);
                    } else if (NwayParticipantList.this.cursor.getColumn() == stable.getColumnCount() - 1 && arg0.keyCode == 0x1000004) {
                        NwayParticipantList.this.cursor.setVisible(false);
                    }
                }
                NwayParticipantList.this.preCursor = NwayParticipantList.this.cursor.getColumn();
                stable.getAccessible().setFocus(-1);
            }
        });
        this.cursor.setVisible(false);
        this.liveNameCtxMenu.registerContextMenu(this.getClass().getName(), (Control)this.cursor, this.liveNameSelProvider);
        stable.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent arg0) {
                if (NwayParticipantList.this.tableViewer.getTable().getSelectionCount() > 0) {
                    TableItem item = NwayParticipantList.this.tableViewer.getTable().getSelection()[0];
                    NwayParticipantList.this.tableViewer.getTable().setSelection(item);
                } else {
                    NwayParticipantList.this.tableViewer.getTable().setSelection(0);
                }
            }

            public void focusLost(FocusEvent arg0) {
            }
        });
        stable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent arg0) {
                if (arg0.keyCode == 0x1000004) {
                    TableItem item = NwayParticipantList.this.tableViewer.getTable().getSelection()[0];
                    NwayParticipantList.this.cursor.setSelection(item, 0);
                    NwayParticipantList.this.cursor.setVisible(true);
                    NwayParticipantList.this.cursor.setFocus();
                    NwayParticipantList.this.preCursor = -1;
                    stable.getAccessible().setFocus(-1);
                } else if (arg0.keyCode == 0x1000003) {
                    TableItem item = NwayParticipantList.this.tableViewer.getTable().getSelection()[0];
                    NwayParticipantList.this.cursor.setSelection(item, NwayParticipantList.this.tableViewer.getTable().getColumnCount() - 1);
                    NwayParticipantList.this.cursor.setVisible(true);
                    NwayParticipantList.this.cursor.setFocus();
                    NwayParticipantList.this.preCursor = -1;
                    stable.getAccessible().setFocus(-1);
                }
            }
        });
        DropTarget target = new DropTarget((Control)stable, 19);
        target.setTransfer(new Transfer[]{PersonGroupTransfer.getInstance(), TextTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                Object object = event.data;
                if (object instanceof String) {
                    String id = (String)object;
                    StringTokenizer ids = new StringTokenizer(id, "\t");
                    ArrayList<PersonInternal> list = new ArrayList<PersonInternal>();
                    while (ids.hasMoreTokens()) {
                        PersonInternal p = PeopleUtil.getPersonById((String)ids.nextToken().trim());
                        if (!p.getCommunityId().equals(NwayParticipantList.this.handler.getCommunityId()) || !PeopleUtil.canAcceptChat((Person)p)) continue;
                        list.add(p);
                    }
                    if (list.size() > 0) {
                        NwayParticipantList.this.handler.handleInviteOthers(list.toArray(new Person[list.size()]));
                    }
                } else if (object instanceof Object[]) {
                    Object[] obj = (Object[])object;
                    ArrayList<Object> list = new ArrayList<Object>();
                    int i = 0;
                    while (i < obj.length) {
                        if (obj[i] instanceof Person) {
                            Person p = (Person)obj[i];
                            if (p.getCommunityId().equals(NwayParticipantList.this.handler.getCommunityId()) && PeopleUtil.canAcceptChat((Person)p)) {
                                list.add(obj[i]);
                            }
                        } else if (obj[i] instanceof Group) {
                            Group group = (Group)obj[i];
                            Person[] people = null;
                            people = group instanceof NestableGroup ? ((NestableGroup)group).getAllPersons() : group.getPersons();
                            int j = 0;
                            while (j < people.length) {
                                if (NwayParticipantList.this.handler.getCommunityId().equals(people[j].getCommunityId()) && PeopleUtil.canAcceptChat((Person)people[j])) {
                                    list.add(people[j]);
                                }
                                ++j;
                            }
                        }
                        ++i;
                    }
                    if (list.size() > 0) {
                        NwayParticipantList.this.handler.handleInviteOthers(list.toArray(new Person[list.size()]));
                    }
                }
            }

            public void dragEnter(DropTargetEvent event) {
            }
        });
        DragSource source = new DragSource((Control)stable, 19);
        source.setTransfer(new Transfer[]{PersonGroupTransfer.getInstance(), TextTransfer.getInstance()});
        source.addDragListener((DragSourceListener)new DragSourceAdapter(){

            public void dragSetData(DragSourceEvent e) {
                if (PersonGroupTransfer.getInstance().isSupportedType(e.dataType)) {
                    StructuredSelection sel = (StructuredSelection)NwayParticipantList.this.tableViewer.getSelection();
                    Iterator iter = sel.iterator();
                    ArrayList<Person> peeps = new ArrayList<Person>();
                    while (iter.hasNext()) {
                        ImChatWindowPartner partner = (ImChatWindowPartner)iter.next();
                        if (partner.getPerson() == null) continue;
                        peeps.add(partner.getPerson());
                    }
                    if (peeps.size() > 0) {
                        e.data = peeps.toArray();
                    }
                } else if (TextTransfer.getInstance().isSupportedType(e.dataType)) {
                    StructuredSelection sel = (StructuredSelection)NwayParticipantList.this.tableViewer.getSelection();
                    Iterator iter = sel.iterator();
                    StringBuffer buffer = new StringBuffer();
                    while (iter.hasNext()) {
                        ImChatWindowPartner partner = (ImChatWindowPartner)iter.next();
                        if (partner.getPerson() == null) continue;
                        if (buffer.length() > 0) {
                            buffer.append("\t");
                        }
                        buffer.append(partner.getPerson().getId());
                    }
                    if (buffer.length() > 0) {
                        e.data = buffer.toString();
                    }
                }
            }
        });
        this.addPersonColumns(stable);
        ArrayList list = ImChatPlugin.getDefault().getListExtensions();
        if (list != null) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                ListExtension ext = (ListExtension)iter.next();
                if (!ext.isEnabled()) continue;
                String activity = ext.getActivity();
                if (activity != null) {
                    if (!this.handler.hasActivity(activity)) continue;
                    this.addListExtension(ext.create(this.handler));
                    continue;
                }
                this.addListExtension(ext.create(this.handler));
            }
        }
        this.tableViewer.setSorter(new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof ImChatWindowPartner && e2 instanceof ImChatWindowPartner) {
                    ImChatWindowPartner p1 = (ImChatWindowPartner)e1;
                    ImChatWindowPartner p2 = (ImChatWindowPartner)e2;
                    Collator collator = this.getCollator();
                    return collator.compare(p1.getName(), p2.getName());
                }
                return 0;
            }
        });
        this.bottomLabel = new CLabel(this.control, 0);
        if (!Display.getCurrent().getHighContrast()) {
            this.bottomLabel.setBackground(new Color[]{ColorCache.getColor((String)"GRADIENT_TOP"), ColorCache.getColor((String)"GRADIENT_BOTTOM")}, new int[]{100});
        }
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment((Control)this.bottomLabel, 0);
        this.tableViewer.getTable().setLayoutData((Object)fd);
        fd = new FormData();
        fd.bottom = new FormAttachment(100, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.height = 0;
        this.bottomLabel.setLayoutData((Object)fd);
        this.bottomLabel.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                switch (e.detail) {
                    case 2: 
                    case 4: 
                    case 8: 
                    case 16: 
                    case 256: 
                    case 512: {
                        e.doit = true;
                    }
                }
            }
        });
        this.bottomLabel.addListener(15, new Listener(){

            public void handleEvent(Event e) {
                GC gc = new GC((Drawable)NwayParticipantList.this.bottomLabel);
                gc.setForeground(NwayParticipantList.this.bottomLabel.getDisplay().getSystemColor(2));
                gc.drawFocus(0, 0, NwayParticipantList.this.bottomLabel.getClientArea().width, NwayParticipantList.this.bottomLabel.getClientArea().height);
                gc.dispose();
            }
        });
        this.bottomLabel.addListener(16, new Listener(){

            public void handleEvent(Event e) {
                NwayParticipantList.this.bottomLabel.redraw();
            }
        });
        this.bottomLabel.addListener(1, new Listener(){

            public void handleEvent(Event e) {
            }
        });
        this.control.setTabList(new Control[]{this.tableViewer.getTable()});
        this.tableViewer.getTable().getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getValue(AccessibleControlEvent e) {
                if (NwayParticipantList.this.cursor == null || !NwayParticipantList.this.cursor.isVisible()) {
                    Person person;
                    TableItem item;
                    Object data;
                    if (NwayParticipantList.this.card != null && NwayParticipantList.this.card.isVisible()) {
                        e.result = NwayParticipantList.this.card.getBusinessCard().getAllText();
                    } else if (NwayParticipantList.this.tableViewer.getTable().getSelectionCount() > 0 && (data = (item = NwayParticipantList.this.tableViewer.getTable().getSelection()[0]).getData()) instanceof ImChatWindowPartner && (person = ((ImChatWindowPartner)data).getPerson()) != null) {
                        NwayParticipantList.this.card = new HoverBusinessCard(NwayParticipantList.this.tableViewer.getTable().getShell(), person, null);
                        e.result = NwayParticipantList.this.card.getBusinessCard().getAllText();
                        NwayParticipantList.this.card.dispose();
                        NwayParticipantList.this.card = null;
                    }
                }
            }

            public void getRole(AccessibleControlEvent e) {
                if (NwayParticipantList.this.cursor != null && NwayParticipantList.this.cursor.isVisible()) {
                    IBaseLabelProvider provider;
                    TableItem item = NwayParticipantList.this.cursor.getRow();
                    int col = NwayParticipantList.this.cursor.getColumn();
                    if (item != null && col > -1 && (provider = NwayParticipantList.this.getTableViewer().getLabelProvider()) instanceof ImChatWindowLabelProvider) {
                        ImChatWindowLabelProvider labelProv = (ImChatWindowLabelProvider)provider;
                        e.detail = labelProv.getRole(item.getData(), col);
                    }
                }
            }
        });
        this.tableViewer.getTable().getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                TableItem item;
                Object data;
                if (NwayParticipantList.this.cursor != null && NwayParticipantList.this.cursor.isVisible()) {
                    IBaseLabelProvider provider;
                    TableItem item2 = NwayParticipantList.this.cursor.getRow();
                    int col = NwayParticipantList.this.cursor.getColumn();
                    if (item2 != null && (provider = NwayParticipantList.this.getTableViewer().getLabelProvider()) instanceof ImChatWindowLabelProvider) {
                        ImChatWindowLabelProvider labelProv = (ImChatWindowLabelProvider)provider;
                        e.result = labelProv.getColumnToolTipText(item2.getData(), col);
                    }
                } else if (NwayParticipantList.this.tableViewer.getTable().getSelectionCount() > 0 && (data = (item = NwayParticipantList.this.tableViewer.getTable().getSelection()[0]).getData()) instanceof ImChatWindowPartner) {
                    String name = ((ImChatWindowPartner)data).getName();
                    Person person = ((ImChatWindowPartner)data).getPerson();
                    if (person != null) {
                        String status = ", " + PeopleUtil.getStatusText((int)person.getStatus());
                        String statusText = person.getStatusMessage();
                        name = String.valueOf(name) + status + (statusText != null ? ": " + statusText : "");
                    }
                    e.result = name;
                }
            }

            public void getDescription(AccessibleEvent e) {
                Person person;
                TableItem item;
                Object data;
                if (NwayParticipantList.this.tableViewer.getTable().getSelectionCount() > 0 && (data = (item = NwayParticipantList.this.tableViewer.getTable().getSelection()[0]).getData()) instanceof ImChatWindowPartner && (person = ((ImChatWindowPartner)data).getPerson()) != null) {
                    e.result = String.valueOf(e.result) + ", " + person.getStatusMessage();
                }
            }
        });
        if (this.bLabel != null || this.bImage != null) {
            this.setBottomLabel(this.bLabel, this.bImage);
        }
        this.uiCreated = true;
    }

    protected void createExtensions() {
        if (this.enabledExts != null && !this.enabledExts.isEmpty()) {
            int i = 0;
            while (i < this.enabledExts.size()) {
                ListExtension ext = (ListExtension)this.enabledExts.get(i);
                this.createExtension(ext);
                ++i;
            }
        }
    }

    protected void setModel(ArrayList list) {
        if (this.uiCreated) {
            this.tableViewer.setInput((Object)list);
            TableColumn[] cols = this.tableViewer.getTable().getColumns();
            int start = 2;
            if (this.useTextOnly) {
                start = 0;
            }
            int i = start;
            while (i < cols.length) {
                cols[i].pack();
                ++i;
            }
            if (this.handler.isMultiChat()) {
                this.select(0);
            }
        }
    }

    private void select(int index) {
        if (!this.uiCreated) {
            return;
        }
        if (this.tableViewer.getTable().getItemCount() > index) {
            TableItem item = this.tableViewer.getTable().getItem(index);
            StructuredSelection sel = new StructuredSelection(item.getData());
            this.tableViewer.setSelection((ISelection)sel);
        }
    }

    public void addListExtension(ListExtension ext) {
        if (this.control == null && ext != null) {
            if (this.enabledExts == null) {
                this.enabledExts = new ArrayList();
            }
            if (!this.hasExtension(ext.getId())) {
                this.enabledExts.add(ext);
            }
            return;
        }
        if (ext != null) {
            if (this.enabledExts != null && this.hasExtension(ext.getId())) {
                return;
            }
            if (this.enabledExts == null) {
                this.enabledExts = new ArrayList();
            }
            this.enabledExts.add(ext);
            this.createExtension(ext);
        }
    }

    private Person[] getSelectedPersons(IStructuredSelection sel) {
        if (sel == null) {
            return null;
        }
        ArrayList<Person> items = new ArrayList<Person>();
        Iterator it = sel.iterator();
        while (it.hasNext()) {
            ImChatWindowPartner ip;
            Object o = it.next();
            if (!(o instanceof ImChatWindowPartner) || (ip = (ImChatWindowPartner)o).getPerson() == null) continue;
            items.add(ip.getPerson());
        }
        return items.toArray(new Person[items.size()]);
    }

    public void setBottomLabel(String label, Image im) {
        if (this.control == null) {
            this.bLabel = label;
            this.bImage = im;
            return;
        }
        boolean resize = false;
        if (this.bottomLabel != null) {
            if (label != null) {
                this.bottomLabel.setText(label);
                resize = true;
            }
            if (im != null) {
                this.bottomLabel.setImage(im);
                resize = true;
            }
            FormData fd = (FormData)this.bottomLabel.getLayoutData();
            FormData fd2 = (FormData)this.tableViewer.getTable().getLayoutData();
            if (resize) {
                fd.height = -1;
                fd2.bottom = new FormAttachment((Control)this.bottomLabel, -1);
            } else {
                fd.height = 0;
                fd2.bottom = new FormAttachment((Control)this.bottomLabel, 0);
            }
            this.control.layout();
        }
    }

    public Control getControl() {
        return this.control;
    }

    private void createExtension(ListExtension ext) {
        this.tableViewer.getTable().getParent().removeControlListener(this.resizeListener);
        int startWidth = 0;
        TableColumn[] cols = this.tableViewer.getTable().getColumns();
        int i = 0;
        while (i < cols.length) {
            if (!OSUtils.isWin32()) {
                cols[i].pack();
            }
            startWidth += cols[i].getWidth();
            ++i;
        }
        this.clearParticipants();
        int existingColumns = this.tableViewer.getTable().getColumnCount();
        int addWidth = 0;
        if (ext.getExtraColumns() != null) {
            ListExtension.Column[] columns = ext.getExtraColumns();
            int i2 = 0;
            while (i2 < columns.length) {
                boolean contains = false;
                int j = 2;
                while (j < cols.length) {
                    String id = (String)cols[j].getData("COL_ID");
                    if (id != null && id.equals(String.valueOf(ext.id) + ":" + columns[i2].columnIndex)) {
                        contains = true;
                        break;
                    }
                    ++j;
                }
                if (!contains) {
                    TableColumn column = new TableColumn(this.tableViewer.getTable(), 0);
                    column.setData("COL_ID", (Object)(String.valueOf(ext.id) + ":" + columns[i2].columnIndex));
                    column.setWidth(columns[i2].initialWidth);
                    column.setData("COL_WIDTH", (Object)new Integer(columns[i2].initialWidth));
                    addWidth += columns[i2].initialWidth;
                }
                ++i2;
            }
        }
        if (ext.getTableCellListeners() != null) {
            int i3 = 0;
            while (i3 < ext.getTableCellListeners().length) {
                NwayTableCellSelectionListener listener = ext.getTableCellListeners()[i3];
                if (!listener.isReindexed()) {
                    listener.setChatWindowHandler(this.handler);
                    listener.setColumnIndex(existingColumns + listener.getColumnIndex());
                    listener.setReindexed(true);
                }
                this.addTableCellListener(listener);
                ++i3;
            }
        }
        if (ext.viewClass != null) {
            if (ext.outsideShelf) {
                this.createNonShelf(ext.viewClass);
            } else {
                this.createNewForm(ext.viewClass, ext.region);
            }
        }
        this.handler.addChatActionsFromExtension(ext);
        this.setModel(this.handler._remotePartnerMap);
        if (this.handler._rightSide != null && this.handler._sash_Main != null && this.handler._sash_Main.getChildren() != null) {
            cols = this.tableViewer.getTable().getColumns();
            int totalWidth = 0;
            int start = 2;
            if (this.useTextOnly) {
                start = 0;
            }
            int i4 = start;
            while (i4 < cols.length) {
                if (!OSUtils.isWin32()) {
                    cols[i4].pack();
                }
                totalWidth += cols[i4].getWidth();
                ++i4;
            }
            totalWidth += addWidth;
            int heightDiff = 0;
            if (ext.viewClass != null) {
                Control[] controls = this.handler.stack.getControls(true);
                int j = 0;
                while (j < controls.length) {
                    Point r;
                    SViewForm viewForm;
                    String viewClass;
                    if (controls[j] instanceof SViewForm && (viewClass = (String)(viewForm = (SViewForm)controls[j]).getData("VIEW_CLASS")) != null && viewClass.equals(ext.viewClass) && (r = (Point)viewForm.getData("RESIZE_SIZE")) != null) {
                        if (totalWidth < r.x) {
                            totalWidth = r.x;
                        }
                        heightDiff = r.y;
                        viewForm.setData("RESIZE_SIZE", null);
                    }
                    ++j;
                }
            }
            if (addWidth > 0) {
                int change = totalWidth - startWidth;
                int right = this.handler._rightSide.getSize().x;
                int[] weights = this.handler._sash_Main.getWeights();
                if (weights == null) {
                    return;
                }
                if (this.handler._sash_Main.getMaximizedControl() != null && weights[1] > 5) {
                    right = weights[1];
                }
                Point ssize = this.handler.getShell().getSize();
                int w1 = totalWidth;
                if (totalWidth < this.handler._sash_Main.getWeights()[0]) {
                    return;
                }
                if (weights[1] == 5) {
                    weights[1] = right;
                }
                this.handler._sash_Main.setData("LEFT_SIZE", (Object)new Integer(totalWidth));
                this.handler._sash_Main.setWeights(new int[]{w1, weights[1]});
                if (this.handler.isMultiChat()) {
                    if (this.handler._sash_Main.getMaximizedControl() == null) {
                        this.handler.getShell().setSize(right + GrabbyBar.SIZE + change, ssize.y + heightDiff);
                    } else if (this.handler._sash_Main.getGrabbyBar().getCollapsedDir() == 16384) {
                        this.handler.getShell().setSize(right + w1 + GrabbyBar.SIZE, ssize.y + heightDiff);
                    } else {
                        this.handler.getShell().setSize(w1 + GrabbyBar.SIZE, ssize.y + heightDiff);
                    }
                }
            }
        }
        this.tableViewer.getTable().getParent().addControlListener(this.resizeListener);
    }

    protected void createNewForm(String viewId) {
        this.createNewForm(viewId, "TOP");
    }

    protected void createNewForm(String viewId, String region) {
        IViewDescriptor view = PlatformUI.getWorkbench().getViewRegistry().find(viewId);
        if (view != null) {
            block16: {
                try {
                    boolean exists = false;
                    Control[] controls = this.handler.stack.getControls(true);
                    int j = 0;
                    while (j < controls.length) {
                        SViewForm viewForm;
                        String viewClass;
                        if (controls[j] instanceof SViewForm && (viewClass = (String)(viewForm = (SViewForm)controls[j]).getData("VIEW_CLASS")) != null && viewClass.equals(viewId)) {
                            exists = true;
                            break;
                        }
                        ++j;
                    }
                    if (!exists) {
                        Control[] newC;
                        IViewPart viewPart = view.createView();
                        Image image = viewPart.getTitleImage();
                        SViewForm viewForm = this.handler.stack.createViewForm(viewPart.getTitle(), image);
                        viewForm.setData("class", (Object)"shelf");
                        viewForm.setDropDownVisible(false);
                        viewForm.setMaximizeEnabled(false);
                        viewForm.setData("VIEW_CLASS", (Object)viewId);
                        if (viewPart instanceof ChatWindowExtension) {
                            ((ChatWindowExtension)viewPart).setChatWindowHandler(this.handler);
                        }
                        STStyleManager.setStyles((StyledWidget)viewForm);
                        Composite temp = new Composite(this.handler.stack.getParent(), 0);
                        GridLayout gl = new GridLayout();
                        gl.marginHeight = 0;
                        gl.marginWidth = 0;
                        temp.setLayout((Layout)gl);
                        viewPart.createPartControl(temp);
                        Control[] c = temp.getChildren();
                        if (c != null && c.length > 0 && c[0].getLayoutData() == null) {
                            c[0].setLayoutData((Object)new GridData(1808));
                            temp.layout();
                        }
                        viewForm.setContent((Control)temp);
                        viewForm.setCollapsed(false);
                        viewForm.setData("viewpart", (Object)viewPart);
                        if (viewPart instanceof NwayViewResizer) {
                            Point p = ((NwayViewResizer)viewPart).getPreferredSize();
                            viewForm.setData("RESIZE_SIZE", (Object)p);
                        }
                        viewForm.addDisposeListener(new DisposeListener(){

                            public void widgetDisposed(DisposeEvent e) {
                                IViewPart part = (IViewPart)((Control)e.getSource()).getData("viewpart");
                                if (part != null) {
                                    part.dispose();
                                }
                            }
                        });
                        if ("BOTTOM".equals(region)) {
                            newC = new Control[controls.length + 1];
                            System.arraycopy(controls, 0, newC, 0, controls.length);
                            newC[newC.length - 1] = viewForm;
                            this.handler.stack.setControls(newC);
                        } else {
                            newC = new Control[controls.length + 1];
                            newC[0] = viewForm;
                            System.arraycopy(controls, 0, newC, 1, controls.length);
                            this.handler.stack.setControls(newC);
                        }
                    }
                }
                catch (Throwable t) {
                    if (logger == null) {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("com.ibm.collaboration.realtime.chatwindow.NwayParticipantList");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        logger = Logger.getLogger(clazz.getName());
                    }
                    if (!logger.isLoggable(Level.INFO)) break block16;
                    logger.log(Level.INFO, String.valueOf(LogMessages.NwayParticipantList_22) + viewId, t);
                }
            }
            this.handler.stack.layout(true);
        }
    }

    protected void createNonShelf(String viewId) {
        IViewDescriptor view = PlatformUI.getWorkbench().getViewRegistry().find(viewId);
        if (view != null) {
            block16: {
                try {
                    if (this.handler.outsideShelf != null) {
                        IViewPart viewPart = view.createView();
                        if (viewPart instanceof ChatWindowExtension) {
                            ((ChatWindowExtension)viewPart).setChatWindowHandler(this.handler);
                        }
                        GridLayout gl = new GridLayout();
                        gl.marginHeight = 0;
                        gl.marginWidth = 0;
                        this.handler.outsideShelf.setLayout((Layout)new FillLayout());
                        this.handler.outsideShelf.setData("VIEW_CLASS", (Object)viewId);
                        viewPart.createPartControl(this.handler.outsideShelf);
                        FormData fd = (FormData)this.handler.outsideShelf.getLayoutData();
                        if (fd != null) {
                            fd.height = -1;
                        }
                        if ((fd = (FormData)this.handler.outsideSash.getLayoutData()) != null) {
                            fd.height = 2;
                        }
                        if (viewPart instanceof NwayViewResizer) {
                            Point p = ((NwayViewResizer)viewPart).getPreferredSize();
                            Point size = this.handler.container.getSize();
                            if (p != null && (size.x < p.x || size.y < p.y)) {
                                int diffx = p.x - size.x;
                                int diffy = p.y - size.y;
                                if (diffx < 0) {
                                    diffx = 0;
                                }
                                if (diffy < 0) {
                                    diffy = 0;
                                }
                                int[] wts = this.handler._sash_Main.getWeights();
                                wts[0] = wts[0] + diffx;
                                this.handler._sash_Main.setWeights(wts);
                                Point shellSize = this.handler._localShell.getSize();
                                shellSize.x += diffx;
                                shellSize.y += diffy;
                                this.handler._localShell.setSize(shellSize);
                            }
                        }
                    }
                }
                catch (Throwable t) {
                    if (logger == null) {
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("com.ibm.collaboration.realtime.chatwindow.NwayParticipantList");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        logger = Logger.getLogger(clazz.getName());
                    }
                    if (!logger.isLoggable(Level.INFO)) break block16;
                    logger.log(Level.INFO, String.valueOf(LogMessages.NwayParticipantList_22) + viewId, t);
                }
            }
            this.handler.container.layout(true);
        }
    }

    public TableViewer getTableViewer() {
        return this.tableViewer;
    }

    public void clearParticipants() {
        this.tableViewer.getTable().removeAll();
    }

    public void add(ImChatWindowPartner participant) {
        if (this.tableViewer != null && !this.contains(participant)) {
            this.tableViewer.add((Object)participant);
        }
    }

    public void remove(ImChatWindowPartner participant) {
        if (this.tableViewer != null) {
            this.tableViewer.remove((Object)participant);
        }
    }

    public boolean contains(ImChatWindowPartner participant) {
        boolean contains = false;
        if (this.tableViewer != null && participant != null) {
            Table table = this.tableViewer.getTable();
            int i = 0;
            while (i < table.getItemCount()) {
                Object data;
                TableItem item = table.getItem(i);
                if (item != null && (data = item.getData()) instanceof ImChatWindowPartner) {
                    ImChatWindowPartner existingParticipant = (ImChatWindowPartner)data;
                    String existingId = existingParticipant.getContactId();
                    String id = participant.getContactId();
                    if (id != null && existingId != null && (contains = id.equalsIgnoreCase(existingId))) break;
                }
                ++i;
            }
        }
        return contains;
    }

    public void addTableCellListener(NwayTableCellSelectionListener listener) {
        if (this.cellListeners == null) {
            this.cellListeners = new ArrayList();
        }
        this.cellListeners.add(listener);
    }

    public NwayTableCellSelectionListener[] getCellListeners(int columnIndex) {
        if (this.cellListeners != null) {
            ArrayList<NwayTableCellSelectionListener> temp = new ArrayList<NwayTableCellSelectionListener>();
            Iterator iter = this.cellListeners.iterator();
            while (iter.hasNext()) {
                NwayTableCellSelectionListener listener = (NwayTableCellSelectionListener)((Object)iter.next());
                if (columnIndex != listener.getColumnIndex()) continue;
                temp.add(listener);
            }
            if (temp.size() > 0) {
                return temp.toArray(new NwayTableCellSelectionListener[temp.size()]);
            }
            Object var2_2 = null;
        }
        return null;
    }

    public void removeTableCellListener(NwayTableCellSelectionListener listener) {
        if (this.cellListeners == null) {
            return;
        }
        this.cellListeners.remove((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasExtension(String id) {
        boolean hasExt = false;
        if (this.enabledExts != null && id != null) {
            ArrayList arrayList = this.enabledExts;
            synchronized (arrayList) {
                int i = 0;
                while (i < this.enabledExts.size()) {
                    ListExtension ext = (ListExtension)this.enabledExts.get(i);
                    if (ext.getId().equals(id)) {
                        hasExt = true;
                        break;
                    }
                    ++i;
                }
            }
        }
        return hasExt;
    }

    public void redraw() {
        this.tableViewer.getTable().redraw();
    }

    public void removeListExtension(String id) {
        if (this.enabledExts != null && id != null) {
            int i = 0;
            while (i < this.enabledExts.size()) {
                ListExtension ext = (ListExtension)this.enabledExts.get(i);
                if (ext.getId() != null && ext.getId().equals(id)) {
                    this.removeListExtension(ext);
                    return;
                }
                ++i;
            }
        }
    }

    private void removeListExtension(ListExtension ext) {
        int startWidth = 0;
        TableColumn[] cols = this.tableViewer.getTable().getColumns();
        int i = 0;
        while (i < cols.length) {
            if (!OSUtils.isWin32()) {
                cols[i].pack();
            }
            startWidth += cols[i].getWidth();
            ++i;
        }
        if (this.enabledExts != null && ext != null) {
            if (this.enabledExts.contains(ext)) {
                ImChatActionDescriptor[] chatDesc;
                NwayTableCellSelectionListener[] listeners = ext.getTableCellListeners();
                if (listeners != null) {
                    int j = 0;
                    while (j < listeners.length) {
                        this.removeTableCellListener(listeners[j]);
                        ++j;
                    }
                }
                if (ext.outsideShelf) {
                    String id = (String)this.handler.outsideShelf.getData("VIEW_CLASS");
                    if (id != null && ext.viewClass != null && id.compareTo(ext.viewClass) == 0) {
                        Control[] controls = this.handler.outsideShelf.getChildren();
                        int i2 = controls.length - 1;
                        while (i2 >= 0) {
                            controls[i2].dispose();
                            --i2;
                        }
                        FormData fd = (FormData)this.handler.outsideShelf.getLayoutData();
                        if (fd != null) {
                            fd.height = 0;
                        }
                        if ((fd = (FormData)this.handler.outsideSash.getLayoutData()) != null) {
                            fd.height = 0;
                        }
                        this.handler.container.layout();
                    }
                } else {
                    Control[] controls = this.handler.stack.getControls(true);
                    ArrayList<Control> newList = new ArrayList<Control>();
                    int j = 0;
                    while (j < controls.length) {
                        if (controls[j] instanceof SViewForm) {
                            SViewForm viewForm = (SViewForm)controls[j];
                            String viewClass = (String)viewForm.getData("VIEW_CLASS");
                            if (viewClass != null && viewClass.equals(ext.viewClass)) {
                                Control content = viewForm.getContent();
                                content.dispose();
                                viewForm.dispose();
                            } else {
                                newList.add(controls[j]);
                            }
                        }
                        ++j;
                    }
                    this.handler.stack.setControls(newList.toArray(new Control[newList.size()]));
                    this.handler.stack.layout(true);
                    this.handler.stack.layout();
                    this.handler.stack.getParent().getParent().getParent().layout();
                }
                if ((chatDesc = ext.getChatActionDescriptors()) != null && this.handler._nwayToolBar != null) {
                    boolean update = false;
                    int j = 0;
                    while (j < chatDesc.length) {
                        IContributionItem item = this.handler._nwayToolBar.find(chatDesc[j].getId());
                        if (item != null) {
                            this.handler._nwayToolBar.remove(item);
                            item.dispose();
                            update = true;
                        }
                        ++j;
                    }
                    if (update) {
                        this.handler._nwayToolBar.update(true);
                    }
                    if (this.handler._nwayToolBar.getItemCount() == 0) {
                        FormData barData = (FormData)this.handler._nwayToolBar.getControl2().getParent().getLayoutData();
                        barData.height = 0;
                        FormAttachment attach = barData.top;
                        FormData listData = (FormData)this.control.getLayoutData();
                        listData.top = attach;
                        this.handler._nwayToolBar.getControl2().getParent().layout();
                        this.handler._comp_UserList.layout();
                    }
                }
                this.enabledExts.remove(ext);
            }
            this.clearParticipants();
            i = this.tableViewer.getTable().getColumnCount() - 1;
            while (i >= 0) {
                this.tableViewer.getTable().getColumn(i).dispose();
                --i;
            }
            this.addPersonColumns(this.tableViewer.getTable());
            NwayTableLabelProvider labelProvider = ext.getLabelProvider();
            if (labelProvider != null) {
                labelProvider.dispose();
            }
            int i3 = 0;
            while (i3 < this.enabledExts.size()) {
                ListExtension ext2 = (ListExtension)this.enabledExts.get(i3);
                this.createExtension(ext2);
                ++i3;
            }
            this.setModel(this.handler._remotePartnerMap);
            ext = null;
        }
    }

    public ListExtension[] getEnabledExtensions() {
        if (this.enabledExts == null) {
            return null;
        }
        return this.enabledExts.toArray(new ListExtension[this.enabledExts.size()]);
    }

    private void addPersonColumns(Table stable) {
        TableColumn _isTypingCol = new TableColumn(stable, 16384);
        _isTypingCol.setImage(ImChatPlugin.getDefault().getImageRegistry().get(ImChatPlugin.IMAGE_TYPING));
        _isTypingCol.setWidth(25);
        TableColumn _iconCol = new TableColumn(stable, 16384);
        _iconCol.setImage(ImChatPlugin.getDefault().getImageRegistry().get(ImChatPlugin.IMAGE_TYPING));
        try {
            Image im = this.handler.getLocalPartner().getPerson().getStatusImage();
            if (im != null) {
                _iconCol.setWidth(9 + im.getImageData().width);
            } else {
                _iconCol.setWidth(25);
            }
        }
        catch (Throwable throwable) {
            _iconCol.setWidth(25);
        }
        TableColumn _nameCol = new TableColumn(stable, 16384);
        _nameCol.setWidth(100);
        _nameCol.setText("Name Column");
    }

    private void registerContextMenu() {
        LiveNameService svc = LiveNameServiceUtil.getLiveNameService();
        this.liveNameCtxMenu = svc.createLiveNameContextMenu();
        this.liveNameSelProvider = LiveNameUtil.getSelectionProvider();
        this.liveNameMenuManager = this.liveNameCtxMenu.registerContextMenu(this.getClass().getName(), (Control)this.getTableViewer().getTable(), this.liveNameSelProvider);
        this.tableViewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                NwayParticipantList.this.liveNameCtxMenu.dispose();
            }
        });
    }

    public IMenuManager getMenuManager() {
        return this.liveNameMenuManager;
    }

    private void handleCellSelection(TypedEvent arg0) {
        if (this.tableViewer.getTable().getSelection() != null && this.tableViewer.getTable().getSelection().length == 1) {
            TableItem item = this.tableViewer.getTable().getSelection()[0];
            int i = this.cursor.getColumn();
            Point pt = this.tableViewer.getTable().toDisplay(item.getBounds((int)i).x, item.getBounds((int)i).y);
            NwayTableCellSelectionListener[] listeners = this.getCellListeners(i);
            if (listeners != null) {
                Event e = new Event();
                e.item = item;
                e.widget = this.tableViewer.getTable();
                e.detail = i;
                e.x = pt.x;
                e.y = pt.y;
                e.height = item.getBounds((int)i).height;
                Object data = item.getData();
                if (data instanceof ImChatWindowPartner) {
                    e.data = data;
                }
                int l = 0;
                while (l < listeners.length) {
                    listeners[l].handleEvent(e);
                    ++l;
                }
            }
        }
    }

    private void handleDoubleClick(IStructuredSelection sel) {
        Person person;
        Object partner = sel.getFirstElement();
        if (partner instanceof ImChatWindowPartner && (person = ((ImChatWindowPartner)partner).getPerson()) != null) {
            PeopleUtil.getPeopleService().createConversation(person);
        }
    }

    public static void main(String[] asdf) {
        Display display = new Display();
        Shell shell = new Shell(display);
        shell.setLayout((Layout)new FillLayout());
        final Table stable = new Table((Composite)shell, 65536);
        stable.setLinesVisible(true);
        TableColumn col = new TableColumn(stable, 0);
        col.setWidth(25);
        col = new TableColumn(stable, 0);
        col.setWidth(100);
        col = new TableColumn(stable, 0);
        col.setWidth(25);
        col = new TableColumn(stable, 0);
        col.setWidth(100);
        TableItem item = new TableItem(stable, 0);
        item.setText(new String[]{"as", "name really long one", "as", "another long text"});
        item = new TableItem(stable, 0);
        item.setText(new String[]{"a2", "name really long one another long", "as3", "another long text"});
        stable.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent arg0) {
                int columnCount = stable.getColumnCount();
                if (columnCount > 2) {
                    int more;
                    int totalWidth = 0;
                    int i = 0;
                    while (i < columnCount) {
                        stable.getColumn(i).pack();
                        totalWidth += stable.getColumn(i).getWidth();
                        if (logger == null) {
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = Class.forName("com.ibm.collaboration.realtime.chatwindow.NwayParticipantList");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            NwayParticipantList.logger = Logger.getLogger(clazz.getName());
                        }
                        if (logger.isLoggable(Level.INFO)) {
                            logger.log(Level.INFO, String.valueOf(i) + ": " + stable.getColumn(i).getWidth());
                        }
                        ++i;
                    }
                    if (totalWidth < stable.getClientArea().width) {
                        more = stable.getClientArea().width - totalWidth;
                        int curr = stable.getColumn(1).getWidth();
                        stable.getColumn(1).setWidth(curr + more);
                        if (logger == null) {
                            Class<?> clazz = class$0;
                            if (clazz == null) {
                                try {
                                    clazz = class$0 = Class.forName("com.ibm.collaboration.realtime.chatwindow.NwayParticipantList");
                                }
                                catch (ClassNotFoundException classNotFoundException) {
                                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                }
                            }
                            NwayParticipantList.logger = Logger.getLogger(clazz.getName());
                        }
                        if (logger.isLoggable(Level.INFO)) {
                            logger.log(Level.INFO, "less " + stable.getColumn(1).getWidth());
                        }
                    } else if (totalWidth > stable.getClientArea().width) {
                        more = totalWidth - stable.getClientArea().width;
                        int curr = stable.getColumn(1).getWidth();
                        if (curr - more > 0) {
                            stable.getColumn(1).setWidth(curr - more);
                            if (logger == null) {
                                Class<?> clazz = class$0;
                                if (clazz == null) {
                                    try {
                                        clazz = class$0 = Class.forName("com.ibm.collaboration.realtime.chatwindow.NwayParticipantList");
                                    }
                                    catch (ClassNotFoundException classNotFoundException) {
                                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                                    }
                                }
                                NwayParticipantList.logger = Logger.getLogger(clazz.getName());
                            }
                            if (logger.isLoggable(Level.INFO)) {
                                logger.log(Level.INFO, "greater " + stable.getColumn(1).getWidth());
                            }
                        }
                    }
                }
            }
        });
        shell.pack();
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        display.dispose();
    }

    protected void select(ImChatWindowPartner partner) {
        if (this.tableViewer != null) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)partner));
        }
    }

    public boolean isUiCreated() {
        return this.uiCreated;
    }
}

