/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.chatwindow;

import com.ibm.collaboration.realtime.chatwindow.ImChatPlugin;
import com.ibm.collaboration.realtime.chatwindow.ImChatWindowPartner;
import com.ibm.collaboration.realtime.chatwindow.ListExtension;
import com.ibm.collaboration.realtime.chatwindow.NwayParticipantList;
import com.ibm.collaboration.realtime.chatwindow.strings.Messages;
import com.ibm.collaboration.realtime.people.PeopleUtil;
import com.ibm.collaboration.realtime.people.Person;
import com.ibm.collaboration.realtime.tableextension.NwayTableLabelProvider;
import com.ibm.collaboration.realtime.ui.util.ColorCache;
import com.ibm.collaboration.realtime.util.OSUtils;
import com.ibm.rcp.swt.swidgets.table.IPaintModifier;
import java.util.Iterator;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TableItem;

class ImChatWindowLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableColorProvider,
ITableFontProvider {
    private final Color colorGray = Display.getCurrent().getSystemColor(15);
    NwayParticipantList list;
    boolean useTextOnly = false;
    Font bold;
    Font italic;

    public ImChatWindowLabelProvider(NwayParticipantList list) {
        this.list = list;
        FontData df = null;
        df = OSUtils.isMac() ? list.getTableViewer().getTable().getFont().getFontData()[0] : Display.getCurrent().getSystemFont().getFontData()[0];
        df.setStyle(1);
        this.bold = new Font((Device)list.getTableViewer().getTable().getDisplay(), df);
        df.setStyle(2);
        this.italic = new Font((Device)list.getTableViewer().getTable().getDisplay(), df);
        this.useTextOnly = list.useTextOnly;
    }

    public void dispose() {
        this.bold.dispose();
        this.italic.dispose();
        super.dispose();
    }

    public Image getColumnImage(Object element, int columnIndex) {
        if (this.useTextOnly) {
            return null;
        }
        if (element instanceof ImChatWindowPartner) {
            Rectangle itemBounds;
            TableItem item;
            int i;
            ImChatWindowPartner ip = (ImChatWindowPartner)element;
            ListExtension[] exts = this.list.getEnabledExtensions();
            if (exts != null) {
                i = 0;
                while (i < exts.length) {
                    Image im;
                    ListExtension ext = exts[i];
                    NwayTableLabelProvider provider = ext.getLabelProvider();
                    if (provider != null && provider.isGlobal() && (im = provider.getColumnImage(element, columnIndex)) != null) {
                        int k = 0;
                        while (k < this.list.getTableViewer().getTable().getItemCount()) {
                            TableItem item2 = this.list.getTableViewer().getTable().getItem(k);
                            if (element.equals(item2.getData())) {
                                item2.setData("image" + columnIndex, (Object)im);
                                Rectangle itemBounds2 = item2.getBounds(columnIndex);
                                item2.getParent().redraw(itemBounds2.x, itemBounds2.y, itemBounds2.width, itemBounds2.height, true);
                                return null;
                            }
                            ++k;
                        }
                    }
                    ++i;
                }
            }
            if (columnIndex == 0) {
                Image typing = null;
                if (ip.typing) {
                    typing = ImChatPlugin.getDefault().getImageRegistry().get(ImChatPlugin.IMAGE_TYPING);
                }
                int i2 = 0;
                while (i2 < this.list.getTableViewer().getTable().getItemCount()) {
                    item = this.list.getTableViewer().getTable().getItem(i2);
                    if (element.equals(item.getData())) {
                        item.setData("image" + columnIndex, (Object)typing);
                        itemBounds = item.getBounds(columnIndex);
                        item.getParent().redraw(itemBounds.x, itemBounds.y, itemBounds.width, itemBounds.height, true);
                        return null;
                    }
                    ++i2;
                }
                return null;
            }
            if (columnIndex == 1) {
                if (ip.getJoinState() != 1 || ip.getPerson() == null) {
                    i = 0;
                    while (i < this.list.getTableViewer().getTable().getItemCount()) {
                        TableItem item3 = this.list.getTableViewer().getTable().getItem(i);
                        if (element.equals(item3.getData())) {
                            item3.setData("image" + columnIndex, null);
                            Rectangle itemBounds3 = item3.getBounds(columnIndex);
                            item3.getParent().redraw(itemBounds3.x, itemBounds3.y, itemBounds3.width, itemBounds3.height, true);
                            return null;
                        }
                        ++i;
                    }
                    return null;
                }
                if (ip.getPerson() != null) {
                    Image im = ip.getPerson().getStatusImage();
                    if (im == null) {
                        im = ip.getPerson().getStatusImage();
                    }
                    int i3 = 0;
                    while (i3 < this.list.getTableViewer().getTable().getItemCount()) {
                        item = this.list.getTableViewer().getTable().getItem(i3);
                        if (element.equals(item.getData())) {
                            item.setData("image" + columnIndex, (Object)im);
                            itemBounds = item.getBounds(columnIndex);
                            item.getParent().redraw(itemBounds.x, itemBounds.y, itemBounds.width, itemBounds.height, true);
                            return null;
                        }
                        ++i3;
                    }
                    return null;
                }
            } else if (columnIndex > 2) {
                int currIndex = 3;
                if (exts != null) {
                    int i4 = 0;
                    while (i4 < exts.length) {
                        ListExtension ext = exts[i4];
                        int cols = ext.getColumnCount();
                        int j = 0;
                        while (j < cols) {
                            Image colimage;
                            NwayTableLabelProvider provider = ext.getLabelProvider();
                            if (j + currIndex >= columnIndex && provider != null && (colimage = provider.getColumnImage(element, columnIndex - currIndex)) != null) {
                                int k = 0;
                                while (k < this.list.getTableViewer().getTable().getItemCount()) {
                                    TableItem item4 = this.list.getTableViewer().getTable().getItem(k);
                                    if (element.equals(item4.getData())) {
                                        item4.setData("image" + columnIndex, (Object)colimage);
                                        Rectangle itemBounds4 = item4.getBounds(columnIndex);
                                        item4.getParent().redraw(itemBounds4.x, itemBounds4.y, itemBounds4.width, itemBounds4.height, true);
                                        return null;
                                    }
                                    ++k;
                                }
                            }
                            ++j;
                        }
                        if (cols > 0) {
                            currIndex += cols;
                        }
                        ++i4;
                    }
                }
            }
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (element instanceof ImChatWindowPartner) {
            if (columnIndex == 2) {
                ImChatWindowPartner ip = (ImChatWindowPartner)element;
                String alias = ip.getName();
                return alias;
            }
            if (columnIndex > 2) {
                int currIndex = 3;
                ListExtension[] exts = this.list.getEnabledExtensions();
                if (exts != null) {
                    int i = 0;
                    while (i < exts.length) {
                        ListExtension ext = exts[i];
                        int cols = ext.getColumnCount();
                        int j = 0;
                        while (j < cols) {
                            NwayTableLabelProvider provider = ext.getLabelProvider();
                            if (j + currIndex >= columnIndex && provider != null) {
                                return provider.getColumnText(element, columnIndex - currIndex);
                            }
                            ++j;
                        }
                        if (cols > 0) {
                            currIndex += cols;
                        }
                        ++i;
                    }
                }
            }
        }
        if (this.useTextOnly) {
            return this.getColumnToolTipText(element, columnIndex);
        }
        return "";
    }

    public Color getForeground(Object element, int columnIndex) {
        if (Display.getCurrent().getHighContrast()) {
            return null;
        }
        if (columnIndex == 2) {
            if (element instanceof ImChatWindowPartner) {
                if (this.isSelected(element)) {
                    return null;
                }
                ImChatWindowPartner partner = (ImChatWindowPartner)element;
                if (partner != null) {
                    if (partner.getJoinState() == 1) {
                        return ColorCache.getColor((String)"STATUS_ACTIVE_FOREGROUND");
                    }
                    return this.colorGray;
                }
                return ColorCache.getColor((String)"STATUS_ACTIVE_FOREGROUND");
            }
        } else {
            int currIndex = 3;
            ListExtension[] exts = this.list.getEnabledExtensions();
            if (exts != null) {
                int i = 0;
                while (i < exts.length) {
                    ListExtension ext = exts[i];
                    if (this.list.hasExtension(ext.getId())) {
                        int cols = ext.getColumnCount();
                        int j = 0;
                        while (j < cols) {
                            NwayTableLabelProvider provider = ext.getLabelProvider();
                            if (j + currIndex >= columnIndex && provider instanceof ITableColorProvider) {
                                return ((ITableColorProvider)provider).getForeground(element, columnIndex - currIndex);
                            }
                            ++j;
                        }
                        currIndex += cols;
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }

    public Font getFont(Object element, int columnIndex) {
        if (columnIndex == 2) {
            if (element instanceof ImChatWindowPartner) {
                ImChatWindowPartner partner = (ImChatWindowPartner)element;
                if (partner != null) {
                    if (partner.getJoinState() == 1) {
                        Person person = partner.getPerson();
                        if (person != null && (person.getStatus() == 1 || person.getStatus() == 6)) {
                            return this.bold;
                        }
                        return null;
                    }
                    return this.italic;
                }
                return null;
            }
        } else {
            int currIndex = 3;
            ListExtension[] exts = this.list.getEnabledExtensions();
            if (exts != null) {
                int i = 0;
                while (i < exts.length) {
                    ListExtension ext = exts[i];
                    if (this.list.hasExtension(ext.getId())) {
                        int cols = ext.getColumnCount();
                        int j = 0;
                        while (j < cols) {
                            NwayTableLabelProvider provider = ext.getLabelProvider();
                            if (j + currIndex >= columnIndex && provider instanceof IPaintModifier) {
                                int style = ((IPaintModifier)provider).getStyle(element);
                                if (style == 1) {
                                    return this.bold;
                                }
                                if (style == 2) {
                                    return this.italic;
                                }
                            }
                            ++j;
                        }
                        currIndex += cols;
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    private boolean isSelected(Object element) {
        StructuredSelection selection = (StructuredSelection)this.list.getTableViewer().getSelection();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object select = iter.next();
            if (!select.equals(element)) continue;
            return true;
        }
        return false;
    }

    public String getColumnToolTipText(Object element, int columnIndex) {
        if (element instanceof ImChatWindowPartner) {
            String tooltip = null;
            ImChatWindowPartner ip = (ImChatWindowPartner)element;
            if (columnIndex == 1 && ip.isJoined()) {
                Person person = ip.getPerson();
                if (person != null) {
                    tooltip = PeopleUtil.getStatusText((int)person.getStatus());
                }
            } else if (columnIndex > 2) {
                int currIndex = 3;
                ListExtension[] exts = this.list.getEnabledExtensions();
                if (exts != null) {
                    int i = 0;
                    while (i < exts.length) {
                        ListExtension ext = exts[i];
                        int cols = ext.getColumnCount();
                        int j = 0;
                        while (j < cols) {
                            NwayTableLabelProvider provider = ext.getLabelProvider();
                            if (j + currIndex >= columnIndex && provider != null && (tooltip = provider.getColumnToolTipText(element, columnIndex - currIndex)) != null) {
                                i = exts.length;
                                break;
                            }
                            ++j;
                        }
                        if (cols > 0) {
                            currIndex += cols;
                        }
                        ++i;
                    }
                }
            } else if (columnIndex == 0) {
                ListExtension[] exts = this.list.getEnabledExtensions();
                if (exts != null) {
                    int i = 0;
                    while (i < exts.length) {
                        ListExtension ext = exts[i];
                        NwayTableLabelProvider provider = ext.getLabelProvider();
                        if (provider != null && provider.isGlobal() && (tooltip = provider.getColumnToolTipText(element, columnIndex)) != null) {
                            i = exts.length;
                            break;
                        }
                        ++i;
                    }
                }
                if (tooltip == null && ip.typing) {
                    tooltip = NLS.bind((String)Messages.partner_is_responding, (Object)ip.getName());
                }
            }
            if (columnIndex == 2 || tooltip == null) {
                StringBuffer tooltiptext = new StringBuffer();
                switch (ip.getJoinState()) {
                    case 1: {
                        tooltiptext.append(NLS.bind((String)Messages.alt_joined, (Object)ip.getName()));
                        break;
                    }
                    case 0: {
                        tooltiptext.append(NLS.bind((String)Messages.alt_user_left, (Object)ip.getName()));
                        break;
                    }
                    default: {
                        tooltiptext.append(NLS.bind((String)Messages.alt_not_joined, (Object)ip.getName()));
                    }
                }
                tooltiptext.append("\n");
                tooltiptext.append(com.ibm.collaboration.realtime.people.strings.Messages.right_click_for);
                tooltip = tooltiptext.toString();
            }
            return tooltip;
        }
        return null;
    }

    public int getRole(Object element, int columnIndex) {
        if (columnIndex > 2) {
            int currIndex = 3;
            ListExtension[] exts = this.list.getEnabledExtensions();
            if (exts != null) {
                int i = 0;
                while (i < exts.length) {
                    ListExtension ext = exts[i];
                    int cols = ext.getColumnCount();
                    int j = 0;
                    while (j < cols) {
                        NwayTableLabelProvider provider = ext.getLabelProvider();
                        if (j + currIndex >= columnIndex && provider != null) {
                            return provider.getRole(element, columnIndex - currIndex);
                        }
                        ++j;
                    }
                    if (cols > 0) {
                        currIndex += cols;
                    }
                    ++i;
                }
            }
        }
        return 41;
    }
}

