/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.chatwindow;

import com.ibm.collaboration.realtime.chat.actions.ChatWindowAction;
import com.ibm.collaboration.realtime.chat.logging.IChatTranscript;
import com.ibm.collaboration.realtime.chatwindow.ChatActionContributionItem;
import com.ibm.collaboration.realtime.chatwindow.ChatWindowPreferences;
import com.ibm.collaboration.realtime.chatwindow.ImChatPlugin;
import com.ibm.collaboration.realtime.chatwindow.ImChatWindowHandler;
import com.ibm.collaboration.realtime.chatwindow.strings.Messages;
import com.ibm.collaboration.realtime.chatwindow.ui.StyledTextChatArea;
import com.ibm.collaboration.realtime.contacts.search.DirectoryInfo;
import com.ibm.collaboration.realtime.people.Person;
import com.ibm.collaboration.realtime.people.internal.PersonImpl;
import com.ibm.collaboration.realtime.people.internal.ui.StackedBizCards;
import com.ibm.collaboration.realtime.quickfind.QuickFindResult;
import com.ibm.collaboration.realtime.quickfind.ui.QuickFindWidget;
import com.ibm.collaboration.realtime.ui.ImageMgr;
import com.ibm.collaboration.realtime.ui.StatusExtension;
import com.ibm.collaboration.realtime.ui.StatusImageKey;
import com.ibm.collaboration.realtime.ui.util.ColorCache;
import com.ibm.collaboration.realtime.ui.util.ImageCache;
import com.ibm.rcp.realtime.livenames.LiveName;
import com.ibm.rcp.realtime.livenames.ui.BusinessCard;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;

public class ImChatWindow {
    private ArrayList handlers;
    private Shell shell;
    protected StackedBizCards bizCards;
    private StackLayout stack;
    private Composite comp;
    private Sash sash;
    protected QuickFindWidget quickFind;
    private boolean horizontalTabs = false;
    private boolean showQuickFind = true;
    private final Listener keyupFilter = new Listener(){

        public void handleEvent(Event e) {
            Control focus = Display.getDefault().getFocusControl();
            if (focus != null && focus.getParent() != null && focus.getParent().getParent() != null && focus.getParent().getParent().equals(ImChatWindow.this.bizCards)) {
                if (ImChatWindow.this.horizontalTabs) {
                    if ((e.stateMask & 0x40000) == 262144 && (e.keyCode == 0x1000001 || e.keyCode == 0x1000002)) {
                        ImChatWindow.this.setFocusOnSash();
                    }
                } else if ((e.stateMask & 0x40000) == 262144 && (e.keyCode == 0x1000003 || e.keyCode == 0x1000004)) {
                    ImChatWindow.this.setFocusOnSash();
                }
            }
        }
    };
    private final Listener selectListener = new Listener(){

        public void handleEvent(Event e) {
            int index;
            ImChatWindowHandler h;
            if (e.widget instanceof StyledTextChatArea && (h = ((StyledTextChatArea)e.widget).getChatWindowHandler()) != null && (index = ImChatWindow.this.getIndex(h)) != -1 && ImChatWindow.this.bizCards.getState(index) == 2) {
                ImChatWindow.this.bizCards.select(index);
                h.showTrayIcon(false);
            }
        }
    };
    private ImChatWindowHandler mostRecent;

    public ImChatWindow() {
        this.showQuickFind = ImChatPlugin.getDefault().getPrefAsBoolean(ChatWindowPreferences.PREF_SHOW_QUICKFIND);
        this.createShell();
    }

    protected void createShell() {
        FormData fd2;
        if (this.shell != null && !this.shell.isDisposed()) {
            return;
        }
        this.shell = new Shell(Display.getDefault(), 0x4F0 | Window.getDefaultOrientation());
        this.shell.setLayout((Layout)new FormLayout());
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FormData fd = (FormData)ImChatWindow.this.bizCards.getLayoutData();
                if (fd != null) {
                    if (fd.width != -1) {
                        ImChatPlugin.getDefault().getPluginPreferences().setValue("cardWidth", fd.width);
                    } else if (fd.height != -1) {
                        ImChatPlugin.getDefault().getPluginPreferences().setValue("cardHeight", fd.height);
                    }
                    ImChatPlugin.getDefault().savePluginPreferences();
                }
                ImChatWindowHandler[] hs = ImChatPlugin.getDefault().getImChatController().getConversations().values().toArray(new ImChatWindowHandler[0]);
                int i = 0;
                while (i < hs.length) {
                    block9: {
                        ImChatWindowHandler handler = hs[i];
                        if (handler != null) {
                            try {
                                if (handler.getBaseComposite().getParent().equals(ImChatWindow.this.comp)) {
                                    handler.handleClose();
                                }
                            }
                            catch (Throwable t) {
                                if (!ImChatPlugin.logger.isLoggable(Level.INFO)) break block9;
                                ImChatPlugin.logger.log(Level.INFO, t.getMessage(), t);
                            }
                        }
                    }
                    ++i;
                }
                hs = null;
                ImChatWindow.this.shell = null;
                ImChatWindow.this.handlers.clear();
                ImChatWindow.this.handlers = null;
                Display.getDefault().removeFilter(2, ImChatWindow.this.keyupFilter);
                ImChatPlugin.getDefault().getImChatController().removeTabbedWindow(ImChatWindow.this);
            }
        });
        this.quickFind = new QuickFindWidget((Composite)this.shell, 0){

            public boolean handleSelection(QuickFindResult quickFindr) {
                return QuickFindWidget.STATUS_UNHANDLED;
            }
        };
        this.quickFind.setDrawBackgroundGradient(true);
        this.horizontalTabs = ImChatPlugin.getDefault().getPluginPreferences().getBoolean("horizontalTabs");
        this.bizCards = new StackedBizCards((Composite)this.shell, this.horizontalTabs ? 256 : 512){

            public void handleCardSelected(BusinessCard card) {
                ImChatWindowHandler handler;
                String conv;
                ImChatWindow.this.setCurrentChat(card);
                int index = ImChatWindow.this.bizCards.indexOf(card);
                if (index > -1 && ImChatWindow.this.handlers.size() > index && (conv = (String)ImChatWindow.this.handlers.get(index)) != null && (handler = ImChatPlugin.getChatWindow(conv)) != null) {
                    handler.getTranscriptArea().redraw();
                }
            }

            public void handleCardClosed(BusinessCard card) {
                ImChatWindow.this.removeChatWindowHandler(card);
            }

            public void handleCardMenuOpened(IMenuManager mm, BusinessCard card) {
            }
        };
        this.bizCards.setShowCloseButtons(true);
        this.bizCards.setOverflowToolTip(Messages.moreTabsToolTip);
        this.sash = new Sash((Composite)this.shell, this.horizontalTabs ? 256 : 512);
        this.sash.addMouseListener((MouseListener)new MouseAdapter(){
            Point cursor = null;

            public void mouseDown(MouseEvent arg0) {
                if (this.cursor == null) {
                    this.cursor = Display.getDefault().getCursorLocation();
                }
            }

            public void mouseUp(MouseEvent e) {
                Point end = Display.getDefault().getCursorLocation();
                Rectangle sashBounds = ImChatWindow.this.bizCards.getBounds();
                FormData fd = (FormData)ImChatWindow.this.bizCards.getLayoutData();
                if (this.cursor != null) {
                    if (!ImChatWindow.this.horizontalTabs) {
                        int width = sashBounds.width + (end.x - this.cursor.x);
                        if (Window.getDefaultOrientation() == 0x4000000) {
                            width = sashBounds.width - (end.x - this.cursor.x);
                        }
                        fd.width = ImChatWindow.this.checkWidth(width);
                    } else {
                        int height = sashBounds.height + (end.y - this.cursor.y);
                        fd.height = ImChatWindow.this.checkHeight(height);
                    }
                    ImChatWindow.this.shell.layout();
                    this.cursor = null;
                }
            }
        });
        this.sash.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (ImChatWindow.this.horizontalTabs) {
                    if (e.keyCode == 0x1000001) {
                        Rectangle sashBounds = ImChatWindow.this.bizCards.getBounds();
                        FormData fd = (FormData)ImChatWindow.this.bizCards.getLayoutData();
                        int end = sashBounds.height - 10;
                        fd.height = ImChatWindow.this.checkHeight(end);
                        ImChatWindow.this.shell.layout();
                        ImChatWindow.this.setFocusOnSash();
                    } else if (e.keyCode == 0x1000002) {
                        Rectangle sashBounds = ImChatWindow.this.bizCards.getBounds();
                        FormData fd = (FormData)ImChatWindow.this.bizCards.getLayoutData();
                        int end = sashBounds.height + 10;
                        fd.height = ImChatWindow.this.checkHeight(end);
                        ImChatWindow.this.shell.layout();
                        ImChatWindow.this.setFocusOnSash();
                    }
                } else {
                    boolean rtl;
                    boolean bl = rtl = Window.getDefaultOrientation() == 0x4000000;
                    if (!rtl && e.keyCode == 0x1000003 || rtl && e.keyCode == 0x1000004) {
                        Rectangle sashBounds = ImChatWindow.this.bizCards.getBounds();
                        FormData fd = (FormData)ImChatWindow.this.bizCards.getLayoutData();
                        int end = sashBounds.width - 10;
                        fd.width = ImChatWindow.this.checkWidth(end);
                        ImChatWindow.this.shell.layout();
                        ImChatWindow.this.setFocusOnSash();
                    } else if (!rtl && e.keyCode == 0x1000004 || Window.getDefaultOrientation() == 0x4000000 && e.keyCode == 0x1000003) {
                        Rectangle sashBounds = ImChatWindow.this.bizCards.getBounds();
                        FormData fd = (FormData)ImChatWindow.this.bizCards.getLayoutData();
                        int end = sashBounds.width + 10;
                        fd.width = ImChatWindow.this.checkWidth(end);
                        ImChatWindow.this.shell.layout();
                        ImChatWindow.this.setFocusOnSash();
                    }
                }
            }

            public void keyReleased(KeyEvent arg0) {
            }
        });
        Display.getDefault().addFilter(2, this.keyupFilter);
        this.sash.setBackground(ColorCache.getColor((String)"SEPARATOR_BACKGROUND"));
        FormData fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        if (!this.showQuickFind) {
            fd.height = 0;
        }
        this.quickFind.setLayoutData((Object)fd);
        fd = new FormData();
        fd.top = new FormAttachment(0, 0);
        fd.left = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.bizCards.setLayoutData((Object)fd);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent event) {
                String conv;
                ImChatWindowHandler handler;
                if (ImChatWindow.this.handlers != null && ImChatWindow.this.handlers.size() > 1) {
                    event.doit = ImChatWindow.this.checkBeforeClosing();
                } else if (ImChatWindow.this.handlers != null && ImChatWindow.this.handlers.size() == 1 && (handler = ImChatPlugin.getChatWindow(conv = (String)ImChatWindow.this.handlers.get(0))) != null) {
                    event.doit = handler.checkBeforeClosing();
                }
            }
        });
        this.comp = new Composite((Composite)this.shell, 0);
        this.stack = new StackLayout();
        this.comp.setLayout((Layout)this.stack);
        if (this.handlers == null) {
            this.handlers = new ArrayList();
        }
        if (!this.horizontalTabs) {
            int cardWidth = ImChatPlugin.getDefault().getPluginPreferences().getInt("cardWidth");
            fd2 = new FormData();
            fd2.top = new FormAttachment((Control)this.quickFind, 0);
            fd2.left = new FormAttachment(0, 0);
            fd2.bottom = new FormAttachment(100, 0);
            fd2.width = cardWidth > 0 ? cardWidth : 100;
            this.bizCards.setLayoutData((Object)fd2);
            fd = new FormData();
            fd.top = new FormAttachment(0, 0);
            fd.left = new FormAttachment((Control)this.bizCards, 0);
            fd.bottom = new FormAttachment(100, 0);
            this.sash.setLayoutData((Object)fd);
            fd2 = new FormData();
            fd2.top = new FormAttachment((Control)this.quickFind, 0);
            fd2.left = new FormAttachment((Control)this.sash, 0);
            fd2.bottom = new FormAttachment(100, 0);
            fd2.right = new FormAttachment(100, 0);
            this.comp.setLayoutData((Object)fd2);
        } else {
            int cardHeight = ImChatPlugin.getDefault().getPluginPreferences().getInt("cardHeight");
            fd2 = new FormData();
            fd2.top = new FormAttachment((Control)this.quickFind, 0);
            fd2.left = new FormAttachment(0, 0);
            fd2.right = new FormAttachment(100, 0);
            fd2.height = cardHeight > 0 ? cardHeight : -1;
            this.bizCards.setLayoutData((Object)fd2);
            fd = new FormData();
            fd.top = new FormAttachment((Control)this.bizCards, 0);
            fd.left = new FormAttachment(0, 0);
            fd.right = new FormAttachment(100, 0);
            this.sash.setLayoutData((Object)fd);
            fd2 = new FormData();
            fd2.top = new FormAttachment((Control)this.sash, 0);
            fd2.left = new FormAttachment(0, 0);
            fd2.bottom = new FormAttachment(100, 0);
            fd2.right = new FormAttachment(100, 0);
            this.comp.setLayoutData((Object)fd2);
        }
        int windowWidth = 460;
        int windowHeight = 370;
        int prefw = ImChatPlugin.getDefault().getPrefAsInt(ChatWindowPreferences.PREF_PREVIOUS_WIDTH);
        int prefh = ImChatPlugin.getDefault().getPrefAsInt(ChatWindowPreferences.PREF_PREVIOUS_HEIGHT);
        if (prefw > 0 && prefh > 0) {
            windowWidth = prefw;
            windowHeight = prefh;
        }
        this.shell.setSize(windowWidth, windowHeight);
    }

    private int checkWidth(int width) {
        if (width < 10) {
            width = 10;
        } else if (width > this.shell.getBounds().width - 20) {
            width = this.shell.getBounds().width - 20;
        }
        return width;
    }

    private int checkHeight(int height) {
        if (height < 10) {
            height = 10;
        } else if (height > this.shell.getClientArea().height - 50 - this.quickFind.getBounds().height) {
            height = this.shell.getClientArea().height - 50 - this.quickFind.getBounds().height;
        }
        return height;
    }

    private void setFocusOnSash() {
        UIJob b = new UIJob("SashFocus"){

            public IStatus runInUIThread(IProgressMonitor arg0) {
                Point d = ImChatWindow.this.sash.getParent().toDisplay(ImChatWindow.this.sash.getLocation());
                if (!ImChatWindow.this.horizontalTabs) {
                    d.y += ((ImChatWindow)ImChatWindow.this).sash.getSize().y / 2;
                } else {
                    d.x += ((ImChatWindow)ImChatWindow.this).sash.getSize().x / 2;
                }
                Display.getDefault().setCursorLocation(d);
                ImChatWindow.this.sash.setFocus();
                return Status.OK_STATUS;
            }
        };
        b.setSystem(true);
        b.schedule();
    }

    public Shell getShell() {
        if (this.shell == null || this.shell.isDisposed()) {
            this.createShell();
        }
        return this.shell;
    }

    private void setCurrentChat(BusinessCard card) {
        block5: {
            String conv;
            int index = this.bizCards.indexOf(card);
            if (index > -1 && this.handlers.size() > index && (conv = (String)this.handlers.get(index)) != null) {
                ImChatWindowHandler handler = ImChatPlugin.getChatWindow(conv);
                if (handler != null) {
                    this.setCurrentChat(handler);
                    return;
                }
                try {
                    handler = ImChatPlugin.getDefault().getImChatController().getReplacementWindow(card.getLiveName().getContactId(), conv, card.getLiveName().getCommunityId());
                    if (handler != null) {
                        this.handlers.set(index, handler.getConversationId());
                        this.setCurrentChat(handler);
                    }
                }
                catch (Throwable t) {
                    if (!ImChatPlugin.logger.isLoggable(Level.INFO)) break block5;
                    ImChatPlugin.logger.log(Level.INFO, conv, t);
                }
            }
        }
    }

    protected void setCurrentChat(ImChatWindowHandler handler) {
        if (handler == null) {
            return;
        }
        if (handler.equals(this.mostRecent)) {
            this.mostRecent = null;
        }
        this.stack.topControl = handler.getBaseComposite();
        this.comp.layout();
        if (handler._parent != null) {
            handler._parent.layout();
        }
        int index = this.getIndex(handler);
        this.bizCards.select(index);
        if (handler.isMultiChat()) {
            IChatTranscript transcript = handler.getChatTranscript(false);
            if (transcript != null) {
                handler.setTitle(transcript.getChatTopic());
            }
        } else {
            BusinessCard card = this.bizCards.getSelectedCard();
            if (card != null) {
                LiveName ln = card.getLiveName();
                handler.setTitle(ln.getDisplayName());
            }
        }
        this.resetMenu(handler);
        handler.getSendArea().setFocus();
        handler.showTrayIcon(false);
    }

    private void resetMenu(ImChatWindowHandler handler) {
        if (this.shell != null && handler != null && handler.getMenuManager() != null) {
            this.shell.setMenuBar(handler.getMenuManager().getMenu());
        }
    }

    private void resetChatHandler(IContributionItem[] items, ImChatWindowHandler handler) {
        int i = 0;
        while (i < items.length) {
            if (items[i] instanceof ChatActionContributionItem) {
                ChatActionContributionItem cc = (ChatActionContributionItem)items[i];
                if (cc.getAction() instanceof ChatWindowAction) {
                    ChatWindowAction action = (ChatWindowAction)cc.getAction();
                    action.setChatWindowHandler(handler);
                }
            } else if (items[i] instanceof IMenuManager) {
                IMenuManager mm = (IMenuManager)items[i];
                this.resetChatHandler(mm.getItems(), handler);
            }
            ++i;
        }
    }

    private void removeChatWindowHandler(BusinessCard card) {
        String conv;
        int index = this.bizCards.indexOf(card);
        if (index > -1 && this.handlers.size() > index && (conv = (String)this.handlers.get(index)) != null) {
            block6: {
                ImChatWindowHandler handler = ImChatPlugin.getChatWindow(conv);
                if (handler != null) {
                    this.removeChatWindowHandler(handler);
                } else {
                    try {
                        handler = ImChatPlugin.getDefault().getImChatController().getReplacementWindow(card.getLiveName().getContactId(), conv, card.getLiveName().getCommunityId());
                        if (handler != null) {
                            this.handlers.set(index, handler.getConversationId());
                            this.removeChatWindowHandler(handler);
                        }
                    }
                    catch (Throwable t) {
                        if (!ImChatPlugin.logger.isLoggable(Level.INFO)) break block6;
                        ImChatPlugin.logger.log(Level.INFO, conv, t);
                    }
                }
            }
            return;
        }
    }

    protected void removeBizCard(ImChatWindowHandler handler) {
        int index = this.getIndex(handler);
        if (index != -1) {
            this.bizCards.removeCardAt(index);
        }
        if (this.handlers != null) {
            if (this.handlers.contains(handler.getConversationId())) {
                this.handlers.remove(handler.getConversationId());
            }
            if (this.handlers.size() > 0) {
                BusinessCard card;
                String conv = (String)this.handlers.get(this.handlers.size() - 1);
                ImChatWindowHandler h = ImChatPlugin.getChatWindow(conv);
                if (h == null && (card = this.bizCards.getCardAt(index = this.handlers.size() - 1)) != null) {
                    try {
                        h = ImChatPlugin.getDefault().getImChatController().getReplacementWindow(card.getLiveName().getContactId(), conv, card.getLiveName().getCommunityId());
                        this.handlers.set(index, h.getConversationId());
                    }
                    catch (Throwable throwable) {}
                }
                this.setCurrentChat(h);
            }
        }
    }

    public void removeChatWindowHandler(ImChatWindowHandler handler) {
        boolean closed = false;
        boolean disposeShell = false;
        if (this.handlers.size() == 1) {
            disposeShell = true;
            closed = handler.close(true);
        } else {
            closed = handler.checkBeforeClosing();
        }
        if (closed) {
            this.removeBizCard(handler);
            if (!disposeShell) {
                handler.handleClose();
            }
            return;
        }
    }

    public void addChatWindowHandler(ImChatWindowHandler handler) {
        Shell activeShell;
        int cardHeight;
        if (this.shell == null || this.shell.isDisposed()) {
            this.createShell();
        }
        if (this.handlers.contains(handler.getConversationId())) {
            if (handler.getLocallyInitiated() || this.handlers.size() == 1) {
                this.setCurrentChat(handler);
            }
            return;
        }
        if (handler._oldConversationID != null && this.handlers.contains(handler._oldConversationID)) {
            int index = this.getIndex(handler);
            this.handlers.set(index, handler.getConversationId());
            if (handler.getLocallyInitiated() || this.handlers.size() == 1) {
                this.setCurrentChat(handler);
            }
            return;
        }
        this.handlers.add(handler.getConversationId());
        handler.setParent(this.getComposite());
        handler.setShell(this.getShell());
        handler.initWindow();
        handler.getSendArea().addListener(15, this.selectListener);
        handler.getSendArea().addListener(3, this.selectListener);
        handler.getSendArea().addListener(24, this.selectListener);
        handler.getSendArea().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                Control c = (Control)e.getSource();
                c.removeListener(15, ImChatWindow.this.selectListener);
                c.removeListener(3, ImChatWindow.this.selectListener);
                c.removeListener(24, ImChatWindow.this.selectListener);
            }
        });
        this.bizCards.addPerson(handler.getFirstPartner().getPerson());
        if (this.handlers.size() == 1 && this.horizontalTabs && (cardHeight = ImChatPlugin.getDefault().getPluginPreferences().getInt("cardHeight")) <= 0) {
            this.bizCards.pack();
            this.bizCards.getParent().layout();
        }
        if ((activeShell = Display.getDefault().getActiveShell()) == null || this.handlers.size() == 1) {
            this.bizCards.select(this.handlers.indexOf(handler.getConversationId()));
            this.stack.topControl = handler.getBaseComposite();
            this.comp.layout();
        }
    }

    private Composite getComposite() {
        if (this.comp == null || this.comp.isDisposed()) {
            this.createShell();
        }
        return this.comp;
    }

    public void notifyIncoming(ImChatWindowHandler handler) {
        int index = this.getIndex(handler);
        this.bizCards.notify(index);
        this.mostRecent = handler;
    }

    public void open() {
        this.shell.open();
    }

    protected boolean checkBeforeClosing() {
        ImChatWindowHandler handler;
        if (this.handlers != null && this.handlers.size() > 1) {
            return MessageDialog.openQuestion((Shell)this.shell, (String)Messages.ImChatWindowHandler_104, (String)Messages.closeTabbedWindowWarning);
        }
        if (this.handlers != null && this.handlers.size() == 1 && (handler = ImChatPlugin.getChatWindow((String)this.handlers.get(0))) != null) {
            return handler.checkBeforeClosing();
        }
        return true;
    }

    public int getNumOpenWindows() {
        if (this.handlers != null) {
            return this.handlers.size();
        }
        return 0;
    }

    protected void setMultiChat(ImChatWindowHandler handler, String displayName) {
        int index = this.getIndex(handler);
        BusinessCard card = this.bizCards.getCardAt(index);
        if (card != null) {
            PersonImpl dummy = new PersonImpl(null, false, null, null){

                public Image getStatusImage() {
                    return ImageCache.getImage((Plugin)ImChatPlugin.getDefault(), (String)"images/NWay_Chat_14x14.png");
                }

                public int getStatus() {
                    return 5;
                }
            };
            dummy.setDisplayName(displayName);
            card.setLiveName((LiveName)dummy);
            this.bizCards.layout();
        }
    }

    protected int getIndex(ImChatWindowHandler handler) {
        if (this.handlers == null) {
            return -1;
        }
        int index = this.handlers.indexOf(handler.getConversationId());
        if (index == -1 && handler._oldConversationID != null) {
            index = this.handlers.indexOf(handler._oldConversationID);
        }
        return index;
    }

    private void setLatest(ImChatWindowHandler handler) {
        int index;
        if (handler != null && this.bizCards.getState(index = this.getIndex(handler)) == 2) {
            this.setCurrentChat(handler);
        }
    }

    protected int getIndex(String conversationID) {
        if (this.handlers == null) {
            return -1;
        }
        return this.handlers.indexOf(conversationID);
    }

    protected void setTyping(ImChatWindowHandler handler, boolean typing) {
        int index = this.getIndex(handler);
        BusinessCard card = this.bizCards.getCardAt(index);
        if (typing) {
            LiveName old = card.getLiveName();
            if (old instanceof PersonImpl && !(old instanceof TypingPerson)) {
                PersonImpl impl = (PersonImpl)old;
                TypingPerson dummy = new TypingPerson(impl);
                dummy.setDisplayName(impl.getDisplayName());
                card.setLiveName((LiveName)dummy);
                handler.getBaseComposite().setData("livename", (Object)impl);
            }
        } else {
            LiveName current;
            PersonImpl ln = (PersonImpl)handler.getBaseComposite().getData("livename");
            if (ln != null && (current = card.getLiveName()) instanceof TypingPerson) {
                ln.removePropertyChangeListener((PropertyChangeListener)((TypingPerson)current));
                ((TypingPerson)current).dispose();
                current = null;
                card.setLiveName((LiveName)ln);
            }
        }
    }

    public void setMultiTabImage(ImChatWindowHandler handler, final Image image) {
        LiveName old;
        int index = this.getIndex(handler);
        BusinessCard card = this.bizCards.getCardAt(index);
        if (card != null && (old = card.getLiveName()) instanceof PersonImpl) {
            PersonImpl impl = (PersonImpl)old;
            PersonImpl dummy = new PersonImpl(null, false, null, null){

                public Image getStatusImage() {
                    return image;
                }

                public int getStatus() {
                    return 5;
                }
            };
            dummy.setDisplayName(impl.getDisplayName());
            card.setLiveName((LiveName)dummy);
            this.bizCards.layout();
        }
    }

    public void setMultiTabText(ImChatWindowHandler handler, String text) {
        LiveName old;
        int index = this.getIndex(handler);
        BusinessCard card = this.bizCards.getCardAt(index);
        if (card != null && (old = card.getLiveName()) instanceof PersonImpl) {
            PersonImpl impl = (PersonImpl)old;
            impl.setDisplayName(text);
            card.setLiveName((LiveName)impl);
            this.bizCards.layout();
        }
    }

    public void setShowQuickFind(boolean show) {
        this.showQuickFind = show;
        if (this.quickFind != null) {
            FormData fd = (FormData)this.quickFind.getLayoutData();
            if (fd != null) {
                if (show && fd.height == 0) {
                    fd.height = -1;
                } else if (!show && fd.height != 0) {
                    fd.height = 0;
                }
            }
            this.quickFind.setLayoutData((Object)fd);
            this.quickFind.getParent().layout();
        }
    }

    private class TypingPerson
    extends PersonImpl
    implements PropertyChangeListener {
        PersonImpl real;
        Image typing;

        TypingPerson(PersonImpl old) {
            super(old.getContactId(), false, old.getGatewayCommunity(), old.getCommunityId());
            this.real = null;
            this.typing = null;
            this.real = old;
            this.real.addPropertyChangeListener((PropertyChangeListener)this);
        }

        public DirectoryInfo getDirectoryInfo() {
            return this.real.getDirectoryInfo();
        }

        public Image getStatusImage() {
            StatusImageKey key = this.real.getStatusImgKey();
            if (key != null) {
                key.setStatusExtension(StatusExtension.EXT_TYPING);
                return ImageMgr.getInstance().getStatusImage(key);
            }
            if (this.typing == null) {
                this.typing = ImageMgr.getInstance().createImageOverlayAlpha(this.real.getStatusImage(), ImageMgr.getInstance().getTypingOverlay(), false, 0, null, null, true);
            }
            return this.typing;
        }

        public int getStatus() {
            return this.real.getStatus();
        }

        public void propertyChange(PropertyChangeEvent e) {
            Person person = (Person)e.getSource();
            if ("status".equals(e.getPropertyName())) {
                this.setStatus(person.getStatus());
            } else if ("displayName".equals(e.getPropertyName())) {
                this.setDisplayName(person.getDisplayName());
            }
        }

        public void dispose() {
            if (this.typing != null) {
                this.typing.dispose();
            }
        }
    }
}

