/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.chatwindow;

import com.ibm.collaboration.realtime.browser.Browser;
import com.ibm.collaboration.realtime.chatwindow.ChatControllerService;
import com.ibm.collaboration.realtime.chatwindow.ChatWindowPreferences;
import com.ibm.collaboration.realtime.chatwindow.ImChatActionDescriptor;
import com.ibm.collaboration.realtime.chatwindow.ImChatAreaView;
import com.ibm.collaboration.realtime.chatwindow.ImChatController;
import com.ibm.collaboration.realtime.chatwindow.ImChatWindowHandler;
import com.ibm.collaboration.realtime.chatwindow.ListExtension;
import com.ibm.collaboration.realtime.chatwindow.strings.LogMessages;
import com.ibm.collaboration.realtime.chatwindow.ui.BrowserChatTranscript;
import com.ibm.collaboration.realtime.magiccarpet.MessageEventCode;
import com.ibm.collaboration.realtime.servicehub.ServiceException;
import com.ibm.collaboration.realtime.servicehub.ServiceHub;
import com.ibm.collaboration.realtime.ui.RtcUIPlugin;
import com.ibm.collaboration.realtime.ui.util.ImageCache;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.DeviceResourceException;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.progress.UIJob;
import org.osgi.framework.BundleContext;

public class ImChatPlugin
extends RtcUIPlugin {
    static final Logger logger;
    private static ImChatPlugin plugin;
    private ImChatController controller = null;
    private ArrayList chatActions;
    private ArrayList listExtensions;
    private ArrayList popupAddons;
    private HashMap chatAreas;
    private boolean isInitialized;
    protected static String IMAGE_TYPING;
    protected static String IMAGE_ENCRYPTED;
    protected static String IMAGE_NOT_ENCRYPTED;
    protected static String CHAT_ACTION_EXT_POINT;
    private static ResourceManager resourceManager;
    public static final MessageEventCode PopupAddon;
    public static final MessageEventCode EmbedObject;
    public static final MessageEventCode NwayListExtension;
    public static final MessageEventCode NwayListUpdate;
    public static final MessageEventCode ChatArea;
    public static final MessageEventCode ChatAlertArea;
    private IPropertyChangeListener prefListener;
    public static boolean isUsingXulrunner;
    private static PreloadImagesJob preloadImagesJob;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.collaboration.realtime.chatwindow.ImChatPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
        IMAGE_TYPING = "IMAGE_TYPING";
        IMAGE_ENCRYPTED = "IMAGE_ENCRYPTED";
        IMAGE_NOT_ENCRYPTED = "IMAGE_NOT_ENCRYPTED";
        CHAT_ACTION_EXT_POINT = "chatAction";
        PopupAddon = new MessageEventCode("/app/chatwindow/addon");
        EmbedObject = new MessageEventCode("/app/chatwindow/embedobject");
        NwayListExtension = new MessageEventCode("/app/chatwindow/nwaylist/extensions");
        NwayListUpdate = new MessageEventCode("/app/chatwindow/nwaylist/update");
        ChatArea = new MessageEventCode("/app/chatwindow/chatarea");
        ChatAlertArea = new MessageEventCode("/app/chatwindow/chatalertarea");
        isUsingXulrunner = false;
    }

    public ImChatPlugin() {
        plugin = this;
    }

    public ImChatController getImChatController() {
        block4: {
            if (this.controller == null) {
                try {
                    this.controller = (ImChatController)ServiceHub.getService((String)ChatControllerService.SERVICE_TYPE);
                }
                catch (ServiceException e) {
                    if (!logger.isLoggable(Level.SEVERE)) break block4;
                    logger.log(Level.SEVERE, LogMessages.cannotGetChatController, e);
                }
            }
        }
        if (this.controller == null) {
            throw new IllegalStateException(LogMessages.cannotGetChatController);
        }
        return this.controller;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    protected synchronized void initialize() {
        if (!this.isInitialized) {
            Job job = new Job("ImChatPlugin StartupJob"){

                protected IStatus run(IProgressMonitor monitor) {
                    ImChatPlugin.this.doInitialize();
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
            ImChatPlugin.preloadImages();
            this.isInitialized = true;
        }
    }

    private void doInitialize() {
        this.getImChatController().registerCapabilities();
        this.loadChatWindowExtensions();
        BrowserChatTranscript.resetStyleFromPrefs(this.getPreferenceStore());
        if (this.prefListener == null) {
            this.prefListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent e) {
                    if (e.getProperty().equals("currentCss")) {
                        BrowserChatTranscript.resetStyleFromPrefs(ImChatPlugin.this.getPreferenceStore());
                    }
                }
            };
            this.getPreferenceStore().addPropertyChangeListener(this.prefListener);
        }
        isUsingXulrunner = "com.ibm.swt.xulrunner.browser.SWTXULRunnerBrowser".compareTo(Browser.getRealBrowserClass().getName()) == 0;
    }

    public void stop(BundleContext context) throws Exception {
        try {
            if (this.getPreferenceStore() != null) {
                this.getPreferenceStore().removePropertyChangeListener(this.prefListener);
            }
        }
        catch (Throwable throwable) {}
        boolean saveTabs = ImChatPlugin.getDefault().getPrefAsBoolean(ChatWindowPreferences.PREF_SAVE_CHATS);
        XMLMemento memento = null;
        if (saveTabs) {
            memento = ImChatPlugin.getDefault().getWriteMemento("openChats");
        }
        ImChatWindowHandler[] hs = this.getImChatController().getConversations().values().toArray(new ImChatWindowHandler[0]);
        int i = 0;
        while (i < hs.length) {
            ImChatWindowHandler handler = hs[i];
            if (handler != null && memento != null) {
                IMemento child;
                if (handler.isMultiChat()) {
                    if (handler.hasActivity("chatroom")) {
                        child = memento.createChild("chat");
                        child.putString("type", "chatroom");
                        child.putString("chatid", handler.getConversationId());
                    } else {
                        child = memento.createChild("chat");
                        child.putString("type", "nway");
                        child.putString("chatid", handler.getPlaceID());
                        if (handler.chatDisplayName != null) {
                            child.putString("name", handler.chatDisplayName);
                        }
                    }
                } else if (handler.getFirstPartner() != null) {
                    child = memento.createChild("chat");
                    child.putString("type", "single");
                    child.putString("chatid", handler.getFirstPartner().getContactId());
                }
            }
            ++i;
        }
        if (saveTabs && memento != null) {
            ImChatPlugin.getDefault().saveMemento("openChats.xml", memento);
        }
        super.stop(context);
    }

    public static ImChatPlugin getDefault() {
        return plugin;
    }

    public static ImageDescriptor getImageDesc(String path) {
        return ImChatPlugin.imageDescriptorFromPlugin((String)ImChatPlugin.getDefault().getBundle().getSymbolicName(), (String)path);
    }

    public static synchronized void preloadImages() {
        if (preloadImagesJob == null) {
            preloadImagesJob = new PreloadImagesJob("preload images");
            preloadImagesJob.setPriority(50);
            preloadImagesJob.schedule(1500L);
            preloadImagesJob.addJobChangeListener((IJobChangeListener)ImChatPlugin.getDefault().getImChatController().jobListener);
        }
    }

    public static void addImagePreloadListener(IJobChangeListener listener) {
        if (preloadImagesJob == null) {
            ImChatPlugin.preloadImages();
        }
        preloadImagesJob.addJobChangeListener(listener);
    }

    public static ImageDescriptor loadImageInJob(String bundleName, String path) {
        final ImageDescriptor imageDescriptor = ImageCache.getImageDescriptor((String)bundleName, (String)path);
        if (imageDescriptor == null) {
            return null;
        }
        if (resourceManager.find((DeviceResourceDescriptor)imageDescriptor) == null) {
            new UIJob("load image"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    block2: {
                        try {
                            resourceManager.createImage(imageDescriptor);
                        }
                        catch (Exception e) {
                            if (!logger.isLoggable(Level.FINE)) break block2;
                            logger.log(Level.FINE, LogMessages.ImChatPlugin_48, e);
                        }
                    }
                    return Status.OK_STATUS;
                }
            }.schedule();
        }
        return imageDescriptor;
    }

    public static Image findImage(String path) {
        Image image;
        block4: {
            image = null;
            try {
                ImageDescriptor imageDescriptor = ImChatPlugin.getImageDesc(path);
                Object obj = resourceManager.find((DeviceResourceDescriptor)imageDescriptor);
                if (obj instanceof Image) {
                    image = (Image)obj;
                }
                if (image == null) {
                    return resourceManager.createImage(imageDescriptor);
                }
            }
            catch (DeviceResourceException e) {
                if (!logger.isLoggable(Level.FINE)) break block4;
                logger.log(Level.FINE, LogMessages.ImChatPlugin_49, e);
            }
        }
        return image;
    }

    public static Image getCachedImage(String path) {
        try {
            return resourceManager.createImage(ImChatPlugin.getImageDesc(path));
        }
        catch (DeviceResourceException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, LogMessages.ImChatPlugin_50, e);
            }
            return null;
        }
    }

    public static void returnCachedImage(String path) {
        resourceManager.destroyImage(ImChatPlugin.getImageDesc(path));
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        super.initializeImageRegistry(reg);
        reg.put(IMAGE_TYPING, ImChatPlugin.getImageDesc("images" + File.separator + "ST_Typing_Message.png"));
        reg.put(IMAGE_ENCRYPTED, ImChatPlugin.getImageDesc("images" + File.separator + "ST_Lock.png"));
        reg.put(IMAGE_NOT_ENCRYPTED, ImChatPlugin.getImageDesc("images" + File.separator + "ST_Unlock.png"));
    }

    private void loadChatWindowExtensions() {
        int j;
        IConfigurationElement[] elements;
        int index;
        IExtension[] extensions;
        this.chatActions = new ArrayList();
        String pluginId = this.getBundle().getSymbolicName();
        IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(pluginId, "chatAction");
        if (extensionPoint != null && (extensions = extensionPoint.getExtensions()) != null) {
            index = 0;
            while (index < extensions.length) {
                elements = extensions[index].getConfigurationElements();
                j = 0;
                while (j < elements.length) {
                    ImChatActionDescriptor desc = new ImChatActionDescriptor(extensions[index].getNamespaceIdentifier(), elements[j]);
                    this.chatActions.add(desc);
                    ++j;
                }
                ++index;
            }
        }
        if ((extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(pluginId, "nwayListExtension")) != null && (extensions = extensionPoint.getExtensions()) != null) {
            index = 0;
            while (index < extensions.length) {
                elements = extensions[index].getConfigurationElements();
                if (elements != null) {
                    if (this.listExtensions == null) {
                        this.listExtensions = new ArrayList();
                    }
                    j = 0;
                    while (j < elements.length) {
                        ListExtension extension = new ListExtension(elements[j]);
                        this.listExtensions.add(extension);
                        ++j;
                    }
                }
                ++index;
            }
        }
        if ((extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(pluginId, "popupAddOn")) != null && (extensions = extensionPoint.getExtensions()) != null) {
            index = 0;
            while (index < extensions.length) {
                elements = extensions[index].getConfigurationElements();
                if (elements != null) {
                    if (this.popupAddons == null) {
                        this.popupAddons = new ArrayList();
                    }
                    j = 0;
                    while (j < elements.length) {
                        this.popupAddons.add(elements[j]);
                        ++j;
                    }
                }
                ++index;
            }
        }
        if ((extensionPoint = Platform.getExtensionRegistry().getExtensionPoint(pluginId, "chatArea")) != null && (extensions = extensionPoint.getExtensions()) != null) {
            index = 0;
            while (index < extensions.length) {
                elements = extensions[index].getConfigurationElements();
                if (elements != null) {
                    if (this.chatAreas == null) {
                        this.chatAreas = new HashMap(5);
                    }
                    j = 0;
                    while (j < elements.length) {
                        this.chatAreas.put(elements[j].getAttribute("id"), new ImChatAreaView(extensions[index].getNamespaceIdentifier(), elements[j]));
                        ++j;
                    }
                }
                ++index;
            }
        }
    }

    public ArrayList getChatWindowActions() {
        return this.chatActions;
    }

    public ArrayList getListExtensions() {
        return this.listExtensions;
    }

    public ArrayList getPopupAddOns() {
        return this.popupAddons;
    }

    public HashMap getChatAreas() {
        return this.chatAreas;
    }

    public Image getImage(String path) {
        ImageRegistry registry = this.getImageRegistry();
        Image im = registry.get(path);
        if (im != null) {
            return im;
        }
        ImageDescriptor desc = registry.getDescriptor(path);
        if (desc != null) {
            im = desc.createImage();
            registry.remove(path);
            registry.put(path, im);
        } else {
            desc = ImChatPlugin.getImageDesc(path);
            im = desc.createImage();
            registry.put(path, im);
        }
        return im;
    }

    public String getImageAsURL(String filename) {
        try {
            return FileLocator.toFileURL((URL)ImChatPlugin.getDefault().getBundle().getEntry("/" + filename)).toString();
        }
        catch (Exception exception) {
            return filename;
        }
    }

    public static ImChatWindowHandler getChatWindow(String conversationID) {
        if (ImChatPlugin.getDefault().getImChatController() != null) {
            return ImChatPlugin.getDefault().getImChatController().getHandler(conversationID);
        }
        return null;
    }

    public static ImChatWindowHandler getChatWindowFromPlaceID(String placeID) {
        Map map = ImChatPlugin.getDefault().getImChatController().getConversations();
        if (map != null) {
            Iterator iter = map.values().iterator();
            while (iter.hasNext()) {
                ImChatWindowHandler ich = (ImChatWindowHandler)iter.next();
                if (ich.getPlaceID() == null || !ich.getPlaceID().equals(placeID)) continue;
                return ich;
            }
        }
        return null;
    }

    protected XMLMemento getReadMemento(String filename) {
        try {
            return XMLMemento.createReadRoot((Reader)new FileReader(this.getStateLocation().append(filename).toFile()));
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected XMLMemento getWriteMemento(String root) {
        return XMLMemento.createWriteRoot((String)root);
    }

    protected void saveMemento(String filename, XMLMemento memento) {
        block3: {
            try {
                File file = this.getStateLocation().append(filename).toFile();
                if (!file.exists()) {
                    file.createNewFile();
                }
                FileWriter writer = new FileWriter(file);
                memento.save((Writer)writer);
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.WARNING)) break block3;
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    private static final class PreloadImagesJob
    extends UIJob {
        private PreloadImagesJob(String name) {
            super(name);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            block2: {
                ImChatPlugin.resourceManager = JFaceResources.getResources((Display)this.getDisplay());
                String bundleName = ImChatPlugin.getDefault().getBundle().getSymbolicName();
                try {
                    resourceManager.createImage(ImChatPlugin.imageDescriptorFromPlugin((String)bundleName, (String)"images/toolbar/tb_18_bold_n.png"));
                    resourceManager.createImage(ImChatPlugin.imageDescriptorFromPlugin((String)bundleName, (String)"images/toolbar/tb_18_bold_d.png"));
                    resourceManager.createImage(ImChatPlugin.imageDescriptorFromPlugin((String)bundleName, (String)"images/toolbar/tb_18_style_n.png"));
                    resourceManager.createImage(ImChatPlugin.imageDescriptorFromPlugin((String)bundleName, (String)"images/toolbar/tb_18_style_d.png"));
                    resourceManager.createImage(ImChatPlugin.imageDescriptorFromPlugin((String)bundleName, (String)"images/send_bg.png"));
                    resourceManager.createImage(ImChatPlugin.imageDescriptorFromPlugin((String)bundleName, (String)"images/send_bg_off.png"));
                    resourceManager.createImage(ImChatPlugin.imageDescriptorFromPlugin((String)bundleName, (String)"images/send_corner.png"));
                    resourceManager.createImage(ImChatPlugin.imageDescriptorFromPlugin((String)bundleName, (String)"images/send_corner_off.png"));
                    resourceManager.createImage(ImChatPlugin.imageDescriptorFromPlugin((String)bundleName, (String)"images/toolbar/tb_18_textbox_n.png"));
                    resourceManager.createImage(ImChatPlugin.imageDescriptorFromPlugin((String)bundleName, (String)"images/toolbar/tb_18_textbox_d.png"));
                    resourceManager.createImage(ImChatPlugin.imageDescriptorFromPlugin((String)bundleName, (String)"images/toolbar/tb_18_enlarge_text_n.png"));
                    resourceManager.createImage(ImChatPlugin.imageDescriptorFromPlugin((String)bundleName, (String)"images/toolbar/tb_18_enlarge_d.png"));
                    resourceManager.createImage(ImChatPlugin.imageDescriptorFromPlugin((String)bundleName, (String)"images/toolbar/tb_18_italic_n.png"));
                    resourceManager.createImage(ImChatPlugin.imageDescriptorFromPlugin((String)bundleName, (String)"images/toolbar/tb_18_italic_d.png"));
                    resourceManager.createImage(ImChatPlugin.imageDescriptorFromPlugin((String)bundleName, (String)"images/toolbar/tb_18_reduce_text_n.png"));
                    resourceManager.createImage(ImChatPlugin.imageDescriptorFromPlugin((String)bundleName, (String)"images/toolbar/tb_18_reduce_text_d.png"));
                    resourceManager.createImage(ImChatPlugin.imageDescriptorFromPlugin((String)bundleName, (String)"images/toolbar/tb_18_underline_n.png"));
                    resourceManager.createImage(ImChatPlugin.imageDescriptorFromPlugin((String)bundleName, (String)"images/toolbar/tb_18_underline_d.png"));
                    resourceManager.createImage(ImChatPlugin.imageDescriptorFromPlugin((String)bundleName, (String)"images/toolbar/Hyper_Link.png"));
                    resourceManager.createImage(ImChatPlugin.imageDescriptorFromPlugin((String)bundleName, (String)"images/ST_Screen_Capture.png"));
                    resourceManager.createImage(ImChatPlugin.imageDescriptorFromPlugin((String)bundleName, (String)"images/ST_Lock.png"));
                    resourceManager.createImage(ImChatPlugin.imageDescriptorFromPlugin((String)bundleName, (String)"images/toolbar/Font_Color_d.png"));
                    resourceManager.createImage(ImChatPlugin.imageDescriptorFromPlugin((String)bundleName, (String)"images/toolbar/Font_Color_n.png"));
                    resourceManager.createImage(ImChatPlugin.imageDescriptorFromPlugin((String)bundleName, (String)"images/toolbar/Background_Color_n.png"));
                    resourceManager.createImage(ImChatPlugin.imageDescriptorFromPlugin((String)bundleName, (String)"images/toolbar/Background_Color_d.png"));
                    resourceManager.createImage(ImChatPlugin.imageDescriptorFromPlugin((String)bundleName, (String)"icon/icon.png"));
                    resourceManager.createImage(ImChatPlugin.imageDescriptorFromPlugin((String)bundleName, (String)"images/ST_Screen_Capture_off.png"));
                    resourceManager.createImage(ImChatPlugin.imageDescriptorFromPlugin((String)bundleName, (String)"images/ST_NWay_Chat.png"));
                    resourceManager.createImage(ImChatPlugin.imageDescriptorFromPlugin((String)bundleName, (String)"images/ST_Typing_Message.png"));
                    resourceManager.createImage(ImChatPlugin.imageDescriptorFromPlugin((String)bundleName, (String)"icon/ST_Awns_Chat_Window_16x16.png"));
                    resourceManager.createImage(ImChatPlugin.imageDescriptorFromPlugin((String)bundleName, (String)"icon/ST_Awns_Chat_Window_32x32.png"));
                }
                catch (DeviceResourceException e) {
                    if (!logger.isLoggable(Level.WARNING)) break block2;
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
            return Status.OK_STATUS;
        }
    }
}

