/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.chatwindow;

import com.ibm.collaboration.realtime.chatwindow.ImChatController;
import com.ibm.collaboration.realtime.chatwindow.ImChatPlugin;
import com.ibm.collaboration.realtime.chatwindow.ImChatWindowHandler;
import com.ibm.collaboration.realtime.chatwindow.addon.Embeddable;
import com.ibm.collaboration.realtime.chatwindow.strings.LogMessages;
import com.ibm.collaboration.realtime.chatwindow.strings.Messages;
import com.ibm.collaboration.realtime.im.community.CommunityInternal;
import com.ibm.collaboration.realtime.im.community.CommunityUtil;
import com.ibm.collaboration.realtime.invitations.BasicInviteDialog;
import com.ibm.collaboration.realtime.invitations.ChatInviteReceivedDialog;
import com.ibm.collaboration.realtime.magiccarpet.MessageEvent;
import com.ibm.collaboration.realtime.magiccarpet.MessageEventCode;
import com.ibm.collaboration.realtime.magiccarpet.MessageEventConstants;
import com.ibm.collaboration.realtime.magiccarpet.MessageEventGuiAdapter;
import com.ibm.collaboration.realtime.magiccarpet.SearchEventConstants;
import com.ibm.collaboration.realtime.magiccarpet.StandardMessageEventConstants;
import com.ibm.collaboration.realtime.magiccarpet.messageprocessor.MessageProcessor;
import com.ibm.collaboration.realtime.people.PeopleUtil;
import com.ibm.collaboration.realtime.people.Person;
import com.ibm.collaboration.realtime.people.PersonInternal;
import com.ibm.collaboration.realtime.ui.DisplayLoop;
import com.ibm.collaboration.realtime.ui.util.ImageCache;
import com.ibm.collaboration.realtime.util.ListImplodeExplode;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ImChatEventHandler
extends MessageEventGuiAdapter {
    static final MessageEventCode ImRichTextEnabledDisabled = new MessageEventCode("/transport/richtext/enabledDisabled");
    static String ID = "com.ibm.collaboration.realtime.chatwindow.eventhandler";
    static final Logger logger;
    protected ArrayList allowSendHistory = null;
    protected static final String REPLACE_TEXT = "replaceText";
    protected static final String APPEND_TEXT = "appendText";
    protected static final String EVENT_TYPE = "eventType";
    protected static boolean bPlayAlertSound;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.collaboration.realtime.chatwindow.ImChatEventHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
        bPlayAlertSound = true;
    }

    protected void registerEvents() {
        super.registerEvents();
        this.registerEventListener(StandardMessageEventConstants.InitializeCommand);
        this.registerEventListener(StandardMessageEventConstants.PlugInBroadcastInfo);
        this.registerEventListener(MessageEventConstants.PartnerStatusUpdate);
        this.registerEventListener(MessageEventConstants.PlugInShowConfigurationWindow);
        this.registerEventListener(MessageEventConstants.ImConnected);
        this.registerEventListener(MessageEventConstants.ImDisconnected);
        this.registerEventListener(MessageEventConstants.ManyToManyInvite);
        this.registerEventListener(MessageEventConstants.ManyToManyCreate);
        this.registerEventListener(MessageEventConstants.ManyToManyCreateSuccess);
        this.registerEventListener(MessageEventConstants.ManyToManyTextReceived);
        this.registerEventListener(MessageEventConstants.ManyToManyTranscriptReceived);
        this.registerEventListener(MessageEventConstants.ManyToManyUserEnterExit);
        this.registerEventListener(MessageEventConstants.ManyToManyShowInviteDialog);
        this.registerEventListener(MessageEventConstants.ManyToManyInviteOthers);
        this.registerEventListener(MessageEventConstants.ImTextConnectionOpen);
        this.registerEventListener(MessageEventConstants.ImTextConnectionOpenSuccess);
        this.registerEventListener(MessageEventConstants.ImTextConnectionOpenFailed);
        this.registerEventListener(MessageEventConstants.ImTextReceived);
        this.registerEventListener(MessageEventConstants.ImTextConnectionClosed);
        this.registerEventListener(MessageEventConstants.ImTextTyping);
        this.registerEventListener(MessageEventConstants.ImTextSendFailed);
        this.registerEventListener(MessageEventConstants.ResetUser);
        this.registerEventListener(StandardMessageEventConstants.ShutdownCommand);
        this.registerEventListener(StandardMessageEventConstants.PlugInInitializedAll);
        this.registerEventListener(SearchEventConstants.PersonSearchResponse);
        this.registerEventListener(MessageEventConstants.ManyToManyTextConnectionClosed);
        this.registerEventListener(ImRichTextEnabledDisabled);
        this.registerEventListener(MessageEventConstants.ImChatWindowEventResponse);
        this.registerEventListener(MessageEventConstants.ImChatWindowCloseWarning);
        this.registerEventListener(MessageEventConstants.GeneralInformationMesseage);
        this.registerEventListener(MessageEventConstants.ImChatWindowForceFocus);
        this.registerEventListener(MessageEventConstants.ImChatWindowFlashWindow);
        this.registerEventListener(ImChatPlugin.NwayListExtension);
        this.registerEventListener(ImChatPlugin.NwayListUpdate);
        this.registerEventListener(ImChatPlugin.PopupAddon);
        this.registerEventListener(ImChatPlugin.EmbedObject);
        this.registerEventListener(ImChatPlugin.ChatArea);
        this.registerEventListener(ImChatPlugin.ChatAlertArea);
        this.registerEventListener(new MessageEventCode("/alerts/muted"));
        this.registerEventListener(new MessageEventCode("/alerts/unmuted"));
        this.registerEventListener(MessageEventConstants.PolicyChanged);
    }

    public static boolean isBPlayAlertSound() {
        return bPlayAlertSound;
    }

    public static void setBPlayAlertSound(boolean playAlertSound) {
        bPlayAlertSound = playAlertSound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void guiHandleMessageEvent(MessageEvent event) {
        String partnerId;
        Hashtable parent;
        String conversationID;
        ImChatWindowHandler iwh;
        if (event.getMessageEventCode().equals((Object)StandardMessageEventConstants.InitializeCommand)) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, NLS.bind((String)LogMessages.initializeCommand, (Object)this.getID()));
            }
            MessageEvent me = new MessageEvent(StandardMessageEventConstants.PlugInInitialized);
            ImChatPlugin.getDefault().getImChatController().postMessageEvent(me);
        } else if (event.matches(MessageEventConstants.PlugInShowConfigurationWindow)) {
            if (event.getDestinationID().equalsIgnoreCase(this.getID()) && event.getProperty((Object)"ConferenceAlertSettings") != null) {
                ImChatPlugin.getDefault().getImChatController().configureNwayAlerts();
            }
        } else if (event.matches(MessageEventConstants.ImConnected) || event.matches(MessageEventConstants.ImDisconnected)) {
            event.getSourceID();
            String __connectionUID = (String)event.getProperty((Object)"connectionUID");
            boolean connected = event.matches(MessageEventConstants.ImConnected);
            if (connected) {
                ImChatPlugin.getDefault().initialize();
            }
            Iterator it = ImChatPlugin.getDefault().getImChatController().getConversations().values().iterator();
            while (it.hasNext()) {
                iwh = (ImChatWindowHandler)it.next();
                if (iwh == null || !iwh._connectionUID.equalsIgnoreCase(__connectionUID)) continue;
                iwh.setDimmed(!connected);
                iwh.setStatusTextAndImage(null, null);
                if (connected) continue;
                if (iwh.isMultiChat()) {
                    iwh.clearRemotePartners();
                    continue;
                }
                iwh.setRichTextBytesCapable(false);
                iwh.setRichTextEnabled(false);
            }
        } else if (event.matches(MessageEventConstants.PartnerStatusUpdate)) {
            String listUID = (String)event.getProperty((Object)"listUID");
            if (listUID == null) {
                String connectionUID = (String)event.getProperty((Object)"connectionUID");
                String cfr_ignored_0 = (String)event.getProperty((Object)"partnerUID");
                String partnerID = (String)event.getProperty((Object)"partnerID");
                String partnerLoginID = (String)event.getProperty((Object)"partnerLoginID");
                String conversationID2 = (String)event.getProperty((Object)"conversationID");
                "true".equals(event.getProperty((Object)"usingICT"));
                String cfr_ignored_1 = (String)event.getProperty((Object)"ictCapabilities");
                String cfr_ignored_2 = (String)event.getProperty((Object)"statusText");
                ImChatPlugin.getDefault().getImChatController().handleOneToOnePartnerUpdate(connectionUID, partnerID, partnerLoginID, conversationID2);
            }
        } else if (event.matches(MessageEventConstants.ImTextSendFailed)) {
            String message;
            conversationID = (String)event.getProperty((Object)"conversationID");
            ImChatWindowHandler iwh2 = ImChatPlugin.getDefault().getImChatController().getHandler(conversationID);
            if (iwh2 != null) {
                iwh2.setDisabled(true);
            }
            if ((message = (String)event.getProperty((Object)"message")) != null) {
                Shell shell = null;
                shell = iwh2 != null ? iwh2.getShell() : PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageDialog.openWarning((Shell)shell, (String)Messages.ImChatWindowPlugIn_85, (String)message);
            } else {
                String partnerUID = (String)event.getProperty((Object)"partnerUID");
                PersonInternal person = PeopleUtil.getPersonById((String)partnerUID);
                if (person != null) {
                    String msg = NLS.bind((String)Messages.messageSendFailed, (Object)person.getDisplayName(), (Object)person.getDisplayName());
                    MessageDialog.openWarning((Shell)iwh2.getShell(), (String)Messages.ImChatWindowPlugIn_85, (String)msg);
                }
            }
        } else if (event.matches(MessageEventConstants.ImTextConnectionOpenFailed)) {
            conversationID = (String)event.getProperty((Object)"conversationID");
            if (conversationID != null) {
                ImChatPlugin.getDefault().getImChatController().handleTextConnectionClosed(event);
            }
        } else if (event.matches(MessageEventConstants.ManyToManyInvite)) {
            String inviteTopic = (String)event.getProperty((Object)"inviteTopic");
            String inviteText = (String)event.getProperty((Object)"inviteText");
            String connectionUID = (String)event.getProperty((Object)"connectionUID");
            String conversationID3 = (String)event.getProperty((Object)"conversationID");
            String partnerUID = (String)event.getProperty((Object)"partnerUID");
            String partnerID = (String)event.getProperty((Object)"partnerID");
            String cfr_ignored_3 = (String)event.getProperty((Object)"partnerAlias");
            ImChatWindowHandler iwh3 = ImChatPlugin.getDefault().getImChatController().getHandler(conversationID3);
            if (iwh3 == null) {
                PersonInternal person;
                Integer numofvitees;
                Shell shell = null;
                boolean disposeMe = false;
                if (iwh3 != null) {
                    shell = iwh3.getShell();
                }
                if (shell == null) {
                    disposeMe = true;
                    shell = new Shell(DisplayLoop.getDisplay(), 18528);
                }
                if ((numofvitees = (Integer)event.getProperty((Object)"numofinvitees")) == null) {
                    numofvitees = new Integer(0);
                }
                if ((person = PeopleUtil.getPersonById((String)partnerUID)) == null) {
                    person = PeopleUtil.getPerson((String)partnerID, (String)connectionUID);
                }
                ChatInviteReceivedDialog dialog = new ChatInviteReceivedDialog(shell, CommunityUtil.getCommunity((String)connectionUID), (Person)person);
                String name = person.getDisplayName();
                dialog.setText(Messages.bind((String)Messages.ModelessYesNoDialogForInvites_2, (Object)name));
                dialog.setMeetingTopic(inviteTopic);
                inviteText = inviteText.replaceAll("&", "&&");
                dialog.setMeetingDescription(inviteText);
                dialog.setNumParticipants(numofvitees.intValue());
                dialog.setOkButtonText(Messages.ImChatEventhandler_Join);
                int retval = dialog.open();
                if (retval == 0) {
                    ImChatPlugin.getDefault().getImChatController().acceptInvite(connectionUID, conversationID3, event.getProperty((Object)"creationInfo"));
                } else {
                    ImChatPlugin.getDefault().getImChatController().declineInvite(connectionUID, conversationID3);
                }
                if (disposeMe) {
                    shell.dispose();
                    shell = null;
                }
            }
        } else if (event.matches(MessageEventConstants.ManyToManyInviteOthers)) {
            conversationID = (String)event.getProperty((Object)"conversationID");
            String[] invitees = (String[])event.getProperty((Object)"inviteList");
            Boolean allow = (Boolean)event.getProperty((Object)"allowTranscript");
            iwh = ImChatPlugin.getDefault().getImChatController().getHandler(conversationID);
            if (iwh != null && invitees != null) {
                if (allow != null) {
                    iwh.allowTranscript = allow;
                }
                iwh.setOriginalInvitees(invitees);
            } else if (iwh == null && allow != null && allow.booleanValue()) {
                if (this.allowSendHistory == null) {
                    this.allowSendHistory = new ArrayList(2);
                }
                this.allowSendHistory.add(conversationID);
            }
        } else if (event.matches(MessageEventConstants.ManyToManyShowInviteDialog)) {
            int retVal;
            Point pt;
            String connUID = (String)event.getProperty((Object)"connectionUID");
            Shell[] shells = Display.getDefault().getShells();
            parent = null;
            int i = 0;
            while (i < shells.length) {
                if (!shells[i].isDisposed()) {
                    parent = shells[i];
                    break;
                }
                ++i;
            }
            CommunityInternal comm = CommunityUtil.getCommunity((String)connUID);
            PersonInternal localPerson = PeopleUtil.getLocalPerson((CommunityInternal)comm);
            BasicInviteDialog iDialog = new BasicInviteDialog((Shell)parent, false, 0, false, connUID);
            String name = localPerson.getDisplayName();
            iDialog.setTopicInitialText(Messages.bind((String)Messages.InviteDialog_chat_with_new, (Object)name));
            iDialog.setText(Messages.dialog_invite_to_meeting);
            iDialog.setInviterName(localPerson.getDisplayName());
            iDialog.setCheckDifferentCommunitiesAdded(true);
            iDialog.setCheckForOffline(true);
            iDialog.setImage(ImageCache.getImage((String)ImageCache.IMAGE_ST_LOGO));
            iDialog.addTools("history", Messages.allowOthersToSeeTranscript, false);
            List list = (List)event.getProperty((Object)"namestoinvite");
            if (list != null) {
                Person[] people = new Person[list.size()];
                int i2 = 0;
                while (i2 < people.length) {
                    Object obj = list.get(i2);
                    if (obj instanceof String) {
                        people[i2] = PeopleUtil.getPerson((String)((String)obj), (String)connUID);
                    }
                    ++i2;
                }
                iDialog.setPersons(people);
            }
            if ((pt = (Point)event.getProperty((Object)"suggestedLocation")) != null) {
                iDialog.getShell().setLocation(pt);
            }
            if ((retVal = iDialog.open()) == 1) {
                return;
            }
            Person[] peeps = iDialog.getParticipants();
            if (peeps != null) {
                String[] invitees = new String[peeps.length];
                int i3 = 0;
                while (i3 < peeps.length) {
                    invitees[i3] = peeps[i3].getContactId();
                    ++i3;
                }
                MessageEvent me = new MessageEvent(MessageEventConstants.ManyToManyInviteOthers);
                me.setProperty((Object)"allowTranscript", (Object)new Boolean(iDialog.getSelection("history")));
                me.setProperty((Object)"connectionUID", (Object)connUID);
                me.setProperty((Object)"inviteList", (Object)invitees);
                me.setProperty((Object)"inviteTopic", (Object)iDialog.getTopic());
                me.setProperty((Object)"conversationID", (Object)("CONV" + MessageProcessor.generateUniqueID()));
                MessageProcessor.getInstance().postMessageEvent(me);
            }
        } else if (event.matches(MessageEventConstants.ImTextConnectionOpen) || event.matches(MessageEventConstants.ManyToManyCreate)) {
            String connectionUID = (String)event.getProperty((Object)"connectionUID");
            String conversationID4 = (String)event.getProperty((Object)"conversationID");
            if (connectionUID != null && conversationID4 != null) {
                parent = ImChatPlugin.getDefault().getImChatController()._pendingOpens;
                synchronized (parent) {
                    String key = String.valueOf(connectionUID) + ":" + conversationID4;
                    ImChatPlugin.getDefault().getImChatController()._pendingOpens.put(key, event);
                    key = null;
                }
            }
        } else if (event.matches(MessageEventConstants.ImTextTyping)) {
            ImChatPlugin.getDefault().getImChatController().handleImTextTypingEvent(event);
        } else if (event.matches(MessageEventConstants.ManyToManyTextConnectionClosed)) {
            conversationID = (String)event.getProperty((Object)"conversationID");
            ImChatController controller = ImChatPlugin.getDefault().getImChatController();
            controller.dyingManyToManyConversations.remove(conversationID);
            controller.handleTextConnectionClosed(event);
        } else if (event.matches(MessageEventConstants.ImTextConnectionOpenSuccess) || event.matches(MessageEventConstants.ImTextReceived) || event.matches(MessageEventConstants.ManyToManyCreateSuccess) || event.matches(MessageEventConstants.ManyToManyTextReceived) || event.matches(MessageEventConstants.ManyToManyTranscriptReceived)) {
            if (event.matches(MessageEventConstants.ManyToManyCreateSuccess)) {
                String convID = (String)event.getProperty((Object)"conversationID");
                if (this.allowSendHistory != null && convID != null && this.allowSendHistory.contains(convID)) {
                    event.setProperty((Object)"allowTranscript", (Object)Boolean.TRUE);
                    this.allowSendHistory.remove(convID);
                }
            }
            ImChatPlugin.getDefault().getImChatController().handleCreateChatHandler(event);
        } else if (event.matches(ImRichTextEnabledDisabled)) {
            ImChatPlugin.getDefault().getImChatController().handleImRichTextEnabledDisabled(event);
        } else if (event.matches(MessageEventConstants.ManyToManyUserEnterExit)) {
            ImChatPlugin.getDefault().getImChatController().handleNwayUserEnterExit(event);
        } else if (event.matches(MessageEventConstants.ImTextConnectionClosed)) {
            ImChatPlugin.getDefault().getImChatController().handleTextConnectionClosed(event);
        } else if (!event.matches(StandardMessageEventConstants.PlugInBroadcastInfo) && !event.matches(StandardMessageEventConstants.PlugInInitializedAll)) {
            if (event.matches(StandardMessageEventConstants.ShutdownCommand)) {
                ImChatPlugin.getDefault().getImChatController().handleShutdown();
            } else if (event.matches(MessageEventConstants.ImChatWindowAddition)) {
                this.handleChatWindowAddition(event);
            } else if (event.matches(MessageEventConstants.ImChatWindowAdditionUpdate)) {
                this.handleChatWindowAdditionUpdate(event);
            } else if (event.getMessageEventCodeString().equals("/alerts/muted")) {
                ImChatEventHandler.setBPlayAlertSound(false);
            }
        }
        if (event.getMessageEventCodeString().equals("/alerts/unmuted")) {
            ImChatEventHandler.setBPlayAlertSound(true);
        } else if (event.matches(MessageEventConstants.ImChatWindowEventResponse)) {
            String text;
            String ident = (String)event.getProperty((Object)"conversationID");
            if (ident == null) {
                return;
            }
            String eventType = (String)event.getProperty((Object)EVENT_TYPE);
            if (eventType == null) {
                return;
            }
            ImChatWindowHandler iwh4 = ImChatPlugin.getChatWindow(ident);
            if (iwh4 == null) {
                return;
            }
            boolean convertHTML = false;
            Object object = event.getProperty((Object)"hasRichText");
            if (object instanceof Boolean) {
                convertHTML = (Boolean)object;
            } else if (object instanceof String) {
                convertHTML = Boolean.valueOf((String)object);
            }
            if (eventType.compareTo(REPLACE_TEXT) == 0) {
                text = (String)event.getProperty((Object)"text");
                iwh4.replaceText(text, convertHTML);
            } else if (eventType.compareTo(APPEND_TEXT) == 0) {
                text = (String)event.getProperty((Object)"text");
                iwh4.appendText(text, convertHTML);
            }
        } else if (event.matches(MessageEventConstants.ImChatWindowCloseWarning)) {
            conversationID = (String)event.getProperty((Object)"conversationID");
            ImChatWindowHandler iwh5 = ImChatPlugin.getChatWindow(conversationID);
            String pluginID = (String)event.getProperty((Object)"pluginID");
            if (iwh5 != null && pluginID != null) {
                boolean enable = (Boolean)event.getProperty((Object)"enabled");
                if (event.getProperty((Object)"messageDialog") != null) {
                    iwh5.setCloseWarning(pluginID, enable, (Dialog)event.getProperty((Object)"messageDialog"));
                } else {
                    iwh5.setCloseWarning(pluginID, enable, (String)event.getProperty((Object)"text"));
                }
            }
        } else if (event.matches(MessageEventConstants.ImChatWindowFlashWindow)) {
            conversationID = (String)event.getProperty((Object)"conversationID");
            ImChatPlugin.getDefault().getImChatController().flashWindow(conversationID);
        } else if (event.matches(MessageEventConstants.ImChatWindowForceFocus)) {
            conversationID = (String)event.getProperty((Object)"conversationID");
            ImChatPlugin.getDefault().getImChatController().forceFocus(conversationID);
        } else if (event.matches(ImChatPlugin.PopupAddon)) {
            ImChatPlugin.getDefault().getImChatController().handlePopupAddon(event);
        } else if (event.matches(ImChatPlugin.NwayListExtension)) {
            String[] extensionIds = (String[])event.getProperty((Object)"extensions");
            String handler = (String)event.getProperty((Object)"conversationID");
            String activity = (String)event.getProperty((Object)"activity");
            Boolean enable = (Boolean)event.getProperty((Object)"enable");
            String label = (String)event.getProperty((Object)"label");
            boolean enableBool = true;
            if (enable != null) {
                enableBool = enable;
            }
            ImChatPlugin.getDefault().getImChatController().handleExtensionUpdate(handler, extensionIds, activity, enableBool, label);
        } else if (event.matches(ImChatPlugin.NwayListUpdate)) {
            partnerId = (String)event.getProperty((Object)"partnerID");
            String handler = (String)event.getProperty((Object)"conversationID");
            ImChatPlugin.getDefault().getImChatController().handleNwayListUpdate(handler, partnerId);
        } else if (event.matches(ImChatPlugin.EmbedObject)) {
            partnerId = (String)event.getProperty((Object)"partnerUID");
            String handler = (String)event.getProperty((Object)"conversationID");
            Embeddable embed = (Embeddable)event.getProperty((Object)"embeddable");
            ImChatPlugin.getDefault().getImChatController().handleEmbedObject(handler, partnerId, embed);
        } else if (event.matches(ImChatPlugin.ChatArea)) {
            String chatAreaID = (String)event.getProperty((Object)"chatAreaID");
            String handler = (String)event.getProperty((Object)"conversationID");
            Boolean enable = (Boolean)event.getProperty((Object)"enable");
            boolean enableBool = true;
            if (enable != null) {
                enableBool = enable;
            }
            ImChatPlugin.getDefault().getImChatController().handleChatAreaEvent(handler, chatAreaID, enableBool);
        } else if (event.matches(MessageEventConstants.ResetUser)) {
            this.handleResetUser();
        } else if (event.matches(MessageEventConstants.PolicyChanged)) {
            String policyKey = (String)event.getProperty((Object)"policyKey");
            String communityId = (String)event.getProperty((Object)"connectionUID");
            Object policyValue = event.getProperty((Object)"policyValue");
            ImChatPlugin.getDefault().getImChatController().handlePolicyUpdate(communityId, policyKey, policyValue);
        } else if (event.matches(ImChatPlugin.ChatAlertArea)) {
            ImChatPlugin.getDefault().getImChatController().handleChatAlertAreaEvent(event);
        }
    }

    private void handleResetUser() {
        ImChatController controller = ImChatPlugin.getDefault().getImChatController();
        Hashtable convs = (Hashtable)controller.getConversations();
        Map conversations = (Map)convs.clone();
        if (conversations != null && conversations.size() > 0) {
            Iterator it = conversations.keySet().iterator();
            while (it.hasNext()) {
                String conversationId = (String)it.next();
                ImChatWindowHandler handler = controller.getHandler(conversationId);
                if (handler == null) continue;
                handler.close();
            }
        }
        controller.hideBlinkingTrayIcon();
    }

    private void handleChatWindowAddition(MessageEvent event) {
        String pluginID = (String)event.getProperty((Object)"pluginID");
        String sourceID = event.getSourceID();
        Vector v = (Vector)event.getProperty((Object)"bulkAdditions");
        if (v != null) {
            ImChatPlugin.getDefault().getImChatController().addChatWindowAddition(pluginID == null ? sourceID : pluginID, v);
        } else {
            ImChatPlugin.getDefault().getImChatController().addChatWindowAddition(pluginID == null ? sourceID : pluginID, event);
        }
    }

    private void handleChatWindowAdditionUpdate(MessageEvent event) {
        String ident = (String)event.getProperty((Object)"ident");
        String pluginID = (String)event.getProperty((Object)"pluginID");
        if (pluginID == null) {
            pluginID = (String)event.getProperty((Object)"pluginAlias");
        }
        String sourceID = event.getSourceID();
        ImChatWindowHandler iwh = null;
        if (ident == null) {
            Iterator convos = ImChatPlugin.getDefault().getImChatController().getConversations().values().iterator();
            Vector v = (Vector)event.getProperty((Object)"bulkUpdates");
            while (convos.hasNext()) {
                iwh = (ImChatWindowHandler)convos.next();
                if (v != null) {
                    int i = 0;
                    while (i < v.size()) {
                        Map map = (Map)v.elementAt(i);
                        if (map != null) {
                            iwh.updateToolBarItem(pluginID == null ? sourceID : pluginID, (String)map.get("id"), (String)map.get("property"), map.get("value"));
                        }
                        ++i;
                    }
                    v.clear();
                    v = null;
                    continue;
                }
                iwh.updateToolBarItem(pluginID == null ? sourceID : pluginID, (String)event.getProperty((Object)"id"), (String)event.getProperty((Object)"property"), event.getProperty((Object)"value"));
            }
            return;
        }
        String[] params = ListImplodeExplode.explode((String)ident, (char)':');
        if (params != null && params.length > 1) {
            iwh = (ImChatWindowHandler)ImChatPlugin.getDefault().getImChatController().getConversations().get(params[1]);
        }
        if (iwh == null) {
            return;
        }
        Vector v = (Vector)event.getProperty((Object)"bulkUpdates");
        if (v != null) {
            int i = 0;
            while (i < v.size()) {
                Map map = (Map)v.elementAt(i);
                if (map != null) {
                    iwh.updateToolBarItem(pluginID == null ? sourceID : pluginID, (String)map.get("id"), (String)map.get("property"), map.get("value"));
                }
                ++i;
            }
            v.clear();
            v = null;
        } else {
            iwh.updateToolBarItem(pluginID == null ? sourceID : pluginID, (String)event.getProperty((Object)"id"), (String)event.getProperty((Object)"property"), event.getProperty((Object)"value"));
        }
    }

    static Person getPerson(MessageEvent msgEvent) {
        PersonInternal person = null;
        String personId = (String)msgEvent.getProperty((Object)"partnerUID");
        person = PeopleUtil.getPersonById((String)personId);
        return person;
    }

    public boolean canBeConsumed() {
        return true;
    }
}

