/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.chatwindow;

import com.ibm.collaboration.realtime.chat.actions.ChatWindowAction;
import com.ibm.collaboration.realtime.chat.logging.ChatLoggingApiPlugin;
import com.ibm.collaboration.realtime.chat.logging.IChatLoggingService;
import com.ibm.collaboration.realtime.chat.logging.IChatLoggingServiceListener;
import com.ibm.collaboration.realtime.chat.logging.internal.ChatLoggingUtil;
import com.ibm.collaboration.realtime.chatwindow.ChatControllerService;
import com.ibm.collaboration.realtime.chatwindow.ChatWindowHandler;
import com.ibm.collaboration.realtime.chatwindow.ChatWindowPreferences;
import com.ibm.collaboration.realtime.chatwindow.GetTranscriptJob;
import com.ibm.collaboration.realtime.chatwindow.ImChatEventHandler;
import com.ibm.collaboration.realtime.chatwindow.ImChatPlugin;
import com.ibm.collaboration.realtime.chatwindow.ImChatWindow;
import com.ibm.collaboration.realtime.chatwindow.ImChatWindowButton;
import com.ibm.collaboration.realtime.chatwindow.ImChatWindowHandler;
import com.ibm.collaboration.realtime.chatwindow.ImChatWindowPartner;
import com.ibm.collaboration.realtime.chatwindow.addon.Embeddable;
import com.ibm.collaboration.realtime.chatwindow.addon.PopupAddOn;
import com.ibm.collaboration.realtime.chatwindow.strings.LogMessages;
import com.ibm.collaboration.realtime.chatwindow.strings.Messages;
import com.ibm.collaboration.realtime.im.community.CommunityInternal;
import com.ibm.collaboration.realtime.im.community.CommunityUtil;
import com.ibm.collaboration.realtime.magiccarpet.MessageEvent;
import com.ibm.collaboration.realtime.magiccarpet.MessageEventCode;
import com.ibm.collaboration.realtime.magiccarpet.MessageEventConstants;
import com.ibm.collaboration.realtime.magiccarpet.messageprocessor.MessageProcessor;
import com.ibm.collaboration.realtime.messages.im.ImTextConnectionOpenMessage;
import com.ibm.collaboration.realtime.messages.im.ManyToManyCreateMessage;
import com.ibm.collaboration.realtime.people.PeopleUtil;
import com.ibm.collaboration.realtime.people.Person;
import com.ibm.collaboration.realtime.people.PersonInternal;
import com.ibm.collaboration.realtime.ui.DisplayLoop;
import com.ibm.collaboration.realtime.ui.util.tray.BlinkingTrayItem;
import com.ibm.collaboration.realtime.util.AudioManager;
import com.ibm.collaboration.realtime.util.ListImplodeExplode;
import com.ibm.collaboration.realtime.util.MultilineTextBuffer;
import java.net.URL;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.progress.UIJob;

public class ImChatController
implements ChatControllerService,
IChatLoggingServiceListener,
Preferences.IPropertyChangeListener {
    protected static MessageEventCode MessageEventAcceptInvite = new MessageEventCode("/app/ImChatWindow/AcceptInvite");
    protected static MessageEventCode FileTransferStarted = new MessageEventCode("/filetransfer/dialogopened");
    protected static MessageEventCode FileTransferStopped = new MessageEventCode("/filetransfer/dialogclosed");
    static final Logger logger;
    protected static final String audio_MessageReceivedKey = "MessageReceived";
    AudioManager _audioManager = new AudioManager();
    protected Hashtable _conversations = new Hashtable(50);
    protected Hashtable _pendingOpens = new Hashtable();
    protected Set dyingManyToManyConversations = new HashSet(4);
    boolean fileXferPluginInstalled = false;
    protected ArrayList _preventSaves = null;
    private HashMap _tabbedWindows = null;
    private IChatLoggingService service;
    private boolean donePreload = false;
    private ArrayList cachedEvents = null;
    protected JobChangeAdapter jobListener = new JobChangeAdapter(){

        public void done(IJobChangeEvent e) {
            boolean reopenTabs;
            ImChatController.this.donePreload = true;
            if (ImChatController.this.cachedEvents != null) {
                UIJob job = new UIJob(this, "openChats"){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                        super($anonymous0);
                    }

                    public IStatus runInUIThread(IProgressMonitor arg0) {
                        int i = 0;
                        while (i < ImChatController.access$1(1.access$0(this.this$1)).size()) {
                            1.access$0(this.this$1).handleCreateChatHandler((MessageEvent)ImChatController.access$1(1.access$0(this.this$1)).get(i));
                            ++i;
                        }
                        ImChatController.access$1(1.access$0(this.this$1)).clear();
                        ImChatController.access$2(1.access$0(this.this$1), null);
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule();
            }
            if (reopenTabs = ImChatPlugin.getDefault().getPluginPreferences().getBoolean(ChatWindowPreferences.PREF_SAVE_CHATS)) {
                Job job = new Job(this, "openChats"){
                    final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = var1_1;
                        super($anonymous0);
                    }

                    protected IStatus run(IProgressMonitor arg0) {
                        XMLMemento memento = ImChatPlugin.getDefault().getReadMemento("openChats.xml");
                        IMemento[] children = memento.getChildren("chat");
                        int i = 0;
                        while (i < children.length) {
                            ManyToManyCreateMessage msg;
                            String type = children[i].getString("type");
                            String chatid = children[i].getString("chatid");
                            if ("nway".equals(type)) {
                                String name = children[i].getString("name");
                                ManyToManyCreateMessage msg2 = new ManyToManyCreateMessage();
                                msg2.setCommunityId(CommunityUtil.getDefaultCommunity().getId());
                                msg2.setPlaceId(chatid);
                                msg2.setLocalContactId(CommunityUtil.getDefaultUsername());
                                if (name != null) {
                                    msg2.setProperty("displayName", (Object)name);
                                }
                                msg2.setProperty("rejoinedAcrossSession", (Object)Boolean.TRUE);
                                msg2.post();
                            } else if ("room".equals(type)) {
                                msg = new ManyToManyCreateMessage();
                                msg.setCommunityId(CommunityUtil.getDefaultCommunity().getId());
                                msg.setPlaceId(chatid);
                                msg.setProperty("isServerBased", (Object)Boolean.TRUE);
                                msg.setLocalContactId(CommunityUtil.getDefaultUsername());
                                msg.setPartnerContactId(CommunityUtil.getDefaultUsername());
                                msg.setProperty("initiator", (Object)"nobody");
                                msg.setProperty("rejoinedAcrossSession", (Object)Boolean.TRUE);
                                msg.post();
                            } else {
                                msg = new ImTextConnectionOpenMessage();
                                msg.setCommunityId(CommunityUtil.getDefaultCommunity().getId());
                                msg.setPartnerContactId(chatid);
                                msg.setLocalContactId(CommunityUtil.getDefaultUsername());
                                msg.setProperty("rejoinedAcrossSession", (Object)Boolean.TRUE);
                                msg.post();
                            }
                            ++i;
                        }
                        return Status.OK_STATUS;
                    }
                };
                job.setSystem(true);
                job.schedule(5000L);
            }
            e.getJob().removeJobChangeListener((IJobChangeListener)this);
        }

        static /* synthetic */ ImChatController access$0(1 var0) {
            return var0.ImChatController.this;
        }
    };
    private Map _chatWindowAdditions;
    private final Hashtable _chatWindowMenuAdditions = new Hashtable();
    HashMap pendingAddons = new HashMap(2);
    BlinkingTrayItem item = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.collaboration.realtime.chatwindow.ImChatController");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    protected void registerCapabilities() {
    }

    public ImChatController() {
        if (Display.getDefault() != null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    Display.getDefault().addFilter(1, new Listener(this){
                        final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void handleEvent(Event e) {
                            block3: {
                                Map conv;
                                block5: {
                                    block4: {
                                        conv = 4.access$0(this.this$1).getConversations();
                                        if (conv == null || conv.size() <= 0) break block3;
                                        if ((e.stateMask & 0x40000) != 262144 || e.keyCode != 109) break block4;
                                        Shell shell = Display.getDefault().getActiveShell();
                                        Iterator<V> iter = conv.values().iterator();
                                        while (iter.hasNext()) {
                                            ImChatWindowHandler handler = (ImChatWindowHandler)iter.next();
                                            if (!handler.getShell().equals(shell) || handler.getSendArea().isFocusControl()) continue;
                                            handler.getSendArea().setFocus();
                                            return;
                                        }
                                        break block3;
                                    }
                                    if ((e.stateMask & 0x40000) != 262144 || e.keyCode != 116) break block5;
                                    Shell shell = Display.getDefault().getActiveShell();
                                    Iterator<V> iter = conv.values().iterator();
                                    while (iter.hasNext()) {
                                        ImChatWindowHandler handler = (ImChatWindowHandler)iter.next();
                                        if (!handler.getShell().equals(shell) || handler.getTranscriptArea().getBrowser().isFocusControl()) continue;
                                        handler.getTranscriptArea().getBrowser().setFocus();
                                        return;
                                    }
                                    break block3;
                                }
                                if ((e.stateMask & 0x40000) != 262144 || e.keyCode != 102) break block3;
                                Shell shell = Display.getDefault().getActiveShell();
                                Iterator<V> iter = conv.values().iterator();
                                while (iter.hasNext()) {
                                    ImChatWindow window;
                                    ImChatWindowHandler handler = (ImChatWindowHandler)iter.next();
                                    if (!handler.getShell().equals(shell) || (window = 4.access$0(this.this$1).findTabbedWindow(handler)) == null || window.quickFind.getTextBox().isFocusControl()) continue;
                                    window.quickFind.getTextBox().setFocus();
                                    return;
                                }
                            }
                        }
                    });
                    Display.getDefault().addFilter(31, new Listener(this){
                        final /* synthetic */ 4 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void handleEvent(Event e) {
                            Map conv = 4.access$0(this.this$1).getConversations();
                            if (conv != null && conv.size() > 0 && e.detail == 2) {
                                Shell shell = Display.getDefault().getActiveShell();
                                Iterator<V> iter = conv.values().iterator();
                                while (iter.hasNext()) {
                                    ImChatWindowHandler handler = (ImChatWindowHandler)iter.next();
                                    if (!handler.getShell().equals(shell) || !shell.equals(e.widget) || !ImChatPlugin.getDefault().getPrefAsBoolean(ChatWindowPreferences.PREF_ESC_CLOSES)) continue;
                                    4.access$0(this.this$1).handleClose(handler);
                                    return;
                                }
                            }
                        }
                    });
                }

                static /* synthetic */ ImChatController access$0(4 var0) {
                    return var0.ImChatController.this;
                }
            });
        }
    }

    public IChatLoggingService getChatLoggingService() {
        if (this.service == null) {
            block4: {
                try {
                    Preferences prefs = ChatLoggingApiPlugin.getDefault().getPluginPreferences();
                    prefs.addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
                    String serviceType = prefs.getString("logging.service");
                    this.service = ChatLoggingUtil.getChatLoggingService((String)serviceType);
                }
                catch (Exception e) {
                    if (!logger.isLoggable(Level.WARNING)) break block4;
                    logger.log(Level.WARNING, e.getLocalizedMessage());
                }
            }
            if (this.service != null) {
                this.service.addListener((IChatLoggingServiceListener)this);
            }
        }
        return this.service;
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        if (this.service != null && event.getProperty() == "logging.service") {
            this.service.removeListener((IChatLoggingServiceListener)this);
            this.service = null;
        }
    }

    protected Map getConversations() {
        return this._conversations;
    }

    protected void handleShutdown() {
        this._audioManager.closeAllClips();
    }

    protected void acceptInvite(MessageEvent event) {
        String connectionUID = (String)event.getProperty((Object)"connectionUID");
        String conversationID = (String)event.getProperty((Object)"conversationID");
        MessageEvent _me = new MessageEvent(MessageEventConstants.ManyToManyInviteAccept);
        _me.setDestinationID(event.getSourceID());
        _me.setProperty((Object)"connectionUID", (Object)connectionUID);
        _me.setProperty((Object)"conversationID", (Object)conversationID);
        _me.setProperty((Object)"creationInfo", event.getProperty((Object)"creationInfo"));
        this.postMessageEvent(_me);
    }

    protected void acceptInvite(String connectionUID, String conversationID, Object mysteriousObject) {
        MessageEvent _me = new MessageEvent(MessageEventConstants.ManyToManyInviteAccept);
        _me.setProperty((Object)"connectionUID", (Object)connectionUID);
        _me.setProperty((Object)"conversationID", (Object)conversationID);
        _me.setProperty((Object)"creationInfo", mysteriousObject);
        this.postMessageEvent(_me);
    }

    protected void declineInvite(String connectionUID, String conversationID) {
        MessageEvent _me = new MessageEvent(MessageEventConstants.ManyToManyInviteDecline);
        _me.setProperty((Object)"connectionUID", (Object)connectionUID);
        _me.setProperty((Object)"conversationID", (Object)conversationID);
        this.postMessageEvent(_me);
    }

    protected void watchUser(ImChatWindowHandler iwh, String connectionUID, String partnerID, String partnerUID) {
    }

    protected void ignoreUser(ImChatWindowHandler iwh, String connectionUID, String partnerID) {
    }

    protected void ignorePartners(String connectionUID, ImChatWindowHandler iwh, ImChatWindowPartner[] partners) {
        if (partners != null) {
            int i = 0;
            while (i < partners.length) {
                this.ignoreUser(iwh, connectionUID, partners[i].getContactId());
                ++i;
            }
        }
    }

    protected ImChatWindowHandler getWindowByPartnerID(String partnerID, String conversationID, String connectionUID, boolean replaceConversationId) {
        if (partnerID == null) {
            return null;
        }
        Iterator e = this._conversations.values().iterator();
        while (e.hasNext()) {
            ImChatWindowHandler ich = (ImChatWindowHandler)e.next();
            if (ich.getFirstPartner() == null || ich.isMultiChat() || ich.isAbandoned() || partnerID.compareToIgnoreCase(ich.getFirstPartner().getContactId()) != 0 || ich._connectionUID == null || connectionUID == null || ich._connectionUID.compareTo(connectionUID) != 0) continue;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, LogMessages.ImChatController_2);
            }
            if (replaceConversationId) {
                ich._oldConversationID = ich._conversationID;
                ich.setIsChatActive(true);
                this._conversations.remove(ich._conversationID);
                ich._conversationID = conversationID;
                this._conversations.put(ich._conversationID, ich);
            }
            return ich;
        }
        return null;
    }

    protected void handleOneToOnePartnerUpdate(String connectionUID, String partnerID, String partnerLoginID, String conversationID) {
        ImChatWindowHandler iwh;
        if (conversationID != null && (iwh = (ImChatWindowHandler)this._conversations.get(conversationID)) != null && !iwh.isMultiChat() && partnerLoginID != null) {
            ImChatWindowPartner ip = (ImChatWindowPartner)iwh.getPartner(partnerID);
            ip.setPersonLoginId(partnerLoginID);
            iwh.refreshRichTextCapability(ip);
        }
    }

    protected void handlePartnerUpdate(String connectionUID, String partnerID, String partnerUID, boolean partnerUsingICT, String capabilityString, int statusCode, String statusText) {
        if (logger.isLoggable(Level.INFO)) {
            logger.log(Level.INFO, NLS.bind((String)LogMessages.ImChatController_0, (Object)partnerID, (Object)statusText));
        }
        ImChatWindowPartner.setCapabiltiy(partnerID, capabilityString);
        ListImplodeExplode.implode((String[])new String[]{connectionUID, partnerID}, (char)':');
        boolean bl = partnerUsingICT && capabilityString != null ? capabilityString.indexOf("filexfer") != -1 : false;
        Iterator it = this._conversations.values().iterator();
        while (it.hasNext()) {
            ImChatWindowHandler iwh = (ImChatWindowHandler)it.next();
            if (iwh == null) continue;
            if (iwh._localPartner != null && partnerID != null && iwh._localPartner.getContactId() != null && iwh._localPartner.getContactId().equalsIgnoreCase(partnerID)) {
                iwh._localPartner.setStatus(statusCode);
                iwh._localPartner.statusText = statusText;
                iwh.updateStatus(iwh._localPartner);
            }
            if (!iwh.isMultiChat()) {
                if (iwh.getFirstPartner() == null || partnerUID == null || iwh.getFirstPartner().getPerson().getId() == null || !iwh.getFirstPartner().getPerson().getId().equals(partnerUID)) continue;
                iwh.getFirstPartnerInternal().setStatus(statusCode);
                iwh.getFirstPartnerInternal().statusText = statusText;
                iwh.updateStatus(iwh.getFirstPartnerInternal());
                continue;
            }
            ImChatWindowPartner ip = (ImChatWindowPartner)iwh.getPartner(partnerID);
            if (ip == null) continue;
            ip.usingICT = partnerUsingICT;
            ip.setStatus(statusCode);
            ip.statusText = statusText;
            iwh.updateStatus(ip);
        }
    }

    protected boolean isTyping() {
        Iterator it = this._conversations.values().iterator();
        while (it.hasNext()) {
            ImChatWindowHandler iwh = (ImChatWindowHandler)it.next();
            if (iwh == null || !iwh.isTyping()) continue;
            return true;
        }
        return false;
    }

    private String findExistingName(String pluginID) {
        Iterator iter = this.getChatWindowAdditions().keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!key.endsWith("_" + pluginID)) continue;
            return key;
        }
        return pluginID;
    }

    protected void addChatWindowAddition(String pluginID, Object e) {
        ArrayList<ImChatWindowButton> existing;
        if (pluginID == null || pluginID.trim().length() == 0) {
            pluginID = MessageProcessor.generateUniqueID();
        }
        if ((existing = (ArrayList<ImChatWindowButton>)this.getChatWindowAdditions().get(this.findExistingName(pluginID))) == null) {
            existing = new ArrayList<ImChatWindowButton>(1);
        }
        String firstAddition = null;
        if (e != null) {
            if (e instanceof Vector) {
                Iterator iter = ((Vector)e).iterator();
                while (iter.hasNext()) {
                    Boolean addMenu;
                    Boolean enabled;
                    Integer style;
                    Object o = iter.next();
                    if (!(o instanceof Map)) continue;
                    Map map = (Map)o;
                    ImChatWindowButton button = new ImChatWindowButton();
                    if (firstAddition == null) {
                        firstAddition = (String)map.get("id");
                    }
                    button.setId((String)map.get("id"));
                    button.setLabel((String)map.get("label"));
                    button.setToolTip((String)map.get("tooltip"));
                    button.setImage((Image)map.get("image"));
                    button.setDisabledImage((Image)map.get("disabledImage"));
                    if (map.get("capabilityRequired") != null) {
                        button.setCapabilityRequired((String)map.get("capabilityRequired"));
                    }
                    if (map.get("capabilityAltText") != null) {
                        button.setCapabilityAltText((String)map.get("capabilityAltText"));
                    }
                    if (map.get("capabilityAltImage") != null) {
                        button.setCapabilityAltImage((Image)map.get("capabilityAltImage"));
                    }
                    if ((style = (Integer)map.get("style")) != null) {
                        button.setStyle(style);
                    }
                    if ((enabled = (Boolean)map.get("enabled")) != null) {
                        button.setEnabled(enabled);
                    }
                    if ((addMenu = (Boolean)map.get("addMenuItems")) != null) {
                        button.setAddMenuItem(addMenu);
                    }
                    button.setShowsFor((String)map.get("showsFor"));
                    button.setMessageEvent((MessageEvent)map.get("event"));
                    existing.add(button);
                }
            } else if (e instanceof MessageEvent) {
                Boolean enabled;
                MessageEvent event = (MessageEvent)e;
                ImChatWindowButton button = new ImChatWindowButton();
                button.setId((String)event.getProperty((Object)"id"));
                if (firstAddition == null) {
                    firstAddition = (String)event.getProperty((Object)"id");
                }
                button.setLabel((String)event.getProperty((Object)"label"));
                button.setToolTip((String)event.getProperty((Object)"tooltip"));
                button.setImage((Image)event.getProperty((Object)"image"));
                button.setDisabledImage((Image)event.getProperty((Object)"disabledImage"));
                Integer style = (Integer)event.getProperty((Object)"style");
                if (style != null) {
                    button.setStyle(style);
                }
                if ((enabled = (Boolean)event.getProperty((Object)"enabled")) != null) {
                    button.setEnabled(enabled);
                }
                button.setShowsFor((String)event.getProperty((Object)"showsFor"));
                button.setMessageEvent((MessageEvent)event.getProperty((Object)"event"));
                existing.add(button);
            }
        }
        this._chatWindowAdditions.put(String.valueOf(firstAddition) + "_" + pluginID, existing);
        this._chatWindowAdditions.remove(pluginID);
    }

    protected Map getChatWindowAdditions() {
        if (this._chatWindowAdditions == null) {
            this._chatWindowAdditions = new TreeMap(Collator.getInstance());
        }
        return this._chatWindowAdditions;
    }

    protected Vector getChatWindowMenuAdditions(String conversationID, String partnerID) {
        if (this._chatWindowMenuAdditions.containsKey(partnerID.toLowerCase())) {
            Hashtable h = (Hashtable)this._chatWindowMenuAdditions.get(partnerID.toLowerCase());
            return (Vector)h.get(conversationID);
        }
        return null;
    }

    private void addChatWindowAdditions() {
        Map additions = this.getChatWindowAdditions();
        if (additions != null) {
            Iterator iter = additions.keySet().iterator();
            while (iter.hasNext()) {
                ImChatWindowButton button;
                String pluginName = (String)iter.next();
                ArrayList buttons = (ArrayList)additions.get(pluginName);
                if (pluginName.lastIndexOf("_") > -1) {
                    pluginName = pluginName.substring(pluginName.lastIndexOf("_") + 1);
                }
                ImChatWindowButton newButton = button = (ImChatWindowButton)buttons.get(0);
                try {
                    newButton = (ImChatWindowButton)button.clone();
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {}
                MenuManager manager = null;
                if (buttons.size() > 1) {
                    newButton.style = 4;
                    newButton.id = pluginName;
                    newButton.event = null;
                    manager = new MenuManager();
                    int i = 0;
                    while (i < buttons.size()) {
                        ImChatWindowButton b = (ImChatWindowButton)buttons.get(i);
                        if (b.getLabel() != null || b.getToolTip() != null) {
                            ChatWindowAction action = this.createAction(b);
                            action.setId(b.getId());
                            if (b.getLabel() != null) {
                                action.setText(b.getLabel());
                            } else if (b.getToolTip() != null) {
                                action.setText(b.getToolTip());
                            }
                            action.setImageDescriptor(null);
                            manager.add((IContributionItem)new ActionContributionItem((IAction)action));
                        }
                        ++i;
                    }
                }
                if (newButton == null) continue;
                this.addToolBarItem(newButton, manager);
            }
        }
    }

    private ChatWindowAction createAction(final ImChatWindowButton button) {
        MessageEvent me = button.getMessageEvent();
        ChatWindowAction action = new ChatWindowAction(me){

            public int getStyle() {
                if (button.getStyle() == 16) {
                    return 8;
                }
                if (button.getStyle() == 4) {
                    return 4;
                }
                if (button.getStyle() == 2 || button.getStyle() == 32) {
                    return 2;
                }
                return 1;
            }

            public void run() {
                MessageEvent me;
                if (this.getStyle() == 2) {
                    this.setChecked(!this.isChecked());
                    this.firePropertyChange("checked", null, null);
                }
                if ((me = this.getMessageEvent()) != null) {
                    HashMap[] partnerMaps;
                    if (!this.getChatWindowHandlerInternal().isMultiChat() && button.getCapabilityRequired() != null && this.getChatWindowHandlerInternal().getFirstPartnerInternal().getCapabilities().indexOf(button.getCapabilityRequired()) == -1) {
                        if (logger.isLoggable(Level.FINE)) {
                            logger.log(Level.FINE, NLS.bind((String)LogMessages.ImChatController_3, (Object[])new Object[]{this.getChatWindowHandler().getFirstPartner().getContactId(), button.getCapabilityRequired(), this.getChatWindowHandlerInternal().getFirstPartnerInternal().getCapabilities()}));
                        }
                        return;
                    }
                    if (me == null) {
                        return;
                    }
                    me.setProperty((Object)"selected", (Object)new Boolean(this.isChecked()));
                    me.setProperty((Object)"ident", (Object)(String.valueOf(this.getChatWindowHandlerInternal()._connectionUID) + ":" + this.getChatWindowHandlerInternal()._conversationID));
                    me.setProperty((Object)"connectionUID", (Object)this.getChatWindowHandlerInternal()._connectionUID);
                    ImChatWindowPartner[] partners = this.getChatWindowHandlerInternal().getRemotePartners();
                    if (partners != null) {
                        partnerMaps = new HashMap[partners.length];
                        int i = 0;
                        while (i < partners.length) {
                            HashMap<String, Object> map = new HashMap<String, Object>(4);
                            map.put("partnerUID", partners[i].getPerson().getId());
                            map.put("partnerAlias", partners[i].getContactId());
                            map.put("partnerID", partners[i].getContactId());
                            map.put("usingICT", new Boolean(partners[i].usingICT));
                            partnerMaps[i] = map;
                            ++i;
                        }
                    } else {
                        partnerMaps = new HashMap[]{};
                    }
                    me.setProperty((Object)"partnerMaps", (Object)partnerMaps);
                    if (this.getChatWindowHandlerInternal()._localPartner != null) {
                        me.setProperty((Object)"localUID", (Object)this.getChatWindowHandlerInternal()._localPartner.getPerson().getId());
                        me.setProperty((Object)"localID", (Object)this.getChatWindowHandlerInternal()._localPartner.getContactId());
                        me.setProperty((Object)"localAlias", (Object)this.getChatWindowHandlerInternal()._localPartner.getContactId());
                    }
                    me.setProperty((Object)"conversationID", (Object)this.getChatWindowHandlerInternal()._conversationID);
                    MessageProcessor.getInstance().postMessageEvent(me);
                }
            }
        };
        action.setId(button.id);
        if (button.getImage() != null) {
            action.setImageDescriptor(ImageDescriptor.createFromImage((Image)button.getImage()));
        }
        if (button.getDisabledImage() != null) {
            action.setDisabledImageDescriptor(ImageDescriptor.createFromImage((Image)button.getDisabledImage()));
        }
        if (button.getToolTip() != null) {
            action.setToolTipText(button.getToolTip());
        } else if (button.getLabel() != null) {
            action.setToolTipText(button.getLabel());
        }
        return action;
    }

    public void addToolBarItem(ImChatWindowButton button, MenuManager optionalMenu) {
        button.getShowsFor();
        try {
            ChatWindowAction action = this.createAction(button);
            if (optionalMenu != null) {
                action.setMenuManager(optionalMenu);
            }
        }
        catch (Throwable throwable) {}
    }

    public void removeConversation(String conversationID) {
        this._conversations.remove(conversationID);
    }

    public ChatWindowHandler getChatWindowHandler(String conversationID) {
        return this.getHandler(conversationID);
    }

    protected ImChatWindowHandler getHandler(String conversationID) {
        ImChatWindowHandler handler = null;
        if (conversationID != null) {
            handler = (ImChatWindowHandler)this._conversations.get(conversationID);
        }
        return handler;
    }

    protected ImChatWindowHandler reclaimDeadIMWindow(boolean isIMMessage, String connectionUID, String conversationID, String partnerID, String placeID) {
        ImChatWindowHandler __iwh = null;
        if (partnerID == null) {
            return null;
        }
        Enumeration _c = this._conversations.keys();
        while (_c.hasMoreElements()) {
            Object key = _c.nextElement();
            __iwh = (ImChatWindowHandler)this._conversations.get(key);
            if (__iwh.getCommunityId().equals(connectionUID)) {
                ImChatWindowPartner ip = (ImChatWindowPartner)__iwh.getPartner(partnerID);
                if (ip != null && !ip.equals(__iwh.getLocalPartner())) {
                    if (__iwh.isMultiChat() || __iwh.isChatActive()) {
                        __iwh = null;
                        continue;
                    }
                    if (__iwh.isMultiChat() && placeID != null && !placeID.equals(__iwh.getPlaceID())) {
                        __iwh = null;
                        continue;
                    }
                    if (!__iwh.isMultiChat() && placeID != null) {
                        __iwh = null;
                        continue;
                    }
                    this._conversations.remove(__iwh._conversationID);
                    __iwh._conversationID = conversationID;
                    this._conversations.put(__iwh._conversationID, __iwh);
                    __iwh.setHasActiveFileTransfer(false);
                    continue;
                }
                __iwh = null;
                continue;
            }
            __iwh = null;
        }
        return __iwh;
    }

    protected void configureNwayAlerts() {
        MessageEvent me = new MessageEvent(MessageEventConstants.ConfigureAlerts);
        me.setProperty((Object)"scopetext", (Object)Messages.ImChatWindowPlugIn_63);
        this.postMessageEvent(me);
    }

    protected void handleImTextTypingEvent(MessageEvent event) {
        ImChatWindowHandler iwh;
        String conversationID = (String)event.getProperty((Object)"conversationID");
        if (conversationID != null && (iwh = (ImChatWindowHandler)this._conversations.get(conversationID)) != null) {
            ImChatWindow window;
            ImChatWindowPartner ip;
            String partnerID;
            Boolean isTyping = (Boolean)event.getProperty((Object)"isTyping");
            String partnerAlias = (String)event.getProperty((Object)"partnerAlias");
            if (partnerAlias == null) {
                partnerAlias = (String)event.getProperty((Object)"partnerID");
            }
            if (partnerAlias == null) {
                partnerAlias = "The other person";
            }
            if ((partnerID = (String)event.getProperty((Object)"partnerID")) != null && (ip = iwh.getPartnerInternal(partnerID = partnerID.toLowerCase(Locale.US))) != null) {
                ip.typing = isTyping;
                partnerAlias = ip.getPerson().getDisplayName();
                iwh.updatePartnerList(ip, null);
            }
            if (!iwh.isMultiChat()) {
                if (isTyping.booleanValue()) {
                    String msg = Messages.partner_is_responding;
                    iwh.setStatusTextAndImage(MessageFormat.format(msg, partnerAlias), ImChatPlugin.getDefault().getImageRegistry().get(ImChatPlugin.IMAGE_TYPING));
                } else {
                    iwh.setStatusTextAndImage(null, null);
                }
                if (!ImChatPlugin.getDefault().getPluginPreferences().getBoolean(ChatWindowPreferences.PREF_USE_LESS_VERBOSE)) {
                    iwh.getTranscriptArea().setAccessibleMessage(NLS.bind((String)Messages.partner_is_responding, (Object)partnerAlias), NLS.bind((String)Messages.partner_is_responding, (Object)partnerAlias));
                }
            }
            if ((window = this.findTabbedWindow(iwh)) != null) {
                window.setTyping(iwh, isTyping);
            }
        }
    }

    protected void sendTypingStatus(String connectionUID, String conversationID, boolean isTyping) {
        MessageEvent me = new MessageEvent(MessageEventConstants.ImTextTypingRequest);
        me.setProperty((Object)"connectionUID", (Object)connectionUID);
        me.setProperty((Object)"conversationID", (Object)conversationID);
        me.setProperty((Object)"isTyping", (Object)(isTyping ? Boolean.TRUE : Boolean.FALSE));
        this.postMessageEvent(me);
    }

    protected void rejoinPlace(String connectionUID, String placeID) {
        if (placeID != null) {
            MessageEvent me = new MessageEvent(MessageEventConstants.ManyToManyInviteAccept);
            me.setProperty((Object)"connectionUID", (Object)connectionUID);
            me.setProperty((Object)"placeID", (Object)placeID);
            this.postMessageEvent(me);
        }
    }

    protected void handleTextConnectionClosed(MessageEvent event) {
        ImChatWindowHandler iwh;
        String conversationID = (String)event.getProperty((Object)"conversationID");
        if (conversationID != null && this._conversations != null && (iwh = (ImChatWindowHandler)this._conversations.get(conversationID)) != null) {
            iwh.setIsChatActive(false);
            if (!iwh.isMultiChat()) {
                iwh.handleConnectionClosed();
                Boolean disable = (Boolean)event.getProperty((Object)"disable");
                if (disable != null && disable.booleanValue()) {
                    iwh.setDisabled(true);
                }
            } else {
                iwh.setDisabled(true);
            }
        }
    }

    protected void handleExtensionUpdate(String id, String[] extensions, String activity, boolean enable, String label) {
        ImChatWindowHandler iwh;
        if (id != null && this._conversations != null && (iwh = (ImChatWindowHandler)this._conversations.get(id)) != null) {
            if (extensions != null) {
                int i = 0;
                while (i < extensions.length) {
                    if (enable) {
                        iwh.enableListExtension(extensions[i]);
                    } else {
                        iwh.disableListExtension(extensions[i]);
                    }
                    ++i;
                }
            }
            if (activity != null) {
                if (enable) {
                    iwh.addActivity(activity);
                } else {
                    iwh.removeActivity(activity);
                }
            }
            if (label != null) {
                iwh.setListTopLabel(label);
            }
        }
    }

    void handleNwayListUpdate(String id, String partnerID) {
        ImChatWindowHandler iwh;
        if (id != null && this._conversations != null && (iwh = (ImChatWindowHandler)this._conversations.get(id)) != null) {
            if (partnerID == null) {
                iwh.getPartnerList().refresh();
            } else {
                ImChatWindowPartner partner = iwh.getPartnerInternal(partnerID);
                if (partner != null) {
                    iwh.updatePartnerList(partner, null);
                }
            }
        }
    }

    void handlePopupAddon(MessageEvent event) {
        PopupAddOn addon = (PopupAddOn)event.getProperty((Object)"addon");
        String id = (String)event.getProperty((Object)"conversationID");
        String partnerID = (String)event.getProperty((Object)"partnerID");
        String partnerLoginID = (String)event.getProperty((Object)"partnerLoginID");
        String connUID = (String)event.getProperty((Object)"connectionUID");
        if (id != null && this._conversations != null) {
            ImChatWindowHandler iwh = (ImChatWindowHandler)this._conversations.get(id);
            if (iwh == null) {
                iwh = this.getWindowByPartnerID(partnerID, id, connUID, false);
            }
            if (iwh == null) {
                MessageEvent me = new MessageEvent(MessageEventConstants.ImTextConnectionOpen);
                me.setProperty((Object)"connectionUID", (Object)connUID);
                me.setProperty((Object)"partnerID", (Object)partnerID);
                me.setProperty((Object)"partnerLoginID", (Object)partnerLoginID);
                MessageProcessor.getInstance().postMessageEvent(me);
                this.pendingAddons.put(partnerID, addon);
            }
            if (iwh != null) {
                iwh.createPopupMessageArea(addon);
                iwh.doNotifyWindow();
                ImChatWindow window = this.findTabbedWindow(iwh);
                if (window != null) {
                    window.notifyIncoming(iwh);
                }
            }
        }
    }

    protected void handleNwayUserEnterExit(MessageEvent event) {
        String conversationID = (String)event.getProperty((Object)"conversationID");
        String connectionUID = (String)event.getProperty((Object)"connectionUID");
        if (conversationID == null) {
            return;
        }
        ImChatWindowHandler iwh = (ImChatWindowHandler)this._conversations.get(conversationID);
        if (iwh == null) {
            return;
        }
        String partnerUID = (String)event.getProperty((Object)"partnerUID");
        String partnerID = (String)event.getProperty((Object)"partnerID");
        String partnerLoginID = (String)event.getProperty((Object)"partnerLoginID");
        String partnerAlias = (String)event.getProperty((Object)"partnerAlias");
        int status = event.getProperty((Object)"status") != null ? (Integer)event.getProperty((Object)"status") : -99;
        String strAppendSystem = (String)event.getProperty((Object)"appendSystemMessage");
        boolean bAppendSystem = strAppendSystem == null || strAppendSystem.equals("") ? true : strAppendSystem.equals("true");
        String action = (String)event.getProperty((Object)"action");
        if (partnerID == null && partnerAlias != null) {
            partnerID = partnerAlias;
        }
        if (action.equals("enter")) {
            ImChatWindowPartner ip = null;
            if (partnerID != null) {
                boolean joined = false;
                if (!partnerID.equalsIgnoreCase(iwh._localPartner.getContactId())) {
                    ip = iwh.getPartnerInternal(partnerID);
                    if (ip != null) {
                        joined = ip.getJoinState() == 1;
                        ip.setJoinState(1);
                        ip.setPersonLoginId(partnerLoginID);
                        if (!ip.getPerson().getId().equals(partnerUID)) {
                            PersonInternal p = PeopleUtil.getPersonById((String)partnerUID);
                            if (p.isExternal()) {
                                p.setDisplayName(ip.getPerson().getDisplayName());
                            }
                            ip.setPerson((Person)p);
                        }
                        iwh.updatePartnerList(ip, null);
                        iwh.redrawList();
                    } else {
                        ip = new ImChatWindowPartner((Person)PeopleUtil.getPerson((String)partnerID, (String)connectionUID), partnerLoginID);
                        if (status != -99) {
                            ip.setStatus(status);
                        }
                        ip.setJoinState(1);
                        iwh.addPartner(ip);
                    }
                    if (ip.getPerson() != null && ip.getPerson().isExternal()) {
                        return;
                    }
                } else {
                    ip = iwh._localPartner;
                    joined = ip.getJoinState() == 1;
                    ip.setPersonLoginId(partnerLoginID);
                    ip.setJoinState(1);
                    iwh.addPartner(ip);
                }
                if (!joined) {
                    iwh.setStatusText(NLS.bind((String)Messages.entered_the_chat, (Object)ip.getName()));
                    if (bAppendSystem) {
                        iwh.appendSystemMessage(NLS.bind((String)Messages.entered_the_chat, (Object)ip.getName()));
                    }
                }
            }
        } else if (action.equals("exit")) {
            ImChatWindowPartner ip = iwh.getPartnerInternal(partnerID);
            if (ip == null) {
                return;
            }
            if (ip.getPersonLoginId() != null && !ip.getPersonLoginId().equals(partnerLoginID) || partnerLoginID != null && !partnerLoginID.equals(ip.getPersonLoginId())) {
                return;
            }
            if (ip.getPerson() != null && ip.getPerson().isExternal()) {
                return;
            }
            iwh.setStatusText(NLS.bind((String)Messages.left_the_chat, (Object)ip.getName()));
            if (bAppendSystem) {
                iwh.appendSystemMessage(NLS.bind((String)Messages.left_the_chat, (Object)ip.getName()));
            }
            ip.setJoinState(0);
            iwh.updatePartnerList(ip, null);
            iwh.redrawList();
        }
    }

    protected void sendPrelogueText(ImChatWindowHandler iwh) {
        MessageEvent me = null;
        if (iwh.prelogueText != null) {
            me = iwh.isMultiChat() ? new MessageEvent(MessageEventConstants.ManyToManyTextSend) : new MessageEvent(MessageEventConstants.ImTextSend);
            me.setProperty((Object)"connectionUID", (Object)iwh._connectionUID);
            me.setProperty((Object)"conversationID", (Object)iwh._conversationID);
            me.setProperty((Object)"partnerUID", (Object)iwh.getFirstPartner().getPerson().getId());
            me.setProperty((Object)"partnerID", (Object)iwh.getFirstPartner().getContactId());
            me.setProperty((Object)"text", (Object)iwh.prelogueText);
            MessageProcessor.getInstance().postMessageEvent(me);
            if (!iwh.hidePrelogueText) {
                iwh.appendText(iwh._localPartner, iwh.prelogueText, true, false);
            }
            iwh.prelogueText = null;
        }
    }

    protected void sendEpilogueText(ImChatWindowHandler iwh) {
        MessageEvent _me = null;
        if (iwh.epilogueText != null) {
            _me = iwh.isMultiChat() ? new MessageEvent(MessageEventConstants.ManyToManyTextSend) : new MessageEvent(MessageEventConstants.ImTextSend);
            _me.setProperty((Object)"connectionUID", (Object)iwh._connectionUID);
            _me.setProperty((Object)"conversationID", (Object)iwh._conversationID);
            _me.setProperty((Object)"partnerUID", (Object)iwh.getFirstPartner().getPerson().getId());
            _me.setProperty((Object)"partnerID", (Object)iwh.getFirstPartner().getContactId());
            _me.setProperty((Object)"text", (Object)iwh.epilogueText);
            MessageProcessor.getInstance().postMessageEvent(_me);
            if (!iwh.hideEpilogueText) {
                iwh.appendText(iwh._localPartner, iwh.epilogueText, true, false);
            }
            iwh.epilogueText = null;
        }
    }

    protected void sendPrologueText(ImChatWindowHandler iwh) {
        if (iwh.prologueText != null) {
            MessageEvent me = null;
            me = iwh.isMultiChat() ? new MessageEvent(MessageEventConstants.ManyToManyTextSend) : new MessageEvent(MessageEventConstants.ImTextSend);
            me.setProperty((Object)"connectionUID", (Object)iwh._connectionUID);
            me.setProperty((Object)"conversationID", (Object)iwh._conversationID);
            me.setProperty((Object)"partnerUID", (Object)iwh.getFirstPartner().getPerson().getId());
            me.setProperty((Object)"partnerID", (Object)iwh.getFirstPartner().getContactId());
            me.setProperty((Object)"text", (Object)iwh.prologueText);
            MessageProcessor.getInstance().postMessageEvent(me);
            if (!iwh.hidePrologueText) {
                iwh.appendText(iwh._localPartner, iwh.prologueText, true, false);
            }
            iwh.prologueText = null;
        }
    }

    public void postMessageEvent(final MessageEvent me) {
        Job postJob = new Job("postMessageEventJob"){

            protected IStatus run(IProgressMonitor mon) {
                me.setSourceID(ImChatEventHandler.ID);
                MessageProcessor.getInstance().postMessageEvent(me);
                return Status.OK_STATUS;
            }
        };
        postJob.setSystem(true);
        postJob.schedule();
    }

    public void flashWindow(String conversationID) {
        ImChatWindowHandler iwh = (ImChatWindowHandler)this._conversations.get(conversationID);
        if (iwh != null) {
            ImChatWindow window = this.findTabbedWindow(iwh);
            if (window != null) {
                window.getShell().forceActive();
            }
            iwh.flashWindowOnly();
        }
    }

    public void forceFocus(String conversationID) {
        ImChatWindowHandler iwh = (ImChatWindowHandler)this._conversations.get(conversationID);
        if (iwh != null) {
            ImChatWindow window = this.findTabbedWindow(iwh);
            if (window != null) {
                window.getShell().forceActive();
            }
            iwh.forceFocus();
        }
    }

    public void showTrayIcon(final boolean show, final String partnerAlias, final HashMap context) {
        DisplayLoop.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (ImChatController.this.item == null) {
                    ImChatController.this.item = new BlinkingTrayItem(Display.getDefault().getSystemTray(), 0);
                    if (ImChatController.this.item != null) {
                        ImChatController.this.item.setVisibleOnlyWhenBlinking(true);
                        ImChatController.this.item.setImage(ImChatPlugin.getDefault().getImage("images/ST_Awns_Logo.png"));
                        ImChatController.this.item.setInvertedImage(ImChatPlugin.getDefault().getImage("images/ST_Task_Bar_Flashing_Alert.png"));
                        MultilineTextBuffer buffer = new MultilineTextBuffer(Messages.systray_message_header, 10, Messages.systray_message_more);
                        buffer.setFooterText(Messages.systray_message_end);
                        ImChatController.this.item.setTooltipTextBuffer(buffer);
                        ImChatController.this.item.setRunnable(new Runnable(this){
                            final /* synthetic */ 9 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                HashMap map;
                                if (9.access$0(this.this$1).item.getNumberOfTooltipEntries() > 0 && (map = 9.access$0(this.this$1).item.getTooltipContextAt(9.access$0(this.this$1).item.getNumberOfTooltipEntries() - 1)) != null) {
                                    String convID = (String)map.get("conversationID");
                                    ImChatWindowHandler iwh = (ImChatWindowHandler)9.access$0(this.this$1)._conversations.get(convID);
                                    ImChatWindow window = 9.access$0(this.this$1).findTabbedWindow(convID);
                                    if (iwh != null) {
                                        if (window == null) {
                                            9.access$0(this.this$1).forceFocus(convID);
                                        } else {
                                            if (window.getShell().getMinimized()) {
                                                window.getShell().setMinimized(false);
                                            }
                                            window.setCurrentChat(iwh);
                                        }
                                        iwh.showTrayIcon(false);
                                    } else {
                                        if (window != null && window.getShell() != null) {
                                            window.getShell().forceActive();
                                        }
                                        9.access$0(this.this$1).item.blinkIcon(false);
                                    }
                                }
                            }
                        });
                    }
                }
                if (ImChatController.this.item != null) {
                    if (show) {
                        ImChatController.this.item.appendTooltipText(partnerAlias, context);
                    } else {
                        ImChatController.this.item.removeTooltipText(partnerAlias);
                    }
                    ImChatController.this.item.blinkIcon(show);
                }
            }

            static /* synthetic */ ImChatController access$0(9 var0) {
                return var0.ImChatController.this;
            }
        });
    }

    protected void hideBlinkingTrayIcon() {
        if (this.item != null) {
            this.item.hideIcon();
        }
    }

    protected void sendStatusChangeRequest(String connectionUID, int status) {
        String rtcStatus = PeopleUtil.convertToRtcStatus((int)status);
        CommunityInternal community = CommunityUtil.getCommunity((String)connectionUID);
        community.setStatus(rtcStatus);
    }

    public void changeTranscriptLocation(String conversationID, URL newURL) {
        ImChatWindowHandler cfr_ignored_0 = (ImChatWindowHandler)this._conversations.get(conversationID);
    }

    protected void handleImRichTextEnabledDisabled(MessageEvent event) {
        String conversationID = (String)event.getProperty((Object)"conversationID");
        String connectionUID = (String)event.getProperty((Object)"connectionUID");
        String createChatWindow = (String)event.getProperty((Object)"createChatWindow");
        String partnerID = (String)event.getProperty((Object)"partnerID");
        ImChatController controller = ImChatPlugin.getDefault().getImChatController();
        ImChatWindowHandler iwh = (ImChatWindowHandler)controller._conversations.get(conversationID);
        if (iwh != null) {
            iwh.handleImRichTextEnableDisable(event);
        } else {
            iwh = controller.getWindowByPartnerID(partnerID, conversationID, connectionUID, false);
            if (iwh != null) {
                iwh.handleImRichTextEnableDisable(event);
            } else if (Boolean.valueOf(createChatWindow).booleanValue()) {
                this.handleCreateChatHandler(event);
            }
        }
    }

    /*
     * Exception decompiling
     */
    protected void handleCreateChatHandler(MessageEvent event) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [8 : 2804->2808)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ImChatWindow getChatWindow() {
        return this.getChatWindow("default");
    }

    private ImChatWindow getChatWindow(String name) {
        if (name == null) {
            name = "default";
        }
        if (ImChatPlugin.getDefault().getPrefAsBoolean(ChatWindowPreferences.PREF_USE_TABS)) {
            ImChatWindow window = null;
            if (this._tabbedWindows != null) {
                window = (ImChatWindow)this._tabbedWindows.get(name);
            }
            if (window == null) {
                window = new ImChatWindow();
                if (this._tabbedWindows == null) {
                    this._tabbedWindows = new HashMap(2);
                }
                this._tabbedWindows.put(name, window);
            }
            return window;
        }
        return null;
    }

    protected void removeTabbedWindow(ImChatWindow window) {
        if (this._tabbedWindows != null) {
            Iterator iter = this._tabbedWindows.keySet().iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                Object obj = this._tabbedWindows.get(key);
                if (!obj.equals(window)) continue;
                this._tabbedWindows.remove(key);
                window = null;
                return;
            }
        }
    }

    protected void retrieveTranscript(ImChatWindowHandler handler) {
        if (this.getChatLoggingService() != null) {
            GetTranscriptJob job = new GetTranscriptJob(handler, false);
            job.addJobChangeListener(handler.jobChangeListener);
            job.schedule();
        }
    }

    protected void retrieveNwayTranscript(ImChatWindowHandler handler) {
        if (this.getChatLoggingService() != null) {
            GetTranscriptJob job = new GetTranscriptJob(handler, true);
            job.addJobChangeListener(handler.jobChangeListener);
            job.schedule();
        }
    }

    protected void handleEmbedObject(String conversationID, String partnerUID, Embeddable embed) {
        ImChatWindowHandler handler = this.getHandler(conversationID);
        if (handler != null && embed != null) {
            handler.embedObject(embed);
        }
    }

    protected void handleChatAreaEvent(String conversationID, String chatAreaID, boolean enable) {
        ImChatWindowHandler handler = this.getHandler(conversationID);
        if (handler != null && chatAreaID != null) {
            if (enable) {
                handler.enableChatArea(chatAreaID);
            } else {
                handler.removeChatArea(chatAreaID);
            }
        }
    }

    public void handleClose(ChatWindowHandler handler) {
        ImChatWindow window = this.findTabbedWindow((ImChatWindowHandler)handler);
        if (window != null) {
            if (!window.checkBeforeClosing()) {
                return;
            }
            window.getShell().dispose();
            return;
        }
        handler.close();
    }

    protected void handlePolicyUpdate(String communityId, String policyKey, Object policyValue) {
        Iterator windows = this._conversations.values().iterator();
        while (windows.hasNext()) {
            ImChatWindowHandler handler = (ImChatWindowHandler)windows.next();
            if (communityId == null || !communityId.equals(handler.getCommunityId())) continue;
            handler.updatePolicy(policyKey, policyValue, true);
        }
    }

    protected ImChatWindowHandler getReplacementWindow(String partnerID, String conversationID, String connectionUID) {
        ImChatWindowHandler iwh = ImChatPlugin.getDefault().getImChatController().getWindowByPartnerID(partnerID, conversationID, connectionUID, true);
        if (iwh == null) {
            iwh = ImChatPlugin.getDefault().getImChatController().reclaimDeadIMWindow(true, connectionUID, conversationID, partnerID, null);
        }
        return iwh;
    }

    public ImChatWindow findTabbedWindow(ChatWindowHandler handler) {
        return this.findTabbedWindow(handler.getConversationId());
    }

    protected ImChatWindow findTabbedWindow(String conversationID) {
        ImChatWindow window = null;
        if (this._tabbedWindows != null) {
            Iterator iter = this._tabbedWindows.values().iterator();
            while (iter.hasNext()) {
                window = (ImChatWindow)iter.next();
                if (window.getIndex(conversationID) > -1) break;
            }
            Object var3_3 = null;
        }
        return window;
    }

    protected boolean checkBeforeClosing(ImChatWindowHandler handler) {
        ImChatWindow window = this.findTabbedWindow(handler);
        if (window != null) {
            return window.checkBeforeClosing();
        }
        return true;
    }

    protected boolean isTabbedWindow(ImChatWindowHandler handler) {
        return this.findTabbedWindow(handler) != null;
    }

    protected boolean isTabbedWindow(String conversationID) {
        return this.findTabbedWindow(conversationID) != null;
    }

    protected void handleChatAlertAreaEvent(MessageEvent me) {
        String conversationID = (String)me.getProperty((Object)"conversationID");
        Boolean enableBool = (Boolean)me.getProperty((Object)"enable");
        ImChatWindowHandler handler = this.getHandler(conversationID);
        if (handler != null) {
            boolean enable = true;
            if (enableBool != null) {
                enable = enableBool;
            }
            if (enable) {
                String img = (String)me.getProperty((Object)"imageUrl");
                String line1 = (String)me.getProperty((Object)"title");
                String line2 = (String)me.getProperty((Object)"description");
                handler.getTranscriptArea().showChatAlertArea(img, line1, line2);
            } else {
                handler.getTranscriptArea().hideChatAlertArea();
            }
        }
    }

    static /* synthetic */ void access$2(ImChatController imChatController, ArrayList arrayList) {
        imChatController.cachedEvents = arrayList;
    }
}

