/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.collaboration.realtime.chatwindow;

import com.ibm.collaboration.realtime.chatwindow.ImChatWindowHandler;
import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.SimpleTimeZone;
import com.ibm.icu.util.TimeZone;
import java.io.IOException;
import java.io.StringReader;
import java.text.ParseException;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FreeJamTranscriptParser
extends DefaultHandler {
    TimeUtils timeUtils = new TimeUtils();
    String theXML;
    ImChatWindowHandler imcwh;
    static final int IN_CHATSESSIONLOG = 0;
    static final int IN_CHATITEM = 1;
    static final int IN_CHATITEM_TEXT = 2;
    String currentMessage = null;
    String currentWho = null;
    Date currentWhen = null;
    int state = -1;
    static final Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.ibm.collaboration.realtime.chatwindow.FreeJamTranscriptParser");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger(clazz.getName());
    }

    public FreeJamTranscriptParser(ImChatWindowHandler _imcwh, String _theXML) {
        this.imcwh = _imcwh;
        this.theXML = _theXML;
    }

    public void parse() {
        block9: {
            if (this.theXML == null || this.theXML.indexOf("chatitem") == -1) {
                return;
            }
            SAXParser sp = null;
            try {
                sp = SAXParserFactory.newInstance().newSAXParser();
                sp.parse(new InputSource(new StringReader(this.theXML)), (DefaultHandler)this);
            }
            catch (ParserConfigurationException e) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
            catch (SAXException e) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
            catch (FactoryConfigurationError e) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
            catch (IOException e) {
                if (!logger.isLoggable(Level.WARNING)) break block9;
                logger.log(Level.WARNING, e.getMessage(), e);
            }
        }
    }

    public void characters(char[] arg0, int arg1, int arg2) throws SAXException {
        if (this.state == 1) {
            this.currentMessage = String.valueOf(this.currentMessage) + new String(arg0, arg1, arg2);
        }
    }

    public void endDocument() throws SAXException {
        this.imcwh.appendSystemMessage("--end transcript--");
    }

    public void endElement(String uri, String qName, String localName) throws SAXException {
        if ("chatitem".equals(qName)) {
            this.imcwh.appendText(null, this.currentWho, this.currentMessage, false, this.currentWhen, false, false, false, -1);
            this.state = -1;
        }
    }

    public void startDocument() throws SAXException {
        this.imcwh.appendSystemMessage("--begin transcript--");
    }

    public void startElement(String uri, String qName, String localName, Attributes atts) throws SAXException {
        if ("chatitem".equals(qName)) {
            this.currentMessage = "";
            this.currentWhen = this.timeUtils.parseString(atts.getValue("when"));
            this.currentWho = atts.getValue("who");
            this.state = 1;
        }
    }

    class TimeUtils {
        static final String DATE_PATTERN = "yyyy.MM.dd HH:mm:ss z";
        static final String GMT_STRING = "GMT";
        private SimpleDateFormat sdf = null;
        private TimeZone tz = null;

        TimeUtils() {
        }

        protected TimeZone getTimeZone() {
            if (this.tz == null) {
                this.tz = SimpleTimeZone.getTimeZone((String)GMT_STRING);
            }
            return this.tz;
        }

        protected SimpleDateFormat getDateFormatter() {
            if (this.sdf == null) {
                this.sdf = new SimpleDateFormat(DATE_PATTERN);
                this.sdf.setTimeZone(this.getTimeZone());
            }
            return this.sdf;
        }

        public Date parseString(String aDateString) {
            try {
                return this.getDateFormatter().parse(aDateString);
            }
            catch (ParseException e) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
                return null;
            }
        }

        public String getDateAsGMTString(Date aDate) {
            return this.getDateFormatter().format(aDate);
        }
    }
}

