/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.foundation.ui;

import com.ibm.team.foundation.common.URIReference;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public final class URIReferenceTransfer
extends ByteArrayTransfer {
    private static URIReferenceTransfer fgInstance = new URIReferenceTransfer();
    private static final String REFERENCE_FORMAT = "uri-reference-transfer-format";
    private static final int REFERENCE_FORMAT_ID = URIReferenceTransfer.registerType((String)"uri-reference-transfer-format");
    private static final String TYPE_UNTYPED = "<untyped>";

    public static URIReferenceTransfer getInstance() {
        return fgInstance;
    }

    protected int[] getTypeIds() {
        return new int[]{REFERENCE_FORMAT_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{REFERENCE_FORMAT};
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void javaToNative(Object object, TransferData data) {
        if (!(object instanceof URIReference[])) {
            return;
        }
        if (!this.isSupportedType(data)) return;
        URIReference[] references = (URIReference[])object;
        try {
            byte[] bytes = new byte[]{};
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            DataOutputStream dataStream = new DataOutputStream(byteStream);
            try {
                int index = 0;
                while (true) {
                    block9: {
                        if (index < references.length) break block9;
                        bytes = byteStream.toByteArray();
                        break;
                    }
                    URIReference reference = references[index];
                    dataStream.writeUTF(reference.getName());
                    dataStream.writeUTF(reference.getDetails());
                    dataStream.writeUTF(reference.getURI().toString());
                    String type = reference.getType();
                    if (type != null) {
                        dataStream.writeUTF(type);
                    } else {
                        dataStream.writeUTF(TYPE_UNTYPED);
                    }
                    ++index;
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                dataStream.close();
                throw throwable;
            }
            {
                Object var10_12 = null;
            }
            dataStream.close();
            super.javaToNative((Object)bytes, data);
            return;
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object nativeToJava(TransferData data) {
        URIReference[] result = new URIReference[]{};
        if (!this.isSupportedType(data)) return result;
        byte[] bytes = (byte[])super.nativeToJava(data);
        if (bytes == null) {
            return null;
        }
        ByteArrayInputStream byteStream = new ByteArrayInputStream(bytes);
        DataInputStream dataStream = new DataInputStream(byteStream);
        try {
            try {
                ArrayList<URIReference> collection = new ArrayList<URIReference>(4);
                while (true) {
                    if (dataStream.available() <= 0) {
                        result = collection.toArray(new URIReference[collection.size()]);
                    }
                    String name = dataStream.readUTF();
                    String details = dataStream.readUTF();
                    String uri = dataStream.readUTF();
                    String type = dataStream.readUTF();
                    boolean untyped = TYPE_UNTYPED.equals(type);
                    if (untyped) {
                        collection.add(new URIReference(name, details, new URI(uri)));
                        continue;
                    }
                    collection.add(new URIReference(name, details, type, new URI(uri)));
                }
            }
            catch (IOException iOException) {
            }
            catch (URISyntaxException uRISyntaxException) {}
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            try {
                dataStream.close();
                throw throwable;
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        {
            Object var12_14 = null;
        }
        try {}
        catch (IOException iOException) {
            return result;
        }
        dataStream.close();
        return result;
    }
}

