/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.retroweaver.runtime.java.lang.reflect;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.sourceforge.retroweaver.runtime.java.lang.Integer_;
import net.sourceforge.retroweaver.runtime.java.lang.TypeNotPresentException;
import net.sourceforge.retroweaver.runtime.java.lang.annotation.AIB;
import net.sourceforge.retroweaver.runtime.java.lang.reflect.GenericArrayType;
import net.sourceforge.retroweaver.runtime.java.lang.reflect.GenericDeclaration;
import net.sourceforge.retroweaver.runtime.java.lang.reflect.GenericSignatureFormatError;
import net.sourceforge.retroweaver.runtime.java.lang.reflect.MalformedParameterizedTypeException;
import net.sourceforge.retroweaver.runtime.java.lang.reflect.ParameterizedType;
import net.sourceforge.retroweaver.runtime.java.lang.reflect.Type;
import net.sourceforge.retroweaver.runtime.java.lang.reflect.TypeVariable;
import net.sourceforge.retroweaver.runtime.java.lang.reflect.WildcardType;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;

public class ReflectionDescriptor
implements ClassVisitor {
    private static final boolean DEBUG = false;
    private static final Map descriptors = new HashMap();
    private final Class class_;
    private String internalName;
    private String enclosingClassName;
    private String enclosingMethodName;
    private String enclosingMethodDesc;
    private TypeVariable[] typeParameters;
    private Type genericSuperclass;
    private Type[] genericInterfaces;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ReflectionDescriptor getReflectionDescriptor(Class class_) {
        Map map = descriptors;
        synchronized (map) {
            ReflectionDescriptor d = (ReflectionDescriptor)descriptors.get(class_);
            if (d == null) {
                d = new ReflectionDescriptor(class_);
                descriptors.put(class_, d);
            }
            return d;
        }
    }

    private ReflectionDescriptor(Class class_) {
        this.class_ = class_;
        String name = class_.getName();
        String resource = "/" + name.replace('.', '/') + ".class";
        InputStream classStream = class_.getResourceAsStream(resource);
        this.parseStream(name, classStream);
    }

    protected ReflectionDescriptor(String name, InputStream classStream) {
        this.class_ = null;
        this.parseStream(name, classStream);
    }

    private void parseStream(String name, InputStream classStream) {
        try {
            ClassReader r = new ClassReader(classStream);
            r.accept((ClassVisitor)this, 7);
        }
        catch (IOException e) {
            throw new TypeNotPresentException("[Retroweaver] Unable to read reflection data for: " + name, e);
        }
        finally {
            try {
                if (classStream != null) {
                    classStream.close();
                }
            }
            catch (IOException e) {}
        }
    }

    public String getEnclosingClassName() {
        return this.enclosingClassName;
    }

    public void debugMessage(String msg) {
        System.out.println(msg + "\n\tclass: " + this.class_.getName() + "\n\tenclosingClassName: " + this.enclosingClassName + "\n\tenclosingMethodName: " + this.enclosingMethodName + ' ' + this.enclosingMethodDesc);
    }

    public Class getEnclosingClass() {
        if (this.enclosingClassName == null) {
            return null;
        }
        try {
            String name = this.enclosingClassName.replace('/', '.');
            Class<?> c = this.class_.getClassLoader().loadClass(name);
            return c;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public Method getEnclosingMethod() {
        if (this.enclosingMethodName == null) {
            return null;
        }
        return this.getMethod(this.getEnclosingClass(), this.enclosingMethodName, this.enclosingMethodDesc);
    }

    public Constructor getEnclosingConstructor() {
        if (this.enclosingMethodName == null) {
            return null;
        }
        return this.getConstructor(this.getEnclosingClass(), this.enclosingMethodDesc);
    }

    private Method getMethod(Class class_, String name, String desc) {
        org.objectweb.asm.Type[] types = org.objectweb.asm.Type.getArgumentTypes((String)desc);
        Method[] arr$ = class_.getDeclaredMethods();
        int len$ = arr$.length;
        block0: for (int i$ = 0; i$ < len$; ++i$) {
            Method m = arr$[i$];
            org.objectweb.asm.Type[] methodTypes = org.objectweb.asm.Type.getArgumentTypes((Method)m);
            if (!m.getName().equals(name) || methodTypes.length != types.length) continue;
            for (int i = 0; i < types.length; ++i) {
                if (!types[i].equals((Object)methodTypes[i])) continue block0;
            }
            return m;
        }
        return null;
    }

    private Constructor getConstructor(Class class_, String desc) {
        org.objectweb.asm.Type[] types = org.objectweb.asm.Type.getArgumentTypes((String)desc);
        Constructor<?>[] arr$ = class_.getDeclaredConstructors();
        int len$ = arr$.length;
        block0: for (int i$ = 0; i$ < len$; ++i$) {
            Constructor<?> c = arr$[i$];
            Class<?>[] constructorTypes = c.getParameterTypes();
            if (constructorTypes.length != types.length) continue;
            for (int i = 0; i < types.length; ++i) {
                if (!types[i].equals((Object)org.objectweb.asm.Type.getType(constructorTypes[i]))) continue block0;
            }
            return c;
        }
        return null;
    }

    private void parseSignature(String signature, boolean isInterface, String superName, String[] interfaces) {
        if (signature == null) {
            this.typeParameters = new TypeVariable[0];
            Type type = this.genericSuperclass = superName == null ? null : new ClassTypeImpl(superName.replaceAll("/", "."));
            if (interfaces == null) {
                this.genericInterfaces = new Type[0];
            } else {
                this.genericInterfaces = new Type[interfaces.length];
                for (int i = 0; i < interfaces.length; ++i) {
                    this.genericInterfaces[i] = new ClassTypeImpl(interfaces[i].replaceAll("/", "."), true);
                }
            }
        } else {
            SignatureReader r = new SignatureReader(signature);
            ClassTypeImpl currentType = new ClassTypeImpl(this.internalName.replaceAll("/", "."), isInterface);
            SigVisitor v = new SigVisitor(currentType, false);
            r.accept((SignatureVisitor)v);
            v.endParsing();
            this.typeParameters = v.typeParameters;
            this.genericSuperclass = v.genericSuperclass;
            this.genericInterfaces = v.genericInterfaces;
        }
        if (isInterface) {
            this.genericSuperclass = null;
        }
    }

    public TypeVariable[] getTypeParameters() throws GenericSignatureFormatError {
        return this.typeParameters;
    }

    public Type getGenericSuperclass() throws GenericSignatureFormatError, TypeNotPresentException, MalformedParameterizedTypeException {
        return this.genericSuperclass;
    }

    public Type[] getGenericInterfaces() throws GenericSignatureFormatError, TypeNotPresentException, MalformedParameterizedTypeException {
        return this.genericInterfaces;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.internalName = name;
        boolean isInterface = (access & 0x200) == 512;
        this.parseSignature(signature, isInterface, superName, interfaces);
    }

    public void visitSource(String source, String debug) {
    }

    public void visitOuterClass(String owner, String name, String desc) {
        this.enclosingClassName = owner;
        this.enclosingMethodName = name;
        this.enclosingMethodDesc = desc;
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (name.equals(this.internalName) && outerName != null) {
            this.enclosingClassName = outerName;
        }
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        return AIB.EMPTY_VISITOR;
    }

    public void visitAttribute(Attribute attr) {
    }

    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        return null;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        return null;
    }

    public void visitEnd() {
    }

    public static void main(String[] args) {
        String signature = "<E:Ljava/lang/String;>Ljava/util/LinkedList<TE;>;Ljava/io/Serializable;Ljava/lang/Comparable<TE;>;";
        String internalName = "blah.TopLevel";
        System.out.println("Parsing " + signature);
        SignatureReader r = new SignatureReader(signature);
        ClassTypeImpl currentType = new ClassTypeImpl(internalName.replaceAll("/", "."), false);
        SigVisitor v = new SigVisitor(currentType, false);
        r.accept((SignatureVisitor)v);
        v.endParsing();
        System.out.println(v.genericInterfaces.length);
        Type[] arr$ = v.genericInterfaces;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            Type t = arr$[i$];
            System.out.println(t);
        }
    }

    public static class WildcardTypeImpl
    implements WildcardType {
        public Type[] getLowerBounds() throws TypeNotPresentException, MalformedParameterizedTypeException {
            throw new UnsupportedOperationException("NotImplemented");
        }

        public Type[] getUpperBounds() throws TypeNotPresentException, MalformedParameterizedTypeException {
            throw new UnsupportedOperationException("NotImplemented");
        }
    }

    public static class TypeVariableImpl
    implements TypeVariable {
        private final String name;
        private Type[] bounds;
        private GenericDeclaration genericDeclaration;

        public TypeVariableImpl(String name) {
            this.name = name;
        }

        protected void setBounds(Type[] bounds) {
            this.bounds = bounds;
        }

        public Type[] getBounds() throws TypeNotPresentException, MalformedParameterizedTypeException {
            return this.bounds;
        }

        protected void setGenericDeclaration(GenericDeclaration d) {
            this.genericDeclaration = d;
        }

        public GenericDeclaration getGenericDeclaration() {
            return this.genericDeclaration;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static class ParameterizedTypeImpl
    implements ParameterizedType {
        private Type owner;
        private Type[] args;
        private Type raw;

        public ParameterizedTypeImpl(Type owner, Type[] args, Type raw) {
            this.owner = owner;
            this.args = args;
            this.raw = raw;
        }

        public Type[] getActualTypeArguments() throws TypeNotPresentException, MalformedParameterizedTypeException {
            return this.args;
        }

        public Type getOwnerType() {
            return this.owner;
        }

        public Type getRawType() {
            return this.raw;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            String s = this.raw.toString();
            if (s.startsWith("class ")) {
                s = s.substring(6);
            } else if (s.startsWith("interface ")) {
                s = s.substring(10);
            }
            sb.append(s);
            if (this.args.length != 0) {
                sb.append('<');
                boolean first = true;
                Type[] arr$ = this.args;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Type t = arr$[i$];
                    if (!first) {
                        sb.append(", ");
                    }
                    first = false;
                    s = t.toString();
                    if (s.startsWith("class ")) {
                        s = s.substring(6);
                    }
                    sb.append(s);
                }
                sb.append('>');
            }
            return sb.toString();
        }
    }

    public static class GenericArrayTypeImpl
    implements GenericArrayType {
        private Type genericComponentType;

        public GenericArrayTypeImpl(Type genericComponentType) {
            this.genericComponentType = genericComponentType;
        }

        public Type getGenericComponentType() throws TypeNotPresentException, MalformedParameterizedTypeException {
            return this.genericComponentType;
        }
    }

    public static class ClassTypeImpl
    implements Type,
    GenericDeclaration {
        private final String name;
        private boolean isInterface;
        private TypeVariable[] typeParameters;

        public ClassTypeImpl(String name) {
            this.name = name;
            this.isInterface = false;
        }

        public ClassTypeImpl(String name, boolean isInterface) {
            this.name = name;
            this.isInterface = isInterface;
        }

        public String toString() {
            return (this.isInterface ? "interface " : "class ") + this.name;
        }

        public TypeVariable[] getTypeParameters() {
            return this.typeParameters;
        }

        public void setTypeParameters(TypeVariable[] typeParameters) {
            this.typeParameters = typeParameters;
        }
    }

    private static class SigVisitor
    implements SignatureVisitor {
        protected TypeVariable[] typeParameters;
        protected Type genericSuperclass;
        protected Type[] genericInterfaces;
        private Stack stack = new Stack();
        private Set typeVariables = new HashSet();
        private LinkedList formalTypeParameters = new LinkedList();
        private StringBuffer declaration;
        private boolean isInterface;
        private ClassTypeImpl currentType;
        private boolean seenFormalParameter;
        private boolean seenInterfaceBound;
        private boolean seenParameter;
        private boolean seenInterface;
        private StringBuffer returnType;
        private StringBuffer exceptions;
        private int argumentStack;
        private Stack argumentStackPosition = new Stack();
        private int arrayStack;
        private String separator = "";

        public SigVisitor(ClassTypeImpl currentType, boolean isInterface) {
            this.isInterface = isInterface;
            this.declaration = new StringBuffer();
            this.currentType = currentType;
        }

        private SigVisitor(StringBuffer buf) {
            this.declaration = buf;
        }

        public void visitFormalTypeParameter(String name) {
            if (this.seenFormalParameter) {
                this.endFormal();
            }
            TypeVariableImpl t = new TypeVariableImpl(name);
            this.typeVariables.add(t);
            this.formalTypeParameters.add(t);
            this.declaration.append(this.seenFormalParameter ? ", " : "<").append(name);
            this.seenFormalParameter = true;
            this.seenInterfaceBound = false;
        }

        public SignatureVisitor visitClassBound() {
            this.separator = " extends ";
            this.startType();
            return this;
        }

        public SignatureVisitor visitInterfaceBound() {
            this.separator = this.seenInterfaceBound ? ", " : " extends ";
            this.seenInterfaceBound = true;
            this.startType();
            return this;
        }

        public SignatureVisitor visitSuperclass() {
            this.endFormals();
            this.separator = " extends ";
            this.startType();
            return this;
        }

        public SignatureVisitor visitInterface() {
            if (!this.seenInterface) {
                this.endGenericSuperclass();
            }
            this.separator = this.seenInterface ? ", " : (this.isInterface ? " extends " : " implements ");
            this.seenInterface = true;
            this.startType();
            return this;
        }

        public SignatureVisitor visitParameterType() {
            this.endFormals();
            if (!this.seenParameter) {
                this.seenParameter = true;
                this.declaration.append('(');
            } else {
                this.declaration.append(", ");
            }
            this.startType();
            return this;
        }

        public SignatureVisitor visitReturnType() {
            this.endFormals();
            if (!this.seenParameter) {
                this.declaration.append('(');
            } else {
                this.seenParameter = false;
            }
            this.declaration.append(')');
            this.returnType = new StringBuffer();
            return new SigVisitor(this.returnType);
        }

        public SignatureVisitor visitExceptionType() {
            if (this.exceptions == null) {
                this.exceptions = new StringBuffer();
            } else {
                this.exceptions.append(", ");
            }
            return new SigVisitor(this.exceptions);
        }

        public void visitBaseType(char descriptor) {
            switch (descriptor) {
                case 'V': {
                    this.declaration.append("void");
                    break;
                }
                case 'B': {
                    this.declaration.append("byte");
                    break;
                }
                case 'J': {
                    this.declaration.append("long");
                    break;
                }
                case 'Z': {
                    this.declaration.append("boolean");
                    break;
                }
                case 'I': {
                    this.declaration.append("int");
                    break;
                }
                case 'S': {
                    this.declaration.append("short");
                    break;
                }
                case 'C': {
                    this.declaration.append("char");
                    break;
                }
                case 'F': {
                    this.declaration.append("float");
                    break;
                }
                default: {
                    this.declaration.append("double");
                }
            }
            this.endType();
        }

        public void visitTypeVariable(String name) {
            TypeVariableImpl t = new TypeVariableImpl(name);
            this.typeVariables.add(t);
            this.stack.push(t);
            this.declaration.append(name);
            this.endType();
        }

        public SignatureVisitor visitArrayType() {
            this.startType();
            this.arrayStack |= 1;
            return this;
        }

        public void visitClassType(String name) {
            ClassTypeImpl t = new ClassTypeImpl(name.replace('/', '.'));
            this.stack.push(t);
            if (!"java/lang/Object".equals(name)) {
                this.declaration.append(this.separator).append(name.replace('/', '.'));
            } else {
                boolean needObjectClass;
                boolean bl = needObjectClass = this.argumentStack % 2 != 0 || this.seenParameter;
                if (needObjectClass) {
                    this.declaration.append(this.separator).append(name.replace('/', '.'));
                }
            }
            this.separator = "";
            this.argumentStack *= 2;
            this.argumentStackPosition.push(Integer_.valueOf(this.stack.size()));
        }

        public void visitInnerClassType(String name) {
            if (this.argumentStack % 2 != 0) {
                this.declaration.append('>');
            }
            this.argumentStack /= 2;
            this.argumentStackPosition.pop();
            this.declaration.append('.');
            this.declaration.append(this.separator).append(name.replace('/', '.'));
            this.separator = "";
            this.argumentStack *= 2;
            this.argumentStackPosition.push(Integer_.valueOf(this.stack.size()));
        }

        public void visitTypeArgument() {
            if (this.argumentStack % 2 == 0) {
                ++this.argumentStack;
                this.declaration.append('<');
            } else {
                this.declaration.append(", ");
            }
            this.declaration.append('?');
        }

        public SignatureVisitor visitTypeArgument(char tag) {
            if (this.argumentStack % 2 == 0) {
                ++this.argumentStack;
                this.declaration.append('<');
            } else {
                this.declaration.append(", ");
            }
            if (tag == '+') {
                this.declaration.append("? extends ");
            } else if (tag == '-') {
                this.declaration.append("? super ");
            }
            this.startType();
            return this;
        }

        public void visitEnd() {
            if (this.argumentStack % 2 != 0) {
                int stackPos = (Integer)this.argumentStackPosition.peek() - 1;
                Type raw = (Type)this.stack.elementAt(stackPos);
                Type owner = null;
                int l = this.stack.size() - stackPos - 1;
                Type[] args = new Type[l];
                for (int i = l - 1; i >= 0; --i) {
                    args[i] = (Type)this.stack.pop();
                }
                this.stack.pop();
                ParameterizedTypeImpl t = new ParameterizedTypeImpl(owner, args, raw);
                this.stack.push(t);
                this.declaration.append('>');
            }
            this.argumentStack /= 2;
            this.argumentStackPosition.pop();
            this.endType();
        }

        public String getDeclaration() {
            return this.declaration.toString();
        }

        public String getReturnType() {
            return this.returnType == null ? null : this.returnType.toString();
        }

        public String getExceptions() {
            return this.exceptions == null ? null : this.exceptions.toString();
        }

        private void endFormal() {
            Type[] bounds = this.stack.toArray(new Type[this.stack.size()]);
            this.stack.removeAllElements();
            ((TypeVariableImpl)this.formalTypeParameters.getLast()).setBounds(bounds);
        }

        private void endGenericSuperclass() {
            this.genericSuperclass = (Type)this.stack.pop();
        }

        public void endParsing() {
            if (!this.seenInterface) {
                this.endGenericSuperclass();
                this.genericInterfaces = new Type[0];
            } else {
                this.genericInterfaces = this.stack.toArray(new Type[this.stack.size()]);
                this.stack.removeAllElements();
                Type[] arr$ = this.genericInterfaces;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Type t = arr$[i$];
                    if (t instanceof ParameterizedTypeImpl) {
                        ParameterizedTypeImpl p = (ParameterizedTypeImpl)t;
                        t = p.raw;
                    }
                    if (!(t instanceof ClassTypeImpl)) continue;
                    ClassTypeImpl c = (ClassTypeImpl)t;
                    c.isInterface = true;
                }
            }
            this.currentType.setTypeParameters(this.typeParameters);
            Iterator i$ = this.typeVariables.iterator();
            while (i$.hasNext()) {
                TypeVariableImpl t = (TypeVariableImpl)i$.next();
                t.setGenericDeclaration(this.currentType);
            }
        }

        private void endFormals() {
            if (this.seenFormalParameter) {
                this.endFormal();
                this.declaration.append('>');
                this.seenFormalParameter = false;
            }
            this.typeParameters = this.formalTypeParameters.toArray(new TypeVariable[this.formalTypeParameters.size()]);
        }

        private void startType() {
            this.arrayStack *= 2;
        }

        private void endType() {
            if (this.arrayStack % 2 != 0) {
                while (this.arrayStack % 2 != 0) {
                    Type t = (Type)this.stack.pop();
                    this.stack.push(new GenericArrayTypeImpl(t));
                    this.arrayStack /= 2;
                    this.declaration.append("[]");
                }
            } else {
                this.arrayStack /= 2;
            }
        }
    }
}

